/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.jxdinfo.hussar.authorization.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonUserAuditManager {
    @Resource
    protected SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    protected SysUserroleAuditMapper sysUserroleAuditMapper;
    @Autowired
    protected ISysUserRoleService userRoleService;
    @Autowired
    protected ISysUserIpAuditService sysUserIpAuditService;
    @Autowired
    protected ISysUserIpService sysUserIpService;
    @Autowired
    protected ISysUsersService sysUsersService;
    @Autowired
    protected ISysDicRefService dicRefService;
    @Autowired
    protected ISysUserPostService sysUserPostService;
    @Autowired
    protected ISysUserPostAuditService sysUserPostAuditService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;

    protected SysUsersAudit getSysUsersAudit(Long id) {
        AssertUtil.isNotNull((Object)id, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAMETERS.getMessage()));
        SysUsersAudit usersAudit = (SysUsersAudit)this.sysUsersAuditMapper.selectById(id);
        AssertUtil.isNotNull((Object)usersAudit, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_USER_REVIEW.getMessage()));
        return usersAudit;
    }

    protected String queryIp(Long userId) {
        List userIps = this.sysUserIpService.selectUserIp(userId);
        if (HussarUtils.isNotEmpty((Object)userIps)) {
            return String.join((CharSequence)",", userIps);
        }
        return null;
    }

    protected String queryAuditIp(Long userId, String inuse) {
        List userIps = this.sysUserIpAuditService.selectUserIp(userId, inuse);
        if (HussarUtils.isNotEmpty((Object)userIps)) {
            return String.join((CharSequence)",", userIps);
        }
        return null;
    }

    protected boolean saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(ip);
                sysUserIps.add(sysUserIp);
            }
        }
        if (ToolUtil.isNotEmpty(sysUserIps)) {
            flag = this.sysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }
}

