/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.audit.service.ISysFunctionsAuditService;
import com.jxdinfo.hussar.authorization.audit.vo.SysFunctionsAuditDetailsVo;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionsAudit;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u529f\u80fd\u5ba1\u6838"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.HussarBaseFunctionsAuditController")
@RequestMapping(value={"/hussarBase/authorization/functionAudit"})
public class HussarBaseFunctionsAuditController {
    @Autowired
    private ISysFunctionsAuditService functionsAuditService;

    @ApiOperation(value="\u529f\u80fd\u5ba1\u6838\u5217\u8868", notes="\u529f\u80fd\u5ba1\u6838\u5217\u8868")
    @GetMapping(value={"/getList"})
    @CheckPermission(value={"functionAudit:getList"})
    @AuditLog(moduleName="\u529f\u80fd\u5ba1\u6838", eventDesc="\u529f\u80fd\u5ba1\u6838\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysFunctionsAudit>> listAudit(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<SysFunctionsAudit> page, @ApiParam(value="\u529f\u80fd\u5ba1\u6838\u5b9e\u4f53") SysFunctionsAudit functionsAudit) {
        if (HussarUtils.isNotEmpty((Object)functionsAudit.getFunctionName())) {
            functionsAudit.setFunctionName(functionsAudit.getFunctionName().replace("%", "\\%").replace("_", "\\_"));
        }
        return ApiResponse.success((Object)this.functionsAuditService.queryList(page, functionsAudit));
    }

    @ApiOperation(value="\u67e5\u770b\u529f\u80fd\u5ba1\u6838\u8be6\u60c5", notes="\u67e5\u770b\u529f\u80fd\u5ba1\u6838\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    @CheckPermission(value={"functionAudit:detail"})
    @AuditLog(moduleName="\u529f\u80fd\u5ba1\u6838", eventDesc="\u67e5\u770b\u529f\u80fd\u5ba1\u6838\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysFunctionsAuditDetailsVo> view(@ApiParam(value="\u529f\u80fd\u5ba1\u6838\u5b9e\u4f53") SysFunctionsAudit functionsAudit) {
        return ApiResponse.success((Object)this.functionsAuditService.detail(functionsAudit));
    }

    @ApiOperation(value="\u529f\u80fd\u5ba1\u6838\u901a\u8fc7\u63a5\u53e3", notes="\u529f\u80fd\u5ba1\u6838\u901a\u8fc7")
    @PostMapping(value={"/pass"})
    @AuditLog(moduleName="\u529f\u80fd\u5ba1\u6838", eventDesc="\u529f\u80fd\u5ba1\u6838\u901a\u8fc7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"functionAudit:pass"})
    public ApiResponse<Boolean> pass(@RequestBody SysFunctionsAudit functionsAudit) {
        return ApiResponse.success((Object)this.functionsAuditService.pass(functionsAudit));
    }

    @ApiOperation(value="\u529f\u80fd\u5ba1\u6838\u9a73\u56de", notes="\u529f\u80fd\u5ba1\u6838\u9a73\u56de")
    @PostMapping(value={"/reject"})
    @CheckPermission(value={"functionAudit:reject"})
    @AuditLog(moduleName="\u529f\u80fd\u5ba1\u6838", eventDesc="\u529f\u80fd\u5ba1\u6838\u9a73\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse rejectAdd(@RequestBody SysFunctionsAudit functionsAudit) {
        return ApiResponse.success((Object)this.functionsAuditService.reject(functionsAudit));
    }
}

