/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.service.ILocalOrganService;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalHussarBaseOrganServiceImpl
implements ILocalOrganService {
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private EditOrganizationManager editOrganizationManager;

    public List<SimpleOrganVo> getSimpleOrgan(List<Long> struId) {
        return this.sysStaffMapper.getSimpleOrgan(struId);
    }

    public SysOrganVo getOrgInfoByOrgId(Long organId) {
        return this.sysStruMapper.getOrgInfoByOrgId(organId);
    }

    public void refreshOrgan() {
        this.editOrganizationManager.refreshOrgan();
    }

    public List<SysOrgan> listByIds(List<Long> organIds) {
        if (HussarUtils.isEmpty(organIds)) {
            return Collections.emptyList();
        }
        return this.sysOrganMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysOrgan::getId, organIds));
    }

    public String getDeptIcon(Long organId) {
        return this.sysOrganTypeMapper.getDeptIcon(organId);
    }
}

