/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.audit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.dao.SysFunctionResourcesAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysFunctionsAuditMapper;
import com.jxdinfo.hussar.authorization.audit.service.ISysFunctionResourcesAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysFunctionsAuditService;
import com.jxdinfo.hussar.authorization.audit.vo.SysFunctionsAuditDetailsVo;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionsAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysFunctionsAuditServiceImpl
extends HussarServiceImpl<SysFunctionsAuditMapper, SysFunctionsAudit>
implements ISysFunctionsAuditService {
    private static Logger logger = LoggerFactory.getLogger(SysFunctionsAuditServiceImpl.class);
    @Autowired
    private ISysFunctionsService functionsService;
    @Autowired
    private ISysFunctionResourcesAuditService functionResourcesAuditService;
    @Autowired
    private ISysResManageService sysResManageService;
    @Resource
    private IHussarBaseRoleService hussarBaseRoleServiceImpl;
    @Resource
    private HussarTenantProperties tenantProperties;
    @Autowired
    private SysFunctionResourcesAuditMapper functionResourcesAuditMapper;
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private ISysFunctionModulesService functionModulesService;
    @Autowired
    private ISysBaseConfigService baseConfigService;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;

    public boolean saveUnAuditFunctionInfo(SysFunctions sysFunctions, String OperationType) {
        SysFunctionsAudit functionsAudit = new SysFunctionsAudit();
        BeanUtils.copyProperties((Object)sysFunctions, (Object)functionsAudit);
        functionsAudit.setId(null);
        functionsAudit.setFunctionId(sysFunctions.getId());
        functionsAudit.setOperateType(OperationType);
        functionsAudit.setAuditStatus("0");
        return this.save((BaseEntity)functionsAudit);
    }

    public boolean insertFunctionAuditSave(SysFunctions sysFunctions) {
        return this.saveUnAuditFunctionInfo(sysFunctions, "1");
    }

    public boolean updateFunctionAuditSave(SysFunctions sysFunctions) {
        return this.saveUnAuditFunctionInfo(sysFunctions, "2");
    }

    public boolean deleteFunctionAuditSave(SysFunctions sysFunctions) {
        return this.saveUnAuditFunctionInfo(sysFunctions, "3");
    }

    public IPage<SysFunctionsAudit> queryList(Page<SysFunctionsAudit> page, SysFunctionsAudit functionsAudit) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ToolUtil.isNotEmpty((Object)functionsAudit.getAuditStatus()), SysFunctionsAudit::getAuditStatus, (Object)functionsAudit.getAuditStatus())).eq(ToolUtil.isNotEmpty((Object)functionsAudit.getOperateType()), SysFunctionsAudit::getOperateType, (Object)functionsAudit.getOperateType())).like(ToolUtil.isNotEmpty((Object)functionsAudit.getFunctionName()), SysFunctionsAudit::getFunctionName, (Object)functionsAudit.getFunctionName())).orderByDesc(HussarBaseEntity::getCreateTime);
        return this.page((IPage)page, (Wrapper)wrapper);
    }

    @HussarTransactional
    public SysFunctionsAuditDetailsVo detail(SysFunctionsAudit functionsAudit) {
        if (HussarUtils.isEmpty((Object)functionsAudit) || HussarUtils.isEmpty((Object)functionsAudit.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
        }
        SysFunctionsAuditDetailsVo functionsAuditDetailsVo = new SysFunctionsAuditDetailsVo();
        Long auditId = functionsAudit.getId();
        SysFunctionsAudit functionAuditInfo = (SysFunctionsAudit)this.getById(auditId);
        String operationType = functionAuditInfo.getOperateType();
        Long functionId = functionAuditInfo.getFunctionId();
        if ("1".equals(operationType)) {
            Long moduleId;
            SysFunctionModules module;
            Long defaultResourceId = functionAuditInfo.getDefaultResourceId();
            SysResources resource = Optional.ofNullable(defaultResourceId).map(id -> (SysResources)this.sysResourcesService.getById((Serializable)defaultResourceId)).orElse(null);
            if (HussarUtils.isNotEmpty((Object)resource)) {
                functionAuditInfo.setDefaultResourceName(resource.getResourceName());
            }
            if (HussarUtils.isNotEmpty((Object)(module = (SysFunctionModules)Optional.ofNullable(moduleId = functionAuditInfo.getFunctionModuleId()).map(id -> (SysFunctionModules)this.functionModulesService.getById((Serializable)moduleId)).orElse(null)))) {
                functionAuditInfo.setFunctionModuleName(module.getFunctionModuleName());
            }
            functionAuditInfo.setType("\u529f\u80fd");
            functionsAuditDetailsVo.setNewData(functionAuditInfo);
        } else if ("2".equals(operationType)) {
            Long newModuleId;
            SysFunctionModules newModule;
            Long oldModuleId;
            SysFunctionModules oldModule;
            SysFunctions oldData = (SysFunctions)this.functionsService.getById((Serializable)functionId);
            Long oldDefaultResourceId = functionAuditInfo.getDefaultResourceId();
            SysResources oldResource = Optional.ofNullable(oldDefaultResourceId).map(id -> (SysResources)this.sysResourcesService.getById((Serializable)oldDefaultResourceId)).orElse(null);
            if (HussarUtils.isNotEmpty((Object)oldResource)) {
                oldData.setDefaultResourceName(oldResource.getResourceName());
            }
            if (HussarUtils.isNotEmpty((Object)(oldModule = (SysFunctionModules)Optional.ofNullable(oldModuleId = oldData.getFunctionModuleId()).map(id -> (SysFunctionModules)this.functionModulesService.getById((Serializable)oldModuleId)).orElse(null)))) {
                oldData.setFunctionModuleName(oldModule.getFunctionModuleName());
            }
            oldData.setType("\u529f\u80fd");
            functionsAuditDetailsVo.setOldData(oldData);
            Long newDefaultResourceId = functionAuditInfo.getDefaultResourceId();
            SysResources newesource = Optional.ofNullable(newDefaultResourceId).map(id -> (SysResources)this.sysResourcesService.getById((Serializable)newDefaultResourceId)).orElse(null);
            if (HussarUtils.isNotEmpty((Object)newesource)) {
                functionAuditInfo.setDefaultResourceName(newesource.getResourceName());
            }
            if (HussarUtils.isNotEmpty((Object)(newModule = (SysFunctionModules)Optional.ofNullable(newModuleId = functionAuditInfo.getFunctionModuleId()).map(id -> (SysFunctionModules)this.functionModulesService.getById((Serializable)newModuleId)).orElse(null)))) {
                functionAuditInfo.setFunctionModuleName(newModule.getFunctionModuleName());
            }
            functionAuditInfo.setType("\u529f\u80fd");
            functionsAuditDetailsVo.setNewData(functionAuditInfo);
        } else if ("3".equals(operationType)) {
            Long oldModuleId;
            SysFunctionModules oldModule;
            SysFunctions oldData = (SysFunctions)this.functionsService.getById((Serializable)functionId);
            Long oldDefaultResourceId = functionAuditInfo.getDefaultResourceId();
            SysResources oldResource = Optional.ofNullable(oldDefaultResourceId).map(id -> (SysResources)this.sysResourcesService.getById((Serializable)oldDefaultResourceId)).orElse(null);
            if (HussarUtils.isNotEmpty((Object)oldResource)) {
                oldData.setDefaultResourceName(oldResource.getResourceName());
            }
            if (HussarUtils.isNotEmpty((Object)(oldModule = (SysFunctionModules)Optional.ofNullable(oldModuleId = oldData.getFunctionModuleId()).map(id -> (SysFunctionModules)this.functionModulesService.getById((Serializable)oldModuleId)).orElse(null)))) {
                oldData.setFunctionModuleName(oldModule.getFunctionModuleName());
            }
            oldData.setType("\u529f\u80fd");
            functionsAuditDetailsVo.setOldData(oldData);
        } else {
            logger.error("\u529f\u80fd\u5ba1\u6838\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff1a\u5ba1\u6838id-{}\uff0c\u64cd\u4f5c\u7c7b\u578b-{}", (Object)auditId, (Object)operationType);
        }
        return functionsAuditDetailsVo;
    }

    @HussarTransactional
    public boolean pass(SysFunctionsAudit functionsAudit) {
        if (HussarUtils.isEmpty((Object)functionsAudit) || HussarUtils.isEmpty((Object)functionsAudit.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
        }
        SysFunctionsAudit functionsAuditInfo = (SysFunctionsAudit)this.getById(functionsAudit.getId());
        if (HussarUtils.isEmpty((Object)functionsAuditInfo)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
        }
        String operationType = functionsAuditInfo.getOperateType();
        if ("1".equals(operationType)) {
            functionsAuditInfo.setAuditStatus("1");
            boolean flag = this.updateById((BaseEntity)functionsAuditInfo);
            if (flag) {
                SysFunctions sysFunctions = new SysFunctions();
                BeanUtils.copyProperties((Object)functionsAuditInfo, (Object)sysFunctions);
                sysFunctions.setId(functionsAuditInfo.getFunctionId());
                this.sysResManageService.functionSaveByType(sysFunctions, "0");
                this.functionsService.functionSaveNotify(sysFunctions);
                List oldRoleIds = this.hussarBaseRoleServiceImpl.getRoleIdsByFunctionId(sysFunctions.getId());
                this.functionsService.functionPermissionRefresh(oldRoleIds, sysFunctions);
                List list = this.functionResourcesAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionResourcesAudit::getFunctionId, (Object)sysFunctions.getId())).eq(SysFunctionResourcesAudit::getResourceId, (Object)sysFunctions.getDefaultResourceId())).eq(SysFunctionResourcesAudit::getAuditStatus, (Object)"0")).eq(SysFunctionResourcesAudit::getOperateType, (Object)"1"));
                if (HussarUtils.isNotEmpty((Object)list)) {
                    for (SysFunctionResourcesAudit audit : list) {
                        this.functionResourcesAuditService.pass(audit);
                    }
                }
            }
            return flag;
        }
        if ("2".equals(operationType)) {
            functionsAuditInfo.setAuditStatus("1");
            boolean flag = this.updateById((BaseEntity)functionsAuditInfo);
            if (flag) {
                SysFunctions sysFunctions = new SysFunctions();
                BeanUtils.copyProperties((Object)functionsAuditInfo, (Object)sysFunctions);
                sysFunctions.setId(functionsAuditInfo.getFunctionId());
                this.sysResManageService.functionSaveByType(sysFunctions, "1");
                this.functionsService.functionEditNotify(sysFunctions);
                List oldRoleIds = this.hussarBaseRoleServiceImpl.getRoleIdsByFunctionId(sysFunctions.getId());
                this.functionsService.functionPermissionRefresh(oldRoleIds, sysFunctions);
            }
            return flag;
        }
        if ("3".equals(operationType)) {
            SysFunctions sysFunctions = new SysFunctions();
            BeanUtils.copyProperties((Object)functionsAuditInfo, (Object)sysFunctions);
            sysFunctions.setId(functionsAuditInfo.getFunctionId());
            ArrayList<Long> ingoreRoleIds = new ArrayList<Long>();
            Long adminRoleId = SysUserAndRole.SUPERADMIN_ROLE.getValue();
            if (this.tenantProperties.isEnabled() && !((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
                adminRoleId = TenantConstant.ADMIN_ROLE;
            }
            if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                ingoreRoleIds.add(TenantConstant.TENANT_SYSTEM_ADMIN_ROLE);
                ingoreRoleIds.add(SysUserAndRole.SYSTEMADMIN_ROLE.getValue());
            }
            ingoreRoleIds.add(adminRoleId);
            ingoreRoleIds.add(SysUserAndRole.DEVELOP_ROLE.getValue());
            this.functionsService.checkBeforeDelete(sysFunctions.getId(), ingoreRoleIds);
            functionsAuditInfo.setAuditStatus("1");
            boolean flag = this.updateById((BaseEntity)functionsAuditInfo);
            if (flag) {
                this.functionsService.deleteFunctionAndRelations(sysFunctions.getId(), ingoreRoleIds);
                this.functionsService.functionDeleteNotify(sysFunctions);
                List oldRoleIds = this.hussarBaseRoleServiceImpl.getRoleIdsByFunctionId(sysFunctions.getId());
                this.functionsService.functionPermissionRefresh(oldRoleIds, sysFunctions);
                this.functionResourcesAuditMapper.delete((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysFunctionResourcesAudit::getFunctionId, (Object)sysFunctions.getId())).eq(SysFunctionResourcesAudit::getAuditStatus, (Object)"0"));
            }
            return flag;
        }
        logger.error("\u529f\u80fd\u5ba1\u6838\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff1a\u5ba1\u6838id-{}\uff0c\u64cd\u4f5c\u7c7b\u578b-{}", (Object)functionsAudit, (Object)operationType);
        return Boolean.TRUE;
    }

    @HussarTransactional
    public boolean reject(SysFunctionsAudit functionsAudit) {
        if (HussarUtils.isEmpty((Object)functionsAudit) || HussarUtils.isEmpty((Object)functionsAudit.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
        }
        SysFunctionsAudit sysFunctionsAudit = new SysFunctionsAudit();
        sysFunctionsAudit.setId(functionsAudit.getId());
        sysFunctionsAudit.setAuditStatus("2");
        boolean flag = this.updateById((BaseEntity)sysFunctionsAudit);
        if (flag) {
            SysFunctionsAudit functionsAuditInfo = (SysFunctionsAudit)this.getById(functionsAudit.getId());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysFunctionResourcesAudit::getFunctionId, (Object)functionsAuditInfo.getFunctionId());
            this.functionResourcesAuditService.remove((Wrapper)wrapper);
        }
        return flag;
    }
}

