/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.post.manager.DeletePostManager;
import com.jxdinfo.hussar.authorization.post.manager.impl.CommonPostManagerImpl;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.deletePostManagerImpl")
public class DeletePostManagerImpl
extends CommonPostManagerImpl
implements DeletePostManager {
    @Override
    @HussarTransactional
    public String deletePost(Long postId) {
        this.judgeWhetherItCanBeDelete(postId);
        SysPost post = (SysPost)this.sysPostMapper.selectById(postId);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isPostAudit()) {
            List sysPostAudit = this.sysPostAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostAudit::getPostId, (Object)postId)).eq(SysPostAudit::getAuditStatus, (Object)"0")).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)sysPostAudit), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage()));
            SysPostAudit audit = new SysPostAudit();
            BeanUtils.copyProperties((Object)post, (Object)audit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
            audit.setPostId(postId);
            audit.setAuditStatus("0");
            audit.setOperateType("3");
            this.sysPostAuditService.save((Object)audit);
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        this.sysStruPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPostAudit::getPostId, (Object)postId)).eq(SysStruPostAudit::getAuditStatus, (Object)"0"));
        this.sysUserPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getPostId, (Object)postId)).eq(SysUserPostAudit::getAuditStatus, (Object)"0"));
        this.sysPostRoleAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getPostId, (Object)postId)).eq(SysPostRoleAudit::getAuditStatus, (Object)"0"));
        this.sysPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostAudit::getPostId, (Object)postId)).eq(SysPostAudit::getAuditStatus, (Object)"0"));
        this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId));
        this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId));
        this.sysPostMapper.deleteById(postId);
        this.postChangeNotify.notify(DataChangeType.DELETE, new Object[]{post});
        String translateName = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage());
        if (HussarUtils.isNotEmpty((Object)translateName)) {
            return translateName;
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage());
    }

    private void judgeWhetherItCanBeDelete(Long postId) {
        List userPostList = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        AssertUtil.isEmpty((Collection)userPostList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_USER_RELATION.getMessage()));
        List userPostAudits = this.sysUserPostAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getPostId, (Object)postId)).eq(SysUserPostAudit::getAuditStatus, (Object)"0"));
        AssertUtil.isEmpty((Collection)userPostAudits, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_USER_RELATION_EXIST_REVIEW.getMessage()));
    }
}

