/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.transferOrganizationManagerImpl")
public class TransferOrganizationManagerImpl
extends CommonOrganizationManager
implements TransferOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferOrganizationManagerImpl.class);

    @Override
    public String transferOrganization(TransferOrganizationDto transferOrganizationDto) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TRANSFER_PARAM.getMessage()), (Object)JSON.toJSONString((Object)transferOrganizationDto));
        String validateMsg = this.validateService.validate((Object)transferOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long oldId = transferOrganizationDto.getOldId();
        Long newId = transferOrganizationDto.getNewId();
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById(oldId);
        SysStru newSysStru = (SysStru)this.sysStruMapper.selectById(newId);
        AssertUtil.isNotNull((Object)oldSysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_FIND_TRANS_ORG.getMessage()));
        AssertUtil.isNotNull((Object)newSysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_FIND_NEED_TRANS_ORG.getMessage()));
        this.validateTransferOrganization(oldSysStru, newSysStru);
        this.sysOrgEventService.beforeOrgChange(oldId, newId);
        String msg = this.doTransfer(oldSysStru, newSysStru);
        this.sysOrgEventService.afterOrgChange(oldId, newId);
        return msg;
    }

    private String doTransfer(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_REAL_TRANSFER.getMessage()));
        String msg = "";
        String sourceOrgType = oldSysStru.getStruType();
        Long sourceStruId = oldSysStru.getId();
        Long targetStruId = newSysStru.getId();
        Integer changeLevel = newSysStru.getStruLevel();
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(targetStruId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
        Integer struOrder = orderTree.get();
        Integer level = changeLevel + 1;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setOrganId(Long.valueOf(IdWorker.getId((Object)sysStruAudit)));
            sysStruAudit.setInUse("4");
            sysStruAudit.setStruOrder(struOrder);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setStruLevel(level);
            sysStruAudit.setParentId(targetStruId);
            this.sysStruAuditService.save((Object)sysStruAudit);
            SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
            SysOrganAudit sysOrganAudit = new SysOrganAudit();
            CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
            sysOrganAudit.setId(sysStruAudit.getOrganId());
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setInUse("4");
            this.sysOrganAuditService.save((Object)sysOrganAudit);
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS_WAIT_REVIEW.getMessage());
        } else {
            this.organizationChange(sourceStruId, targetStruId, sourceOrgType, struOrder);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(SysStruAssistOrgan::getStruId, (Object)sourceStruId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)targetStruId);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(sourceStruId);
            this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sourceStruId, sysOrgan, null});
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage());
            HussarCacheUtil.evictKeysLike((String)"low_code_organ_info", (String)"*");
        }
        return msg;
    }

    private void validateTransferOrganization(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_VALIDATE_TRANSFER.getMessage()));
        if (newSysStru.getStruFid().contains(oldSysStru.getStruFid())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MOVE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
        this.whetherComplianceWithOrganizationRule(oldSysStru, newSysStru);
        this.existsAuditData(oldSysStru.getId(), newSysStru.getId());
    }

    private void whetherComplianceWithOrganizationRule(SysStru oldSysStru, SysStru newSysStru) {
        String oldOrganType = oldSysStru.getStruType();
        String newOrganType = newSysStru.getStruType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getSysOrganType, (Object)newOrganType);
        wrapper.eq(SysStruRule::getOrganType, (Object)oldOrganType);
        long count = this.sysStruRuleMapper.selectCount((Wrapper)wrapper);
        if (count == 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MOVE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
    }

    private void existsAuditData(Long oldId, Long newId) {
        if (!this.sysStruAuditService.checkCanOperate(oldId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_FAIL_EXIST_REVIEW.getMessage()));
        }
        if (!this.sysStruAuditService.checkCanOperate(newId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORG_HAS_UNAPPROVED.getMessage()));
        }
    }

    @Override
    public void organizationChange(Long sourceStruId, Long targetStruId, String sourceOrgType, Integer order) {
        String struSeq;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_UPDATE_CODE_AND_CHILDREN_CODE.getMessage()));
        SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(targetStruId);
        SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(sourceStruId);
        SysStru newSysStru = (SysStru)this.sysStruMapper.selectById(targetStruId);
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
        LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)oldSysStru.getStruFid());
        wrapper2.orderByAsc(SysStru::getStruSeq);
        List strus = this.sysStruMapper.selectList((Wrapper)wrapper2);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)sysOrgan.getOrganFcode()));
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SysOrgan> organs = this.sysOrganMapper.getSubOrganByFcode(queryOrgParams);
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFcode(parentOrg.getOrganFcode() + sysOrgan.getOrganCode() + "/");
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFname(parentOrg.getOrganFname() + "/" + sysOrgan.getOrganName());
        String struFid = newSysStru.getStruFid() + oldSysStru.getId() + "/";
        String struSeqT = struSeq = this.getStruSeq(newSysStru.getStruFid(), newSysStru.getStruSeq(), OrganUtil.getLevel((SysStru)newSysStru) + 1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(sourceStruId)).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            sysOrganT.setOrganProperty(parentOrg.getOrganProperty());
            stru.setStruFid(OrganUtil.convert((String)(struFid + stru.getId() + "/")));
            stru.setStruSeq(struSeqT + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            this.changeInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        for (SysStru temp : strus) {
            if (!Objects.equals(temp.getId(), sourceStruId)) continue;
            temp.setStruFid(OrganUtil.convert((String)struFid));
            temp.setStruLevel(Integer.valueOf(temp.getStruFid().split("/").length - 1));
            temp.setStruSeq(struSeq);
            temp.setStruOrder(order);
            temp.setParentId(targetStruId);
        }
        this.sysStruService.updateBatchById((Collection)strus);
        this.sysOrganService.updateBatchById(organsMap.values());
        this.updateLeaf(oldSysStru, newSysStru);
    }

    private void updateLeaf(SysStru oldSysStru, SysStru newSysStru) {
        if (!oldSysStru.getStruType().equals("9")) {
            newSysStru.setIsLeaf("N");
        }
        this.sysStruMapper.updateById(newSysStru);
        Long sourceStruId = oldSysStru.getParentId();
        int struLevel = oldSysStru.getStruLevel();
        if (!oldSysStru.getStruType().equals("9") && struLevel > 1) {
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sourceStruId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStru::getParentId, (Object)sourceStruId);
            wrapper.ne(SysStru::getId, (Object)oldSysStru.getId());
            wrapper.ne(SysStru::getStruType, (Object)"9");
            Long count = this.sysStruMapper.selectCount((Wrapper)wrapper);
            pSysStru.setIsLeaf(count > 0L ? "N" : "Y");
            this.sysStruMapper.updateById(pSysStru);
        }
    }

    private void changeInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId() + "/")));
            stru.setStruSeq(root.getStruSeq() + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (Objects.equals(stru.getStruType(), "9")) {
                stru.setStruSeq(OrganUtil.getStruFidByLevel((String)stru.getStruSeq(), (int)(stru.getStruLevel() - 1)));
            }
            this.changeInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }
}

