/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AppVisitRoleFieldDto;
import com.jxdinfo.hussar.authorization.permit.dto.DataLogicAndFieldDto;
import com.jxdinfo.hussar.authorization.permit.dto.DataLogicDto;
import com.jxdinfo.hussar.authorization.permit.dto.DataRightsDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitRoleField;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleUserRightService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.addDataRightManagerImpl")
public class AddDataRightManagerImpl
implements AddDataRightManager {
    @Autowired
    private ISysRoleDataRightService roleDataRightService;
    @Autowired
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;
    @Autowired
    private ISysRoleStruRightService sysRoleStruRightService;
    @Resource
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;
    @Resource
    private ISysAppVisitDataLogicFilterService sysAppVisitDataLogicFilterService;
    @Resource
    private ISysAppVisitRoleFieldService sysAppVisitRoleFieldService;
    @Resource
    private IdentifierGenerator identifierGenerator;
    @Resource
    private ISysRoleUserRightService sysRoleUserRightService;

    @Override
    public boolean saveOrUpdateDataRight(List<DataRightsDto> dataRightsDtoList) {
        ArrayList<SysRoleDataRight> roleDataRightSaveList = new ArrayList<SysRoleDataRight>();
        ArrayList<SysRoleStruRights> roleStruRightsList = new ArrayList<SysRoleStruRights>();
        ArrayList<SysRoleUserRights> roleUserRightsList = new ArrayList<SysRoleUserRights>();
        for (DataRightsDto item2 : dataRightsDtoList) {
            SysRoleDataRight roleDataRight = item2.getDataRightInfo();
            Map dynamicParameterValue = item2.getDynamicParameterValue();
            if (HussarUtils.isEmpty((Object)roleDataRight.getDataRightsId())) {
                roleDataRight.setDataRightsId(Long.valueOf(IdWorker.getId((Object)new SysRoleDataRight())));
            }
            if (!HussarUtils.equals((Object)"res_rights", (Object)roleDataRight.getResTypeCode()) && !HussarUtils.equals((Object)"res_form_rights", (Object)roleDataRight.getResTypeCode())) {
                roleDataRight.setDataScope(PermitConstants.DATA_SCOPE_EXTEND);
                if (HussarUtils.isNotEmpty((Object)dynamicParameterValue)) {
                    roleDataRight.setCustomDataCondition(JSON.toJSONString((Object)dynamicParameterValue));
                }
            } else {
                if (Integer.parseInt("5") == roleDataRight.getDataScope()) {
                    String departmentId = item2.getDepartmentId();
                    String userIdArr = item2.getUserId();
                    if (HussarUtils.isEmpty((Object)departmentId) && HussarUtils.isEmpty((Object)userIdArr)) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CUSTOM_DEPARTMENT_AND_USER_VISIBLE_NOT_EMPTY.getMessage()));
                    }
                    if (HussarUtils.isNotEmpty((Object)departmentId)) {
                        Long[] deptIds;
                        for (Long deptId : deptIds = (Long[])ConvertUtils.convert((String[])departmentId.split(","), Long.class)) {
                            SysRoleStruRights sysRoleStruRights = new SysRoleStruRights();
                            sysRoleStruRights.setRoleDataRightsId(roleDataRight.getDataRightsId());
                            sysRoleStruRights.setRoleId(roleDataRight.getRoleId());
                            sysRoleStruRights.setStruid(deptId);
                            roleStruRightsList.add(sysRoleStruRights);
                        }
                    }
                    if (HussarUtils.isNotEmpty((Object)userIdArr)) {
                        Long[] userIds;
                        for (Long userId : userIds = (Long[])ConvertUtils.convert((String[])userIdArr.split(","), Long.class)) {
                            SysRoleUserRights sysRoleUserRights = new SysRoleUserRights();
                            sysRoleUserRights.setRoleDataRightsId(roleDataRight.getDataRightsId());
                            sysRoleUserRights.setRoleId(roleDataRight.getRoleId());
                            sysRoleUserRights.setUserId(userId);
                            roleUserRightsList.add(sysRoleUserRights);
                        }
                    }
                } else if (Integer.parseInt("6") == roleDataRight.getDataScope()) {
                    roleDataRight.setCustomDataCondition(JSON.toJSONString((Object)dynamicParameterValue));
                }
                roleDataRight.setDataScopeLabel(String.valueOf(roleDataRight.getDataScope()));
            }
            roleDataRightSaveList.add(roleDataRight);
        }
        List dataRightIdList = dataRightsDtoList.stream().map(item -> item.getDataRightInfo().getDataRightsId()).collect(Collectors.toList());
        boolean addDataRightFlag = this.roleDataRightService.saveOrUpdateBatch(roleDataRightSaveList);
        AssertUtil.isTrue((boolean)addDataRightFlag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FAILED_TO_ADD_DATA.getMessage()));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleStruRights::getRoleDataRightsId, dataRightIdList);
        this.sysRoleStruRightsMapper.delete((Wrapper)queryWrapper);
        this.sysRoleUserRightService.remove((Wrapper)new LambdaQueryWrapper().in(SysRoleUserRights::getRoleDataRightsId, dataRightIdList));
        boolean struRightFlag = this.sysRoleStruRightService.saveBatch(roleStruRightsList);
        boolean userRightFlag = this.sysRoleUserRightService.saveBatch(roleUserRightsList);
        return struRightFlag || userRightFlag;
    }

    @Override
    public boolean updateDataLogicAndFieldByRoleId(List<DataLogicAndFieldDto> dataLogicAndFields, Long roleId) {
        if (HussarUtils.isEmpty(dataLogicAndFields)) {
            return Boolean.TRUE;
        }
        List<DataLogicAndFieldDto> dataLogicList = dataLogicAndFields.stream().filter(dataLogicAndFieldDto -> HussarUtils.isNotEmpty((Object)dataLogicAndFieldDto.getDataFilter())).collect(Collectors.toList());
        this.updateDataLogicByRoleId(dataLogicList, roleId);
        List<DataLogicAndFieldDto> fieldPermissionList = dataLogicAndFields.stream().filter(dataLogicAndFieldDto -> HussarUtils.isNotEmpty((Object)dataLogicAndFieldDto.getFieldPermission())).collect(Collectors.toList());
        this.updateRoleFieldByRoleId(fieldPermissionList, roleId);
        return Boolean.TRUE;
    }

    private Boolean updateDataLogicByRoleId(List<DataLogicAndFieldDto> dataLogicList, Long roleId) {
        if (HussarUtils.isEmpty(dataLogicList)) {
            return Boolean.TRUE;
        }
        List delByFormIds = dataLogicList.stream().map(DataLogicAndFieldDto::getFormId).collect(Collectors.toList());
        this.sysAppVisitDataLogicService.deleteDataLogicByRoleIdFormIds(roleId, delByFormIds);
        ArrayList saveDataLogics = Lists.newArrayListWithCapacity((int)10);
        ArrayList saveDataLogicFilters = Lists.newArrayListWithCapacity((int)10);
        dataLogicList.stream().forEach(dataLogicAndFieldDto -> {
            DataLogicDto dataFilter = dataLogicAndFieldDto.getDataFilter();
            SysAppVisitDataLogic dataLogicModel = new SysAppVisitDataLogic();
            HussarUtils.copy((Object)dataFilter, (Object)dataLogicModel);
            Long dataLogicId = dataFilter.getId();
            if (HussarUtils.isEmpty((Object)dataLogicId)) {
                dataLogicId = this.identifierGenerator.nextId(SysAppVisitDataLogic.class).longValue();
                dataLogicModel.setId(dataLogicId);
            }
            saveDataLogics.add(dataLogicModel);
            if (HussarUtils.isNotEmpty((Object)dataFilter.getFilters())) {
                Long finalDataLogicId = dataLogicId;
                dataFilter.getFilters().stream().forEach(filter -> {
                    SysAppVisitDataLogicFilter filterModel = new SysAppVisitDataLogicFilter();
                    HussarUtils.copy((Object)filter, (Object)filterModel);
                    filterModel.setFilterConditionCode(filter.getFilterCode());
                    filterModel.setFilterConditionName(filter.getFilterName());
                    filterModel.setRoleDataLogicId(finalDataLogicId);
                    saveDataLogicFilters.add(filterModel);
                });
            }
        });
        this.sysAppVisitDataLogicService.saveBatch((Collection)saveDataLogics);
        if (HussarUtils.isNotEmpty((Object)saveDataLogicFilters)) {
            this.sysAppVisitDataLogicFilterService.saveBatch((Collection)saveDataLogicFilters);
        }
        return Boolean.TRUE;
    }

    private Boolean updateRoleFieldByRoleId(List<DataLogicAndFieldDto> fieldPermissionList, Long roleId) {
        if (HussarUtils.isEmpty(fieldPermissionList)) {
            return Boolean.TRUE;
        }
        List delByFormIds = fieldPermissionList.stream().map(DataLogicAndFieldDto::getFormId).collect(Collectors.toList());
        this.sysAppVisitRoleFieldService.deleteSysAppVisitRoleFieldByFormIds(roleId, delByFormIds);
        ArrayList saveRoleFields = Lists.newArrayListWithCapacity((int)10);
        fieldPermissionList.stream().forEach(dataLogicAndFieldDto -> {
            Long appId = dataLogicAndFieldDto.getAppId();
            Long formId = dataLogicAndFieldDto.getFormId();
            Long roleId2 = dataLogicAndFieldDto.getRoleId();
            List fieldPermissions = dataLogicAndFieldDto.getFieldPermission();
            if (HussarUtils.isNotEmpty((Object)fieldPermissions)) {
                List<SysAppVisitRoleField> roleFields = this.convertRoleField(fieldPermissions, appId, formId, roleId2);
                saveRoleFields.addAll(roleFields);
            }
        });
        this.sysAppVisitRoleFieldService.saveBatch((Collection)saveRoleFields);
        return Boolean.TRUE;
    }

    private List<SysAppVisitRoleField> convertRoleField(List<AppVisitRoleFieldDto> fieldPermission, Long appId, Long formId, Long roleId) {
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        fieldPermission.stream().forEach(field -> {
            SysAppVisitRoleField sysUpAppVisitRoleField = new SysAppVisitRoleField();
            sysUpAppVisitRoleField.setAppId(appId);
            sysUpAppVisitRoleField.setFormId(formId);
            sysUpAppVisitRoleField.setRoleId(roleId);
            sysUpAppVisitRoleField.setFieldId(field.getFieldId());
            sysUpAppVisitRoleField.setFieldName(field.getFieldName());
            sysUpAppVisitRoleField.setCanRead(field.getCanRead());
            sysUpAppVisitRoleField.setCanWrite(field.getCanWrite());
            sysUpAppVisitRoleField.setParentId(field.getParentId());
            result.add(sysUpAppVisitRoleField);
            List children = field.getChildren();
            if (HussarUtils.isNotEmpty((Object)children)) {
                List<SysAppVisitRoleField> childrenRoleField = this.convertRoleField(children, appId, formId, roleId);
                result.addAll(childrenRoleField);
            }
        });
        return result;
    }
}

