/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dto.AddStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.StaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruOrganRelationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.manager.ValidateUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.common.properties.HussarBaseIDCardProperties;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addStaffManagerImpl")
public class AddStaffManagerImpl
extends CommonStaffManager
implements AddStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddStaffManagerImpl.class);
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysUserRoleService userRoleService;
    @Autowired
    private SysOrgManageService orgMaintenanceService;
    @Autowired
    private ValidateUserManager validateUserManager;
    @Autowired
    private IConvertPinyinService convertPinyinService;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Autowired(required=false)
    private Encrypt defaultSMEncrypt;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    private HussarBaseIDCardProperties hussarBaseIDCardProperties;

    @Override
    public ApiResponse<Long> addStaff(AddStaffDto addStaffDto) {
        String validateMsg = this.validateService.validate((Object)addStaffDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String staffCode = addStaffDto.getStaffCode();
        if (HussarUtils.isNotBlank((CharSequence)staffCode)) {
            boolean flag;
            boolean bl = flag = !staffCode.contains("/") && staffCode.length() < 33;
            if (!flag) {
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_CODE_OUTSIDE_CHECK.getMessage()));
            }
        }
        SysStru sysStru = new SysStru();
        SysStaff sysStaff = new SysStaff();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(addStaffDto, sysStru, sysOrgan, sysStaff);
        this.parentOrganizationAuditDataExists(addStaffDto.getParentId());
        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
        String assistIds = addStaffDto.getAssistIds();
        boolean isUpper = false;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && StringUtils.isNotBlank((CharSequence)sysOrgan.getOrganName()) && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)sysOrgan.getOrganName())) {
            isUpper = true;
        }
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysStaff, assistIds, isUpper);
        return ApiResponse.success((Object)sysStru.getId(), (String)result);
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds, boolean isUpper) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IF_AUDIT_STAFF_NEED.getMessage()));
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            this.validateUserManager.validateLimit();
            return this.syncUser(sysStru, sysOrgan, sysStaff, assistIds, isUpper);
        }
        return this.doAddStaff(sysStru, sysOrgan, sysStaff, assistIds);
    }

    private String doAddAuditStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        boolean canOperate = this.sysStruAuditService.checkCanOperate(sysStru.getParentId());
        if (!canOperate) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UNAPPROVED_ORG_NEW_PERSONNEL.getMessage()));
        }
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer struOrder = 1;
        Integer maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1;
        }
        sysStru.setStruOrder(struOrder);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysStru.setOrganId(sysOrgan.getId());
        long sysStruId = IdWorker.getId((Object)sysStru);
        sysStru.setId(Long.valueOf(sysStruId));
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setName(sysOrgan.getOrganName());
            long sysStaffId = IdWorker.getId((Object)sysStaff);
            sysStaff.setId(Long.valueOf(sysStaffId));
        }
        this.auditAdd(sysOrgan, sysStru, sysStaff, "1");
        this.sysStruAssistOrganAuditService.saveAssistOrganAudit(assistIds, sysStru.getId());
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage());
    }

    private String doAddNoAuditStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        Long sysStruId;
        boolean saveAssistOrgan;
        sysStru.setId(null);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer struOrder = 1;
        Integer maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1;
        }
        sysStru.setStruOrder(struOrder);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffMapper.insert(sysStaff);
        }
        if (!(saveAssistOrgan = this.sysStruAssistOrganService.saveAssistOrgan(assistIds, sysStruId = sysStru.getId()))) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage());
    }

    private String doAddStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            Set organIds;
            List sysStruAuditList;
            List sysOrganAuditList = this.sysOrganAuditService.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getOrganCode, (Object)sysOrgan.getOrganCode()));
            if (HussarUtils.isNotEmpty((Object)sysOrganAuditList) && HussarUtils.isNotEmpty((Object)(sysStruAuditList = this.sysStruAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruAudit::getOrganId, organIds = sysOrganAuditList.stream().map(SysOrganAudit::getId).collect(Collectors.toSet()))).eq(SysStruAudit::getState, (Object)"0"))))) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DUPLICATE_CODES_REVIEWED.getMessage()));
            }
            return this.doAddAuditStaff(sysStru, sysOrgan, sysStaff, assistIds);
        }
        return this.doAddNoAuditStaff(sysStru, sysOrgan, sysStaff, assistIds);
    }

    private String syncUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds, boolean isUpper) {
        if (this.sysUsersService.isExistAccount(isUpper ? sysOrgan.getOrganName().toUpperCase() : sysOrgan.getOrganName())) {
            LOGGER.warn(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
        }
        this.addStaffUser(sysStru, sysOrgan, sysStaff, isUpper);
        Long sysStruId = sysStru.getId();
        StruOrganRelationDto relationDto = new StruOrganRelationDto();
        relationDto.setOrganIds(assistIds);
        relationDto.setSysStruId(sysStruId);
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEAL_ASSIST_POST.getMessage()));
        boolean saveAssistOrgan = this.sysStruAssistOrganService.saveAssistOrgan(relationDto);
        if (!saveAssistOrgan) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage());
    }

    private void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, boolean isUpper) {
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer order = 1;
        Integer maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            order = maxOrder + 1;
        }
        sysStru.setStruOrder(order);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            sysStaff.setStruId(sysStru.getId());
            this.staffUserMapper.insert(sysStaff);
        }
        SysUsers user = new SysUsers();
        user.setUserAccount(isUpper ? sysOrgan.getOrganName().toUpperCase() : sysOrgan.getOrganName());
        user.setUserName(sysOrgan.getOrganName());
        String pass = "";
        pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? GeneratePassword.generate((String)this.pwdConfigService.getPwdRule()) : this.pwdConfigService.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        user.setPassword(pwd);
        user.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
        user.setAccountStatus(UserStatus.OK.getCode());
        user.setSecurityLevel(Integer.valueOf(1));
        user.setMaxSessions(Integer.valueOf(1));
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setCorporationId(sysStru.getParentId());
        user.setDepartmentId(sysStru.getParentId());
        user.setEmployeeId(sysStru.getId());
        user.setTypeProperty("1");
        Integer userOrder = this.sysUsersService.getMaxOrder(user.getDepartmentId());
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        this.sysUsersService.save((Object)user);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && user.geteMail() != null) {
            CreateUserSendMailUtil.sendMail((SysUsers)user, (String)pass);
        }
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(user.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.sysUserRoleMapper.insert(userRole);
    }

    private void initialization(AddStaffDto addStaffDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_STAFF_DTO_INITIALIZE.getMessage()), (Object)JSON.toJSONString((Object)addStaffDto));
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(addStaffDto.getParentId());
        sysStru.setStruType("9");
        sysStru.setOrganAlias(StringUtils.trimToEmpty((String)addStaffDto.getStaffName()));
        sysStru.setStaffPosition(StringUtils.trimToEmpty((String)addStaffDto.getStaffPosition()));
        sysStru.setIsEmployee("1");
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setStruId(Long.valueOf(sysStruId));
        sysStaff.setName(StringUtils.trimToEmpty((String)addStaffDto.getStaffName()));
        sysStaff.setAddress(StringUtils.trimToEmpty((String)addStaffDto.getAddress()));
        sysStaff.setBirthday(StringUtils.trimToEmpty((String)addStaffDto.getBirthday()));
        sysStaff.setSex(StringUtils.trimToEmpty((String)addStaffDto.getSex()));
        sysStaff.setIdcard(StringUtils.trimToEmpty((String)addStaffDto.getIdcard()));
        sysStaff.setGraduateDate(StringUtils.trimToEmpty((String)addStaffDto.getGraduateDate()));
        sysStaff.setGraduateSchool(StringUtils.trimToEmpty((String)addStaffDto.getGraduateSchool()));
        sysStaff.setWorkDate(StringUtils.trimToEmpty((String)addStaffDto.getWorkDate()));
        sysStaff.setWorkId(StringUtils.trimToEmpty((String)addStaffDto.getWorkId()));
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(StringUtils.trimToEmpty((String)addStaffDto.getStaffCode()));
        sysOrgan.setOrganName(sysStaff.getName());
        sysOrgan.setOrganType("9");
        String newCode = this.getCode(sysOrgan);
        sysOrgan.setOrganCode(newCode);
    }

    @Override
    public String add(StaffDto staffDto) {
        StringBuilder stringBuilder = new StringBuilder("");
        SysStaff sysStaff = new SysStaff();
        long id = IdWorker.getId((Object)sysStaff);
        staffDto.setId(Long.valueOf(id));
        Integer maxOrder = this.sysStaffMapper.getMaxOrder();
        sysStaff.setStaffOrder(Integer.valueOf(maxOrder != null ? maxOrder + 1 : 1));
        String code = this.getCode(staffDto.getStaffCode());
        staffDto.setStaffCode(code);
        BeanUtil.copy((Object)staffDto, (Object)sysStaff);
        if (this.hussarBaseIDCardProperties.getNotEmpty().booleanValue() && HussarUtils.isNotEmpty((Object)sysStaff) && HussarUtils.isEmpty((Object)sysStaff.getIdcard())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IDCARD_REQUIRED.getMessage()));
        }
        if (this.hussarBaseIDCardProperties.getUniqueness().booleanValue() && HussarUtils.isNotEmpty((Object)sysStaff) && HussarUtils.isNotEmpty((Object)sysStaff.getIdcard())) {
            String encryptIdCard = sysStaff.getIdcard();
            if (HussarUtils.isNotEmpty((Object)this.defaultSMEncrypt)) {
                encryptIdCard = this.defaultSMEncrypt.encrypt(sysStaff.getIdcard());
            }
            LambdaQueryWrapper qSysStaff = new LambdaQueryWrapper();
            qSysStaff.eq(SysStaff::getIdcard, (Object)encryptIdCard);
            List list = this.sysStaffService.list((Wrapper)qSysStaff);
            if (HussarUtils.isNotEmpty((Object)list)) {
                String staffNames = "";
                for (int i = 0; i < list.size(); ++i) {
                    SysStaff checkStaff = (SysStaff)list.get(i);
                    if (!HussarUtils.isNotEmpty((Object)checkStaff) || !HussarUtils.isNotEmpty((Object)checkStaff.getIdcard()) || !checkStaff.getIdcard().equals(sysStaff.getIdcard())) continue;
                    staffNames = staffNames + checkStaff.getName() + "\uff08" + checkStaff.getStaffCode() + "\uff09,";
                }
                if (HussarUtils.isNotEmpty((Object)staffNames) && staffNames.length() > 0) {
                    staffNames = staffNames.substring(0, staffNames.length() - 1);
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IDCARD_DB_EXIST.getMessage()) + staffNames);
                }
            }
            LambdaQueryWrapper qSysStaffAudit = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)qSysStaffAudit.eq(SysStaffAudit::getIdcard, (Object)encryptIdCard)).eq(SysStaffAudit::getAuditStatus, (Object)"0");
            List sysStaffAuditList = this.sysStaffAuditService.list((Wrapper)qSysStaffAudit);
            if (HussarUtils.isNotEmpty((Object)sysStaffAuditList)) {
                String auditStaffNames = "";
                for (int i = 0; i < sysStaffAuditList.size(); ++i) {
                    SysStaffAudit checkSysStaffAudit = (SysStaffAudit)sysStaffAuditList.get(i);
                    if (!HussarUtils.isNotEmpty((Object)checkSysStaffAudit) || !HussarUtils.isNotEmpty((Object)checkSysStaffAudit.getIdcard()) || !checkSysStaffAudit.getIdcard().equals(sysStaff.getIdcard())) continue;
                    auditStaffNames = auditStaffNames + checkSysStaffAudit.getName() + "\uff08" + checkSysStaffAudit.getStaffCode() + "\uff09,";
                }
                if (HussarUtils.isNotEmpty((Object)auditStaffNames) && auditStaffNames.length() > 0) {
                    auditStaffNames = auditStaffNames.substring(0, auditStaffNames.length() - 1);
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_IDCARD_AUDIT.getMessage()) + auditStaffNames);
                }
            }
        }
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            this.validateUserManager.validateLimit();
            this.sysStaffService.save((Object)sysStaff);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
            this.dealSaveOrUpdate(staffDto);
            this.staffChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStaff});
            this.syncUser(staffDto);
            return stringBuilder.toString();
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
            List audits = this.sysStaffAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStaffCode, (Object)staffDto.getStaffCode())).eq(SysStaffAudit::getAuditStatus, (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)audits)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_CODE_REVIEW.getMessage()));
            }
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            BeanUtil.copy((Object)sysStaff, (Object)sysStaffAudit);
            long sysStaffAuditId = IdWorker.getId((Object)sysStaffAudit);
            sysStaffAudit.setId(Long.valueOf(sysStaffAuditId));
            sysStaffAudit.setRealStaffId(sysStaff.getId());
            sysStaffAudit.setAuditStatus("0");
            sysStaffAudit.setOperateType("1");
            this.sysStaffAuditService.save((Object)sysStaffAudit);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage()));
            this.auditDealSaveOrUpdate(staffDto);
            return stringBuilder.toString();
        }
        this.sysStaffService.save((Object)sysStaff);
        stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
        this.dealSaveOrUpdate(staffDto);
        this.staffChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStaff});
        return stringBuilder.toString();
    }

    private String getCode(String code) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF");
                lambdaQueryWrapper.eq(SysStaff::getStaffCode, (Object)code);
                currentCount = this.sysStaffMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysStaff::getStaffCode, (Object)code);
            currentCount = this.sysStaffMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_CODE.getMessage()));
            }
        }
        return code;
    }

    private void syncUser(StaffDto staffDto) {
        boolean isUpper = false;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && StringUtils.isNotBlank((CharSequence)staffDto.getName()) && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)staffDto.getName())) {
            isUpper = true;
        }
        if (this.sysUsersService.isExistAccount(isUpper ? staffDto.getName().toUpperCase() : staffDto.getName())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
        }
        SysUsers user = this.initUser(staffDto, isUpper);
        this.sysUsersService.save((Object)user);
        this.handleRelation(user, staffDto);
        this.userChangeNotify.notify(DataChangeType.INSERT, new Object[]{user});
    }

    private void handleRelation(SysUsers user, StaffDto staffDto) {
        Long userId = user.getId();
        String struIds = StringUtils.trimToEmpty((String)staffDto.getOrganId());
        ArrayList<Long> organIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            organIdList.addAll(Arrays.asList(temp));
        }
        ArrayList<SysStruUser> struUsers = new ArrayList<SysStruUser>();
        for (Long struId : organIdList) {
            SysStruUser struUser = new SysStruUser();
            struUser.setStruId(struId);
            struUser.setUserId(userId);
            struUsers.add(struUser);
        }
        this.sysStruUserService.saveBatch(struUsers, struUsers.size());
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(user.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.userRoleService.save((Object)userRole);
    }

    private SysUsers initUser(StaffDto staffDto, Boolean isUpper) {
        SysUsers user = new SysUsers();
        long id = IdWorker.getId((Object)user);
        user.setId(Long.valueOf(id));
        user.setUserAccount(isUpper != false ? staffDto.getName().toUpperCase() : staffDto.getName());
        user.setUserName(StringUtils.trimToEmpty((String)staffDto.getName()));
        user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(StringUtils.trimToEmpty((String)staffDto.getName())));
        user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(StringUtils.trimToEmpty((String)staffDto.getName())));
        user.setAccountStatus(UserStatus.OK.getCode());
        user.setMaxSessions(Integer.valueOf(1));
        user.setSecurityLevel(Integer.valueOf(this.protectionStatusConfigBoService.isFenBaoEnable() != false ? 60 : 1));
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        user.setTypeProperty("1");
        user.setEmployeeId(staffDto.getId());
        Integer userOrder = this.sysUsersMapper.getUserMaxOrder();
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        user.setCorporationId(user.getDepartmentId());
        user.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
        String secure = this.pwdConfigService.getDefaultPassword();
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue()) {
            AssertUtil.isNotEmpty((String)user.geteMail(), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CREATE_USER_MAST_SEND_EMAIL.getMessage()));
            if (!this.createUserConfigService.getCreateUserUseDefaultPass().booleanValue()) {
                secure = GeneratePassword.generate((String)this.pwdConfigService.getPwdRule());
            }
        }
        String encodeSecure = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
        user.setPassword(encodeSecure);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && HussarUtils.isNotBlank((CharSequence)user.geteMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)user, (String)secure);
        }
        return user;
    }
}

