/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleExpandService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarBaseUserStruRoleServiceImpl
implements IHussarBaseUserRoleExpandService {
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruRoleService sysStruRoleService;

    public String getRelateType() {
        return "stru";
    }

    public List<Long> getExpandRolesByUserId(Long userId) {
        List struUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId));
        if (HussarUtils.isEmpty((Object)struUsers)) {
            return Collections.emptyList();
        }
        List struIds = struUsers.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        List struRoles = this.sysStruRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, struIds));
        if (HussarUtils.isEmpty((Object)struRoles)) {
            return Collections.emptyList();
        }
        return struRoles.stream().map(SysStruRole::getGrantedRole).distinct().collect(Collectors.toList());
    }

    public List<Long> getRolesByBusinessId(List<Long> businessIds) {
        if (HussarUtils.isEmpty(businessIds)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_ID_NOT_EMPTY.getMessage()));
        }
        List struRoles = this.sysStruRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, businessIds));
        if (HussarUtils.isEmpty((Object)struRoles)) {
            return Collections.emptyList();
        }
        return struRoles.stream().map(SysStruRole::getGrantedRole).collect(Collectors.toList());
    }
}

