/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysLoginUserIdentityMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.CopyUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.SwitchUserAccountDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserActivateDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserSecureDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.EditUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.ExportUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.RestUserSecureManager;
import com.jxdinfo.hussar.authorization.permit.manager.SortUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.HussarBaseUserCustomExcelServiceImpl;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.UserExcel;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.vo.EnableSwitchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserMobileVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.properties.SwitchUserProperties;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserCount;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.FileAddition;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseUserServiceImpl")
public class HussarBaseUserServiceImpl
implements IHussarBaseUserService {
    public static final String TENANT_MASTER = "master";
    protected static final String PARENTID = "parentId";
    protected static final String ORGANPROPERTY = "organProperty";
    @Lazy
    @Autowired
    private QueryUserManager queryUserManager;
    @Autowired
    private RestUserSecureManager restUserSecureManager;
    @Autowired
    private AddUserManager addUserManager;
    @Autowired
    private EditUserManager editUserManager;
    @Autowired
    private DeleteUserManager deleteUserManager;
    @Autowired
    private SortUserManager sortUserManager;
    @Autowired
    @Lazy
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ExportUserManager exportUserManager;
    @Autowired
    private HussarBaseUserCustomExcelServiceImpl hussarBaseCustomExcelService;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private SysLoginUserIdentityMapper sysLoginUserIdentityMapper;
    @Resource
    private SwitchUserProperties switchUserProperties;
    @Resource
    private ISysUserPostService sysUserPostService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private IHussarBasePostService postService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ILocalHussarBaseUserIdentityService userIdentityService;
    @Resource
    protected SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private ISysStruService sysStruService;
    @Resource
    protected IProtectionStatusConfigBoService protectionStatusConfigBoService;

    public ApiResponse<Page<SearchUserVo>> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return ApiResponse.success(this.queryUserManager.searchUsersAllowPinyin(pageInfo, queryUserDto));
    }

    public ApiResponse<List<UserTreeVo>> lazyLoadingUserTree(Long parentId, String organProperty) {
        return ApiResponse.success(this.queryUserManager.lazyLoadingUserTree(parentId, organProperty));
    }

    public ApiResponse<List<UserTreeVo>> getOrderUserTree(Long parentId) {
        return ApiResponse.success(this.queryUserManager.getOrderUserTree(parentId));
    }

    public ApiResponse<List<UserTreeVo>> backUserTree(Long id) {
        return ApiResponse.success(this.queryUserManager.backUserTree(id));
    }

    public ApiResponse<UserPartialVo> viewUser(Long id) {
        return ApiResponse.success((Object)this.queryUserManager.viewUser(id));
    }

    public ApiResponse<UserInfolVo> loadUser(Long id) {
        return ApiResponse.success((Object)this.queryUserManager.loadUser(id));
    }

    @HussarTransactional
    public ApiResponse<Long> addUser(AddUserDto addUserDto) {
        return this.addUserManager.addUser(addUserDto);
    }

    @HussarTransactional
    public ApiResponse<String> editUser(EditUserDto editUserDto) {
        return ApiResponse.success((String)this.editUserManager.editUser(editUserDto));
    }

    @HussarTransactional
    public ApiResponse<String> deleteUser(Long id) {
        return ApiResponse.success((String)this.deleteUserManager.deleteUser(id));
    }

    @HussarTransactional
    public ApiResponse<String> copyUserRole(CopyUserRoleDto copyRoleDto) {
        return ApiResponse.success((String)this.editUserManager.copyUserRole(copyRoleDto));
    }

    @HussarTransactional
    public ApiResponse<String> dormancyUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.dormancyUser(id));
    }

    @HussarTransactional
    public ApiResponse<String> sortUser(List<Long> idList) {
        return ApiResponse.success((String)this.sortUserManager.sortUser(idList));
    }

    public ApiResponse<String> cancelUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.cancelUser(id));
    }

    public ApiResponse<String> activateUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.activateUser(id));
    }

    public ApiResponse<String> activateTempUser(UserActivateDto activateDto) {
        return ApiResponse.success((String)this.editUserManager.activateTempUser(activateDto));
    }

    public ApiResponse<Page<SearchUserVo>> searchCopyRoleUsers(PageInfo pageInfo, QueryCopyRoleUserDto queryCopyRoleUserDto) {
        return ApiResponse.success(this.queryUserManager.searchCopyRoleUsers(pageInfo, queryCopyRoleUserDto));
    }

    public ApiResponse<Page<SearchUserVo>> unRelateStaffUserList(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return ApiResponse.success(this.queryUserManager.unRelateStaffUserList(pageInfo, queryUserDto));
    }

    public ApiResponse<List<UserVo>> getUserByPostId(Long postId) {
        return ApiResponse.success(this.queryUserManager.getUserByPostId(postId));
    }

    public ApiResponse<Page<SearchUserVo>> postUserList(PageInfo pageInfo, String organTypeCode, List<Long> organIds, String userName, String userAccount) {
        return ApiResponse.success(this.queryUserManager.postUserList(pageInfo, organTypeCode, organIds, userName, userAccount));
    }

    public ApiResponse<Page<SearchUserVo>> getUserList(PageInfo pageInfo, String userName, String userAccount) {
        return ApiResponse.success(this.queryUserManager.getUserList(pageInfo, userName, userAccount));
    }

    public ApiResponse<Page<ResetSecureUserVo>> searchResetSecureUsers(PageInfo pageInfo, ResetSecureUserDto resetSecureUserDto) {
        return ApiResponse.success(this.queryUserManager.searchResetSecureUsers(pageInfo, resetSecureUserDto));
    }

    @HussarTransactional
    public ApiResponse<UpdateInfoVo> resetUserSecure(UserSecureDto userSecureDto) {
        return ApiResponse.success((Object)this.restUserSecureManager.resetUserSecure(userSecureDto));
    }

    public List<OrganTreeInitVo> getUserTreeInitVos(Long parentId, int ifLazy, Integer defaultLevel) {
        if (ifLazy != 0 && ifLazy != 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTER_TRUE_LAZY_PARAM.getMessage()));
        }
        int defaultLevelNum = 1;
        if (defaultLevel != null && defaultLevel > 0) {
            defaultLevelNum = defaultLevel;
        }
        if (ifLazy == 0) {
            defaultLevelNum = 0;
        }
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getOrgansByParentIdAndLevel(parentId, defaultLevelNum, false, true);
        ArrayList<Long> organIds = new ArrayList<Long>();
        for (OrganTreeInitVo organ : organs) {
            if (defaultLevelNum != 0) {
                if (organ.getChangedLevel() >= defaultLevelNum) continue;
                organIds.add((Long)organ.getId());
                continue;
            }
            organIds.add((Long)organ.getId());
        }
        List<Object> users = new ArrayList();
        if (organIds.size() != 0) {
            users = this.queryUserManager.getUsersByOrganIds(organIds);
        }
        if (parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            OrganTreeInitVo firstOrgan = this.sysStruMapper.queryOrganInfoById(OrganConstants.ROOT_ORGAN_ID);
            organs.add(firstOrgan);
        }
        organs.addAll(users);
        List<OrganTreeInitVo> organTree = this.queryOrganizationManager.getOrganTree(organs);
        return organTree;
    }

    public List<OrganTreeInitVo> getChildrenUsersByParentId(Long parentId) {
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getChildrenOrgan(parentId, false, true);
        List<OrganTreeInitVo> users = this.queryUserManager.getChildrenUsersByParentId(parentId);
        organs.addAll(users);
        return organs;
    }

    public ApiResponse<List<OrganTreeInitVo>> getUsersLikeName(String searchValue) {
        List<OrganTreeInitVo> users = this.queryUserManager.getUsersLikeName(searchValue);
        return ApiResponse.success(users);
    }

    public List<OrganTreeInitVo> getUpUserTreeByUserId(Long userId, Long parentId) {
        Integer defaultLevel = 0;
        Integer parentLevel = 0;
        if (!userId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            parentLevel = this.queryOrganizationManager.getOrganLevelByOrganId(parentId);
            if (parentLevel != null) {
                defaultLevel = parentLevel + 1;
            } else {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTER_TRUE_PARAM.getMessage()));
            }
        }
        List<OrganTreeInitVo> parentLevelOrganUsersList = this.sysStruMapper.queryUpOrgansByFidAndLevelForUserTree("", defaultLevel, false, true);
        for (OrganTreeInitVo organ : parentLevelOrganUsersList) {
            organ.setChangedLevel(organ.getStruLevel() + 1);
        }
        OrganTreeInitVo firstOrgan = this.sysStruMapper.queryOrganInfoById(OrganConstants.ROOT_ORGAN_ID);
        parentLevelOrganUsersList.add(firstOrgan);
        List<OrganTreeInitVo> users = this.queryUserManager.queryUpUsersByFidAndLevel("", parentLevel);
        parentLevelOrganUsersList.addAll(users);
        List<OrganTreeInitVo> brotherUsers = this.sysUsersMapper.queryBrotherUsersByParentId(parentId);
        List<OrganTreeInitVo> brotherOrgans = this.sysStruMapper.queryBrotherOrganForUserTree(parentId, false, true);
        ArrayList<OrganTreeInitVo> organsAndUsers = new ArrayList<OrganTreeInitVo>();
        organsAndUsers.addAll(parentLevelOrganUsersList);
        organsAndUsers.addAll(brotherOrgans);
        organsAndUsers.addAll(brotherUsers);
        return this.queryOrganizationManager.getOrganTree(organsAndUsers);
    }

    public ApiResponse<OrganTreeInitVo> getUserInfoByUserId(Long userId) {
        List<OrganTreeInitVo> users = this.queryUserManager.getUserInfoByUserId(userId);
        if (users.size() < 1) {
            return null;
        }
        OrganTreeInitVo user = users.get(0);
        String firstFid = user.getStruFid();
        String firstFname = user.getParentName();
        for (int i = 1; i < users.size(); ++i) {
            String fId = users.get(i).getStruFid();
            String fName = users.get(i).getParentName();
            firstFid = firstFid + "," + fId;
            firstFname = firstFname + "," + fName;
        }
        user.setStruFid(firstFid);
        user.setParentName(firstFname);
        return ApiResponse.success((Object)user);
    }

    public ApiResponse<List<OrganTreeInitVo>> getUsersByParentId(Long parentId) {
        String fid = "";
        if (!parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            fid = this.sysStruMapper.getStruFidByOrganId(parentId);
        }
        List<OrganTreeInitVo> users = this.queryUserManager.getAllChildrenUsers(fid);
        return ApiResponse.success(users);
    }

    public ApiResponse<List<SearchUserMobileVo>> getUsersByStruId(Long struId) {
        List<SearchUserMobileVo> userList = this.queryUserManager.getUsersByStruId(struId);
        return ApiResponse.success(userList);
    }

    public ApiResponse<List<SearchUserMobileVo>> getUsersByUserIds(List<Long> userIds) {
        List<SearchUserMobileVo> userList = this.queryUserManager.getUsersByUserIds(userIds);
        return ApiResponse.success(userList);
    }

    public ApiResponse<List<UserVo>> getRoleUser(String roleId) {
        return ApiResponse.success(this.queryUserManager.getRoleUser(roleId));
    }

    public List<UserVo> getUsersByStruIds(List<Long> struIds) {
        return this.queryUserManager.getUsersByStruIds(struIds);
    }

    public void exportUserExcel(String ids, Long taskId, boolean exportKey) {
        this.exportUserManager.exportUserExcel(ids, taskId, exportKey);
    }

    public void exportUserExcelWithSecurity(String ids, Long taskId, boolean exportKey, String securityLevel) throws Exception {
        this.exportUserManager.exportUserExcelWithSecurity(ids, taskId, exportKey, securityLevel);
    }

    public void exportUserExcelWithSecurityForBigDate(List<String> idList, Long taskId, Boolean exportKey, String securityLevel, Boolean isAssociateSub) {
        this.exportUserManager.exportUserExcelWithSecurityForBigDate(idList, taskId, exportKey, securityLevel, isAssociateSub);
    }

    public void exportUserExcelWithSub(String ids, Long taskId, boolean exportKey) throws Exception {
        this.exportUserManager.exportUserExcelWithSub(ids, taskId, exportKey);
    }

    public void downloadUserExcelImpTpl(HttpServletResponse response, String fileKey) {
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            fileKey = fileKey + "Security";
        }
        this.hussarBaseExcelServiceImpl.downloadImportTpl(response, "\u7528\u6237\u4eba\u5458Excel\u5bfc\u5165\u6a21\u677f", fileKey);
    }

    @HussarTransactional
    public void importUserExcel(String scenario, Long taskId, String organProperty) {
        this.hussarBaseCustomExcelService.addOrganPropertyMap(taskId, organProperty);
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            HussarContextHolder.setTenant((String)connName, (String)tenantCode);
            ImportSheetMsg importSheetMsg = new ImportSheetMsg(Integer.valueOf(0), UserExcel.class, (IHussarBaseCustomExcelService)this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg);
            this.hussarBaseExcelServiceImpl.importExcelSheets(importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap());
        });
    }

    public void checkUserExcel(MultipartFile userFile, String scenario, Long taskId, String organProperty) {
        InputStream input;
        try {
            input = userFile.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = userFile.getOriginalFilename();
        ApiResponse fileResponse = this.ossService.backgroundUpload(userFile);
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setFileName(fileName);
        task.setCheckScenario(scenario);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        this.hussarBaseCustomExcelService.addOrganPropertyMap(taskId, organProperty);
        Map<Integer, List<String>> selectParamMap = this.exportUserManager.getUserExcelOptions();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), UserExcel.class, (IHussarBaseCustomExcelService)this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            this.hussarBaseExcelServiceImpl.checkExcelSheets(input, importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap(), selectParamMap);
        });
    }

    public void checkUserExcelWithSecurity(MultipartFile userFile, String scenario, Long taskId, String organProperty, String securityLevel) {
        ApiResponse fileResponse;
        InputStream input;
        try {
            input = userFile.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = userFile.getOriginalFilename();
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            FileAddition addition = new FileAddition();
            addition.setSecurityLevel(securityLevel);
            String securityAddition = JsonUtil.toJson((Object)addition);
            fileResponse = this.ossService.backgroundUploadWithAddition(userFile, securityAddition);
        } else {
            fileResponse = this.ossService.backgroundUpload(userFile);
        }
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setFileName(fileName);
        task.setCheckScenario(scenario);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        this.hussarBaseCustomExcelService.addOrganPropertyMap(taskId, organProperty);
        Map<Integer, List<String>> selectParamMap = this.exportUserManager.getUserExcelOptions();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), UserExcel.class, (IHussarBaseCustomExcelService)this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            this.hussarBaseExcelServiceImpl.checkExcelSheets(input, importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap(), selectParamMap);
        });
    }

    public ApiResponse<String> switchUserAccount(SwitchUserAccountDto switchUserAccountDto) {
        String tenantCode;
        Map userMap;
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        Long originalUserId = switchUserAccountDto.getOriginalUserId();
        Long userId = switchUserAccountDto.getUserId();
        Long struId = switchUserAccountDto.getStruId();
        Long postId = switchUserAccountDto.getPostId();
        BaseException.throwBy((boolean)HussarUtils.isEmpty((Object)originalUserId), (String)"\u539f\u59cb\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        BaseException.throwBy((boolean)HussarUtils.isEmpty((Object)userId), (String)"\u5207\u6362\u76ee\u6807\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        BaseException.throwBy((HussarUtils.isEmpty((Object)struId) && HussarUtils.isEmpty((Object)postId) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7id\u548c\u5c97\u4f4did\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        boolean flag = true;
        Map switchInfo = this.switchUserProperties.getInfo();
        if (HussarUtils.isNotEmpty((Object)switchInfo) && HussarUtils.isNotEmpty((Object)(userMap = (Map)switchInfo.get(tenantCode = HussarUtils.isBlank((CharSequence)userDetails.getTenantCode()) ? TENANT_MASTER : userDetails.getTenantCode()))) && userMap.containsKey(originalUserId) && (((List)userMap.get(originalUserId)).contains(userId) || HussarUtils.equals((Object)originalUserId, (Object)userId))) {
            flag = false;
        }
        BaseException.throwBy((boolean)flag, (String)"\u672a\u67e5\u8be2\u5230\u53ef\u5207\u6362\u7684\u8d26\u53f7\u914d\u7f6e\u4fe1\u606f\uff01");
        SysUsers targetUser = (SysUsers)this.sysUsersMapper.selectById(userId);
        BaseException.throwBy((HussarUtils.isNull((Object)targetUser) || !HussarUtils.equals((Object)targetUser.getAccountStatus(), (Object)UserStatus.OK.getCode()) ? 1 : 0) != 0, (String)"\u8be5\u8d26\u53f7\u72b6\u6001\u4e0d\u53ef\u7528\uff01");
        userDetails.setUserId(userId);
        userDetails.setLoginId((Object)userId);
        userDetails.setUserName(targetUser.getUserName());
        userDetails.addExtendUserMap("account", (Object)targetUser.getUserAccount());
        this.userIdentityService.handleUserIdentity(userDetails, Long.valueOf(1L));
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)("hussar_menus:" + userDetails.getUserId()));
        HussarCacheUtil.evictKeysLike((String)"resource_info", (String)("hussar_resource:" + userDetails.getUserId()));
        this.userIdentityService.updateSecurityUser(userDetails);
        return ApiResponse.success((String)"\u5207\u6362\u6210\u529f\uff01");
    }

    public ApiResponse<List<EnableSwitchUserVo>> getUserAccountList(Long originalUserId) {
        String tenantCode;
        Map userMap;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        Map switchInfo = this.switchUserProperties.getInfo();
        List<Long> userIdList = new ArrayList<Long>();
        ArrayList<EnableSwitchUserVo> enableSwitchUserVoList = new ArrayList<EnableSwitchUserVo>();
        List configList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)switchInfo) && HussarUtils.isNotEmpty((Object)(userMap = (Map)switchInfo.get(tenantCode = HussarUtils.isBlank((CharSequence)user.getTenantCode()) ? TENANT_MASTER : user.getTenantCode()))) && userMap.containsKey(originalUserId)) {
            configList = (List)userMap.get(originalUserId);
            userIdList.add(originalUserId);
            userIdList.addAll(configList);
        }
        if (!userIdList.isEmpty()) {
            List userList = this.sysUsersMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUsers::getId, userIdList)).eq(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode()));
            userIdList = !userList.isEmpty() ? userList.stream().map(SysUsers::getId).collect(Collectors.toList()) : new ArrayList();
        }
        if (!userIdList.isEmpty()) {
            enableSwitchUserVoList.addAll(this.sysLoginUserIdentityMapper.queryDefaultUserLoginInfoList(userIdList));
            if (enableSwitchUserVoList.size() < userIdList.size()) {
                userIdList.removeAll(enableSwitchUserVoList.stream().map(EnableSwitchUserVo::getUserId).collect(Collectors.toList()));
                userIdList.forEach(userId -> enableSwitchUserVoList.add(this.getFirstLoginUserIdentity((Long)userId)));
            }
        }
        if (!enableSwitchUserVoList.isEmpty() && !configList.isEmpty()) {
            ArrayList finalConfigList = configList;
            enableSwitchUserVoList.sort((u1, u2) -> {
                int io1 = finalConfigList.indexOf(u1.getUserId());
                int io2 = finalConfigList.indexOf(u2.getUserId());
                if (io1 == -1) {
                    return -1;
                }
                if (io2 == -1) {
                    return 1;
                }
                io1 = enableSwitchUserVoList.size() - io1;
                io2 = enableSwitchUserVoList.size() - io2;
                return io2 - io1;
            });
        }
        return ApiResponse.success(enableSwitchUserVoList);
    }

    public ApiResponse<Boolean> switchUserFlag(Long originalUserId) {
        String tenantCode;
        Map userMap;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        Boolean enable = this.switchUserProperties.getEnable();
        Map switchInfo = this.switchUserProperties.getInfo();
        if (enable.booleanValue() && HussarUtils.isNotEmpty((Object)switchInfo) && HussarUtils.isNotEmpty((Object)(userMap = (Map)switchInfo.get(tenantCode = HussarUtils.isBlank((CharSequence)user.getTenantCode()) ? TENANT_MASTER : user.getTenantCode()))) && userMap.containsKey(originalUserId) && HussarUtils.isNotEmpty(userMap.get(originalUserId))) {
            return ApiResponse.success((Object)Boolean.TRUE);
        }
        return ApiResponse.success((Object)Boolean.FALSE);
    }

    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        return this.queryUserManager.lazyOrganUserTree(parentOrganIds, needParentOrganInfo, resultType);
    }

    private EnableSwitchUserVo getFirstLoginUserIdentity(Long userId) {
        EnableSwitchUserVo vo = new EnableSwitchUserVo();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(userId);
        vo.setUserId(userId);
        vo.setUserName(user.getUserName());
        List userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId)).orderByAsc(HussarBaseEntity::getCreateTime));
        List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId)).orderByAsc(HussarBaseEntity::getCreateTime));
        SysPost post = null;
        if (HussarUtils.isNotEmpty((Object)userPosts)) {
            List mainUserPosts = userPosts.stream().filter(staffPost -> HussarUtils.equals((Object)"0", (Object)staffPost.getRelateType())).collect(Collectors.toList());
            Long postId = HussarUtils.isNotEmpty(mainUserPosts) ? ((SysUserPost)mainUserPosts.get(0)).getPostId() : ((SysUserPost)userPosts.get(0)).getPostId();
            post = (SysPost)this.postService.getById((Serializable)postId);
            vo.setPostId(postId);
            vo.setPostName(post.getPostName());
        }
        if (HussarUtils.isNotEmpty((Object)struUsers)) {
            Long deptId = HussarUtils.isNotEmpty(post) ? this.getDeptIdByPostId(post, struUsers) : ((SysStruUser)struUsers.get(0)).getStruId();
            SysStru stru = (SysStru)this.sysStruMapper.selectById(deptId);
            SysOrgan organ = (SysOrgan)this.organService.getById((Serializable)stru.getOrganId());
            vo.setStruId(stru.getId());
            vo.setOrganName(organ.getOrganName());
            vo.setOrganFname(organ.getOrganFname());
        }
        return vo;
    }

    private Long getDeptIdByPostId(SysPost post, List<SysStruUser> struUsers) {
        Long deptId = struUsers.get(0).getStruId();
        if (HussarUtils.isEmpty((Object)post.getOrganTypeCode())) {
            return deptId;
        }
        String organTypeCode = post.getOrganTypeCode();
        List struIds = struUsers.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
        List strus = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getStruType, (Object)organTypeCode)).in(SysStru::getId, struIds));
        if (HussarUtils.isEmpty((Object)strus)) {
            return deptId;
        }
        boolean flag = false;
        for (SysStruUser struUser : struUsers) {
            for (SysStru stru : strus) {
                flag = HussarUtils.equals((Object)struUser.getStruId(), (Object)stru.getId()) && HussarUtils.equals((Object)organTypeCode, (Object)stru.getStruType());
                if (!flag) continue;
                deptId = stru.getId();
                break;
            }
            if (!flag) continue;
            break;
        }
        return deptId;
    }

    private Map<String, Integer> getExcludeColumnIndexesMap() {
        HashMap<String, Integer> excludeColumnIndexesMap = new HashMap<String, Integer>();
        excludeColumnIndexesMap.put("\u4eba\u5458\u7f16\u7801", 17);
        excludeColumnIndexesMap.put("\u4e3b\u952e", 25);
        return excludeColumnIndexesMap;
    }

    public List<OrganUserTreeVo> lazyOrganUserTreeCurrentOrg(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        ArrayList<OrganUserTreeVo> organUserTreeVos = new ArrayList<OrganUserTreeVo>();
        if (HussarUtils.isEmpty(parentOrganIds)) {
            return organUserTreeVos;
        }
        List<Long> organIds = this.getParentOrganIds(parentOrganIds);
        for (Long organId : organIds) {
            SysOrgan sysOrgan;
            if (organId.equals(Constants.ROOT_NODE_ID)) {
                sysOrgan = (SysOrgan)this.organService.getById((Serializable)organId);
                if (!HussarUtils.isNotEmpty((Object)sysOrgan)) continue;
                this.getInAndOutTreeCurrentOrg(needParentOrganInfo, organUserTreeVos, organId, resultType, "0", this.sysStruMapper.getOrganFname(Constants.ROOT_NODE_ID));
                continue;
            }
            if (organId.equals(Constants.OUT_STRU_NODE_ID)) {
                sysOrgan = (SysOrgan)this.organService.getById((Serializable)organId);
                if (!HussarUtils.isNotEmpty((Object)sysOrgan)) continue;
                this.getInAndOutTreeCurrentOrg(needParentOrganInfo, organUserTreeVos, organId, resultType, "1", this.sysStruMapper.getOrganFname(Constants.OUT_STRU_NODE_ID));
                continue;
            }
            this.getOrganUserTreeCurrentOrg(needParentOrganInfo, organUserTreeVos, organId, resultType);
        }
        return HussarTreeParser.getTreeList(organUserTreeVos);
    }

    private void getInAndOutTreeCurrentOrg(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType, String organProperty, String organName) {
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(0) || resultType.equals(2)) {
            List<OrganUserTreeVo> internalOrgans = this.getOneOrganInfoCurrentOrg(organId, resultType, organProperty);
            flag = internalOrgans.size() > 0;
            organUserTreeVos.addAll(internalOrgans);
        }
        if (needParentOrganInfo.booleanValue()) {
            OrganUserTreeVo internalOrganStaffTreeVo = this.initRootTree(organName, organId);
            internalOrganStaffTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVos.add(internalOrganStaffTreeVo);
        }
    }

    private List<OrganUserTreeVo> getOneOrganInfoCurrentOrg(Long organId, Integer resultType, String organProperty) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENTID, organId);
        queryParams.put(ORGANPROPERTY, organProperty);
        List<OrganUserTreeVo> organs = this.sysStruMapper.getOrganUserTreeOnlyOrgan(queryParams);
        if (HussarUtils.isEmpty(organs)) {
            return organs;
        }
        List<Long> oneOrganIds = organs.stream().map(s -> (Long)s.getId()).distinct().collect(Collectors.toList());
        List<SysStruUserCount> userCountCurrentOrg = this.sysStruUserMapper.getUserCountCurrentOrg(oneOrganIds);
        Map<Long, Integer> organIdUserCount = userCountCurrentOrg.stream().collect(Collectors.toMap(SysStruUserCount::getStruId, SysStruUserCount::getUserCount));
        for (OrganUserTreeVo treeVo : organs) {
            int count = 0;
            if (HussarUtils.isNotEmpty(organIdUserCount) && HussarUtils.isNotEmpty((Object)treeVo.getId()) && organIdUserCount.containsKey(treeVo.getId())) {
                count = organIdUserCount.get((long)((Long)treeVo.getId()));
            }
            treeVo.setUserCount(Integer.valueOf(count));
            if (resultType.equals(1)) {
                treeVo.setHasChildren(Boolean.valueOf(count > 0));
                continue;
            }
            if (!resultType.equals(2)) continue;
            treeVo.setHasChildren(Boolean.valueOf(treeVo.getHasChildren() != false || count > 0));
        }
        return organs;
    }

    private void getOrganUserTreeCurrentOrg(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType) {
        List<OrganUserTreeVo> organs;
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(0)) {
            organs = this.getOneOrganInfoCurrentOrg(organId, resultType, null);
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (resultType.equals(1)) {
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            List<OrganUserTreeVo> userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                flag = true;
                organUserTreeVos.addAll(userTreeVos);
            }
        }
        if (resultType.equals(2)) {
            organs = this.getOneOrganInfoCurrentOrg(organId, resultType, null);
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            List<OrganUserTreeVo> userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                organs.addAll(userTreeVos);
            }
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (needParentOrganInfo.booleanValue()) {
            SearchOrganVo organVo = this.sysStruMapper.getOrganById(organId);
            if (HussarUtils.isEmpty((Object)organVo)) {
                return;
            }
            OrganUserTreeVo organUserTreeVo = this.initRootTree(organVo.getLabel(), organId);
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            List<SysStruUserCount> userCountCurrentOrg = this.sysStruUserMapper.getUserCountCurrentOrg(struIds);
            if (HussarUtils.isNotEmpty(userCountCurrentOrg)) {
                Map<Long, Integer> organIdUserCount = userCountCurrentOrg.stream().collect(Collectors.toMap(SysStruUserCount::getStruId, SysStruUserCount::getUserCount));
                if (organIdUserCount.containsKey(organId) && HussarUtils.isNotEmpty((Object)organIdUserCount.get(organId))) {
                    organUserTreeVo.setUserCount(organIdUserCount.get(organId));
                } else {
                    organUserTreeVo.setUserCount(Integer.valueOf(0));
                }
            } else {
                organUserTreeVo.setUserCount(Integer.valueOf(0));
            }
            organUserTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVo.setIcon(organVo.getIcon());
            organUserTreeVo.setOrganType(organVo.getOrganType());
            organUserTreeVos.add(organUserTreeVo);
        }
    }

    private List<Long> getParentOrganIds(List<Long> struIds) {
        if (!struIds.contains(Constants.ROOT_NODE_ID) && !struIds.contains(Constants.OUT_STRU_NODE_ID)) {
            List sysStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            Map<Long, String> fidMap = sysStrus.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getStruFid));
            ArrayList<Long> removeIds = new ArrayList<Long>();
            block0: for (Long struId : struIds) {
                int num = 0;
                String fidParent = fidMap.get(struId);
                for (Long id : struIds) {
                    String fid = fidMap.get(id);
                    if (fidParent.contains(fid)) {
                        ++num;
                    }
                    if (num <= 1) continue;
                    removeIds.add(struId);
                    continue block0;
                }
            }
            struIds.removeAll(removeIds);
            return new ArrayList<Long>(struIds);
        }
        if (struIds.contains(Constants.ROOT_NODE_ID) && struIds.contains(Constants.OUT_STRU_NODE_ID)) {
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(Constants.ROOT_NODE_ID);
            result.add(Constants.OUT_STRU_NODE_ID);
            return result;
        }
        Long rootId = struIds.contains(Constants.ROOT_NODE_ID) ? Constants.ROOT_NODE_ID : Constants.OUT_STRU_NODE_ID;
        List sysStrus = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds));
        sysStrus.removeIf(item -> HussarUtils.equals((Object)item.getId(), (Object)Constants.ROOT_NODE_ID) || HussarUtils.equals((Object)item.getId(), (Object)Constants.OUT_STRU_NODE_ID));
        if (HussarUtils.isNotEmpty((Object)sysStrus)) {
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).collect(Collectors.toList());
            List parentStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)rootId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List parentFIdList = parentStrus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
            if (HussarUtils.isEmpty((Object)parentStrus)) {
                List<Long> parentOrganIds = this.getParentOrganIds(struIdList);
                ArrayList<Long> result = new ArrayList<Long>();
                result.add(rootId);
                result.addAll(parentOrganIds);
                return result;
            }
            ArrayList<SysStru> strus = new ArrayList<SysStru>();
            for (SysStru stru : sysStrus) {
                String parentFId;
                String struFid = stru.getStruFid();
                int num = 0;
                Iterator iterator = parentFIdList.iterator();
                while (iterator.hasNext() && !struFid.contains(parentFId = (String)iterator.next())) {
                    ++num;
                }
                if (num != parentFIdList.size()) continue;
                strus.add(stru);
            }
            if (HussarUtils.isEmpty(strus)) {
                ArrayList result = new ArrayList();
                result.add(rootId);
                return result;
            }
            List<Long> parentIds = strus.stream().map(SysStru::getId).collect(Collectors.toList());
            List<Long> parentOrganIds = this.getParentOrganIds(parentIds);
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(rootId);
            result.addAll(parentOrganIds);
            return result;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        result.add(rootId);
        return result;
    }

    private OrganUserTreeVo initRootTree(String organName, Long parentId) {
        OrganUserTreeVo internalOrganUserTreeVo = new OrganUserTreeVo();
        internalOrganUserTreeVo.setLabel(organName);
        internalOrganUserTreeVo.setId((Serializable)parentId);
        internalOrganUserTreeVo.setTypes("organ");
        return internalOrganUserTreeVo;
    }

    public SysUsers getUserInfo(String userAccount, List<String> accountStatus) {
        LambdaQueryWrapper qu = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qu.eq(SysUsers::getUserAccount, (Object)userAccount)).in(SysUsers::getAccountStatus, accountStatus);
        return (SysUsers)this.sysUsersMapper.selectOne((Wrapper)qu);
    }

    @HussarDs(value="#connName")
    public SysUsers getUserInfo(String connName, String userAccount, List<String> accountStatus) {
        LambdaQueryWrapper qu = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qu.eq(SysUsers::getUserAccount, (Object)userAccount)).in(SysUsers::getAccountStatus, accountStatus);
        return (SysUsers)this.sysUsersMapper.selectOne((Wrapper)qu);
    }

    static {
        ExcelConstants.TemplateMap.put("userImportTpl", "static/userImportTpl.xlsx");
        ExcelConstants.TemplateMap.put("userImportTplWithKey", "static/userImportTplWithKey.xlsx");
        ExcelConstants.TemplateMap.put("userImportTplSecurity", "static/userImportTplSecurity.xlsx");
        ExcelConstants.TemplateMap.put("userImportTplWithKeySecurity", "static/userImportTplWithKeySecurity.xlsx");
    }
}

