/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.vo.OptionVo;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataConditionFactory;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataScopeFactory;
import com.jxdinfo.hussar.support.datascope.core.support.extend.model.OptionValue;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.IDataConditionService;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.IDataScopeService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.form.render.entity.SelectOption;
import com.jxdinfo.hussar.support.form.render.entity.Widget;
import com.jxdinfo.hussar.support.form.render.enums.WidgetType;
import com.jxdinfo.hussar.support.form.render.service.IFormRenderService;
import com.jxdinfo.hussar.support.form.render.utils.WidgetDataUtil;
import com.jxdinfo.hussar.support.form.render.utils.WidgetSchemaUtil;
import com.jxdinfo.hussar.support.form.render.vo.BaseTreeNode;
import com.jxdinfo.hussar.support.form.render.vo.FormSchemaVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DataRightFormRenderServiceImpl
implements IFormRenderService {
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;

    public FormSchemaVO getSchema(String s) {
        FormSchemaVO vo = new FormSchemaVO();
        IDataScopeService dataScope = DataScopeFactory.getDataScope((String)s);
        if (HussarUtils.isEmpty((Object)dataScope)) {
            return vo;
        }
        vo.setName(dataScope.name());
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        List conditions = DataConditionFactory.getDataConditionsByScopeLabel((String)s);
        int i = 0;
        for (IDataConditionService conditionService : conditions) {
            List optionValues;
            if (!conditionService.isCustomValue()) continue;
            Widget widget = new Widget();
            WidgetType widgetType = conditionService.customValue().displayStyle();
            if (HussarUtils.equals((Object)WidgetType.INPUT, (Object)widgetType)) {
                widget = WidgetSchemaUtil.createInput((String)conditionService.customValue().desc(), (String)conditionService.label(), (int)i++);
            } else if (HussarUtils.equals((Object)WidgetType.SELECT, (Object)widgetType)) {
                optionValues = conditionService.customValue().optionValues(null);
                widget = WidgetSchemaUtil.createSelect((String)conditionService.customValue().desc(), (String)conditionService.label(), (int)i++, this.getSelectOption(optionValues));
            } else if (HussarUtils.equals((Object)WidgetType.SELECT_MULTI, (Object)widgetType)) {
                optionValues = conditionService.customValue().optionValues(null);
                widget = WidgetSchemaUtil.createSelectMulti((String)conditionService.customValue().desc(), (String)conditionService.label(), (int)i++, this.getSelectOption(optionValues));
            } else if (HussarUtils.equals((Object)WidgetType.RANGE_INPUT, (Object)widgetType)) {
                widget = WidgetSchemaUtil.createRangeInput((String)conditionService.customValue().desc(), (String)conditionService.label(), (int)i++);
            } else if (HussarUtils.equals((Object)WidgetType.TREE_MULTI, (Object)widgetType)) {
                widget = WidgetSchemaUtil.createTreeMulti((String)conditionService.customValue().desc(), (String)conditionService.label(), (String)this.type(), (String)s, (int)i++);
            } else if (HussarUtils.equals((Object)WidgetType.DATE, (Object)widgetType)) {
                widget = WidgetSchemaUtil.createDate((String)conditionService.customValue().desc(), (String)conditionService.label(), (int)i++);
            } else if (HussarUtils.equals((Object)WidgetType.TIME, (Object)widgetType)) {
                widget = WidgetSchemaUtil.createDateTime((String)conditionService.customValue().desc(), (String)conditionService.label(), (int)i++);
            } else if (HussarUtils.equals((Object)WidgetType.SWITCH, (Object)widgetType)) {
                widget = WidgetSchemaUtil.createSwitch((String)conditionService.customValue().desc(), (String)conditionService.label(), (int)i++);
                widget.getRule().setRequired(Boolean.valueOf(false));
            } else if (HussarUtils.equals((Object)WidgetType.LAZY_TREE_MULTI, (Object)widgetType)) {
                widget = WidgetSchemaUtil.createLazyTreeMulti((String)conditionService.customValue().desc(), (String)conditionService.label(), (String)this.type(), (String)s, (int)i++);
            }
            widgets.add(widget);
        }
        vo.setWidgets(widgets);
        return vo;
    }

    public Map<String, Object> getData(String s, String s1) {
        String customDataCondition;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (HussarUtils.isEmpty((Object)s1)) {
            return result;
        }
        Map customDataConditionMap = new HashMap();
        IDataScopeService dataScope = DataScopeFactory.getDataScope((String)s);
        SysRoleDataRight roleDataRight = (SysRoleDataRight)this.sysRoleDataRightService.getById((Serializable)Long.valueOf(Long.parseLong(s1)));
        if (HussarUtils.equals((Object)PermitConstants.DATA_SCOPE_EXTEND, (Object)roleDataRight.getDataScope()) && HussarUtils.isEmpty(customDataConditionMap = (Map)JSON.parseObject((String)(customDataCondition = roleDataRight.getCustomDataCondition()), (TypeReference)new TypeReference<Map<String, List<OptionVo>>>(){}, (Feature[])new Feature[0]))) {
            return result;
        }
        for (Map.Entry entry : customDataConditionMap.entrySet()) {
            IDataConditionService conditionService = DataConditionFactory.getDataCondition((String)((String)entry.getKey()));
            WidgetType widgetType = conditionService.customValue().displayStyle();
            List optionVos = (List)entry.getValue();
            if (HussarUtils.isEmpty((Object)optionVos)) continue;
            if (HussarUtils.equals((Object)WidgetType.INPUT, (Object)widgetType)) {
                WidgetDataUtil.generateInputData(result, (String)((String)entry.getKey()), (String)((OptionVo)optionVos.get(0)).getValue());
                continue;
            }
            if (HussarUtils.equals((Object)WidgetType.SELECT, (Object)widgetType)) {
                WidgetDataUtil.generateSelectData(result, (String)((String)entry.getKey()), (String)((OptionVo)optionVos.get(0)).getValue(), (String)((OptionVo)optionVos.get(0)).getLabel());
                continue;
            }
            if (HussarUtils.equals((Object)WidgetType.SELECT_MULTI, (Object)widgetType)) {
                WidgetDataUtil.generateSelectMultiData(result, (String)((String)entry.getKey()), this.getSelectOption(optionVos));
                continue;
            }
            if (HussarUtils.equals((Object)WidgetType.RANGE_INPUT, (Object)widgetType)) {
                String left = ((OptionVo)optionVos.get(0)).getValue();
                String right = ((OptionVo)optionVos.get(1)).getValue();
                WidgetDataUtil.generateRangeInputData(result, (String)((String)entry.getKey()), (Integer)(HussarUtils.isEmpty((Object)left) ? null : Integer.valueOf(Integer.parseInt(left))), HussarUtils.isEmpty((Object)right) ? null : Integer.valueOf(Integer.parseInt(right)));
                continue;
            }
            if (HussarUtils.equals((Object)WidgetType.TREE_MULTI, (Object)widgetType)) {
                WidgetDataUtil.generateTreeMultiData(result, (String)((String)entry.getKey()), this.getTreeNode(optionVos));
                continue;
            }
            if (HussarUtils.equals((Object)WidgetType.DATE, (Object)widgetType)) {
                WidgetDataUtil.generateDateData(result, (String)((String)entry.getKey()), (LocalDate)Java8DateUtils.convertStringToLocalDate((String)((OptionVo)optionVos.get(0)).getValue()));
                continue;
            }
            if (HussarUtils.equals((Object)WidgetType.TIME, (Object)widgetType)) {
                WidgetDataUtil.generateLocalDateTimeData(result, (String)((String)entry.getKey()), (LocalDateTime)Java8DateUtils.convertStringToLocalDateTime((String)((OptionVo)optionVos.get(0)).getValue()));
                continue;
            }
            if (HussarUtils.equals((Object)WidgetType.SWITCH, (Object)widgetType)) {
                WidgetDataUtil.generateSwitchData(result, (String)((String)entry.getKey()), (Integer)Integer.parseInt(((OptionVo)optionVos.get(0)).getValue()));
                continue;
            }
            if (!HussarUtils.equals((Object)WidgetType.LAZY_TREE_MULTI, (Object)widgetType)) continue;
            WidgetDataUtil.generateTreeMultiData(result, (String)((String)entry.getKey()), this.getTreeNode(optionVos));
        }
        return result;
    }

    public String type() {
        return "custom_data_right";
    }

    private List<SelectOption> getSelectOption(List<?> options) {
        if (HussarUtils.isEmpty(options)) {
            return Collections.emptyList();
        }
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        for (Object vo : options) {
            SelectOption selectOption = new SelectOption();
            if (vo instanceof OptionVo) {
                BeanUtils.copyProperties(vo, (Object)selectOption);
            } else if (vo instanceof OptionValue) {
                OptionValue optionValue = (OptionValue)vo;
                selectOption.setValue(optionValue.getId());
                selectOption.setLabel(optionValue.getLabel());
            }
            result.add(selectOption);
        }
        return result;
    }

    private List<BaseTreeNode> getTreeNode(List<OptionVo> optionVos) {
        ArrayList<BaseTreeNode> baseTreeNodes = new ArrayList<BaseTreeNode>();
        if (HussarUtils.isEmpty(optionVos)) {
            return baseTreeNodes;
        }
        for (OptionVo optionVo : optionVos) {
            BaseTreeNode treeNode = new BaseTreeNode();
            treeNode.setId(optionVo.getValue());
            treeNode.setLabel(optionVo.getLabel());
            baseTreeNodes.add(treeNode);
        }
        return baseTreeNodes;
    }
}

