/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTypeExpandDto;
import com.jxdinfo.hussar.authorization.permit.manager.ResourceTypeExpandManager;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceType;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceTypeExpand;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResTypeExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceTypeService;
import com.jxdinfo.hussar.authorization.permit.vo.OptionVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResTypeExpandVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.resourceTypeExpandManagerImpl")
public class ResourceTypeExpandManagerImpl
implements ResourceTypeExpandManager {
    @Autowired
    private IHussarValidateService hussarValidateService;
    @Autowired
    private IHussarBaseResourceTypeService hussarBaseResourceTypeService;
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Autowired
    private IHussarBaseResTypeExpandService hussarBaseResTypeExpandService;
    @Resource
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;

    @Override
    public String addExpand(ResourceTypeExpandDto resourceTypeExpandDto) {
        String validateMsg = this.hussarValidateService.validate((Object)resourceTypeExpandDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String options = resourceTypeExpandDto.getExpandOptions();
        this.checkOption(options);
        SysResourceTypeExpand resourceTypeExpand = new SysResourceTypeExpand();
        BeanUtils.copyProperties((Object)resourceTypeExpandDto, (Object)resourceTypeExpand);
        String currentCode = this.sysIdtableService.getCurrentCode("RESOURCE_TYPE_EXPAND_CODE", "SYS_RESOURCE_TYPE_EXPAND");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_NOT_GET_RESOURCE_TYPE_CODE.getMessage()));
        }
        resourceTypeExpand.setExpandCode(currentCode);
        this.hussarBaseResTypeExpandService.save((Object)resourceTypeExpand);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage());
    }

    @Override
    public String editExpand(ResourceTypeExpandDto resourceTypeExpandDto) {
        String validateMsg = this.hussarValidateService.validate((Object)resourceTypeExpandDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long id = resourceTypeExpandDto.getId();
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_EXPAND_ID_NOT_NULL.getMessage()));
        }
        SysResourceTypeExpand resourceTypeExpand = new SysResourceTypeExpand();
        BeanUtils.copyProperties((Object)resourceTypeExpandDto, (Object)resourceTypeExpand);
        resourceTypeExpand.setId(id);
        this.hussarBaseResTypeExpandService.updateById((Object)resourceTypeExpand);
        List resourceExpands = this.hussarBaseResourceExpandService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceTypeExpandId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)resourceExpands)) {
            resourceExpands.forEach(r -> r.setResourceTypeExpandName(resourceTypeExpand.getExpandName()));
            this.hussarBaseResourceExpandService.saveOrUpdateBatch((Collection)resourceExpands);
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
    }

    @Override
    public String deleteExpand(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_EXPAND_ID_NOT_NULL.getMessage()));
        }
        SysResourceTypeExpand resourceTypeExpand = (SysResourceTypeExpand)this.hussarBaseResTypeExpandService.getById((Serializable)id);
        boolean flag = this.hussarBaseResourceTypeService.checkCanEditOrDel(resourceTypeExpand.getResourceTypeId());
        AssertUtil.isTrue((boolean)flag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_EXIST_RESOURCE.getMessage()));
        this.hussarBaseResTypeExpandService.removeById((Serializable)id);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS.getMessage());
    }

    @Override
    public List<ResTypeExpandVo> getExpandListByResTypeId(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_ID_NOT_NULL.getMessage()));
        }
        List resourceTypeExpands = this.hussarBaseResTypeExpandService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceTypeExpand::getResourceTypeId, (Object)id));
        if (HussarUtils.isEmpty((Object)resourceTypeExpands)) {
            return Collections.emptyList();
        }
        ArrayList<ResTypeExpandVo> expandVos = new ArrayList<ResTypeExpandVo>();
        for (SysResourceTypeExpand resourceTypeExpand : resourceTypeExpands) {
            ResTypeExpandVo vo = new ResTypeExpandVo();
            BeanUtils.copyProperties((Object)resourceTypeExpand, (Object)vo);
            vo.setId(resourceTypeExpand.getId().toString());
            String options = resourceTypeExpand.getExpandOptions();
            if (HussarUtils.isNotBlank((CharSequence)options)) {
                List optionVos = JSON.parseArray((String)options, OptionVo.class);
                vo.setExpandOptions(optionVos);
            }
            vo.setResourceTypeId(String.valueOf(id));
            expandVos.add(vo);
        }
        return expandVos;
    }

    @Override
    public SysResourceTypeExpand loadResTypeExpand(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_EXPAND_ID_NOT_NULL.getMessage()));
        }
        SysResourceTypeExpand resourceTypeExpand = (SysResourceTypeExpand)this.hussarBaseResTypeExpandService.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)resourceTypeExpand)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_EXPAND_NOT_FOUND.getMessage()));
        }
        return resourceTypeExpand;
    }

    @Override
    public List<ResTypeExpandVo> getResTypeExpandListByCode(String resTypeCode) {
        if (HussarUtils.isBlank((CharSequence)resTypeCode)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_TYPE_CODE_NO_PASSED.getMessage()));
        }
        SysResourceType resourceType = (SysResourceType)this.hussarBaseResourceTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getResourceTypeCode, (Object)resTypeCode));
        if (HussarUtils.isEmpty((Object)resourceType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_THIS_RES_TYPE_INFO.getMessage()));
        }
        return this.getExpandListByResTypeId(resourceType.getId());
    }

    private void checkOption(String options) {
        if (HussarUtils.isNotBlank((CharSequence)options)) {
            try {
                List optionVos = JSON.parseArray((String)options, OptionVo.class);
                optionVos.stream().collect(Collectors.toMap(OptionVo::getValue, o -> o));
            }
            catch (JSONException e) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_DROP_DOWN_SELECTION_ILLEGAL.getMessage()));
            }
            catch (IllegalStateException e) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_DROP_DOWN_SELECTION_VALUE_REPEATED.getMessage()));
            }
        }
    }
}

