/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSyncOrganizationService;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseSyncOrganizationServiceImpl")
public class HussarBaseSyncOrganizationServiceImpl
implements IHussarBaseSyncOrganizationService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseSyncOrganizationServiceImpl.class);
    private static final String CACHE = "hussarOrganizationJob";
    @Autowired
    private AddOutsideOrganizationManager addOutsideOrganizationManager;
    @Autowired
    private AddBatchOutsideOrganizationManager addBatchOutsideOrganizationManager;
    @Autowired
    private EditOutsideOrganizationManager editOutsideOrganizationManager;
    @Autowired
    private EditBatchOutsideOrganizationManager editBatchOutsideOrganizationManager;
    @Autowired
    private DeleteOutsideOrganizationManager deleteOutsideOrganizationManager;
    @Autowired
    private DeleteBatchOutsideOrganizationManager deleteBatchOutsideOrganizationManager;

    @HussarTransactional
    public synchronized R<AddOutsideOrganizationDto> addOrganization(AddOutsideOrganizationDto addOrganizationDto) {
        R<AddOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_ORG_STRUCTURE_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_ORG_STRUCTURE_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsideOrganizationManager.addOrganization(addOrganizationDto);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ERR_ADD_ORG.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<AddOutsideOrganizationDto> addBatchOrganizations(List<AddOutsideOrganizationDto> organs) {
        R<AddOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_ORG_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_ORG_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addBatchOutsideOrganizationManager.addBatchOrganizations(organs);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_ORG_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideOrganizationDto> editOrganization(EditOutsideOrganizationDto editOrganizationDto) {
        R<EditOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_ORG_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_ORG_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editOutsideOrganizationManager.editOrganization(editOrganizationDto);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ERR_MODIFY_ORG.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideOrganizationDto> editBatchOrganizations(List<EditOutsideOrganizationDto> organs) {
        R<EditOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_ORG_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_ORG_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editBatchOutsideOrganizationManager.editBatchOrganizations(organs);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_ORG_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOrganization(String organCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideOrganizationManager.deleteOrganization(organCode);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchOrganizations(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsideOrganizationManager.deleteBatchOrganizations(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOrganUserRelation(String organCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideOrganizationManager.deleteOrganUserRelation(organCode);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_USER_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOrganStaffRelation(String organCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_STAFF_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_STAFF_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideOrganizationManager.deleteOrganStaffRelation(organCode);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_STAFF_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOrganPostRelation(String organCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideOrganizationManager.deleteOrganPostRelation(organCode);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_POST_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOrganRoleRelation(String organCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_ROLE_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_ROLE_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideOrganizationManager.deleteOrganRoleRelation(organCode);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_ORG_ROLE_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchOrganUserRelations(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_USER_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_USER_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsideOrganizationManager.deleteBatchOrganUserRelations(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_USER_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchOrganStaffRelations(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_STAFF_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_STAFF_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsideOrganizationManager.deleteBatchOrganStaffRelations(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_STAFF_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchOrganPostRelations(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsideOrganizationManager.deleteBatchOrganPostRelations(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_POST_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchOrganRoleRelations(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_ROLE_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_ROLE_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsideOrganizationManager.deleteBatchOrganRoleRelations(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_ORG_ROLE_ERR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> sortOrganization(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u7ec4\u7ec7\u673a\u6784\u6392\u5e8f\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u6392\u5e8f\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editOutsideOrganizationManager.sortOrganization(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u6392\u5e8f\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }
}

