/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.manager.SortStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.sortStaffManagerImpl")
public class SortStaffManagerImpl
implements SortStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortStaffManagerImpl.class);
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    protected ISysStaffService sysStaffService;

    @Override
    public String sortStaff(List<Long> idList) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_SORTING.getMessage()));
        AssertUtil.isNotEmpty(idList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        ArrayList<Long> ids = new ArrayList<Long>();
        LambdaQueryWrapper struQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStru::getId, idList);
        ((LambdaQueryWrapper)struQueryWrapper.eq(SysStru::getStruType, (Object)"9")).orderByAsc(SysStru::getStruOrder);
        List list = this.sysStruService.list((Wrapper)struQueryWrapper);
        AssertUtil.isTrue((idList.size() == list.size() ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CONTAINS_NON_PERSONNEL.getMessage()));
        for (int i = 0; i < idList.size(); ++i) {
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_COMPARE_ID_ORDER.getMessage()));
            if (Objects.equals(((SysStru)list.get(i)).getId(), idList.get(i))) continue;
            ids.add(idList.get(i));
        }
        ArrayList<SysStru> update = new ArrayList<SysStru>();
        if (HussarUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper queryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStru::getId, ids);
            ((LambdaQueryWrapper)queryWrapper.eq(SysStru::getStruType, (Object)"9")).orderByAsc(SysStru::getStruOrder);
            List listTemp = this.sysStruService.list((Wrapper)queryWrapper);
            Map map = listTemp.stream().collect(Collectors.toMap(SysStru::getId, Function.identity()));
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_SORT_CHANGED.getMessage()));
            SysStru temp = null;
            for (int i = 0; i < ids.size(); ++i) {
                temp = new SysStru();
                SysStru sysStruT = (SysStru)map.get(ids.get(i));
                BeanUtils.copyProperties((Object)sysStruT, (Object)temp);
                temp.setStruOrder(((SysStru)listTemp.get(i)).getStruOrder());
                update.add(temp);
            }
        }
        if (HussarUtils.isNotEmpty(update)) {
            this.sysStruService.updateBatchById(update);
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage());
    }

    @Override
    public String sortUnifyStaff(List<Long> idList) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_SORTING.getMessage()));
        AssertUtil.isNotEmpty(idList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        ArrayList<Long> ids = new ArrayList<Long>();
        LambdaQueryWrapper staffQueryWrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getId, idList).orderByAsc(SysStaff::getStaffOrder);
        List list = this.sysStaffService.list((Wrapper)staffQueryWrapper);
        AssertUtil.isTrue((idList.size() == list.size() ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CONTAINS_NON_PERSONNEL.getMessage()));
        for (int i = 0; i < idList.size(); ++i) {
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_COMPARE_ID_ORDER.getMessage()));
            if (Objects.equals(((SysStaff)list.get(i)).getId(), idList.get(i))) continue;
            ids.add(idList.get(i));
        }
        ArrayList<SysStaff> update = new ArrayList<SysStaff>();
        if (HussarUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getId, ids).orderByAsc(SysStaff::getStaffOrder);
            List listTemp = this.sysStaffService.list((Wrapper)queryWrapper);
            Map map = listTemp.stream().collect(Collectors.toMap(SysStaff::getId, Function.identity()));
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_SORT_CHANGED.getMessage()));
            SysStaff temp = null;
            for (int i = 0; i < ids.size(); ++i) {
                temp = new SysStaff();
                SysStaff sysStaffT = (SysStaff)map.get(ids.get(i));
                BeanUtils.copyProperties((Object)sysStaffT, (Object)temp);
                temp.setStaffOrder(((SysStaff)listTemp.get(i)).getStaffOrder());
                update.add(temp);
            }
        }
        if (HussarUtils.isNotEmpty(update)) {
            this.sysStaffService.updateBatchById(update);
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage());
    }
}

