/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAssistOrganAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAssistOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.dao.SysUserIpMapper;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteStaffManagerImpl")
public class DeleteStaffManagerImpl
extends CommonStaffManager
implements DeleteStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteStaffManagerImpl.class);
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysUserIpMapper sysUserIpMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysStruAssistOrganAuditMapper sysStruAssistOrganAuditMapper;
    @Autowired
    private ISysOrgEventService sysOrgEventService;
    @Autowired
    private ISysUserroleAuditService sysUserroleAuditService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserIpService sysUserIpService;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Resource
    private ISysStruPostAuditService sysStruPostAuditService;

    @Override
    public String deleteStaff(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_DELETE_THIS.getMessage()), (Object)id);
        AssertUtil.isNotNull((Object)id, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_DEL_ID.getMessage()));
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            return this.doDeleteStaffAndUser(id);
        }
        return this.doDeleteStaff(id);
    }

    private String doDeleteStaff(Long id) {
        String msg;
        this.sysOrgEventService.beforeDel(id);
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(id);
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(id);
        List<Map<String, Object>> roleList = this.sysRolesMapper.getRolesByOrgId(id);
        List<Map<String, Object>> noRoleList = this.sysConfRolesetMapper.getRolesByOrgId(id);
        List assistOrganChildrenList = this.sysStruAssistOrganService.getAssistOrganByParent(id);
        AssertUtil.isEmpty(orgList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_PRES_DEPT.getMessage()));
        AssertUtil.isEmpty(userList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_ASSOCIATED_USER.getMessage()));
        AssertUtil.isEmpty(roleList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_ROLE.getMessage()));
        AssertUtil.isEmpty(noRoleList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_INCOMPATIBLE.getMessage()));
        AssertUtil.isEmpty((Collection)assistOrganChildrenList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_CONCURRENT.getMessage()));
        this.sysOrgEventService.afterDel(id);
        if (!this.sysStruAuditService.checkCanOperate(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_DELETE.getMessage()));
        }
        SysStru sysStruById = (SysStru)this.sysStruMapper.selectById(id);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(SysStruAudit::getParentId, (Object)id);
        wrapper1.eq(SysStruAudit::getState, (Object)"0");
        ArrayList<String> inUseList = new ArrayList<String>();
        inUseList.add("1");
        inUseList.add("4");
        wrapper1.in(SysStruAudit::getInUse, inUseList);
        List list1 = this.sysStruAuditService.list((Wrapper)wrapper1);
        AssertUtil.isEmpty((Collection)list1, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_UNAPPROVED_PRES_OR_ORG.getMessage()));
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(SysUsersAudit::getDepartmentId, (Object)id);
        wrapper2.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList1 = new ArrayList<String>();
        currentStatusList1.add("0");
        currentStatusList1.add("3");
        currentStatusList1.add("1");
        wrapper2.in(SysUsersAudit::getCurrentStatus, currentStatusList1);
        List list2 = this.sysUsersAuditService.list((Wrapper)wrapper2);
        AssertUtil.isEmpty((Collection)list2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_UNAPPROVED_ASSOCIATED_USER.getMessage()));
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(SysUsersAudit::getEmployeeId, (Object)id);
        wrapper3.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList2 = new ArrayList<String>();
        currentStatusList2.add("0");
        currentStatusList2.add("1");
        wrapper3.in(SysUsersAudit::getCurrentStatus, currentStatusList2);
        List list3 = this.sysUsersAuditService.list((Wrapper)wrapper3);
        AssertUtil.isEmpty((Collection)list3, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_UNAPPROVED_ASSOCIATED_USER.getMessage()));
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        wrapper4.eq(SysStruAssistOrganAudit::getAssistParentId, (Object)id);
        wrapper4.eq(SysStruAssistOrganAudit::getState, (Object)"0");
        List list4 = this.sysStruAssistOrganAuditMapper.selectList((Wrapper)wrapper4);
        AssertUtil.isEmpty((Collection)list4, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DEL_EXIST_UNAPPROVED_ASSOCIATED_USER.getMessage()));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            this.sysStruAuditService.save((Object)sysStruAudit);
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
        } else {
            boolean flag = this.delStaffByStru(sysStruById);
            msg = flag ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL.getMessage());
        }
        return msg;
    }

    private String doDeleteStaffAndUser(Long id) {
        LambdaQueryWrapper wrapper;
        StringBuffer msg = new StringBuffer();
        AssertUtil.isTrue((boolean)this.sysStruAuditService.checkCanOperate(id), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXIST_PERSONNEL_HAVE_UNAPPROVED.getMessage()));
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            this.sysStruAuditService.save((Object)sysStruAudit);
            msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_DEL_SUC_EFFECTIVE.getMessage()));
        } else {
            this.sysStruMapper.deleteById(id);
            wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruAssistOrgan::getStruId, (Object)id);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_DEL_SUC.getMessage()));
            if ("9".equals(sysStru.getStruType())) {
                Long organId = sysStru.getOrganId();
                this.sysOrganMapper.deleteById(organId);
                QueryWrapper sysStaffQueryWrapper = new QueryWrapper();
                sysStaffQueryWrapper.lambda().eq(SysStaff::getStruId, (Object)id);
                this.sysStaffMapper.delete((Wrapper)sysStaffQueryWrapper);
            }
        }
        wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getEmployeeId, (Object)id);
        List sysUsersList = this.sysUsersMapper.selectList((Wrapper)wrapper);
        if (HussarUtils.isEmpty((Object)sysUsersList)) {
            msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_NOT_ASSOCIATED_USER.getMessage()));
        } else {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
                for (SysUsers sysUser : sysUsersList) {
                    AssertUtil.isFalse((boolean)Whether.YES.getValue().equals(sysUser.getIsSys()), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ADMIN.getMessage()));
                    AssertUtil.isFalse((boolean)shiroUser.getId().equals(sysUser.getId()), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ACTIVE_USER.getMessage()));
                    AssertUtil.isFalse((boolean)this.sysUsersAuditService.adjustEdit(sysUser.getId()), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_UNAPPROVED_DEL.getMessage()));
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
                    sysUsersAudit.setId(null);
                    sysUsersAudit.setUserId(sysUser.getId());
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCurrentStatus("2");
                    this.sysUsersAuditService.save((Object)sysUsersAudit);
                }
                msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SUC_SYN_DEL_USER_APPROVAL.getMessage()));
            } else {
                for (SysUsers sysUser : sysUsersList) {
                    AssertUtil.isFalse((boolean)Whether.YES.getValue().equals(sysUser.getIsSys()), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ADMIN.getMessage()));
                    AssertUtil.isFalse((boolean)shiroUser.getId().equals(sysUser.getId()), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ACTIVE_USER.getMessage()));
                    sysUser.setAccountStatus(UserStatus.DELETE.getCode());
                    sysUser.setEmployeeId(Long.valueOf(0L));
                    this.sysStruMapper.updatePrincipal(sysUser.getId());
                    this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
                    this.sysUserIpMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUser.getId()));
                    this.sysUsersMapper.updateById(sysUser);
                }
                msg.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_DEL_SUCCESSFUL.getMessage()));
            }
        }
        return msg.toString();
    }

    @Override
    public String delete(Long staffId) {
        SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId));
        if (HussarUtils.isEmpty((Object)staff)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.DEL_FAIL_STAFF_NOT_EXIST.getMessage()));
        }
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            this.sysStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId));
            this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffId));
            this.syncUser(staffId);
            this.staffChangeNotify.notify(DataChangeType.DELETE, new Object[]{staff});
        } else {
            List users = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffId)).ne(SysUsers::getAccountStatus, (Object)"2"));
            if (HussarUtils.isNotEmpty((Object)users)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_USER_RELATION.getMessage()));
            }
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
                List sysStaffAudits = this.sysStaffAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getRealStaffId, (Object)staff.getId())).eq(SysStaffAudit::getAuditStatus, (Object)"0"));
                if (HussarUtils.isNotEmpty((Object)sysStaffAudits)) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage()));
                }
                List sysUsersAudits = this.sysUsersAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsersAudit::getEmployeeId, (Object)staffId)).eq(SysUsersAudit::getIsAudit, (Object)"0"));
                if (HussarUtils.isNotEmpty((Object)sysUsersAudits)) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_USER_RELATION_EXIST_REVIEW.getMessage()));
                }
                SysStaffAudit sysStaffAudit = new SysStaffAudit();
                BeanUtil.copy((Object)staff, (Object)sysStaffAudit);
                long sysStaffAuditId = IdWorker.getId((Object)sysStaffAudit);
                sysStaffAudit.setId(Long.valueOf(sysStaffAuditId));
                sysStaffAudit.setRealStaffId(staff.getId());
                sysStaffAudit.setAuditStatus("0");
                sysStaffAudit.setOperateType("3");
                LocalDateTime now = LocalDateTime.now();
                sysStaffAudit.setCreateTime(now);
                sysStaffAudit.setLastTime(now);
                this.sysStaffAuditService.save((Object)sysStaffAudit);
            } else {
                this.sysStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId));
                this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffId));
                this.staffChangeNotify.notify(DataChangeType.DELETE, new Object[]{staff});
            }
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage());
    }

    private void syncUser(Long staffId) {
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffId)).ne(SysUsers::getAccountStatus, (Object)"2"));
        if (HussarUtils.isNotEmpty((Object)user)) {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            AssertUtil.isFalse((boolean)Whether.YES.getValue().equals(user.getIsSys()), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ADMIN.getMessage()));
            AssertUtil.isFalse((boolean)shiroUser.getId().equals(user.getId()), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ACTIVE_USER.getMessage()));
            user.setAccountStatus(UserStatus.DELETE.getCode());
            this.sysUsersService.updateById((Object)user);
            this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)user.getId()));
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)user.getId()));
            this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)user.getId()));
            this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId()));
            this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)user.getId()));
            this.userChangeNotify.notify(DataChangeType.DELETE, new Object[]{user});
        }
    }
}

