/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.post.dao.SysPostAuditMapper;
import com.jxdinfo.hussar.authorization.post.manager.AuditPostManager;
import com.jxdinfo.hussar.authorization.post.manager.impl.CommonPostManagerImpl;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.auditPostManagerImpl")
public class AuditPostManagerImpl
extends CommonPostManagerImpl
implements AuditPostManager {
    @Resource
    private SysPostAuditMapper sysPostAuditMapper;

    @Override
    public Boolean pass(Long auditId) {
        boolean result;
        SysPostAudit sysPostAudit = (SysPostAudit)this.sysPostAuditService.getById((Serializable)auditId);
        String operateType = sysPostAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAddPass(sysPostAudit);
        } else if ("2".equals(operateType)) {
            result = this.doAuditEditPass(sysPostAudit);
        } else if ("3".equals(operateType)) {
            result = this.doAuditDeletePass(sysPostAudit);
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UNSUPPORTED_OPERATION_TYPE.getMessage()));
        }
        return result;
    }

    @Override
    public Boolean reject(Long auditId) {
        boolean result;
        SysPostAudit sysPostAudit = (SysPostAudit)this.sysPostAuditService.getById((Serializable)auditId);
        String operateType = sysPostAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAddReject(sysPostAudit);
        } else {
            sysPostAudit.setAuditStatus("2");
            result = this.sysPostAuditMapper.updateById(sysPostAudit) > 0;
        }
        return result;
    }

    private Boolean doAuditAddReject(SysPostAudit sysPostAudit) {
        sysPostAudit.setAuditStatus("2");
        Long postId = sysPostAudit.getPostId();
        this.sysStruPostAuditService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysStruPostAudit::getAuditStatus, (Object)"2")).eq(SysStruPostAudit::getPostId, (Object)postId));
        this.sysUserPostAuditService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUserPostAudit::getAuditStatus, (Object)"2")).eq(SysUserPostAudit::getPostId, (Object)postId));
        this.sysPostRoleAuditService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysPostRoleAudit::getAuditStatus, (Object)"2")).eq(SysPostRoleAudit::getPostId, (Object)postId));
        return this.sysPostAuditMapper.updateById(sysPostAudit) > 0;
    }

    private Boolean doAuditAddPass(SysPostAudit sysPostAudit) {
        sysPostAudit.setAuditStatus("1");
        Long postId = sysPostAudit.getPostId();
        SysPost post = new SysPost();
        BeanUtils.copyProperties((Object)sysPostAudit, (Object)post, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
        post.setId(postId);
        boolean postFlag = this.sysPostMapper.insert(post) > 0;
        boolean auditFlag = this.sysPostAuditMapper.updateById(sysPostAudit) > 0;
        this.postChangeNotify.notify(DataChangeType.INSERT, new Object[]{post});
        return postFlag && auditFlag;
    }

    private Boolean doAuditEditPass(SysPostAudit sysPostAudit) {
        sysPostAudit.setAuditStatus("1");
        SysPost post = new SysPost();
        BeanUtils.copyProperties((Object)sysPostAudit, (Object)post, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
        post.setId(sysPostAudit.getPostId());
        boolean postFlag = this.sysPostMapper.updateById(post) > 0;
        boolean auditFlag = this.sysPostAuditMapper.updateById(sysPostAudit) > 0;
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{post});
        return postFlag && auditFlag;
    }

    private Boolean doAuditDeletePass(SysPostAudit sysPostAudit) {
        sysPostAudit.setAuditStatus("1");
        Long postId = sysPostAudit.getPostId();
        SysPost post = (SysPost)this.sysPostMapper.selectById(postId);
        this.sysStruPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPostAudit::getPostId, (Object)postId)).eq(SysStruPostAudit::getAuditStatus, (Object)"0"));
        this.sysUserPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getPostId, (Object)postId)).eq(SysUserPostAudit::getAuditStatus, (Object)"0"));
        this.sysPostRoleAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getPostId, (Object)postId)).eq(SysPostRoleAudit::getAuditStatus, (Object)"0"));
        this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId));
        this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId));
        this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId));
        boolean auditFlag = this.sysPostAuditMapper.updateById(sysPostAudit) > 0;
        boolean postFlag = this.sysPostMapper.deleteById(postId) > 0;
        this.postChangeNotify.notify(DataChangeType.DELETE, new Object[]{post});
        return postFlag && auditFlag;
    }
}

