/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ILocalRoleAdapterService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalRoleAdapterServiceImpl
implements ILocalRoleAdapterService {
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;

    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        List<JSTreeModel> jsTreeModels = nodeId.equals(Constants.ROOT_NODE_PARENT) ? this.sysRoleGroupMapper.getFirstRoleTree() : this.sysRoleGroupMapper.getLazyRoleTree(nodeId);
        return jsTreeModels;
    }

    public List<SysRoles> listByIds(Collection<? extends Serializable> idList) {
        return this.sysRolesMapper.selectBatchIds(idList);
    }

    public List<Long> getRolesByStruId(Long struId) {
        return this.sysStruRoleMapper.getRolesByStruId(struId);
    }

    public List<Long> getRolesByUserId(Long userId) {
        if (userId == null) {
            return new ArrayList<Long>();
        }
        return this.sysUserRoleMapper.getRolesByUserId(userId);
    }

    public List<SysUserRole> getByUserId(Long userId) {
        return this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
    }

    public List<Long> getRoleIdByRoleName(List<String> roleNames) {
        return this.sysUserRoleMapper.getRoleIdByRoleName(roleNames.toArray(new String[0]));
    }

    public List<Long> getRoleIdByGroupId(List<String> groupNames) {
        return this.sysUserRoleMapper.getRoleIdByGroupId(groupNames.toArray(new String[0]));
    }

    public List<Long> getRolesByStruIds(List<Long> struIds) {
        return this.sysStruRoleMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysStruRole::getStruId, struIds)).stream().map(SysStruRole::getGrantedRole).collect(Collectors.toList());
    }
}

