/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authentication.lock.SecureErr;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.impl.SortOrganizationManagerImpl;
import com.jxdinfo.hussar.authorization.organ.model.OrganExcel;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganExcelCheckResult;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.enums.AccountTypeEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.UserExcel;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginFailConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.manager.impl.hussarBaseUserCustomExcelServiceImpl")
public class HussarBaseUserCustomExcelServiceImpl
implements IHussarBaseCustomExcelService<UserExcel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortOrganizationManagerImpl.class);
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruStaffService sysStruStaffService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private IHussarPwdConfigService pwdConfigService;
    @Autowired
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysDicService sysDicService;
    @Resource
    private IHussarLoginFailConfigService hussarLoginFailConfigService;
    @Resource
    private IConvertPinyinService convertPinyinService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    private static String USER_SECURITY_LEVEL = "user_security_level";
    private static int IMPORT_JOB_SIZE = 5;
    private static int UPDATE_JOB_REMOVE_SIZE = 2;
    private static int UPDATE_JOB_UPDATE_SIZE = 4;
    public Map<Long, String> organPropertyMap = new HashMap<Long, String>();

    public Map<Long, String> getOrganPropertyMap() {
        return this.organPropertyMap;
    }

    public void addOrganPropertyMap(Long taskId, String organProperty) {
        this.organPropertyMap.put(taskId, organProperty);
    }

    public ExcelCheckResult check(List<UserExcel> datas, Long taskId, List<Object> otherParams) throws Exception {
        ArrayList<UserExcel> rootDataList = new ArrayList<UserExcel>(datas);
        ArrayList<UserExcel> successDataList = new ArrayList<UserExcel>();
        ArrayList<ExcelImportMsg<UserExcel>> newDataList = new ArrayList<ExcelImportMsg<UserExcel>>();
        ArrayList<ExcelImportMsg<UserExcel>> updateDataList = new ArrayList<ExcelImportMsg<UserExcel>>();
        ArrayList<ExcelImportMsg<UserExcel>> existDataList = new ArrayList<ExcelImportMsg<UserExcel>>();
        ArrayList<ExcelImportMsg<UserExcel>> errorDataList = new ArrayList<ExcelImportMsg<UserExcel>>();
        OrganExcelCheckResult userExcelCheckResult = new OrganExcelCheckResult();
        ArrayList<String> userAccounts = new ArrayList<String>();
        HashMap<String, Long> userAccountNumMap = new HashMap<String, Long>();
        HashMap<String, Long> userIdNumMap = new HashMap<String, Long>();
        HashMap<String, Long> staffCodeNumMap = new HashMap<String, Long>();
        HashMap<String, UserExcel> userExcelMap = new HashMap<String, UserExcel>();
        HashMap<String, Long> idCardNumMap = new HashMap<String, Long>();
        this.initUserMap(datas, userAccountNumMap, userAccounts, userExcelMap, userIdNumMap, staffCodeNumMap, idCardNumMap);
        this.checkDataInExcel(datas, errorDataList, userAccountNumMap, userIdNumMap, staffCodeNumMap, idCardNumMap);
        if (HussarUtils.isNotEmpty(errorDataList)) {
            userExcelCheckResult.setRootNum(datas.size());
            userExcelCheckResult.setErrorNum(errorDataList.size());
            ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
            excelCheckResult.setCheckMsg((Object)userExcelCheckResult);
            return excelCheckResult;
        }
        List accounts = LambdaQueryUtil.getSplitList(userAccounts);
        List<UserExcel> userExcelDbList = this.sysUsersMapper.getUserExcelDbList(accounts);
        List sysStaffsDb = this.sysStaffMapper.selectList((Wrapper)new QueryWrapper());
        HashMap<String, UserExcel> userDbMap = new HashMap();
        HashMap<Long, List<UserOrganPostVo>> userOrganMap = new HashMap();
        if (HussarUtils.isNotEmpty(userExcelDbList)) {
            userDbMap = userExcelDbList.stream().collect(Collectors.toMap(UserExcel::getUserAccount, Function.identity()));
            List userIds = userExcelDbList.stream().map(u -> Long.valueOf(u.getUserId())).collect(Collectors.toList());
            List userIdList = LambdaQueryUtil.getSplitList(userIds);
            List<UserOrganPostVo> userOrganDbList = this.sysStruUserMapper.getOrganByUserIds(userIdList, this.organPropertyMap.get(taskId));
            userOrganMap = userOrganDbList.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        }
        List<Long> userIdListDb = this.sysUsersService.list().stream().map(SysUsers::getId).collect(Collectors.toList());
        List<OrganExcel> organDataDbList = this.sysStruMapper.getOrganExcelByStruIds(null, this.organPropertyMap.get(taskId));
        Map<String, OrganExcel> fullOrganNameMap = organDataDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, o -> o, (value1, value2) -> value1));
        this.checkDataInDb(datas, successDataList, newDataList, updateDataList, existDataList, errorDataList, userDbMap, fullOrganNameMap, userOrganMap, userIdListDb, sysStaffsDb);
        userExcelCheckResult.setRootNum(datas.size());
        userExcelCheckResult.setErrorNum(errorDataList.size());
        userExcelCheckResult.setNewNum(newDataList.size());
        userExcelCheckResult.setUpdateNum(updateDataList.size());
        userExcelCheckResult.setExistNum(existDataList.size());
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)userExcelCheckResult);
        return excelCheckResult;
    }

    @HussarTransactional
    public void saveData(List<UserExcel> datas, List<Object> otherParams) {
        ArrayList<SysUsers> sysUsers = new ArrayList<SysUsers>();
        ArrayList<SysStaff> sysStaffs = new ArrayList<SysStaff>();
        ArrayList<SysStruUser> sysStruUsers = new ArrayList<SysStruUser>();
        ArrayList<SysStruStaff> sysStruStaffs = new ArrayList<SysStruStaff>();
        ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
        this.initUserAndStaff(datas, sysUsers, sysStaffs, sysStruUsers, sysStruStaffs, sysUserRoles);
        CountDownLatch countDownLatch = new CountDownLatch(IMPORT_JOB_SIZE);
        Executor executor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        Instant allStar = Instant.now();
        executor.execute(() -> {
            try {
                this.sysUsersService.saveBatch((Collection)sysUsers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        executor.execute(() -> {
            try {
                this.sysStaffService.saveBatch((Collection)sysStaffs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        executor.execute(() -> {
            try {
                this.sysStruUserService.saveBatch((Collection)sysStruUsers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        executor.execute(() -> {
            try {
                this.sysStruStaffService.saveBatch((Collection)sysStruStaffs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        executor.execute(() -> {
            try {
                this.sysUserRoleService.saveBatch((Collection)sysUserRoles);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Instant allEnd = Instant.now();
        LOGGER.info("Excel\u5bfc\u5165\u7528\u6237\u4fe1\u606f\uff0c\u6267\u884c\u5199\u5165\u64cd\u4f5c\u603b\u6267\u884c\u65f6\u95f4\uff1a{}\u79d2", (Object)(Duration.between(allStar, allEnd).toMillis() / 1000L));
    }

    private void initUserAndStaff(List<UserExcel> userExcels, List<SysUsers> sysUsers, List<SysStaff> sysStaffs, List<SysStruUser> struUsers, List<SysStruStaff> struStaffs, List<SysUserRole> sysUserRoles) {
        List<OrganExcel> organExcelDbList = this.sysStruMapper.getOrganExcelByStruIds(null, userExcels.get(0).getOrganProperty());
        Map<String, OrganExcel> organDbMap = organExcelDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, Function.identity(), (value1, value2) -> value1));
        String pass = "";
        pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        Integer maxStaffOrder = this.sysStaffMapper.getMaxOrder();
        maxStaffOrder = HussarUtils.isEmpty((Object)maxStaffOrder) ? 1 : maxStaffOrder;
        Integer maxUserOrder = this.sysUsersMapper.getUserMaxOrder();
        maxUserOrder = HussarUtils.isEmpty((Object)maxUserOrder) ? 1 : maxUserOrder;
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        List securityLevelDic = this.sysDicRefService.getDicListByType(USER_SECURITY_LEVEL);
        Map<String, String> securityLevelMap = securityLevelDic.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig(HussarContextHolder.getConnName(), "fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        int lockTime = this.hussarLoginFailConfigService.getLockTime();
        int minutes = this.hussarLoginFailConfigService.getFailTime();
        SecureErr errMode = new SecureErr();
        errMode.setInputTime(new Date());
        errMode.setExpireTime(DateUtils.addMinutes((Date)errMode.getInputTime(), (int)minutes));
        for (UserExcel entry : userExcels) {
            SysUsers user = new SysUsers();
            SysStaff staff = new SysStaff();
            user.setId(Long.valueOf(HussarUtils.isEmpty((Object)entry.getUserId()) ? IdWorker.getId((Object)new SysUsers()) : Long.parseLong(entry.getUserId())));
            entry.setUserId(String.valueOf(user.getId()));
            staff.setId(Long.valueOf(IdWorker.getId((Object)new SysStaff())));
            entry.setEmployeeId(staff.getId());
            BeanUtil.copy((Object)entry, (Object)user);
            BeanUtil.copy((Object)entry, (Object)staff);
            staff.setName(user.getUserName());
            if (HussarUtils.isEmpty((Object)staff.getStaffCode())) {
                staff.setStaffCode(this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF"));
            }
            maxStaffOrder = maxStaffOrder + 1;
            staff.setStaffOrder(maxStaffOrder);
            staff.setStaffPosition(HussarUtils.isEmpty((Object)dicMap.get(entry.getStaffPosition())) ? entry.getStaffPosition() : dicMap.get(entry.getStaffPosition()));
            if (HussarUtils.isEmpty((Object)user.getUserOrder())) {
                maxUserOrder = maxUserOrder + 1;
                user.setUserOrder(maxUserOrder);
            }
            user.setPassword(pwd);
            user.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
            user.setSecurityLevel(Integer.valueOf(1));
            user.setMaxSessions(Integer.valueOf(Integer.parseInt(entry.getMaxSessions())));
            user.setLoginIpLimit("0");
            user.setLoginTimeLimit("0");
            user.setIsSys("0");
            user.setIsCpublic("0");
            user.seteMail(entry.getMail());
            user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(user.getUserName()));
            user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(user.getUserName()));
            if (HussarUtils.equals((Object)"0", (Object)user.getTypeProperty())) {
                user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)entry.getStartTime()));
                user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)entry.getExpiredTime()));
            }
            if (HussarUtils.equals((Object)UserStatus.LOCKED.getCode(), (Object)user.getAccountStatus())) {
                user.setAccountStatus(UserStatus.OK.getCode());
                this.addLockUserCache(user, errMode, tryLoginTime, lockTime);
            }
            if (HussarUtils.isNotEmpty((Object)entry.getSecurityLevelName())) {
                user.setSecurityLevel(Integer.valueOf(securityLevelMap.get(entry.getSecurityLevelName())));
            }
            sysUsers.add(user);
            sysStaffs.add(staff);
            this.initStruUserAndStaff(entry, struUsers, struStaffs, organDbMap);
            if (sysUserRoles == null) continue;
            SysUserRole userRole = new SysUserRole();
            userRole.setUserId(user.getId());
            userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            userRole.setAdminOption("1");
            sysUserRoles.add(userRole);
        }
    }

    private void initStruUserAndStaff(UserExcel userExcel, List<SysStruUser> struUsers, List<SysStruStaff> struStaffs, Map<String, OrganExcel> organDbMap) {
        String deptName = userExcel.getDepartment();
        String[] depts = deptName.split(",");
        for (int i = 0; i < depts.length; ++i) {
            OrganExcel organExcel = organDbMap.get(depts[i]);
            if (!HussarUtils.isNotEmpty((Object)organExcel)) continue;
            this.addRelation(userExcel, organExcel, struUsers, struStaffs);
        }
    }

    private void addRelation(UserExcel userExcel, OrganExcel organExcel, List<SysStruUser> struUsers, List<SysStruStaff> struStaffs) {
        SysStruUser struUser = new SysStruUser();
        SysStruStaff struStaff = new SysStruStaff();
        struUser.setStruId(Long.valueOf(Long.parseLong(organExcel.getStruId())));
        struUser.setUserId(Long.valueOf(userExcel.getUserId()));
        struStaff.setStruId(Long.valueOf(Long.parseLong(organExcel.getStruId())));
        struStaff.setStaffId(userExcel.getEmployeeId());
        struUsers.add(struUser);
        struStaffs.add(struStaff);
    }

    @HussarTransactional
    public void updateData(List<UserExcel> datas, List<Object> otherParams) {
        ArrayList<SysStruUser> sysStruUsers = new ArrayList<SysStruUser>();
        ArrayList<SysStruStaff> sysStruStaffs = new ArrayList<SysStruStaff>();
        List userAccounts = datas.stream().map(UserExcel::getUserAccount).collect(Collectors.toList());
        List sysUsers = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getUserAccount, userAccounts));
        List staffIds = sysUsers.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
        List sysStaffs = this.sysStaffService.list((Wrapper)new LambdaQueryWrapper().in(SysStaff::getId, staffIds));
        this.initEditStruUserAndStaff(datas, sysUsers, sysStaffs, sysStruUsers, sysStruStaffs);
        List userIds = sysUsers.stream().map(SysUsers::getId).collect(Collectors.toList());
        List userIdList = LambdaQueryUtil.getSplitList(userIds);
        String organProperty = HussarUtils.equals((Object)"0", (Object)datas.get(0).getOrganProperty()) ? "1" : "0";
        List<UserOrganPostVo> organByUserIds = this.sysStruUserMapper.getOrganByUserIds(userIdList, organProperty);
        List struIds = organByUserIds.stream().map(UserOrganPostVo::getStruId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds);
        LambdaQueryWrapper lambdaQueryWrapper1 = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds);
        if (HussarUtils.isNotEmpty(struIds)) {
            lambdaQueryWrapper.notIn(SysStruUser::getStruId, struIds);
            lambdaQueryWrapper1.notIn(SysStruStaff::getStruId, struIds);
        }
        Executor asyncExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        CountDownLatch removeJob = new CountDownLatch(UPDATE_JOB_REMOVE_SIZE);
        asyncExecutor.execute(() -> {
            try {
                this.sysStruUserService.remove((Wrapper)lambdaQueryWrapper);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                removeJob.countDown();
            }
        });
        asyncExecutor.execute(() -> {
            try {
                this.sysStruStaffService.remove((Wrapper)lambdaQueryWrapper1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                removeJob.countDown();
            }
        });
        try {
            removeJob.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        CountDownLatch updateJob = new CountDownLatch(UPDATE_JOB_UPDATE_SIZE);
        asyncExecutor.execute(() -> {
            try {
                this.sysUsersService.updateBatchById((Collection)sysUsers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                updateJob.countDown();
            }
        });
        asyncExecutor.execute(() -> {
            try {
                this.sysStaffService.updateBatchById((Collection)sysStaffs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                updateJob.countDown();
            }
        });
        asyncExecutor.execute(() -> {
            try {
                this.sysStruUserService.saveBatch((Collection)sysStruUsers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                updateJob.countDown();
            }
        });
        asyncExecutor.execute(() -> {
            try {
                this.sysStruStaffService.saveBatch((Collection)sysStruStaffs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                updateJob.countDown();
            }
        });
        try {
            updateJob.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void initEditStruUserAndStaff(List<UserExcel> userExcels, List<SysUsers> sysUsers, List<SysStaff> sysStaffs, List<SysStruUser> struUsers, List<SysStruStaff> struStaffs) {
        List<OrganExcel> organExcelDbList = this.sysStruMapper.getOrganExcelByStruIds(null, userExcels.get(0).getOrganProperty());
        Map<String, OrganExcel> organDbMap = organExcelDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, Function.identity(), (value1, value2) -> value1));
        Map userExcelMap = userExcels.stream().collect(Collectors.toMap(UserExcel::getUserAccount, Function.identity()));
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig(HussarContextHolder.getConnName(), "fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        int lockTime = this.hussarLoginFailConfigService.getLockTime();
        int minutes = this.hussarLoginFailConfigService.getFailTime();
        SecureErr errMode = new SecureErr();
        errMode.setInputTime(new Date());
        errMode.setExpireTime(DateUtils.addMinutes((Date)errMode.getInputTime(), (int)minutes));
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List securityLevelDic = this.sysDicRefService.getDicListByType(USER_SECURITY_LEVEL);
        Map<String, String> securityLevelMap = securityLevelDic.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        for (SysUsers user : sysUsers) {
            UserExcel userExcel = (UserExcel)userExcelMap.get(user.getUserAccount());
            if (HussarUtils.isNotEmpty((Object)userExcel.getUserOrder())) {
                user.setUserOrder(Integer.valueOf(Integer.parseInt(userExcel.getUserOrder())));
            }
            userExcel.setEmployeeId(user.getEmployeeId());
            BeanUtil.copyProperties((Object)userExcel, (Object)user);
            if (HussarUtils.isNotEmpty((Object)keyList) && keyList.contains(String.valueOf(user.getId())) && !HussarUtils.equals((Object)UserStatus.LOCKED.getCode(), (Object)user.getAccountStatus())) {
                HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(user.getId()));
            }
            if (HussarUtils.equals((Object)UserStatus.LOCKED.getCode(), (Object)user.getAccountStatus())) {
                user.setAccountStatus(UserStatus.OK.getCode());
                this.addLockUserCache(user, errMode, tryLoginTime, lockTime);
            }
            user.seteMail(userExcel.getMail());
            user.setMaxSessions(Integer.valueOf(Integer.parseInt(userExcel.getMaxSessions())));
            user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(user.getUserName()));
            user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(user.getUserName()));
            if (HussarUtils.equals((Object)"0", (Object)user.getTypeProperty())) {
                user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)userExcel.getStartTime()));
                user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)userExcel.getExpiredTime()));
            }
            if (HussarUtils.isNotEmpty((Object)userExcel.getSecurityLevelName())) {
                user.setSecurityLevel(Integer.valueOf(securityLevelMap.get(userExcel.getSecurityLevelName())));
            }
            userExcel.setUserId(String.valueOf(user.getId()));
            for (SysStaff staff : sysStaffs) {
                if (!HussarUtils.equals((Object)user.getEmployeeId(), (Object)staff.getId())) continue;
                userExcel.setStaffCode(staff.getStaffCode());
                BeanUtil.copy((Object)userExcel, (Object)staff);
                staff.setName(userExcel.getUserName());
                staff.setStaffPosition(HussarUtils.isEmpty((Object)dicMap.get(staff.getStaffPosition())) ? staff.getStaffPosition() : dicMap.get(staff.getStaffPosition()));
                break;
            }
            this.initStruUserAndStaff(userExcel, struUsers, struStaffs, organDbMap);
        }
    }

    private void initUserMap(List<UserExcel> datas, Map<String, Long> userAccountNumMap, List<String> userAccounts, Map<String, UserExcel> userExcelMap, Map<String, Long> userIdNumMap, Map<String, Long> staffCodeNumMap, Map<String, Long> idCardNumMap) {
        for (UserExcel userExcel : datas) {
            String userAccount = userExcel.getUserAccount();
            String userId = userExcel.getUserId();
            String staffCode = userExcel.getStaffCode();
            String idCard = userExcel.getIdcard();
            Long accountNum = userAccountNumMap.get(userAccount);
            accountNum = HussarUtils.isEmpty((Object)accountNum) ? 1L : accountNum + 1L;
            userAccountNumMap.put(userAccount, accountNum);
            if (HussarUtils.isNotEmpty((Object)userId)) {
                Long userIdNum = userIdNumMap.get(userId);
                userIdNum = HussarUtils.isEmpty((Object)userIdNum) ? 1L : userIdNum + 1L;
                userIdNumMap.put(userId, userIdNum);
            }
            if (HussarUtils.isNotEmpty((Object)staffCode)) {
                Long staffCodeNum = staffCodeNumMap.get(staffCode);
                staffCodeNum = HussarUtils.isEmpty((Object)staffCodeNum) ? 1L : staffCodeNum + 1L;
                staffCodeNumMap.put(staffCode, staffCodeNum);
            }
            if (HussarUtils.isNotEmpty((Object)idCard)) {
                Long idCardNum = idCardNumMap.get(idCard);
                idCardNum = HussarUtils.isEmpty((Object)idCardNum) ? 1L : idCardNum + 1L;
                idCardNumMap.put(idCard, idCardNum);
            }
            userAccounts.add(userAccount);
            userExcelMap.put(userAccount, userExcel);
        }
    }

    private void checkDataInExcel(List<UserExcel> datas, List<ExcelImportMsg<UserExcel>> errorDataList, Map<String, Long> userAccountNumMap, Map<String, Long> userIdNumMap, Map<String, Long> staffCodeNumMap, Map<String, Long> idCardNumMap) {
        Boolean checkSecurityLevel = false;
        List<Object> securityLevelName = new ArrayList();
        SysBaseConfig protectStatus = this.sysBaseConfigService.getSysBaseConfig("protection_status");
        if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
            checkSecurityLevel = true;
            List securityLevels = this.sysDicRefService.getDicListByType(USER_SECURITY_LEVEL);
            securityLevelName = securityLevels.stream().map(dicVo -> dicVo.getLabel()).collect(Collectors.toList());
        }
        for (int i = 0; i < datas.size(); ++i) {
            String idCard;
            String staffCode;
            String userId;
            UserExcel userExcel = datas.get(i);
            Map cellErrColMap = HussarBaseExcelValidateHelper.validateEntity((Object)userExcel, (Integer)i);
            String userAccount = userExcel.getUserAccount();
            if (HussarUtils.isNotEmpty(userAccountNumMap) && userAccountNumMap.containsKey(userAccount) && userAccountNumMap.get(userAccount) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_DUPLICATION.getMessage()), (Map)cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c0\u5217\uff0cuserAccount>1\u62a5\u9519\uff0cuserAccount\u503c\uff1a{}", (Object)i, (Object)userAccount);
            }
            if (HussarUtils.isNotEmpty((Object)(userId = userExcel.getUserId())) && userIdNumMap.containsKey(userId) && userIdNumMap.get(userId) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)25, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_PRIMARY_KEY_DUPLICATION.getMessage()), (Map)cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c25\u5217\uff0cuserId>1\u62a5\u9519\uff0cuserId\u503c\uff1a{}", (Object)i, (Object)userId);
            }
            if (HussarUtils.isNotEmpty((Object)(staffCode = userExcel.getStaffCode())) && staffCodeNumMap.containsKey(staffCode) && staffCodeNumMap.get(staffCode) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)17, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_CODE_DUPLICATED.getMessage()), (Map)cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c17\u5217\uff0cstaffCode>1\u62a5\u9519\uff0cstaffCode\u503c\uff1a{}", (Object)i, (Object)staffCode);
            }
            if (HussarUtils.isEmpty((Object)(idCard = userExcel.getIdcard()))) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)18, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IDCARD_REQUIRED.getMessage()), (Map)cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c18\u5217\uff0cidCard\u4e3a\u7a7a\uff0c\u9700\u8981\u5fc5\u586b", (Object)i);
            } else if (HussarUtils.isNotEmpty((Object)idCard) && idCardNumMap.containsKey(idCard) && idCardNumMap.get(idCard) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)18, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IDCARD_REPEAT.getMessage()), (Map)cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c18\u5217\uff0cidCard>1\u62a5\u9519\uff0cidCard\uff1a{}", (Object)i, (Object)idCard);
            }
            if (HussarUtils.isNotEmpty((Object)userExcel.getDepartment())) {
                this.checkExcelForParentOrgan(i, userExcel.getDepartment(), cellErrColMap);
            }
            this.checkExcelForTypeProperty(i, userExcel, cellErrColMap);
            this.checkDate(i, userExcel.getBirthday(), 19, cellErrColMap);
            this.checkDate(i, userExcel.getWorkDate(), 21, cellErrColMap);
            this.checkDate(i, userExcel.getGraduateDate(), 22, cellErrColMap);
            this.checkNumber(i, userExcel.getMaxSessions(), 3, cellErrColMap);
            this.checkNumber(i, userExcel.getUserOrder(), 16, cellErrColMap);
            if (HussarUtils.isNotBlank((CharSequence)userExcel.getUserOrder()) && !this.isInIntegerRange(userExcel.getUserOrder())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)16, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SORT_RANGE_OUT.getMessage()), (Map)cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c16\u5217\uff0c\u6821\u9a8c\u7528\u6237\u6392\u5e8f\u503c\u7684\u8303\u56f4\u62a5\u9519\uff0cuserOrder\u503c\uff1a{}", (Object)i, (Object)userExcel.getUserOrder());
            }
            if (checkSecurityLevel.booleanValue()) {
                if (HussarUtils.isEmpty((Object)userExcel.getSecurityLevelName())) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_SECURITY_LEVEL_NOT_NULL.getMessage()), (Map)cellErrColMap);
                    LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c4\u5217\uff0c\u68c0\u67e5\u7528\u6237\u5bc6\u7ea7\u62a5\u9519\uff0c\u7528\u6237\u5bc6\u7ea7\u4e3a\u7a7a", (Object)i);
                }
                if (!securityLevelName.contains(userExcel.getSecurityLevelName())) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_SECURITY_LEVEL_ERR.getMessage()), (Map)cellErrColMap);
                    LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c4\u5217\uff0c\u68c0\u67e5\u7528\u6237\u5bc6\u7ea7\u62a5\u9519\uff0c\u7528\u6237\u5bc6\u7ea7\u7c7b\u578b\u9519\u8bef\uff1a{}", (Object)i, (Object)userExcel.getSecurityLevelName());
                }
            }
            this.sysDicService.checkExcelPrimaryKey(Integer.valueOf(i), userExcel.getUserId(), Integer.valueOf(25), cellErrColMap, "user");
            if (!HussarUtils.isNotEmpty((Object)cellErrColMap)) continue;
            errorDataList.add((ExcelImportMsg<UserExcel>)new ExcelImportMsg((Object)userExcel, cellErrColMap));
        }
    }

    private boolean isInIntegerRange(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void checkExcelForParentOrgan(int i, String departmentNames, Map<Integer, Map<Integer, String>> cellErrColMap) {
        List<String> deptNames = Arrays.asList(departmentNames.split(","));
        if (HussarUtils.isEmpty(deptNames)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_ORGAN_EMPTY.getMessage()), cellErrColMap);
            LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c2\u5217\uff0c\u6240\u5728\u673a\u6784\u4e3a\u7a7a", (Object)i);
            return;
        }
        String regex = "^(?:/[^/]+)+$";
        Pattern pattern = Pattern.compile(regex);
        for (String deptName : deptNames) {
            Matcher matcher = pattern.matcher(deptName);
            if (matcher.matches()) continue;
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_FORMAT_FALSE.getMessage()), cellErrColMap);
            LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c2\u5217\uff0c\u6240\u5728\u673a\u6784\u62a5\u9519\uff0c\u6240\u5728\u673a\u6784\u503c\uff1a{}", (Object)i, (Object)departmentNames);
            break;
        }
    }

    private void checkDataInDb(List<UserExcel> datas, List<UserExcel> successDataList, List<ExcelImportMsg<UserExcel>> newDataList, List<ExcelImportMsg<UserExcel>> updateDataList, List<ExcelImportMsg<UserExcel>> existDataList, List<ExcelImportMsg<UserExcel>> errorDataList, Map<String, UserExcel> userDbMap, Map<String, OrganExcel> fullOrganNameMap, Map<Long, List<UserOrganPostVo>> userOrganMap, List<Long> userIds, List<SysStaff> sysStaffsDb) {
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        ArrayList<String> staffCodeDbList = new ArrayList();
        List staffDbList = this.sysStaffService.list();
        if (HussarUtils.isNotEmpty((Object)staffDbList)) {
            staffCodeDbList = staffDbList.stream().map(SysStaff::getStaffCode).collect(Collectors.toList());
        }
        List<String> userIdStrList = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        List lockUserIds = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        for (int i = 0; i < datas.size(); ++i) {
            UserExcel userExcel = datas.get(i);
            HashMap<Integer, Map<Integer, String>> cellErrColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellUpdateColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellNewColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellExitColMap = new HashMap<Integer, Map<Integer, String>>();
            this.checkOrganForExist(i, userExcel, fullOrganNameMap, cellErrColMap);
            this.checkUserForExit(i, userExcel, userDbMap, cellNewColMap, cellExitColMap, cellUpdateColMap, userOrganMap, cellErrColMap, dicMap, userIdStrList, staffCodeDbList, lockUserIds);
            this.checkIdCard(i, userExcel, sysStaffsDb, cellErrColMap);
            if (cellErrColMap.isEmpty()) {
                successDataList.add(userExcel);
            }
            if (HussarUtils.isNotEmpty(cellErrColMap)) {
                errorDataList.add((ExcelImportMsg<UserExcel>)new ExcelImportMsg((Object)userExcel, cellErrColMap));
            }
            if (HussarUtils.isNotEmpty(cellExitColMap)) {
                existDataList.add((ExcelImportMsg<UserExcel>)new ExcelImportMsg((Object)userExcel, cellExitColMap));
            }
            if (HussarUtils.isNotEmpty(cellUpdateColMap)) {
                updateDataList.add((ExcelImportMsg<UserExcel>)new ExcelImportMsg((Object)userExcel, cellUpdateColMap));
            }
            if (!HussarUtils.isNotEmpty(cellNewColMap)) continue;
            newDataList.add((ExcelImportMsg<UserExcel>)new ExcelImportMsg((Object)userExcel, cellNewColMap));
        }
    }

    private void checkIdCard(int i, UserExcel userExcel, List<SysStaff> sysStaffsDb, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String idCard = userExcel.getIdcard();
        String userName = userExcel.getUserName();
        if (HussarUtils.isNotEmpty((Object)idCard) && HussarUtils.isNotEmpty(sysStaffsDb)) {
            for (int j = 0; j < sysStaffsDb.size(); ++j) {
                SysStaff sysStaff = sysStaffsDb.get(j);
                if (!HussarUtils.isNotEmpty((Object)sysStaff) || !HussarUtils.isNotEmpty((Object)sysStaff.getIdcard()) || !HussarUtils.isNotEmpty((Object)sysStaff.getName()) || !idCard.equals(sysStaff.getIdcard()) || userName.equals(sysStaff.getName())) continue;
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)18, (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IDCARD_DB_EXIST.getMessage()) + sysStaff.getName() + "\uff08" + sysStaff.getStaffCode() + "\uff09"), cellErrColMap);
                break;
            }
        }
    }

    private void checkOrganForExist(int i, UserExcel userExcel, Map<String, OrganExcel> fullNameOrganMap, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String[] deptNames;
        String departmentName = userExcel.getDepartment();
        for (String deptName : deptNames = departmentName.split(",")) {
            if (!HussarUtils.isEmpty((Object)fullNameOrganMap.get(deptName))) continue;
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_NAME_NOT_EXSIT.getMessage()) + deptName), cellErrColMap);
            break;
        }
    }

    private void checkUserForExit(int i, UserExcel userExcel, Map<String, UserExcel> userDbMap, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellExitColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<Long, List<UserOrganPostVo>> userOrganMap, Map<Integer, Map<Integer, String>> cellErrColMap, Map<String, String> dicMap, List<String> userIdStrList, List<String> staffCodeDbList, List<String> lockUserIds) {
        String userAccount = userExcel.getUserAccount();
        if (!userDbMap.containsKey(userAccount)) {
            String staffCode;
            String userId = userExcel.getUserId();
            if (HussarUtils.isNotEmpty((Object)userId) && userIdStrList.contains(userId)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)25, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ADD_ORGAN_PRIMARY_KEY_EXIST.getMessage()), cellErrColMap);
            }
            if (HussarUtils.isNotEmpty((Object)(staffCode = userExcel.getStaffCode())) && staffCodeDbList.contains(staffCode)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)17, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_NEW_DATA_STAFF_CODE_EXIST.getMessage()), cellErrColMap);
            }
            HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_NEW_DATA.getMessage()), cellNewColMap);
        } else {
            UserExcel userDb;
            boolean exitFlag = true;
            String staffPosition = dicMap.get((userDb = userDbMap.get(userAccount)).getStaffPosition());
            userDb.setStaffPosition(HussarUtils.isEmpty((Object)staffPosition) ? "" : staffPosition);
            List<UserOrganPostVo> userOrgans = userOrganMap.get(Long.parseLong(userDb.getUserId()));
            if (HussarUtils.equals((Object)UserStatus.DELETE.getCode(), (Object)userDb.getAccountStatus())) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
            } else {
                List<String> deptNames = Arrays.asList(userExcel.getDepartment().split(","));
                if (HussarUtils.isEmpty(userOrgans)) {
                    HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                    HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
                } else {
                    if (userOrgans.size() == deptNames.size()) {
                        for (UserOrganPostVo organ : userOrgans) {
                            if (deptNames.contains(organ.getOrganFname())) continue;
                            exitFlag = false;
                            break;
                        }
                    }
                    if (exitFlag) {
                        UserLockModel lockModel;
                        if (HussarUtils.isNotEmpty(lockUserIds) && lockUserIds.contains(userDb.getUserId()) && HussarUtils.isNotEmpty((Object)(lockModel = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)userDb.getUserId())).getLockTime())) {
                            userDb.setAccountStatus(UserStatus.LOCKED.getCode());
                        }
                        exitFlag = userExcel.equals((Object)userDb);
                    }
                    if (exitFlag) {
                        HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                    } else {
                        HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                        HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
                    }
                }
            }
        }
    }

    public List<UserExcel> handleDataBeforeImport(List<UserExcel> list, Long taskId) {
        if (HussarUtils.isEmpty(list)) {
            return list;
        }
        String organProperty = this.organPropertyMap.get(taskId);
        list.forEach(userExcel -> {
            userExcel.setWorkDate(this.handleDateFormat(userExcel.getWorkDate()));
            userExcel.setBirthday(this.handleDateFormat(userExcel.getBirthday()));
            userExcel.setGraduateDate(this.handleDateFormat(userExcel.getGraduateDate()));
            userExcel.setOrganProperty(organProperty);
        });
        return list;
    }

    private String handleDateFormat(String dateStr) {
        if (HussarUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        return dateStr.replace("/", "-");
    }

    private void checkExcelForTypeProperty(int i, UserExcel userExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        if (HussarUtils.equals((Object)AccountTypeEnum.TEMPORARY.getValue(), (Object)userExcel.getTypeProperty())) {
            String startTime = userExcel.getStartTime();
            String expiredTime = userExcel.getExpiredTime();
            this.checkTime(i, startTime, 14, cellErrColMap);
            this.checkTime(i, expiredTime, 15, cellErrColMap);
        }
    }

    private void checkTime(Integer i, String time, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String tip;
        String string = tip = HussarUtils.equals((Object)14, (Object)index) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_START.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_END.getMessage());
        if (HussarUtils.isBlank((CharSequence)time)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_TEMPORARY_ACCOUNT.getMessage()) + tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_DATA_REQUIRED.getMessage())), cellErrColMap);
            LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c{}\u5217\uff0c\u8d26\u53f7\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\u62a5\u9519\uff0c\u503c\uff1a{}", new Object[]{i, index, time});
        } else {
            try {
                Java8DateUtils.convertStringToLocalDateTime((String)time);
            }
            catch (Exception e) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_DATE_TIME_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c{}\u5217\uff0c\u8d26\u53f7\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u62a5\u9519\uff0c\u503c\uff1a{}", new Object[]{i, index, time});
            }
        }
    }

    private void checkDate(Integer i, String date, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        if (HussarUtils.isBlank((CharSequence)date)) {
            return;
        }
        String tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_BIRTH.getMessage());
        if (HussarUtils.equals((Object)21, (Object)index)) {
            tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_EMPLOYMENT.getMessage());
        } else if (HussarUtils.equals((Object)22, (Object)index)) {
            tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_GRADUATION.getMessage());
        }
        try {
            Java8DateUtils.convertStringToLocalDate((String)date);
        }
        catch (Exception e) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_DATE_TIME_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
            LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c{}\u5217\uff0c\u6821\u9a8c\u65e5\u671f\u683c\u5f0f\u62a5\u9519\uff0c\u503c\uff1a{}", new Object[]{i, index, date});
        }
    }

    private void checkNumber(Integer i, String num, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String tip;
        String string = tip = HussarUtils.equals((Object)3, (Object)index) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_MAX_SESSION.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_SORT.getMessage());
        if (HussarUtils.isBlank((CharSequence)num)) {
            if (HussarUtils.equals((Object)3, (Object)index)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_IS_REQUIRED.getMessage())), cellErrColMap);
                LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c{}\u5217\uff0c\u6821\u9a8c\u6821\u9a8c\u6570\u5b57\u683c\u5f0f\u62a5\u9519\uff0c\u6570\u5b57\u6570\u636e\u4e3a\u7a7a", (Object)i, (Object)index);
            } else {
                return;
            }
        }
        try {
            Integer.parseInt(num);
        }
        catch (Exception e) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_NUMBER_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
            LOGGER.info("\u7528\u6237\u6570\u636e\uff0ci={}\uff0c\u7b2c{}\u5217\uff0c\u6821\u9a8c\u6821\u9a8c\u6570\u5b57\u683c\u5f0f\u62a5\u9519\uff0c\u503c\uff1a{}", new Object[]{i, index, num});
        }
    }

    private void addLockUserCache(SysUsers user, SecureErr errMode, String tryLoginTime, int lockTime) {
        UserLockModel lockModel = new UserLockModel();
        lockModel.setUserId(String.valueOf(user.getId()));
        lockModel.setUserName(String.valueOf(user.getUserName()));
        lockModel.getSecureErrList().add(errMode);
        lockModel.setFailNum(Integer.parseInt(tryLoginTime));
        lockModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        lockModel.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)lockTime));
        HussarCacheUtil.put((String)"Login_Lock", (Object)lockModel.getUserId(), (Object)lockModel, (long)((long)lockTime * 60L));
    }
}

