/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAuditStruRoleDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryAuditStruRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.vo.StruRoleAuditVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryAuditStruRoleManagerImpl")
public class QueryAuditStruRoleManagerImpl
implements QueryAuditStruRoleManager {
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysRolesService sysRolesService;

    @Override
    public Page<StruRoleAuditVo> queryStruRoleAuditList(PageInfo pageInfo, QueryAuditStruRoleDto queryAuditStruRoleDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("roleName", SqlQueryUtil.transferSpecialChar((String)queryAuditStruRoleDto.getRoleName()));
        queryParams.put("organName", SqlQueryUtil.transferSpecialChar((String)queryAuditStruRoleDto.getStruName()));
        if (HussarUtils.isNotEmpty((Object)queryAuditStruRoleDto.getAuditStatus())) {
            queryParams.put("auditStatus", String.valueOf(queryAuditStruRoleDto.getAuditStatus()));
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List list = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List rolesList = this.sysRolesService.list();
        if (HussarUtils.isEmpty((Object)list) || HussarUtils.isEmpty((Object)rolesList)) {
            return page;
        }
        List struIds = list.stream().map(SysStru::getId).collect(Collectors.toList());
        List roleIds = rolesList.stream().map(SysRoles::getId).collect(Collectors.toList());
        queryParams.put("struIds", struIds);
        queryParams.put("roleIds", roleIds);
        List<StruRoleAuditVo> struRoleAuditVos = this.sysStruRoleAuditMapper.queryStruRoleAuditList((Page<StruRoleAuditVo>)page, queryParams);
        page.setRecords(struRoleAuditVos);
        return page;
    }
}

