/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.EditOnlyOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editOutsideUserManagerImpl")
public class EditOutsideUserManagerImpl
extends CommonOutsideUserManager
implements EditOutsideUserManager {
    @Override
    public R<EditOutsideUserDto> editUser(EditOutsideUserDto user) {
        List<Long> organIds;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = user.getUserAccount();
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if (user.getUpdateDeleteFlag().booleanValue()) {
            return this.editLogicalDeleteUser(user, (R<EditOutsideUserDto>)result, errors, account);
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()), false);
        if (sysUsers == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)(organIds = user.getOrganIds()))) {
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            user.setOrganIds(organIds);
            List<Long> existStruIds = this.sysStruMapper.selectExistIdByIds(organIds);
            if (existStruIds.size() != organIds.size()) {
                StringBuilder msg = new StringBuilder();
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId)) continue;
                    msg.append(organId).append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())).append("\uff1a");
                }
                OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysUsers.getEmployeeId());
            this.initializationEdit(user, sysStaff, sysUsers);
            if (HussarUtils.isNotEmpty(organIds)) {
                Long departmentId = organIds.get(0);
                sysUsers.setCorporationId(departmentId);
                sysUsers.setDepartmentId(departmentId);
                this.handleUserStaff(user, sysUsers);
            }
            this.sysStaffService.updateById((Object)sysStaff);
            this.sysUsersService.updateById((Object)sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), StringUtils.trimToEmpty((String)sysUsers.getUserAccount()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private R<EditOutsideUserDto> editLogicalDeleteUser(EditOutsideUserDto user, R<EditOutsideUserDto> result, List<Error<EditOutsideUserDto>> errors, String account) {
        List<Long> organIds;
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).eq(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()), false);
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)user, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)(organIds = user.getOrganIds()))) {
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            user.setOrganIds(organIds);
            List<Long> existStruIds = this.sysStruMapper.selectExistIdByIds(organIds);
            if (existStruIds.size() != organIds.size()) {
                StringBuilder msg = new StringBuilder();
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId)) continue;
                    msg.append(organId).append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())).append("\uff1a");
                }
                OrganUtil.addErrorMsg(errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
            }
        }
        if (HussarUtils.isEmpty(errors)) {
            SysStaff sysStaff = new SysStaff();
            this.initializationAddStaff(user, sysStaff);
            sysUsers.setEmployeeId(sysStaff.getId());
            sysUsers.setAccountStatus(UserStatus.OK.getCode());
            this.initializationEdit(user, sysStaff, sysUsers);
            this.sysStaffService.save((Object)sysStaff);
            if (HussarUtils.isNotEmpty(organIds)) {
                Long departmentId = organIds.get(0);
                sysUsers.setCorporationId(departmentId);
                sysUsers.setDepartmentId(departmentId);
                this.handleUserStaff(user, sysUsers);
            }
            this.sysUsersService.updateById((Object)sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), StringUtils.trimToEmpty((String)sysUsers.getUserAccount()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAddStaff(EditOutsideUserDto userDto, SysStaff sysStaff) {
        Integer maxStaffOrder;
        Long sysStaffId = IdWorker.getId((Object)sysStaff);
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        Integer order = userDto.getUserOrder();
        sysStaff.setId(sysStaffId);
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysStaff.setStaffPosition(staffPosition);
        sysStaff.setStaffCode(this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF"));
        int staffOrder = 1;
        staffOrder = HussarUtils.isEmpty((Object)order) ? (HussarUtils.isEmpty((Object)(maxStaffOrder = this.sysStaffMapper.getMaxOrder())) ? staffOrder : maxStaffOrder + 1) : order;
        sysStaff.setStaffOrder(Integer.valueOf(staffOrder));
    }

    @Override
    public R<EditOnlyOutsideUserDto> editOnlyUser(EditOnlyOutsideUserDto user) {
        SysStaff sysStaff;
        SysUsers sysUsers;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = user.getUserAccount();
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if ((sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()), false)) == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)user.getStaffId()) && HussarUtils.isNotEmpty((Object)sysUsers) && !sysUsers.getEmployeeId().equals(user.getStaffId()) && HussarUtils.isEmpty((Object)(sysStaff = (SysStaff)this.sysStaffMapper.selectById(user.getStaffId())))) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"staffId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_STAFF_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            this.initializationEditOnlyUser(user, sysUsers);
            List struIds = user.getOrganIds();
            if (HussarUtils.isNotEmpty((Object)struIds)) {
                ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
                struIds = struIds.stream().distinct().collect(Collectors.toList());
                for (Long struId : struIds) {
                    SysStruUser sysStruUser = new SysStruUser();
                    sysStruUser.setStruId(struId);
                    sysStruUser.setUserId(sysUsers.getId());
                    struUserList.add(sysStruUser);
                }
                this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
                this.sysStruUserService.saveBatch(struUserList);
            }
            this.sysUsersService.updateById((Object)sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), StringUtils.trimToEmpty((String)sysUsers.getUserAccount()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEditOnlyUser(EditOnlyOutsideUserDto userDto, SysUsers sysUsers) {
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String mail = StringUtils.trimToEmpty((String)userDto.getMail());
        Integer order = userDto.getUserOrder();
        String accountStatus = userDto.getAccountStatus();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            sysUsers.setUserName(userName);
        }
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        sysUsers.seteMail(mail);
        sysUsers.setEmployeeId(userDto.getStaffId());
        if (HussarUtils.isNotEmpty((Object)accountStatus)) {
            sysUsers.setAccountStatus(accountStatus);
        }
        if (HussarUtils.isNotEmpty((Object)order)) {
            sysUsers.setUserOrder(order);
        }
    }

    private void handleUserStaff(EditOutsideUserDto user, SysUsers sysUsers) {
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
        this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)sysUsers.getEmployeeId()));
        List organIds = user.getOrganIds();
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
            ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
            for (Long organId : organIds) {
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStruId(organId);
                sysStruStaff.setStaffId(sysUsers.getEmployeeId());
                struStaffList.add(sysStruStaff);
                SysStruUser sysStruUser = new SysStruUser();
                sysStruUser.setStruId(organId);
                sysStruUser.setUserId(sysUsers.getId());
                struUserList.add(sysStruUser);
            }
            this.sysStruStaffService.saveBatch(struStaffList);
            this.sysStruUserService.saveBatch(struUserList);
        }
    }
}

