/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.pinyin.service.IPinyinSysAsyncEventService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteOrganizationManagerImpl")
public class DeleteOrganizationManagerImpl
extends CommonOrganizationManager
implements DeleteOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteOrganizationManagerImpl.class);
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private IPinyinSysAsyncEventService pinyinSysAsyncEventService;

    @Override
    public String deleteOrganization(Long struId) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_DELETE_THIS.getMessage()), (Object)struId);
        if (struId == null) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_DEL_ID.getMessage()));
        }
        this.beforeDeleteOrganization(struId);
        this.judgeWhetherItCanBeDelete(struId);
        String result = this.doDelete(struId);
        this.afterDeleteOrganization(struId);
        return result;
    }

    private void afterDeleteOrganization(Long struId) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_AFTER_DELETE_ORG.getMessage()));
        this.sysOrgEventService.afterDel(struId);
    }

    private String doDelete(Long struId) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETING_DATA.getMessage()));
        String msg = "";
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_DELETE_NEED_AUDIT.getMessage()));
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setOrganId(Long.valueOf(IdWorker.getId((Object)sysStruAudit)));
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            LocalDateTime now = LocalDateTime.now();
            sysStruAudit.setCreateTime(now);
            sysStruAudit.setLastTime(now);
            this.sysStruAuditService.save((Object)sysStruAudit);
            SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
            SysOrganAudit sysOrganAudit = new SysOrganAudit();
            CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
            sysOrganAudit.setId(sysStruAudit.getOrganId());
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setInUse("3");
            sysOrganAudit.setCreateTime(now);
            sysOrganAudit.setLastTime(now);
            this.sysOrganAuditService.save((Object)sysOrganAudit);
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
        } else {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
            SysOrgan sysOrgan = null;
            if (Objects.nonNull(sysStru)) {
                sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
            }
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_DELETE_NO_NEED_AUDIT.getMessage()));
            boolean flag = this.delOrganByStruId(struId);
            String string = msg = flag ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL.getMessage());
            if (Boolean.TRUE.equals(flag)) {
                this.organChangeNotify.notify(DataChangeType.DELETE, new Object[]{struId, sysOrgan, null});
            }
        }
        return msg;
    }

    private void judgeWhetherItCanBeDelete(Long struId) {
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(struId);
        if (HussarUtils.isNotEmpty(orgList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_EXIST_ORGAN.getMessage()));
        }
        List sysStruStaffs = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStruId, (Object)struId));
        if (HussarUtils.isNotEmpty((Object)sysStruStaffs)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_STAFF_RELATION.getMessage()));
        }
        List sysStruUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getStruId, (Object)struId));
        AssertUtil.isEmpty((Collection)sysStruUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_USER_RELATION.getMessage()));
        List assistOrganChildrenList = this.sysStruAssistOrganService.getAssistOrganByParent(struId);
        if (HussarUtils.isNotEmpty((Object)assistOrganChildrenList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_EXIST_ASSIST_ORGAN.getMessage()));
        }
        if (!this.sysStruAuditService.checkCanOperate(struId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage()));
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(SysStruAudit::getParentId, (Object)struId);
        wrapper1.eq(SysStruAudit::getState, (Object)"0");
        ArrayList<String> inUseList = new ArrayList<String>();
        inUseList.add("1");
        inUseList.add("4");
        wrapper1.in(SysStruAudit::getInUse, inUseList);
        List list1 = this.sysStruAuditService.list((Wrapper)wrapper1);
        if (HussarUtils.isNotEmpty((Object)list1)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_RELATION_EXIST_ORGAN.getMessage()));
        }
        LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
        wrapper6.eq(SysStruUserAudit::getStruId, (Object)struId);
        wrapper6.eq(SysStruUserAudit::getAuditStatus, (Object)"0");
        List list6 = this.sysStruUserAuditService.list((Wrapper)wrapper6);
        if (HussarUtils.isNotEmpty((Object)list6)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_USER_RELATION_EXIST_REVIEW.getMessage()));
        }
        LambdaQueryWrapper wrapper7 = new LambdaQueryWrapper();
        wrapper7.eq(SysStruStaffAudit::getStruId, (Object)struId);
        wrapper7.eq(SysStruStaffAudit::getAuditStatus, (Object)"0");
        List list7 = this.sysStruStaffAuditService.list((Wrapper)wrapper7);
        if (HussarUtils.isNotEmpty((Object)list7)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_STAFF_RELATION_EXIST_REVIEW.getMessage()));
        }
    }

    private void beforeDeleteOrganization(Long struId) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BEFORE_DELETE_ORG.getMessage()));
        this.sysOrgEventService.beforeDel(struId);
    }
}

