/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.menu.dto.MenuOrderDto;
import com.jxdinfo.hussar.authorization.menu.dto.MenuTreeChangeDto;
import com.jxdinfo.hussar.authorization.menu.model.MenuInfo;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.menu.vo.SysMenuVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/frontMenu"})
public class SysMenuFrontController
extends HussarBaseController<SysMenu, ISysMenuManageService> {
    @Resource
    ISysMenuManageService sysMenuManageService;

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355\u6743\u9650", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355\u6743\u9650")
    @GetMapping(value={"/getMenu"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MenuInfo>> getMenu(@ApiParam(value="\u524d\u53f0\u9875\u9762\u7c7b\u578b") @RequestParam String type) {
        return ApiResponse.success((Object)this.sysMenuManageService.queryUserMenu(type));
    }

    @ApiOperation(value="\u83dc\u5355\u7ed3\u6784\u6811", notes="\u83dc\u5355\u7ed3\u6784\u6811,\u4e00\u6b21\u52a0\u8f7d,\u4e0d\u67e5\u8be2\u672b\u7ea7\u83dc\u5355")
    @GetMapping(value={"/menuStruTree"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83b7\u53d6\u83dc\u5355\u7ed3\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> menuStruTree() {
        return ApiResponse.success((Object)this.sysMenuManageService.getMenuStruTree());
    }

    @ApiOperation(value="\u83b7\u53d6\u672b\u7ea7\u83dc\u5355\u7684\u5217\u8868", notes="\u83b7\u53d6\u672b\u7ea7\u83dc\u5355\u7684\u5217\u8868,\u5982\u679c\u662f\u975e\u672b\u7ea7\u7684\u83dc\u5355\u5219\u83b7\u53d6\u8be5\u83dc\u5355\u7684\u6240\u6709\u672b\u7ea7\u83dc\u5355")
    @GetMapping(value={"menuInfoList"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83b7\u53d6\u672b\u7ea7\u83dc\u5355\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysMenu>> getDetailMenuList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u8282\u70b9id") @RequestParam Long nodeId) {
        return ApiResponse.success((Object)this.sysMenuManageService.queryMenuInfoList(page, nodeId));
    }

    @ApiOperation(value="\u52a0\u8f7d\u83dc\u5355\u6811", notes="\u52a0\u8f7d\u83dc\u5355\u6811")
    @GetMapping(value={"/menuTree"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u83dc\u5355\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> menuTree() {
        return ApiResponse.success((Object)this.sysMenuManageService.getMenuMergeTree());
    }

    @ApiOperation(value="\u52a0\u8f7d\u4e2a\u6027\u5316\u914d\u7f6e\u5feb\u6377\u65b9\u5f0f\u83dc\u5355\u6811", notes="\u52a0\u8f7d\u4e2a\u6027\u5316\u914d\u7f6e\u5feb\u6377\u65b9\u5f0f\u83dc\u5355\u6811")
    @CheckPermission(value={"frontMenu:shortCutMenuTree"})
    @GetMapping(value={"/shortCutMenuTree"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u4e2a\u6027\u5316\u914d\u7f6e\u5feb\u6377\u65b9\u5f0f\u83dc\u5355\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> shortCutMenuTree() {
        return ApiResponse.success((Object)this.sysMenuManageService.getShortCutMenuTree());
    }

    @ApiOperation(value="\u83dc\u5355\u65b0\u589e", notes="\u83dc\u5355\u65b0\u589e")
    @CheckPermission(value={"frontMenu:menuInfoSave"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @PostMapping(value={"/menuInfoSave"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83dc\u5355\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse menuInfoSave(@ApiParam(value="\u83dc\u5355\u5b9e\u4f53") @RequestBody SysMenu sysMenu) {
        return this.sysMenuManageService.saveMenu(sysMenu);
    }

    @ApiOperation(value="\u83dc\u5355\u4fee\u6539", notes="\u83dc\u5355\u4fee\u6539")
    @CheckPermission(value={"frontMenu:menuInfoEditSave"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @PostMapping(value={"/menuInfoEditSave"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83dc\u5355\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse menuInfoEditSave(@ApiParam(value="\u83dc\u5355\u5b9e\u4f53") @RequestBody SysMenu sysMenu) {
        return this.sysMenuManageService.updateMenu(sysMenu);
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u83dc\u5355\u4fe1\u606f")
    @CheckPermission(value={"frontMenu:menuInfo"})
    @GetMapping(value={"/menuInfo"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83b7\u53d6\u83dc\u5355\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysMenuVo> menuInfo(@ApiParam(value="\u83dc\u5355id") @RequestParam Long menuId) {
        return ApiResponse.success((Object)this.sysMenuManageService.getMenuInfo(menuId));
    }

    @ApiOperation(value="\u83dc\u5355\u5220\u9664", notes="\u83dc\u5355\u5220\u9664")
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @PostMapping(value={"/delMenuById"})
    @CheckPermission(value={"frontMenu:delMenuById"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83dc\u5355\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> delMenuById(@ApiParam(value="\u5220\u9664\u83dc\u5355id\u5b57\u7b26\u4e32") @RequestBody String menuIds) {
        return this.sysMenuManageService.deleteMenus(menuIds);
    }

    @ApiOperation(value="\u7ea7\u8054\u5220\u9664\u83dc\u5355", notes="\u7ea7\u8054\u5220\u9664\u83dc\u5355")
    @PostMapping(value={"/delCascadeMenu"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @CheckPermission(value={"frontMenu:delMenuById"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u7ea7\u8054\u5220\u9664\u83dc\u5355", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delCascadeMenuById(@ApiParam(value="\u5220\u9664\u83dc\u5355id") @RequestBody Long menuId) {
        return this.sysMenuManageService.deleteCascadeMenuId(menuId);
    }

    @ApiOperation(value="\u6839\u636e\u7236ID\u83b7\u53d6\u4e0b\u7ea7\u83dc\u5355\u6811", notes="\u6839\u636e\u7236ID\u83b7\u53d6\u4e0b\u7ea7\u83dc\u5355\u6811")
    @CheckPermission(value={"frontMenu:menuTreeById"})
    @GetMapping(value={"/menuTreeById"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u6839\u636e\u7236ID\u83b7\u53d6\u4e0b\u7ea7\u83dc\u5355\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> menuTreeById(@ApiParam(value="\u7236\u83dc\u5355id") @RequestParam Long menuId, @ApiParam(value="\u662f\u5426\u4e3a\u6839\u8282\u70b9") @RequestParam boolean isRoot) {
        return ApiResponse.success((Object)this.sysMenuManageService.menuTreeById(menuId, isRoot));
    }

    @ApiOperation(value="\u6811\u5217\u8868\u6392\u5e8f\u4fdd\u5b58", notes="\u6811\u5217\u8868\u6392\u5e8f\u4fdd\u5b58")
    @PostMapping(value={"/menuTreeOrder"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @CheckPermission(value={"frontMenu:menuTreeOrder"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u6811\u5217\u8868\u6392\u5e8f\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse menuTreeOrder(@ApiParam(value="\u6392\u5e8f\u83dc\u5355\u96c6\u5408") @RequestBody List<SysMenu> sysMenus) {
        return this.sysMenuManageService.updateMenuOrder(sysMenus);
    }

    @ApiOperation(value="\u83dc\u5355\u6811\u8f6c\u79fb\u4fdd\u5b58", notes="\u83dc\u5355\u6811\u8f6c\u79fb\u4fdd\u5b58")
    @PostMapping(value={"/menuTreeChange"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @CheckPermission(value={"frontMenu:menuTreeChange"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83dc\u5355\u6811\u8f6c\u79fb\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse menuTreeChange(@ApiParam(value="\u83dc\u5355\u6811\u8f6c\u79fbdto") @RequestBody MenuTreeChangeDto menuTreeChangeDto) {
        return this.sysMenuManageService.updateMenuTree(menuTreeChangeDto);
    }

    @ApiOperation(value="\u83dc\u5355\u6811\u4e0a\u79fb\u4e0b\u79fb", notes="\u83dc\u5355\u6811\u4e0a\u79fb\u4e0b\u79fb")
    @PostMapping(value={"/singleMove"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @CheckPermission(value={"frontMenu:singleMove"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83dc\u5355\u6811\u4e0a\u79fb\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse updateMoveNode(@ApiParam(value="\u83dc\u5355\u6392\u5e8fdto") @RequestBody MenuOrderDto menuOrderDto) {
        return this.sysMenuManageService.updateMoveNode(menuOrderDto);
    }

    @ApiOperation(value="\u83dc\u5355\u5bfc\u51fa", notes="\u83dc\u5355\u5bfc\u51fa")
    @PostMapping(value={"/exportMenu"})
    @CheckPermission(value={"frontMenu:exportMenu"})
    @AuditLog(moduleName="\u83dc\u5355\u7ba1\u7406", eventDesc="\u83dc\u5355\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@ApiParam(value="\u5bfc\u51fa\u83dc\u5355id\u5b57\u7b26\u4e32") @RequestBody String menuIds, HttpServletResponse response) {
        this.sysMenuManageService.exportMenu(menuIds, response);
    }
}

