/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysResourceMosulesServiceImpl
extends HussarServiceImpl<SysResourceModulesMapper, SysResourceModules>
implements ISysResourceMosulesService {
    private static Logger logger = LoggerFactory.getLogger(SysResourceMosulesServiceImpl.class);
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private ISysIdtableService sysIdtableService;

    public List<SysResourceModules> getGradeAdminResModuleId(List<Long> resourceIdList) {
        if (ToolUtil.isEmpty(resourceIdList)) {
            return new ArrayList<SysResourceModules>();
        }
        List resourceModulesList = this.sysResourceModulesMapper.selectList((Wrapper)new QueryWrapper());
        List resourcesList = this.sysResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysResources::getId, resourceIdList));
        ArrayList<Long> parentModuleIds = new ArrayList<Long>();
        resourcesList.forEach(resource -> parentModuleIds.add(resource.getModuleId()));
        ArrayList<SysResourceModules> parentModuleList = new ArrayList<SysResourceModules>();
        this.getParentModuleList(parentModuleList, parentModuleIds, resourceModulesList);
        return parentModuleList;
    }

    private void getParentModuleList(List<SysResourceModules> parentModuleList, List<Long> parentModuleIds, List<SysResourceModules> resourceModulesList) {
        ArrayList parentList = new ArrayList();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        for (int i = 0; i < resourceModulesList.size(); ++i) {
            SysResourceModules resourceModules = resourceModulesList.get(i);
            if (!parentModuleIds.contains(Long.parseLong(String.valueOf(resourceModules.getId())))) continue;
            parentModuleList.add(resourceModules);
            parentIdList.add(resourceModules.getParentModuleId());
            resourceModulesList.remove(i);
            --i;
        }
        if (parentIdList.size() > 0) {
            this.getParentModuleList(parentModuleList, parentIdList, resourceModulesList);
        }
    }

    public Map<String, Integer> insertOrUpdateList(List<SysResourceModules> modulesList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (CollectionUtils.isEmpty(modulesList)) {
            result.put("update", modulesList.size());
            result.put("insert", modulesList.size());
            return result;
        }
        List<Long> moduleIds = modulesList.stream().map(SysResourceModules::getId).collect(Collectors.toList());
        List<SysResourceModules> existedResourceModules = this.getResModulesByModuleIds(moduleIds);
        List existedIds = existedResourceModules.stream().map(SysResourceModules::getId).distinct().collect(Collectors.toList());
        ArrayList<SysResourceModules> insertData = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> updateData = new ArrayList<SysResourceModules>();
        Integer maxOrder = this.sysResourceModulesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("MODULE_CODE", "SYS_RESOURCE_MODULES");
        Integer maxCode = sysIdtable.getIdValue();
        for (SysResourceModules sysResourceModules : modulesList) {
            if (existedIds.contains(sysResourceModules.getId())) {
                updateData.add(sysResourceModules);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            sysResourceModules.setSeq(maxOrder);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            int zerolength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zerolength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            StringBuilder currentCode = new StringBuilder();
            for (int i = 0; i < zerolength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            sysResourceModules.setModuleCode(currentCode.toString());
            insertData.add(sysResourceModules);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        result.put("update", updateData.size());
        result.put("insert", insertData.size());
        return result;
    }

    public void insertOrUpdateResourcesModuleList(List<SysResourceModules> resourceModulesList) {
        if (CollectionUtils.isEmpty(resourceModulesList)) {
            logger.info("\u8d44\u6e90\u6a21\u5757\u65b0\u589e{}\u6761", (Object)resourceModulesList.size());
            logger.info("\u8d44\u6e90\u6a21\u5757\u4fee\u6539{}\u6761", (Object)resourceModulesList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysResourceModules::getId).collect(Collectors.toList());
        ArrayList<SysResourceModules> insertData = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> updateData = new ArrayList<SysResourceModules>();
        Integer maxOrder = this.sysResourceModulesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("MODULE_CODE", "SYS_RESOURCE_MODULES");
        Integer maxCode = sysIdtable.getIdValue();
        for (SysResourceModules item : resourceModulesList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            item.setSeq(maxOrder);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            int zeroLength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            StringBuilder currentCode = new StringBuilder();
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            item.setModuleCode(currentCode.toString());
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        logger.info("\u8d44\u6e90\u6a21\u5757\u65b0\u589e{}\u6761", (Object)insertData.size());
        logger.info("\u8d44\u6e90\u6a21\u5757\u4fee\u6539{}\u6761", (Object)updateData.size());
    }

    public List<SysResourceModules> getResourceModulesByOneRes(List<SysResourceModules> result, SysResourceModules children, List<SysResourceModules> allModules) {
        if (ToolUtil.isEmpty((Object)children)) {
            return result;
        }
        Long parentId = children.getParentModuleId();
        SysResourceModules parentModules = null;
        for (SysResourceModules resourceModule : allModules) {
            if (!parentId.equals(resourceModule.getId())) continue;
            parentModules = resourceModule;
        }
        if (HussarUtils.isNotEmpty(parentModules)) {
            result.add(parentModules);
            return this.getResourceModulesByOneRes(result, parentModules, allModules);
        }
        return result;
    }

    public List<SysResourceModules> getResModulesByModuleIds(List<Long> moduleIds) {
        if (HussarUtils.isEmpty(moduleIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long moduleId : moduleIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysResourceModules::getId, (Object)moduleId);
        }
        return this.sysResourceModulesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public String getFullModuleNameById(Long moduleId) {
        List allModules = this.list();
        Map<Long, SysResourceModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, Function.identity()));
        SysResourceModules module = (SysResourceModules)this.sysResourceModulesMapper.selectById(moduleId);
        StringBuilder fullName = new StringBuilder();
        this.getFullName(moduleMap, module, fullName);
        return fullName.reverse().toString();
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName) {
        List allModules = this.list();
        Map<Long, SysResourceModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, Function.identity()));
        List modules = this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getModuleName, (Object)moduleName)).orderByAsc(SysResourceModules::getSeq));
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (SysResourceModules module : modules) {
            StringBuilder fullName = new StringBuilder();
            this.getFullName(moduleMap, module, fullName);
            String finalFullName = fullName.reverse().toString();
            result.put(module.getId(), finalFullName);
        }
        return result;
    }

    private void getFullName(Map<Long, SysResourceModules> moduleMap, SysResourceModules module, StringBuilder fullName) {
        fullName.append(module.getModuleName()).append("/");
        Long parentModuleId = module.getParentModuleId();
        if (!HussarUtils.equals((Object)parentModuleId, (Object)1L)) {
            SysResourceModules parentModule = moduleMap.get(parentModuleId);
            this.getFullName(moduleMap, parentModule, fullName);
        }
    }
}

