/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.SysConfRolesetDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.SysRolesServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SysConfRolesServiceImpl
extends HussarServiceImpl<SysConfRolesMapper, SysConfRoles>
implements ISysConfRolesService {
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private SysRolesServiceImpl sysRolesService;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;

    public List<SysRoles> getSelectInRoles(String selectId) {
        List<SysRoles> list;
        if (selectId != null && !"".equals(selectId)) {
            String[] ids = selectId.substring(1).split(",");
            list = this.sysRolesMapper.getNoSelect(ids);
        } else {
            list = this.sysRolesMapper.selectList(null);
        }
        return list;
    }

    public boolean isIncludeConfRole(Long[] roleIds) {
        boolean flag = false;
        if (roleIds == null || roleIds.length == 0) {
            return true;
        }
        List<SysConfRoles> list = this.getConfRolesByRoleIds(Arrays.asList(roleIds));
        if (ToolUtil.isNotEmpty(list)) {
            ArrayList<String> idList = new ArrayList<String>();
            for (SysConfRoles sysConfRoles : list) {
                idList.add(String.valueOf(sysConfRoles.getSetId()));
            }
            List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List sysConfRolesetList = this.sysConfRolesetMapper.selectBatchIds(cdids);
            for (SysConfRoleset roleset : sysConfRolesetList) {
                Integer cardinality = roleset.getCardinality();
                int count = 0;
                for (SysConfRoles roles : list) {
                    if (!roleset.getId().equals(roles.getSetId())) continue;
                    ++count;
                }
                if (count <= cardinality - 1) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    @HussarTransactional
    public ApiResponse saveBatchSysConfRoles(SysConfRolesetDto sysConfRolesetDto) {
        if (ToolUtil.isEmpty((Object)sysConfRolesetDto)) {
            throw new BaseException("\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6dto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysConfRolesetDto, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        String roIds = sysConfRolesetDto.getRoleIds() == null ? "" : sysConfRolesetDto.getRoleIds();
        Long setId = sysConfRolesetDto.getId() == null ? 0L : sysConfRolesetDto.getId();
        String[] ids = roIds.split(",");
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getSetId, (Object)setId));
        ArrayList<SysConfRoles> list = new ArrayList<SysConfRoles>();
        for (String id : ids) {
            SysConfRoles sysConfRoles = new SysConfRoles();
            sysConfRoles.setSetId(setId);
            sysConfRoles.setId(Long.valueOf(id));
            list.add(sysConfRoles);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.saveBatch(list, list.size());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private void validateParam(Object o, String mdType) {
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysConfRolesetDto) {
            SysConfRolesetDto reqBO = (SysConfRolesetDto)o;
            if (null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleIds())) {
                sBuffer.append(",");
                sBuffer.append("\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (0 < sBuffer.length()) {
                String rspStr = sBuffer.substring(1);
                throw new BaseException(rspStr);
            }
        }
    }

    public List<JSTreeModel> getSelfRoleTree(String[] roleIds) {
        List result = this.sysOrgManageService.selfRoleTree(roleIds);
        List<JSTreeModel> tree = this.sysRolesService.doRecursive(result);
        return TreeModelUtils.merge(tree);
    }

    public List<SysConfRoles> getConfRolesByRoleIds(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long roleId : roleIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysConfRoles::getId, (Object)roleId);
        }
        return this.sysConfRolesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public Long isIncludeConfRole(Map<Long, StringBuilder> map, Long roleId) {
        List<Long> confRoleSetIdList = this.sysConfRolesetMapper.getConfRoleSetIdByRoleId(roleId);
        if (ToolUtil.isEmpty(confRoleSetIdList)) {
            return null;
        }
        LambdaQueryWrapper confRolesetWrapper = new LambdaQueryWrapper();
        for (Long id : confRoleSetIdList) {
            ((LambdaQueryWrapper)confRolesetWrapper.or()).eq(SysConfRoleset::getId, (Object)id);
        }
        List sysConfRolesetList = this.sysConfRolesetMapper.selectList((Wrapper)confRolesetWrapper);
        confRoleSetIdList.clear();
        if (ToolUtil.isEmpty((Object)sysConfRolesetList)) {
            return null;
        }
        HashMap cardinalityMap = new HashMap();
        sysConfRolesetList.forEach(rs -> {
            confRoleSetIdList.add(rs.getId());
            cardinalityMap.put(rs.getId(), rs.getCardinality());
        });
        LambdaQueryWrapper confRoleWrapper = new LambdaQueryWrapper();
        for (Long id : confRoleSetIdList) {
            ((LambdaQueryWrapper)confRoleWrapper.or()).eq(SysConfRoles::getSetId, (Object)id);
        }
        List confRolesList = this.list((Wrapper)confRoleWrapper);
        for (Long userId : map.keySet()) {
            String roleStr = map.get(userId).toString();
            if (ToolUtil.isEmpty((Object)roleStr)) continue;
            HashMap<Long, Integer> countMap = new HashMap<Long, Integer>();
            sysConfRolesetList.forEach(rs -> countMap.put(rs.getId(), 1));
            for (SysConfRoles confRoles : confRolesList) {
                String confRoleId = String.valueOf(confRoles.getId());
                Long confSetId = confRoles.getSetId();
                if (!ToolUtil.isNotEmpty((Object)confRoleId) || !roleStr.contains(confRoleId)) continue;
                Integer cardinality = (Integer)cardinalityMap.get(confSetId);
                Integer count = (Integer)countMap.get(confSetId);
                if ((count = Integer.valueOf(count + 1)) >= cardinality) {
                    return userId;
                }
                countMap.put(confSetId, count);
            }
        }
        return null;
    }
}

