/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.menu.vo.SysMenuVo;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FunctionExportDto;
import com.jxdinfo.hussar.authorization.permit.enums.MigrateFuncResMenuEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncDumpTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResMenuCheckTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.ImportVueFuncVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.ResourceWithFunctionException;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysFunctionsServiceImpl
extends HussarServiceImpl<SysFunctionsMapper, SysFunctions>
implements ISysFunctionsService {
    private static Logger logger = LoggerFactory.getLogger(SysFunctionsServiceImpl.class);
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    @Lazy
    private ISysResManageService sysResManageService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysResourcesService sysResourcesService;

    public void insertOrUpdateFunctionList(List<SysFunctions> sysFunctionsList) {
        if (CollectionUtils.isEmpty(sysFunctionsList)) {
            logger.info("\u529f\u80fd\u65b0\u589e{}\u6761", (Object)sysFunctionsList.size());
            logger.info("\u529f\u80fd\u4fee\u6539{}\u6761", (Object)sysFunctionsList.size());
            return;
        }
        List allFunctions = this.list();
        List allFunctionIds = allFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        ArrayList<SysFunctions> insertFunctions = new ArrayList<SysFunctions>();
        ArrayList<SysFunctions> updateFunctions = new ArrayList<SysFunctions>();
        Integer maxOrder = this.sysFunctionsMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("FUNCTION_CODE", "SYS_FUNCTIONS");
        Integer maxCode = sysIdtable.getIdValue();
        List allFunctionModules = this.sysFunctionModulesService.list();
        HashMap<Long, String> idAndModuleCode = new HashMap<Long, String>();
        for (SysFunctionModules sysFunctionModule : allFunctionModules) {
            idAndModuleCode.put(sysFunctionModule.getId(), sysFunctionModule.getFunctionModuleCode());
        }
        for (SysFunctions sysFunction : sysFunctionsList) {
            if (allFunctionIds.contains(sysFunction.getId())) {
                updateFunctions.add(sysFunction);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            StringBuilder currentCode = new StringBuilder();
            int zeroLength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            currentCode.append((String)idAndModuleCode.get(sysFunction.getFunctionModuleId()));
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            sysFunction.setSeq(maxOrder);
            sysFunction.setFunctionCode(currentCode.toString());
            insertFunctions.add(sysFunction);
        }
        if (ToolUtil.isNotEmpty(insertFunctions)) {
            this.saveBatch(insertFunctions);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateFunctions)) {
            this.updateBatchById(updateFunctions);
        }
        logger.info("\u529f\u80fd\u65b0\u589e{}\u6761", (Object)insertFunctions.size());
        logger.info("\u529f\u80fd\u4fee\u6539{}\u6761", (Object)updateFunctions.size());
    }

    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        return this.sysFunctionsMapper.getFunctionDetail(functionId);
    }

    @HussarTransactional
    public boolean saveOrUpdateFunction(FuncInfoDto funcInfoDto) {
        Long functionId;
        if (ToolUtil.isEmpty((Object)funcInfoDto.getFunctionName())) {
            throw new BaseException("\u529f\u80fd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (funcInfoDto.getFunctionName().length() > 32) {
            throw new BaseException("\u529f\u80fd\u540d\u79f0\u6700\u591a\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
        }
        if (HussarUtils.isNotEmpty((Object)funcInfoDto.getDefaultResourceId())) {
            String defResIdString = funcInfoDto.getDefaultResourceId().toString();
            boolean funcResFlag = false;
            for (Map item : funcInfoDto.getResources()) {
                if (!defResIdString.equals(item.get("id"))) continue;
                funcResFlag = true;
                break;
            }
            if (!funcResFlag) {
                HashMap<String, String> defaultResource = new HashMap<String, String>();
                defaultResource.put("id", defResIdString);
                defaultResource.put("type", "isRes");
                funcInfoDto.getResources().add(defaultResource);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(functionId = funcInfoDto.getFunctionId()))) {
            SysFunctions functions = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
            if (ToolUtil.isNotEmpty((Object)functions)) {
                functions.setFunctionName(funcInfoDto.getFunctionName());
                functions.setDefaultResourceId(funcInfoDto.getDefaultResourceId());
                return this.sysResManageService.functionSave(functions) > 0 && this.sysFunctionResourcesService.saveFunctionRes(functionId, funcInfoDto.getResources());
            }
            return false;
        }
        SysFunctions functions = new SysFunctions();
        String functionCode = this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
        functions.setFunctionCode(functionCode);
        functions.setFunctionModuleId(funcInfoDto.getParentModuleId());
        functions.setFunctionName(funcInfoDto.getFunctionName());
        functions.setDefaultResourceId(funcInfoDto.getDefaultResourceId());
        functions.setIsSys("0");
        return this.sysResManageService.functionSave(functions) > 0 && this.sysFunctionResourcesService.saveFunctionRes(functions.getId(), funcInfoDto.getResources());
    }

    @HussarTransactional
    public boolean deleteFunction(Long functionId) {
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException("\u529f\u80fdID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List menuList = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysMenu::getFunctionId, (Object)functionId));
        if (menuList.size() > 0) {
            throw new ResourceWithFunctionException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u83dc\u5355\u7684\u529f\u80fd\uff01");
        }
        List roleFunctionList = this.sysRoleFunctionsMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)functionId));
        if (roleFunctionList.size() > 0) {
            throw new ResourceWithFunctionException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u89d2\u8272\u7684\u529f\u80fd\uff01");
        }
        return this.sysFunctionsMapper.deleteById(functionId) > 0 && this.sysFunctionResourcesMapper.delete((Wrapper)new LambdaUpdateWrapper().eq(SysFunctionResources::getFunctionId, (Object)functionId)) > 0;
    }

    @HussarTransactional
    public boolean deleteFunction(String functionId) {
        return this.deleteFunction(Long.parseLong(functionId));
    }

    public ApiResponse updateMoveNode(FuncOrderDto funcOrderDto) {
        SysFunctions thatFunction;
        Long functionId = funcOrderDto.getFunctionId();
        Boolean isUp = funcOrderDto.getIsUp();
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException("\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFunctions thisFunction = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
        List<SysFunctions> thatFunctions = isUp != false ? this.sysFunctionsMapper.seletListLt(thisFunction.getFunctionModuleId(), thisFunction.getSeq()) : this.sysFunctionsMapper.seletListGt(thisFunction.getFunctionModuleId(), thisFunction.getSeq());
        if (thatFunctions.size() > 0 && (thatFunction = thatFunctions.get(0)) != null) {
            Integer temp = thisFunction.getSeq();
            thisFunction.setSeq(thatFunction.getSeq());
            thatFunction.setSeq(temp);
            this.sysFunctionsMapper.updateById(thisFunction);
            this.sysFunctionsMapper.updateById(thatFunction);
        }
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public void exportFunction(FunctionExportDto functionExportDto, HttpServletResponse response) {
        List roleIds;
        if (HussarUtils.isBlank((CharSequence)functionExportDto.getFunctionIds())) {
            throw new BaseException("\u4f20\u5165\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> funcAndModuleIds = Arrays.asList(functionExportDto.getFunctionIds().split(","));
        List funcAndModuleIdsLong = funcAndModuleIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List sysFunctions = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctions::getId, funcAndModuleIdsLong));
        List sysFunctionModules = this.sysFunctionModulesService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctionModules::getId, funcAndModuleIdsLong));
        List menuList = new ArrayList();
        if (Boolean.TRUE.equals(functionExportDto.getHasMenu())) {
            menuList = this.sysMenuMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysMenu::getFunctionId, funcAndModuleIdsLong));
            List allMenus = this.sysMenuManageService.list();
            menuList = this.sysMenuManageService.getMenus(allMenus, menuList, menuList);
            menuList = menuList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysMenu>(Comparator.comparing(SysMenu::getId))), ArrayList::new));
        }
        List resourcesList = new ArrayList();
        List<SysResourceModules> resourceModulesList = new ArrayList<SysResourceModules>();
        List functionResourcesList = new ArrayList();
        List<Object> resourcesIds = new ArrayList();
        if (Boolean.TRUE.equals(functionExportDto.getHasResources()) && ToolUtil.isNotEmpty(resourcesIds = (functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctionResources::getFunctionId, funcAndModuleIdsLong))).stream().map(SysFunctionResources::getResourceId).distinct().collect(Collectors.toList()))) {
            resourcesList = this.sysResourcesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResources::getId, resourcesIds));
            List allResourceModules = this.sysResourceMosulesService.list();
            List resourcesModuleIds = resourcesList.stream().map(SysResources::getModuleId).collect(Collectors.toList());
            resourceModulesList.addAll(this.sysResourceModulesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResourceModules::getId, resourcesModuleIds)));
            resourceModulesList = this.getResourceModules(resourceModulesList, resourceModulesList, allResourceModules);
            resourceModulesList = resourceModulesList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysResourceModules>(Comparator.comparing(SysResourceModules::getId))), ArrayList::new));
        }
        List rolesList = new ArrayList();
        List roleFunctionsList = new ArrayList();
        List roleResourceList = new ArrayList();
        List roleGroupsList = new ArrayList();
        if (Boolean.TRUE.equals(functionExportDto.getHasRole()) && ToolUtil.isNotEmpty(roleIds = (roleFunctionsList = this.sysRoleFunctionsMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getFunctionId, funcAndModuleIdsLong))).stream().map(SysRoleFunctions::getRoleId).distinct().collect(Collectors.toList()))) {
            List roleGroupIds;
            rolesList = this.sysRolesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, roleIds));
            if (Boolean.TRUE.equals(functionExportDto.getHasResources()) && ToolUtil.isNotEmpty(resourcesIds)) {
                LambdaQueryWrapper queryRoleRes = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getId, roleIds);
                LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)queryRoleRes, SysRoleResource::getResourceId, resourcesIds);
                queryRoleRes.eq(SysRoleResource::getRelationSource, (Object)"1");
                roleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)queryRoleRes);
            }
            if (ToolUtil.isNotEmpty(roleGroupIds = rolesList.stream().map(SysRoles::getGroupId).collect(Collectors.toList()))) {
                roleGroupsList = this.sysRoleGroupMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleGroup::getId, roleGroupIds));
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("functions", sysFunctions);
        data.put("functionModules", sysFunctionModules);
        data.put("menu", menuList);
        data.put("resources", resourcesList);
        data.put("resourceModules", resourceModulesList);
        data.put("functionResources", functionResourcesList);
        data.put("roles", rolesList);
        data.put("roleFunction", roleFunctionsList);
        data.put("roleResource", roleResourceList);
        data.put("roleGroups", roleGroupsList);
        data.put("export_type", "function");
        String fileName = "function_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.setContentType("application/octet-stream");
        try {
            JsonUtil.getInstance().writeValue((OutputStream)response.getOutputStream(), data);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheEvict(value={"resource_info"}, allEntries=true)
    public ImportVueFuncVo importFunction(MultipartFile hussarFile) {
        Map data;
        if (ToolUtil.isEmpty((Object)hussarFile)) {
            throw new BaseException("\u5bfc\u5165\u529f\u80fd\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ImportVueFuncVo importVueFuncVo = new ImportVueFuncVo();
        try {
            data = (Map)JsonUtil.getInstance().readValue(hussarFile.getInputStream(), Object.class);
        }
        catch (IOException e) {
            try {
                byte[] content = hussarFile.getBytes();
                data = (Map)SerializeUtils.deserialize((byte[])content);
            }
            catch (Exception ex) {
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
            }
        }
        String exportType = (String)data.get("export_type");
        if (!"function".equals(exportType)) {
            importVueFuncVo.setErrorImport(exportType);
            importVueFuncVo.setSuccess("false");
            importVueFuncVo.setImportType("function");
            return importVueFuncVo;
        }
        List sysFunctionModules = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("functionModules")), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        this.sysFunctionModulesService.insertOrUpdateFunctionModuleList(sysFunctionModules);
        List sysFunctions = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("functions")), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        this.insertOrUpdateFunctionList(sysFunctions);
        List sysMenus = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("menu")), (TypeReference)new TypeReference<List<SysMenu>>(){});
        this.sysMenuManageService.insertOrUpdateMenuList(sysMenus);
        List sysResourceModules = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("resourceModules")), (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        this.sysResourceMosulesService.insertOrUpdateResourcesModuleList(sysResourceModules);
        List sysResources = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("resources")), (TypeReference)new TypeReference<List<SysResources>>(){});
        this.sysResManageService.insertOrUpdateResourcesList(sysResources);
        List sysFunctionResources = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("functionResources")), (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        this.sysFunctionResourcesService.insertOrUpdateFunctionResource(sysFunctionResources);
        List sysRoles = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roles")), (TypeReference)new TypeReference<List<SysRoles>>(){});
        this.sysRolesService.insertOrUpdateRoleList(sysRoles);
        List sysRoleFunctions = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roleFunction")), (TypeReference)new TypeReference<List<SysRoleFunctions>>(){});
        this.sysRoleFunctionsService.insertOrUpdateRoleFunction(sysRoleFunctions);
        List sysRoleResources = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roleResource")), (TypeReference)new TypeReference<List<SysRoleResource>>(){});
        this.sysRoleResourceService.insertOrUpdateRoleResource(sysRoleResources);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctions)) {
            this.sysRoleFunctionsService.dataSyncByRoleFunc(sysRoleFunctions);
        }
        List sysRoleGroups = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString(data.get("roleGroups")), (TypeReference)new TypeReference<List<SysRoleGroup>>(){});
        this.sysRoleGroupService.insertOrUpdateRoleGroupList(sysRoleGroups);
        return importVueFuncVo;
    }

    public List<FuncDumpTreeVo> getFuncDumpGuideTree() {
        LambdaQueryWrapper functionsLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)functionsLambdaQueryWrapper.ne(SysFunctions::getIsSys, (Object)"1")).or()).isNull(SysFunctions::getIsSys);
        List allFuncions = this.list((Wrapper)functionsLambdaQueryWrapper);
        if (HussarUtils.isEmpty((Object)allFuncions)) {
            return Collections.emptyList();
        }
        List<Long> allFunctionIdList = allFuncions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        Map<String, Object> allData = this.getDirectData(allFunctionIdList);
        allData.put("function", allFuncions);
        this.buildAssociations(allData);
        List<SysFunctionModules> functionModulesList = this.getFuncHeigherLevel(allFuncions);
        allData.put("functionModule", functionModulesList);
        List<FuncDumpTreeVo> result = this.createFuncDumpTreeVo(allData);
        return HussarTreeParser.getTreeList(result);
    }

    public Map<String, Object> getFuncResMenuDumpData(List<FuncDumpDto> funcDumpDtoList) {
        HashSet<Long> funcIdList = new HashSet<Long>();
        HashSet menuIdList = new HashSet();
        HashSet resIdList = new HashSet();
        List<Object> functionResourcesList = new ArrayList<SysFunctionResources>();
        for (FuncDumpDto item : funcDumpDtoList) {
            List itemResIdList;
            if (HussarUtils.isNotEmpty((Object)item.getFuncId())) {
                funcIdList.add(item.getFuncId());
            }
            if (HussarUtils.isNotEmpty((Object)item.getMenuIdList())) {
                menuIdList.addAll(item.getMenuIdList());
            }
            if (!HussarUtils.isNotEmpty((Object)(itemResIdList = item.getResIdList()))) continue;
            for (Long resId : itemResIdList) {
                SysFunctionResources sysFunctionResources = new SysFunctionResources();
                sysFunctionResources.setFunctionId(item.getFuncId());
                sysFunctionResources.setResourceId(resId);
                functionResourcesList.add(sysFunctionResources);
            }
            resIdList.addAll(itemResIdList);
        }
        HashMap<String, Object> allData = new HashMap<String, Object>();
        if (!HussarUtils.isNotEmpty(funcIdList)) {
            return allData;
        }
        List functionsList = this.listByIds(funcIdList);
        allData.put("function", functionsList);
        if (HussarUtils.isNotEmpty(menuIdList)) {
            List menuList = this.sysMenuManageService.getMenusByMenuIds(new ArrayList(menuIdList));
            allData.put("leafMenu", menuList);
        }
        List resourcesList = new ArrayList();
        if (HussarUtils.isNotEmpty(resIdList)) {
            resourcesList = this.sysResourcesService.selectResourcesByResIds(new ArrayList(resIdList));
            allData.put("resources", resourcesList);
            functionResourcesList = this.sysFunctionResourcesService.selectListByDoubleIds(functionResourcesList);
            allData.put("functionResources", functionResourcesList);
        }
        long total = (long)functionsList.size() + (long)resourcesList.size() + (long)functionResourcesList.size();
        allData.put("total", total);
        this.buildAssociations(allData);
        this.getHeigherLevel(allData);
        return allData;
    }

    public List<FuncDumpTreeVo> getFuncResMenuDumpTree(Map<String, Object> allData) {
        return HussarTreeParser.getTreeList(this.createFuncDumpTreeVo(allData));
    }

    public List<FuncResMenuCheckTreeVo> getFuncResMenuCheckTree(Map<String, Object> importData) {
        List menuList = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)importData.get("menu")), (TypeReference)new TypeReference<List<SysMenu>>(){});
        List leafMenuList = menuList.stream().filter(menu -> "1".equals(menu.getIsLeaf())).collect(Collectors.toList());
        importData.put("leafMenu", leafMenuList);
        this.buildAssociations(importData);
        return HussarTreeParser.getTreeList(this.creatFuncResMenuCheckTree(importData));
    }

    public List<FuncResMenuCheckTreeVo> creatFuncResMenuCheckTree(Map<String, Object> importData) {
        List importFunctionModuleList = (List)IdempotentJsonUtils.convert((Object)importData.get("functionModule"), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        ArrayList<FuncResMenuCheckTreeVo> funcResMenuCheckTreeVoList = new ArrayList<FuncResMenuCheckTreeVo>(this.funcModuleToCheckTreeVo(importFunctionModuleList));
        funcResMenuCheckTreeVoList.addAll(this.funcToCheckTreeVo(importData));
        FuncResMenuCheckTreeVo root = new FuncResMenuCheckTreeVo();
        root.setId("1");
        root.setParentId("0");
        root.setLabel("\u529f\u80fd");
        root.setHasChildren(Boolean.valueOf(true));
        root.setIcon("module");
        root.setRowId("1");
        root.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
        funcResMenuCheckTreeVoList.add(root);
        return funcResMenuCheckTreeVoList;
    }

    private Map<String, Object> getDirectData(List<Long> functionIdList) {
        HashMap<String, Object> allData = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(functionIdList)) {
            List functionResourcesList = this.sysFunctionResourcesService.selectFunctionResByFuncIds(functionIdList);
            allData.put("functionResources", functionResourcesList);
            List resourceIdList = functionResourcesList.stream().map(SysFunctionResources::getResourceId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(resourceIdList)) {
                List resourcesList = this.sysResourcesService.selectResourcesByResIds(resourceIdList);
                allData.put("resources", resourcesList);
            }
            List menuList = this.sysMenuManageService.getMenusByFunctionIds(functionIdList);
            allData.put("leafMenu", menuList);
        }
        return allData;
    }

    private void buildAssociations(Map<String, Object> allData) {
        List menuList;
        List functionResourcesList = (List)IdempotentJsonUtils.convert((Object)allData.get("functionResources"), (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        List resourceModulesList = (List)IdempotentJsonUtils.convert((Object)allData.get("resourceModule"), (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        List resourcesList = (List)IdempotentJsonUtils.convert((Object)allData.get("resources"), (TypeReference)new TypeReference<List<SysResources>>(){});
        if (HussarUtils.isNotEmpty((Object)functionResourcesList) && HussarUtils.isNotEmpty((Object)resourcesList)) {
            Map<Long, List<SysResources>> funcResAssociation = this.buildFuncResAssociation(functionResourcesList, resourcesList);
            allData.put("funcResAssociation", funcResAssociation);
            if (HussarUtils.isEmpty((Object)resourceModulesList)) {
                resourceModulesList = this.sysResourceMosulesService.list();
            }
            Map<Long, List<SysResourceModules>> resAndResModuleAssociation = this.buildResAndModuleAssociation(resourcesList, resourceModulesList);
            allData.put("resModuleAssociation", resAndResModuleAssociation);
        }
        if (HussarUtils.isNotEmpty((Object)(menuList = (List)IdempotentJsonUtils.convert((Object)allData.get("leafMenu"), (TypeReference)new TypeReference<List<SysMenu>>(){})))) {
            this.buildMenuAssociation(menuList, allData);
        }
    }

    private void getHeigherLevel(Map<String, Object> allData) {
        long total;
        List sysFunctionsList = (List)IdempotentJsonUtils.convert((Object)allData.get("function"), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        List<SysFunctionModules> sysFunctionModulesList = this.getFuncHeigherLevel(sysFunctionsList);
        allData.put("functionModule", sysFunctionModulesList);
        Map resourceModuleAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("resModuleAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResourceModules>>>(){});
        Map heigherMenuAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("leafMenuAndMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        HashSet resourceModulesSet = new HashSet();
        HashSet menuSet = new HashSet();
        if (HussarUtils.isNotEmpty((Object)resourceModuleAssociation)) {
            Set resourceModuleKey = resourceModuleAssociation.keySet();
            for (Long resId : resourceModuleKey) {
                List resourceModulesList = (List)resourceModuleAssociation.get(resId);
                if (!HussarUtils.isNotEmpty((Object)resourceModulesList)) continue;
                resourceModulesSet.addAll(resourceModulesList);
            }
        }
        if (HussarUtils.isNotEmpty((Object)heigherMenuAssociation)) {
            Set menuKey = heigherMenuAssociation.keySet();
            for (Long menuId : menuKey) {
                List menuList = (List)heigherMenuAssociation.get(menuId);
                if (!HussarUtils.isNotEmpty((Object)menuList)) continue;
                menuSet.addAll(menuList);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(total = ((Long)allData.get("total")).longValue()))) {
            total = total + (long)menuSet.size() + (long)sysFunctionModulesList.size() + (long)resourceModulesSet.size();
            allData.put("total", total);
        }
        allData.put("resourceModule", new ArrayList(resourceModulesSet));
        allData.put("menu", new ArrayList(menuSet));
    }

    private List<SysFunctionModules> getFuncHeigherLevel(List<SysFunctions> functionsList) {
        List<Object> functionModulesList = new ArrayList();
        if (HussarUtils.isNotEmpty(functionsList)) {
            List lastFuncModulIdList = functionsList.stream().map(SysFunctions::getFunctionModuleId).distinct().collect(Collectors.toList());
            List allFunctionModule = this.sysFunctionModulesService.list();
            functionModulesList = new ArrayList(this.sysFunctionModulesService.recursiveGetFuncModule(lastFuncModulIdList, (Collection)allFunctionModule, new HashSet()));
        }
        functionModulesList = functionModulesList.stream().sorted(Comparator.comparing(SysFunctionModules::getSeq)).collect(Collectors.toList());
        return functionModulesList;
    }

    private List<SysResourceModules> getResourceModules(List<SysResourceModules> result, List<SysResourceModules> children, List<SysResourceModules> allModules) {
        if (ToolUtil.isEmpty(children)) {
            return result;
        }
        List parentIds = children.stream().map(SysResourceModules::getParentModuleId).collect(Collectors.toList());
        if (ToolUtil.isEmpty(parentIds)) {
            return result;
        }
        ArrayList<SysResourceModules> parentModules = new ArrayList<SysResourceModules>();
        ArrayList<SysResourceModules> tempModules = new ArrayList<SysResourceModules>();
        for (SysResourceModules resourceModule : allModules) {
            if (parentIds.contains(resourceModule.getId())) {
                parentModules.add(resourceModule);
                continue;
            }
            tempModules.add(resourceModule);
        }
        result.addAll(parentModules);
        return this.getResourceModules(result, parentModules, tempModules);
    }

    private Map<Long, List<SysResources>> buildFuncResAssociation(List<SysFunctionResources> functionResourcesList, List<SysResources> resourcesList) {
        HashMap<Long, SysResources> idResMap = new HashMap<Long, SysResources>();
        for (SysResources res : resourcesList) {
            idResMap.put(res.getId(), res);
        }
        LinkedMultiValueMap funcResAssociationMap = new LinkedMultiValueMap();
        for (SysFunctionResources funcRes : functionResourcesList) {
            funcResAssociationMap.add((Object)funcRes.getFunctionId(), idResMap.get(funcRes.getResourceId()));
        }
        return funcResAssociationMap;
    }

    private void buildMenuAssociation(List<SysMenu> menuList, Map<String, Object> allData) {
        LinkedMultiValueMap menuAssocation = new LinkedMultiValueMap();
        LinkedMultiValueMap funcMenuAssocation = new LinkedMultiValueMap();
        List allMenuList = this.sysMenuManageService.list();
        for (SysMenu item : menuList) {
            ArrayList<SysMenu> branchMenu = new ArrayList<SysMenu>();
            branchMenu.add(item);
            menuAssocation.put((Object)item.getId(), this.sysMenuManageService.getMenuBranch(allMenuList, item, branchMenu));
            funcMenuAssocation.add((Object)item.getFunctionId(), (Object)item);
        }
        allData.put("funcMenuAssociation", funcMenuAssocation);
        allData.put("leafMenuAndMenuAssociation", menuAssocation);
    }

    private Map<Long, List<SysResourceModules>> buildResAndModuleAssociation(List<SysResources> resourcesList, List<SysResourceModules> allResourceModules) {
        HashMap<Long, List<SysResourceModules>> resAndResModuleAssociation = new HashMap<Long, List<SysResourceModules>>();
        List resModuleIdList = resourcesList.stream().map(SysResources::getModuleId).distinct().collect(Collectors.toList());
        ArrayList<SysResourceModules> resourceModulesList = new ArrayList<SysResourceModules>();
        for (SysResourceModules item : allResourceModules) {
            if (!resModuleIdList.contains(item.getId())) continue;
            resourceModulesList.add(item);
        }
        HashMap<Long, SysResourceModules> resourceModulesMap = new HashMap<Long, SysResourceModules>();
        for (SysResourceModules item : resourceModulesList) {
            resourceModulesMap.put(item.getId(), item);
        }
        for (SysResources resource : resourcesList) {
            SysResourceModules resourceModule = (SysResourceModules)resourceModulesMap.get(resource.getModuleId());
            if (!HussarUtils.isNotEmpty((Object)resourceModule)) continue;
            ArrayList<SysResourceModules> modulesList = new ArrayList<SysResourceModules>();
            modulesList.add(resourceModule);
            resAndResModuleAssociation.put(resource.getId(), this.sysResourceMosulesService.getResourceModulesByOneRes(modulesList, resourceModule, allResourceModules));
        }
        return resAndResModuleAssociation;
    }

    private List<FuncDumpTreeVo> createFuncDumpTreeVo(Map<String, Object> allData) {
        List functionModulesList = (List)IdempotentJsonUtils.convert((Object)allData.get("functionModule"), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        ArrayList<FuncDumpTreeVo> funcDumpTreeVoList = new ArrayList<FuncDumpTreeVo>(this.funcModuleToDumpTreeVo(functionModulesList));
        funcDumpTreeVoList.addAll(this.functionToDumpTreeVo(allData));
        return funcDumpTreeVoList;
    }

    private List<FuncDumpTreeVo> funcModuleToDumpTreeVo(List<SysFunctionModules> functionModulesList) {
        ArrayList<FuncDumpTreeVo> funcDumpTreeVoList = new ArrayList<FuncDumpTreeVo>();
        FuncDumpTreeVo root = new FuncDumpTreeVo();
        root.setId("1");
        root.setLabel("\u529f\u80fd");
        root.setHasChildren(Boolean.valueOf(true));
        root.setIcon("module");
        root.setRowId("1");
        root.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
        funcDumpTreeVoList.add(root);
        for (SysFunctionModules item : functionModulesList) {
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId(item.getId().toString());
            funcDumpTreeVo.setLabel(item.getFunctionModuleName());
            funcDumpTreeVo.setParentId(item.getParentModuleId().toString());
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(true));
            funcDumpTreeVo.setIcon("module");
            funcDumpTreeVo.setRowId(item.getId().toString());
            funcDumpTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
            funcDumpTreeVoList.add(funcDumpTreeVo);
        }
        return funcDumpTreeVoList;
    }

    private List<FuncResMenuCheckTreeVo> funcModuleToCheckTreeVo(List<SysFunctionModules> functionModulesList) {
        ArrayList<FuncResMenuCheckTreeVo> funcResMenuCheckTreeVoList = new ArrayList<FuncResMenuCheckTreeVo>();
        for (SysFunctionModules item : functionModulesList) {
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId(item.getId().toString());
            funcResMenuCheckTreeVo.setLabel(item.getFunctionModuleName());
            funcResMenuCheckTreeVo.setParentId(item.getParentModuleId().toString());
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(true));
            funcResMenuCheckTreeVo.setIcon("module");
            funcResMenuCheckTreeVo.setRowId(item.getId().toString());
            funcResMenuCheckTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION_MODULE.getType());
            funcResMenuCheckTreeVoList.add(funcResMenuCheckTreeVo);
        }
        return funcResMenuCheckTreeVoList;
    }

    private List<FuncResMenuCheckTreeVo> funcToCheckTreeVo(Map<String, Object> importData) {
        ArrayList<FuncResMenuCheckTreeVo> result = new ArrayList<FuncResMenuCheckTreeVo>();
        List functionsList = (List)IdempotentJsonUtils.convert((Object)importData.get("function"), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        if (HussarUtils.isEmpty((Object)functionsList)) {
            return Collections.emptyList();
        }
        List importResDataList = (List)IdempotentJsonUtils.convert((Object)importData.get("resources"), (TypeReference)new TypeReference<List<SysResources>>(){});
        List importMenuDataList = (List)IdempotentJsonUtils.convert((Object)importData.get("menu"), (TypeReference)new TypeReference<List<SysMenu>>(){});
        List importFuncModuleList = (List)IdempotentJsonUtils.convert((Object)importData.get("functionModule"), (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        Map menuAssociation = (Map)IdempotentJsonUtils.convert((Object)importData.get("funcMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        Map funcResAsscationMap = (Map)IdempotentJsonUtils.convert((Object)importData.get("funcResAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResources>>>(){});
        Map resAndResModuleMap = (Map)IdempotentJsonUtils.convert((Object)importData.get("resModuleAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResourceModules>>>(){});
        Map leafMenuAndMenuAssociation = (Map)IdempotentJsonUtils.convert((Object)importData.get("leafMenuAndMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        HashMap<Long, SysFunctions> localFuncMap = new HashMap<Long, SysFunctions>();
        HashMap<Long, SysResources> localResMap = new HashMap<Long, SysResources>();
        HashMap<Long, SysResources> importResMap = new HashMap<Long, SysResources>();
        HashMap<Long, SysFunctionModules> importFuncModuleMap = new HashMap<Long, SysFunctionModules>();
        HashMap<Long, SysMenu> localMenuMap = new HashMap<Long, SysMenu>();
        List functionidList = functionsList.stream().map(SysFunctions::getId).collect(Collectors.toList());
        List localFuncList = this.listByIds(functionidList);
        for (SysFunctions localFunc : localFuncList) {
            localFuncMap.put(localFunc.getId(), localFunc);
        }
        for (SysFunctionModules importFuncModule : importFuncModuleList) {
            importFuncModuleMap.put(importFuncModule.getId(), importFuncModule);
        }
        if (HussarUtils.isNotEmpty((Object)importMenuDataList)) {
            List menuIdList = importMenuDataList.stream().map(SysMenu::getId).collect(Collectors.toList());
            List localMenuList = this.sysMenuManageService.getMenusByMenuIds(menuIdList);
            for (SysMenu localMenu : localMenuList) {
                localMenuMap.put(localMenu.getId(), localMenu);
            }
        }
        if (HussarUtils.isNotEmpty((Object)importResDataList)) {
            List resIdList = importResDataList.stream().map(SysResources::getId).collect(Collectors.toList());
            List localResList = this.sysResourcesService.selectResourcesByResIds(resIdList);
            for (SysResources localRes : localResList) {
                localResMap.put(localRes.getId(), localRes);
            }
            for (SysResources importRes : importResDataList) {
                importResMap.put(importRes.getId(), importRes);
            }
        }
        for (SysFunctions function : functionsList) {
            List resourcesList;
            List menuList;
            ArrayList<FuncResMenuCheckTreeVo> funcResMenuCheckTreeVoList = new ArrayList<FuncResMenuCheckTreeVo>();
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId(function.getId().toString());
            funcResMenuCheckTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION.getType());
            funcResMenuCheckTreeVo.setLabel(function.getFunctionName());
            funcResMenuCheckTreeVo.setParentId(function.getFunctionModuleId().toString());
            funcResMenuCheckTreeVo.setIcon("function");
            funcResMenuCheckTreeVo.setRowId(function.getId().toString());
            funcResMenuCheckTreeVo.setImportData((Object)this.migrationGetFunctionDetail(function, importFuncModuleMap, importResMap));
            SysFunctions localFunc = (SysFunctions)localFuncMap.get(function.getId());
            if (HussarUtils.isNotEmpty((Object)localFunc)) {
                if (localFunc.equals((Object)function)) {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.NO_CHANGE);
                } else {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.MODIFY);
                }
            } else {
                funcResMenuCheckTreeVo.setSelfChange(PermitConstants.ADD);
            }
            int menuChagneType = 0;
            if (HussarUtils.isNotEmpty((Object)menuAssociation) && HussarUtils.isNotEmpty((Object)(menuList = (List)menuAssociation.get(function.getId())))) {
                Map<String, Object> menuCheckTreeMap = this.menuToCheckTreeVo(menuList, function, leafMenuAndMenuAssociation, localMenuMap);
                List menuCheckTreeVoList = (List)IdempotentJsonUtils.convert((Object)menuCheckTreeMap.get("menuCheckTree"), (TypeReference)new TypeReference<List<FuncResMenuCheckTreeVo>>(){});
                funcResMenuCheckTreeVoList.addAll(menuCheckTreeVoList);
                menuChagneType = (Integer)menuCheckTreeMap.get("changType");
            }
            int resChangeType = 0;
            if (HussarUtils.isNotEmpty((Object)funcResAsscationMap) && HussarUtils.isNotEmpty((Object)(resourcesList = (List)funcResAsscationMap.get(function.getId())))) {
                Map<String, Object> resCheckTreeMap = this.resToCheckTreeVo(resourcesList, function.getId(), function.getDefaultResourceId(), resAndResModuleMap, localResMap);
                List checkTreeVoList = (List)IdempotentJsonUtils.convert((Object)resCheckTreeMap.get("funcCheckTree"), (TypeReference)new TypeReference<List<FuncResMenuCheckTreeVo>>(){});
                funcResMenuCheckTreeVoList.addAll(checkTreeVoList);
                resChangeType = (Integer)resCheckTreeMap.get("changType");
            }
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(funcResMenuCheckTreeVoList)));
            int childrenChangeType = Math.max(menuChagneType, resChangeType);
            funcResMenuCheckTreeVo.setChildrenChange(Integer.valueOf(childrenChangeType));
            funcResMenuCheckTreeVoList.add(funcResMenuCheckTreeVo);
            result.addAll(funcResMenuCheckTreeVoList);
        }
        return result;
    }

    private List<FuncDumpTreeVo> functionToDumpTreeVo(Map<String, Object> allData) {
        List functionsList = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)allData.get("function")), (TypeReference)new TypeReference<List<SysFunctions>>(){});
        if (HussarUtils.isEmpty((Object)functionsList)) {
            return Collections.emptyList();
        }
        ArrayList<FuncDumpTreeVo> result = new ArrayList<FuncDumpTreeVo>();
        Map menuAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("funcMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        menuAssociation = menuAssociation == null ? new HashMap() : menuAssociation;
        Map funcResAsscationMap = (Map)IdempotentJsonUtils.convert((Object)allData.get("funcResAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResources>>>(){});
        funcResAsscationMap = funcResAsscationMap == null ? new HashMap() : funcResAsscationMap;
        Map resAndResModuleMap = (Map)IdempotentJsonUtils.convert((Object)allData.get("resModuleAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysResourceModules>>>(){});
        resAndResModuleMap = resAndResModuleMap == null ? new HashMap() : resAndResModuleMap;
        Map leafMenuAndMenuAssociation = (Map)IdempotentJsonUtils.convert((Object)allData.get("leafMenuAndMenuAssociation"), (TypeReference)new TypeReference<Map<Long, List<SysMenu>>>(){});
        leafMenuAndMenuAssociation = leafMenuAndMenuAssociation == null ? new HashMap() : leafMenuAndMenuAssociation;
        for (SysFunctions function : functionsList) {
            List resourcesList;
            ArrayList<FuncDumpTreeVo> funcDumpTreeVoList = new ArrayList<FuncDumpTreeVo>();
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId(function.getId().toString());
            funcDumpTreeVo.setTypeName(MigrateFuncResMenuEnum.FUNCTION.getType());
            funcDumpTreeVo.setLabel(function.getFunctionName());
            funcDumpTreeVo.setParentId(function.getFunctionModuleId().toString());
            funcDumpTreeVo.setIcon("function");
            funcDumpTreeVo.setRowId(function.getId().toString());
            List menuList = (List)menuAssociation.get(function.getId());
            if (HussarUtils.isNotEmpty((Object)menuList)) {
                funcDumpTreeVoList.addAll(this.menuToDumpTreeVo(menuList, function.getId(), leafMenuAndMenuAssociation));
            }
            if (HussarUtils.isNotEmpty((Object)(resourcesList = (List)funcResAsscationMap.get(function.getId())))) {
                funcDumpTreeVoList.addAll(this.resToDumpTreeVo(resourcesList, function.getId(), function.getDefaultResourceId(), resAndResModuleMap));
            }
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(funcDumpTreeVoList)));
            funcDumpTreeVoList.add(funcDumpTreeVo);
            result.addAll(funcDumpTreeVoList);
        }
        return result;
    }

    private Map<String, Object> menuToCheckTreeVo(List<SysMenu> menuList, SysFunctions function, Map<Long, List<SysMenu>> leafMenuAndMenu, Map<Long, SysMenu> menuMap) {
        ArrayList<FuncResMenuCheckTreeVo> result = new ArrayList<FuncResMenuCheckTreeVo>();
        boolean modifyFlag = false;
        boolean addFlag = false;
        Long functionId = function.getId();
        FuncResMenuCheckTreeVo menuRoot = new FuncResMenuCheckTreeVo();
        String rootId = functionId + "-menu";
        menuRoot.setId(rootId);
        menuRoot.setHasChildren(Boolean.valueOf(true));
        menuRoot.setParentId(functionId.toString());
        menuRoot.setLabel("\u83dc\u5355");
        menuRoot.setIcon("tree-folder");
        menuRoot.setRowId(rootId);
        menuRoot.setTypeName(MigrateFuncResMenuEnum.MENU_FILE.getType());
        result.add(menuRoot);
        for (SysMenu menu : menuList) {
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId(menu.getId().toString());
            funcResMenuCheckTreeVo.setParentId(rootId);
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(false));
            funcResMenuCheckTreeVo.setIcon("tree-menu");
            funcResMenuCheckTreeVo.setRowId(menu.getId().toString() + functionId);
            funcResMenuCheckTreeVo.setTypeName(MigrateFuncResMenuEnum.MENU.getType());
            String label = this.migrateMenuLabel(leafMenuAndMenu.get(menu.getId()));
            funcResMenuCheckTreeVo.setLabel(label);
            funcResMenuCheckTreeVo.setImportData((Object)this.migrationGetMenuDetail(menu, leafMenuAndMenu.get(menu.getId()), function.getFunctionName()));
            SysMenu localMenu = menuMap.get(menu.getId());
            if (HussarUtils.isNotEmpty((Object)localMenu)) {
                if (localMenu.equals((Object)menu)) {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.NO_CHANGE);
                } else {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.MODIFY);
                    modifyFlag = true;
                }
            } else {
                funcResMenuCheckTreeVo.setSelfChange(PermitConstants.ADD);
                addFlag = true;
            }
            result.add(funcResMenuCheckTreeVo);
        }
        int changeType = modifyFlag ? PermitConstants.MODIFY : (addFlag ? PermitConstants.ADD.intValue() : PermitConstants.NO_CHANGE.intValue());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("menuCheckTree", result);
        resultMap.put("changType", changeType);
        return resultMap;
    }

    private List<FuncDumpTreeVo> menuToDumpTreeVo(List<SysMenu> menuList, Long functionId, Map<Long, List<SysMenu>> leafMenuAndMenu) {
        ArrayList<FuncDumpTreeVo> result = new ArrayList<FuncDumpTreeVo>();
        FuncDumpTreeVo root = new FuncDumpTreeVo();
        String rootId = functionId + "-menu";
        root.setId(rootId);
        root.setHasChildren(Boolean.valueOf(true));
        root.setParentId(functionId.toString());
        root.setLabel("\u83dc\u5355");
        root.setIcon("tree-folder");
        root.setRowId(rootId);
        root.setTypeName(MigrateFuncResMenuEnum.MENU_FILE.getType());
        result.add(root);
        for (SysMenu menu : menuList) {
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId(menu.getId().toString());
            funcDumpTreeVo.setParentId(rootId);
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(false));
            funcDumpTreeVo.setIcon("tree-menu");
            funcDumpTreeVo.setTypeName(MigrateFuncResMenuEnum.MENU.getType());
            String label = this.migrateMenuLabel(leafMenuAndMenu.get(menu.getId()));
            funcDumpTreeVo.setLabel(label);
            funcDumpTreeVo.setRowId(menu.getId().toString() + functionId);
            result.add(funcDumpTreeVo);
        }
        return result;
    }

    private String migrateMenuLabel(List<SysMenu> menuList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = menuList.size() - 1; i >= 0; --i) {
            stringBuilder.append(menuList.get(i).getText()).append('/');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private List<FuncDumpTreeVo> resToDumpTreeVo(List<SysResources> resourcesList, Long functionId, Long resId, Map<Long, List<SysResourceModules>> resModuleAssociation) {
        ArrayList<FuncDumpTreeVo> result = new ArrayList<FuncDumpTreeVo>();
        FuncDumpTreeVo root = new FuncDumpTreeVo();
        String rootId = functionId + "-res";
        root.setId(rootId);
        root.setHasChildren(Boolean.valueOf(true));
        root.setParentId(functionId.toString());
        root.setLabel("\u8d44\u6e90");
        root.setIcon("tree-folder");
        root.setRowId(rootId);
        root.setTypeName(MigrateFuncResMenuEnum.RES_FILE.getType());
        result.add(root);
        for (SysResources item : resourcesList) {
            FuncDumpTreeVo funcDumpTreeVo = new FuncDumpTreeVo();
            funcDumpTreeVo.setId(item.getId().toString());
            funcDumpTreeVo.setHasChildren(Boolean.valueOf(false));
            funcDumpTreeVo.setParentId(rootId);
            funcDumpTreeVo.setIcon(item.getResTypeId());
            funcDumpTreeVo.setRowId(item.getId().toString() + functionId);
            MigrateFuncResMenuEnum type = MigrateFuncResMenuEnum.of((String)item.getResTypeId());
            if (HussarUtils.isNotEmpty((Object)type)) {
                funcDumpTreeVo.setTypeName(type.getType());
            }
            if (item.getId().equals(resId)) {
                funcDumpTreeVo.setRemark("\u529f\u80fd\u7684\u4e3b\u8d44\u6e90");
            }
            List<SysResourceModules> resourceModulesList = resModuleAssociation.get(item.getId());
            String label = this.migrateResModuleLabel(resourceModulesList) + item.getResourceName();
            funcDumpTreeVo.setLabel(label);
            result.add(funcDumpTreeVo);
        }
        return result;
    }

    private Map<String, Object> resToCheckTreeVo(List<SysResources> resourcesList, Long functionId, Long resId, Map<Long, List<SysResourceModules>> resModuleAssociation, Map<Long, SysResources> resourcesMap) {
        ArrayList<FuncResMenuCheckTreeVo> result = new ArrayList<FuncResMenuCheckTreeVo>();
        boolean modifyFlag = false;
        boolean addFlag = false;
        FuncResMenuCheckTreeVo root = new FuncResMenuCheckTreeVo();
        String rootId = functionId + "-res";
        root.setId(rootId);
        root.setHasChildren(Boolean.valueOf(true));
        root.setParentId(functionId.toString());
        root.setLabel("\u8d44\u6e90");
        root.setIcon("tree-folder");
        root.setRowId(rootId);
        root.setTypeName(MigrateFuncResMenuEnum.RES_FILE.getType());
        result.add(root);
        for (SysResources item : resourcesList) {
            SysResources localRes;
            FuncResMenuCheckTreeVo funcResMenuCheckTreeVo = new FuncResMenuCheckTreeVo();
            funcResMenuCheckTreeVo.setId(item.getId().toString());
            funcResMenuCheckTreeVo.setHasChildren(Boolean.valueOf(false));
            funcResMenuCheckTreeVo.setParentId(rootId);
            funcResMenuCheckTreeVo.setIcon(item.getResTypeId());
            funcResMenuCheckTreeVo.setRowId(item.getId().toString() + functionId);
            funcResMenuCheckTreeVo.setImportData((Object)item);
            MigrateFuncResMenuEnum type = MigrateFuncResMenuEnum.of((String)item.getResTypeId());
            if (HussarUtils.isNotEmpty((Object)type)) {
                funcResMenuCheckTreeVo.setTypeName(type.getType());
            }
            if (item.getId().equals(resId)) {
                funcResMenuCheckTreeVo.setRemark("\u529f\u80fd\u7684\u4e3b\u8d44\u6e90");
            }
            if (HussarUtils.isNotEmpty((Object)(localRes = resourcesMap.get(item.getId())))) {
                if (localRes.equals((Object)item)) {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.NO_CHANGE);
                } else {
                    funcResMenuCheckTreeVo.setSelfChange(PermitConstants.MODIFY);
                    modifyFlag = true;
                }
            } else {
                funcResMenuCheckTreeVo.setSelfChange(PermitConstants.ADD);
                addFlag = true;
            }
            List<SysResourceModules> resourceModulesList = resModuleAssociation.get(item.getId());
            String label = this.migrateResModuleLabel(resourceModulesList) + item.getResourceName();
            funcResMenuCheckTreeVo.setLabel(label);
            SysResourceModules module = this.migrationGetResModuleName(item.getModuleId(), resourceModulesList);
            item.setResourceModules(module);
            result.add(funcResMenuCheckTreeVo);
        }
        int changeType = modifyFlag ? PermitConstants.MODIFY : (addFlag ? PermitConstants.ADD.intValue() : PermitConstants.NO_CHANGE.intValue());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("funcCheckTree", result);
        resultMap.put("changType", changeType);
        return resultMap;
    }

    private String migrateResModuleLabel(List<SysResourceModules> resourceModulesList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = resourceModulesList.size() - 1; i >= 0; --i) {
            stringBuilder.append(resourceModulesList.get(i).getModuleName()).append('/');
        }
        return stringBuilder.toString();
    }

    private SysModuleFunctionsVo migrationGetFunctionDetail(SysFunctions sysFunctions, Map<Long, SysFunctionModules> importFuncModuleMap, Map<Long, SysResources> importResMap) {
        SysModuleFunctionsVo sysModuleFunctionsVo = new SysModuleFunctionsVo();
        sysModuleFunctionsVo.setId(sysFunctions.getId().toString());
        sysModuleFunctionsVo.setName(sysFunctions.getFunctionName());
        sysModuleFunctionsVo.setParentModuleId(sysFunctions.getFunctionModuleId().toString());
        SysFunctionModules parent = importFuncModuleMap.get(sysFunctions.getFunctionModuleId());
        if (HussarUtils.isNotEmpty((Object)parent)) {
            sysModuleFunctionsVo.setParentModuleName(parent.getFunctionModuleName());
        }
        if (HussarUtils.isNotEmpty((Object)sysFunctions.getDefaultResourceId())) {
            sysModuleFunctionsVo.setDefaultResourceId(sysFunctions.getDefaultResourceId().toString());
            SysResources defaultRes = importResMap.get(sysFunctions.getDefaultResourceId());
            if (HussarUtils.isNotEmpty((Object)defaultRes)) {
                sysModuleFunctionsVo.setDefaultResourceName(defaultRes.getResourceName());
            }
        }
        sysModuleFunctionsVo.setType(0);
        return sysModuleFunctionsVo;
    }

    private SysMenuVo migrationGetMenuDetail(SysMenu menu, List<SysMenu> parents, String functionName) {
        SysMenuVo sysMenuVo = new SysMenuVo();
        CopyPropertieUtils.copyProperties((Object)sysMenuVo, (Object)menu);
        String parentName = null;
        for (SysMenu parent : parents) {
            if (!parent.getId().equals(menu.getParentId())) continue;
            parentName = parent.getText();
        }
        sysMenuVo.setParentName(parentName);
        sysMenuVo.setFunctionName(functionName);
        return sysMenuVo;
    }

    private SysResourceModules migrationGetResModuleName(Long id, List<SysResourceModules> modulesList) {
        SysResourceModules resourceModule = new SysResourceModules();
        for (SysResourceModules module : modulesList) {
            if (!module.getId().equals(id)) continue;
            resourceModule.setModuleName(module.getModuleName());
            break;
        }
        return resourceModule;
    }
}

