/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.manager.ApprovedAuditUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonUserAuditManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.approvedAuditUserManagerImpl")
public class ApprovedAuditUserManagerImpl
extends CommonUserAuditManager
implements ApprovedAuditUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovedAuditUserManagerImpl.class);
    @Autowired
    private ISysUsersService sysUsersService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private SysLoginUserService sysLoginUserService;
    @Autowired
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private SysStruMapper sysStruMapper;

    @Override
    @HussarTransactional
    public String approved(Long id) {
        LOGGER.info("\u7528\u6237\u5ba1\u6838\u901a\u8fc7\uff1a{}", (Object)id);
        SysUsersAudit usersAudit = this.getSysUsersAudit(id);
        String currentStatus = usersAudit.getCurrentStatus();
        String result = null;
        if (currentStatus.equals("0")) {
            result = this.doAuditAdd(usersAudit);
        } else if (currentStatus.equals("1")) {
            result = this.doAuditEdit(usersAudit);
        } else if (currentStatus.equals("2")) {
            result = this.doAuditDelete(usersAudit);
        } else if (currentStatus.equals("4")) {
            result = this.doAuditCancel(usersAudit);
        } else {
            throw new BaseException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        return result;
    }

    private String doAuditAdd(SysUsersAudit sysUsersAudit) {
        String secure = sysUsersAudit.getPassword();
        boolean existAccount = this.sysUsersService.isExistAccount(sysUsersAudit.getUserAccount());
        AssertUtil.isFalse((boolean)existAccount, (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsers.setId(sysUsersAudit.getUserId());
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
        sysUsers.setPassword(pwd);
        boolean tenantFlag = this.sysUsersService.isCanAdd(sysUsers);
        this.sysUsersService.save((Object)sysUsers);
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        if (tenantFlag) {
            SysUsers users = (SysUsers)this.sysUsersService.getById((Serializable)sysUsers.getId());
            this.sysLoginUserService.syncAddUser(users);
        }
        String ips = this.queryAuditIp(sysUsersAudit.getUserId(), "0");
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
        this.saveUserIP(sysUsersAudit.getUserId(), ips);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserIpAudit::getUserId, (Object)sysUsersAudit.getUserId());
        this.sysUserIpAuditService.remove((Wrapper)wrapper);
        LambdaQueryWrapper userroleAuditLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userroleAuditLambdaQueryWrapper.eq(SysUserroleAudit::getUserId, (Object)sysUsersAudit.getUserId())).eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.UserAuditButRoleNotAudit.getCode());
        List sysUserroleAudits = this.sysUserroleAuditMapper.selectList((Wrapper)userroleAuditLambdaQueryWrapper);
        ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
        for (SysUserroleAudit sysUserroleAudit : sysUserroleAudits) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(sysUserroleAudit.getUserId());
            sysUserRole.setGrantedRole(sysUserroleAudit.getRoleId());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            userRoleList.add(sysUserRole);
        }
        this.userRoleService.saveBatch(userRoleList);
        this.sysUserroleAuditMapper.delete((Wrapper)userroleAuditLambdaQueryWrapper);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)secure);
        }
        return "\u901a\u8fc7\u6210\u529f\uff01";
    }

    private String doAuditEdit(SysUsersAudit sysUsersAudit) {
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsers.setId(sysUsersAudit.getUserId());
        sysUsersAudit.setIsAudit("1");
        String ips = this.queryAuditIp(sysUsersAudit.getUserId(), "1");
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
        this.saveUserIP(sysUsersAudit.getUserId(), ips);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserIpAudit::getUserId, (Object)sysUsersAudit.getUserId());
        this.sysUserIpAuditService.remove((Wrapper)wrapper);
        SysUsers old = (SysUsers)this.sysUsersService.getById((Serializable)sysUsers.getId());
        sysUsers.setUserOrder(old.getUserOrder());
        if (!"1".equals(old.getAccountStatus()) && "1".equals(sysUsers.getAccountStatus())) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
        }
        this.sysUsersService.updateById((Object)sysUsers);
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        return "\u901a\u8fc7\u6210\u529f\uff01";
    }

    private String doAuditDelete(SysUsersAudit sysUsersAudit) {
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(Long.valueOf(sysUsersAudit.getUserId()));
        sysUsers.setAccountStatus(UserStatus.DELETE.getCode());
        Long employeeId = sysUsers.getEmployeeId();
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsersAudit.getUserId()));
        this.sysStruMapper.updatePrincipal(sysUsers.getId());
        this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUsers.getId()));
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
        this.sysUsersService.updateById((Object)sysUsers);
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        return "\u901a\u8fc7\u6210\u529f\uff01";
    }

    private String doAuditCancel(SysUsersAudit sysUsersAudit) {
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(Long.valueOf(sysUsersAudit.getUserId()));
        sysUsers.setAccountStatus(UserStatus.CANCEL.getCode());
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsersAudit.getUserId()));
        this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUsers.getId()));
        this.sysUsersService.updateById((Object)sysUsers);
        this.sysUsersAuditMapper.updateById(sysUsersAudit);
        return "\u901a\u8fc7\u6210\u529f\uff01";
    }
}

