/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.DataRightsDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.addDataRightManagerImpl")
public class AddDataRightManagerImpl
implements AddDataRightManager {
    @Autowired
    private ISysRoleDataRightService roleDataRightService;
    @Autowired
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;
    @Autowired
    private ISysRoleStruRightService sysRoleStruRightService;

    @Override
    public boolean saveOrUpdateDataRight(List<DataRightsDto> dataRightsDtoList) {
        ArrayList<SysRoleDataRight> roleDataRightSaveList = new ArrayList<SysRoleDataRight>();
        ArrayList<SysRoleStruRights> roleStruRightsList = new ArrayList<SysRoleStruRights>();
        ArrayList<DataRightsDto> customDataRightsList = new ArrayList<DataRightsDto>();
        for (DataRightsDto item2 : dataRightsDtoList) {
            roleDataRightSaveList.add(item2.getDataRightInfo());
            if (Integer.parseInt("7") == item2.getDataRightInfo().getDataScope()) {
                AssertUtil.isNotEmpty((String)item2.getDepartmentId(), (String)"\u81ea\u5b9a\u4e49\u90e8\u95e8\u53ef\u89c1\u65f6\uff0c\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
                customDataRightsList.add(item2);
                continue;
            }
            if (Integer.parseInt("6") != item2.getDataRightInfo().getDataScope()) continue;
            AssertUtil.isNotEmpty((String)item2.getDepartmentId(), (String)"\u81ea\u5b9a\u4e49\u516c\u53f8\u53ef\u89c1\u65f6\uff0c\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
            customDataRightsList.add(item2);
        }
        List dataRightIdList = dataRightsDtoList.stream().map(item -> item.getDataRightInfo().getDataRightsId()).collect(Collectors.toList());
        boolean addDataRightFlag = this.roleDataRightService.saveOrUpdateBatch(roleDataRightSaveList);
        AssertUtil.isTrue((boolean)addDataRightFlag, (String)"\u65b0\u589e\u6570\u636e\u4fe1\u606f\u5931\u8d25");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleStruRights::getRoleDataRightsId, dataRightIdList);
        this.sysRoleStruRightsMapper.delete((Wrapper)queryWrapper);
        for (DataRightsDto item3 : customDataRightsList) {
            String[] deptids = item3.getDepartmentId().split(",");
            List deptIdList = Arrays.stream(deptids).map(Long::parseLong).collect(Collectors.toList());
            for (Long id : deptIdList) {
                SysRoleStruRights sysRoleStruRights = new SysRoleStruRights();
                sysRoleStruRights.setRoleDataRightsId(item3.getDataRightInfo().getDataRightsId());
                sysRoleStruRights.setRoleId(item3.getDataRightInfo().getRoleId());
                sysRoleStruRights.setStruid(id);
                roleStruRightsList.add(sysRoleStruRights);
            }
        }
        return this.sysRoleStruRightService.saveBatch(roleStruRightsList);
    }
}

