/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dto.QueryAssistPostDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.AssistPost;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffListVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffTreeVo;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.queryStaffManagerImpl")
public class QueryStaffManagerImpl
extends CommonQueryOrganizationManager
implements QueryStaffManager {
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Autowired
    private ISysDicRefService dicRefService;
    @Autowired
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private SysStaffMapper sysStaffMapper;

    @Override
    public List<StaffTreeVo> lazyLoadingStaffTree(Long parentId) {
        ArrayList<StaffTreeVo> result = new ArrayList<StaffTreeVo>();
        List<StaffTreeVo> data = this.getStaffTree(parentId);
        this.fillStaffPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public Page<StaffListVo> queryStaff(PageInfo pageInfo, QueryStaffDto queryStaffDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        Long parentStruId = queryStaffDto.getParentId();
        AssertUtil.isNotNull((Object)parentStruId, (String)"\u4e0a\u7ea7\u53c2\u6570\u672a\u4f20\u9012");
        boolean isRoot = Objects.equals(Constants.ROOT_NODE_ID, parentStruId);
        if (!isRoot) {
            SysStru pSysStru = (SysStru)Optional.ofNullable(this.sysStruMapper.selectById(parentStruId)).orElse(new SysStru());
            struFid = pSysStru.getStruFid();
        }
        queryOrgParams.put("struLevel", OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid)));
        queryOrgParams.put("staffName", SqlQueryUtil.transferSpecialChar((String)queryStaffDto.getStaffName()));
        queryOrgParams.put("staffCode", SqlQueryUtil.transferSpecialChar((String)queryStaffDto.getStaffCode()));
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        int gradePLevel = 0;
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            SysStru gradePSysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            gradePLevel = gradePSysStru.getStruLevel();
            int gradeDepStruLevel = gradePLevel + 1;
            int searchStruLevel = 0;
            if (!isRoot) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
                queryOrgParams.put("struLevel", OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid)));
            }
        }
        queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        List<StaffListVo> data = this.sysStruMapper.queryStaff((Page<StaffListVo>)page, queryOrgParams);
        page.setRecords(data);
        return page;
    }

    @Override
    public List<StaffTreeVo> getOrderStaffTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        ArrayList<StaffTreeVo> result = new ArrayList<StaffTreeVo>();
        List<StaffTreeVo> data = this.sysStruMapper.getStaffByParentId(queryParams);
        StaffTreeVo root = new StaffTreeVo();
        OrganizationTreeVo organizationTreeVo = this.queryOrganizationManager.lazyOrganizationById(parentId);
        root.setStruType(organizationTreeVo.getStruType());
        root.setId(organizationTreeVo.getId());
        root.setHasChildren(organizationTreeVo.getHasChildren());
        root.setLabel(organizationTreeVo.getLabel());
        root.setDisabled(Boolean.valueOf(true));
        root.setIcon(organizationTreeVo.getIcon());
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public List<StaffTreeVo> backStaffTree(Long id) {
        List<OrganizationTreeVo> organizations = this.queryOrganizationManager.backOrganizationTree(id);
        return this.convert(organizations);
    }

    private List<StaffTreeVo> convert(List<OrganizationTreeVo> children) {
        ArrayList<StaffTreeVo> list = new ArrayList<StaffTreeVo>();
        if (HussarUtils.isNotEmpty(children)) {
            List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
            for (OrganizationTreeVo vo : children) {
                StaffTreeVo temp = new StaffTreeVo();
                temp.setDisabled(vo.getDisabled());
                temp.setStruType(vo.getStruType());
                if (HussarUtils.isNotEmpty((Object)vo.getChildren())) {
                    temp.setChildren(this.convert(vo.getChildren()));
                }
                temp.setId(vo.getId());
                temp.setHasChildren(vo.getHasChildren());
                temp.setIcon(vo.getIcon());
                temp.setLabel(vo.getLabel());
                temp.setParentId(vo.getParentId());
                this.fillSingleStaffPermissions(temp, staffRuleList);
                list.add(temp);
            }
        }
        return list;
    }

    @Override
    public StaffPartialVo viewStaff(Long id) {
        StaffPartialVo partialVo = new StaffPartialVo();
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrgan, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784");
        partialVo.setId(sysStru.getId());
        partialVo.setStaffCode(sysOrgan.getOrganCode());
        partialVo.setStaffName(sysOrgan.getOrganName());
        String organFname = sysOrgan.getOrganFname();
        partialVo.setParentName(OrganUtil.getShortParentName((String)organFname));
        String staffPosition = sysStru.getStaffPosition();
        String staffPositionName = this.dicRefService.getDictLabel("staff_position", staffPosition);
        partialVo.setStaffPositionName(staffPositionName);
        SysStaff sysStaff = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)partialVo.getId()));
        AssertUtil.isNotNull((Object)sysStaff, (String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f");
        partialVo.setAddress(sysStaff.getAddress());
        String sex = sysStaff.getSex();
        String sexName = this.dicRefService.getDictLabel("sex", sex);
        partialVo.setSexName(sexName);
        partialVo.setBirthday(sysStaff.getBirthday());
        partialVo.setIdcard(sysStaff.getIdcard());
        partialVo.setWorkId(sysStaff.getWorkId());
        partialVo.setWorkDate(sysStaff.getWorkDate());
        partialVo.setGraduateDate(sysStaff.getGraduateDate());
        partialVo.setGraduateSchool(sysStaff.getGraduateSchool());
        partialVo.setAssistPosts(this.getAssistPosts(partialVo.getId()));
        return partialVo;
    }

    private List<AssistPost> getAssistPosts(Long id) {
        List<AssistPost> collect = this.sysStruAssistOrganMapper.getAssistPosts(id);
        ArrayList<AssistPost> posts = new ArrayList<AssistPost>();
        if (HussarUtils.isNotEmpty(collect)) {
            for (AssistPost ap : collect) {
                AssistPost temp = new AssistPost();
                temp.setAssistPostId(ap.getAssistPostId());
                temp.setAssistPostName(OrganUtil.getPostName((String)ap.getAssistPostName()));
                posts.add(temp);
            }
        }
        return posts;
    }

    @Override
    public StaffInfoVo loadStaff(Long id) {
        StaffInfoVo infoVo = new StaffInfoVo();
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrgan, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784");
        infoVo.setId(sysStru.getId());
        infoVo.setStaffCode(sysOrgan.getOrganCode());
        infoVo.setStaffName(sysOrgan.getOrganName());
        String organFname = sysOrgan.getOrganFname();
        infoVo.setParentId(sysStru.getParentId());
        SysStru pSysStru = null;
        String staffPosition = sysStru.getStaffPosition();
        String staffPositionName = this.dicRefService.getDictLabel("staff_position", staffPosition);
        infoVo.setStaffPositionName(staffPositionName);
        SysStaff sysStaff = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)infoVo.getId()));
        AssertUtil.isNotNull((Object)sysStaff, (String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f");
        infoVo.setAddress(sysStaff.getAddress());
        String sex = sysStaff.getSex();
        String sexName = this.dicRefService.getDictLabel("sex", sex);
        infoVo.setSexName(sexName);
        infoVo.setBirthday(sysStaff.getBirthday());
        infoVo.setIdcard(sysStaff.getIdcard());
        infoVo.setWorkId(sysStaff.getWorkId());
        infoVo.setWorkDate(sysStaff.getWorkDate());
        infoVo.setGraduateDate(sysStaff.getGraduateDate());
        infoVo.setGraduateSchool(sysStaff.getGraduateSchool());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruAssistOrgan::getStruId, (Object)infoVo.getId());
        wrapper.select(new SFunction[]{SysStruAssistOrgan::getAssistParentId});
        infoVo.setAssistPosts(this.getAssistPosts(infoVo.getId()));
        infoVo.setStaffPosition(sysStru.getStaffPosition());
        infoVo.setSex(sysStaff.getSex());
        if (HussarUtils.isNotEmpty((Object)infoVo.getParentId()) && HussarUtils.isNotEmpty((Object)(pSysStru = (SysStru)this.sysStruMapper.selectById(infoVo.getParentId())))) {
            infoVo.setParentName(OrganUtil.getShortParentName((String)organFname));
            infoVo.setParentStruType(pSysStru.getStruType());
            infoVo.setParentStruTypeName(this.organTypeService.getSysOrganTypeByTypeCode(pSysStru.getStruType()).getTypeName());
        }
        return infoVo;
    }

    public List<StaffTreeVo> convertStaff(List<OrganizationTreeVo> organizations) {
        ArrayList<StaffTreeVo> list = new ArrayList<StaffTreeVo>();
        StaffTreeVo temp = null;
        List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
        for (OrganizationTreeVo vo : organizations) {
            temp = new StaffTreeVo();
            temp.setDisabled(vo.getDisabled());
            temp.setStruType(vo.getStruType());
            List children = vo.getChildren();
            temp.setChildren(this.convertStaff(children));
            temp.setId(vo.getId());
            temp.setHasChildren(vo.getHasChildren());
            temp.setIcon(vo.getIcon());
            temp.setLabel(vo.getLabel());
            temp.setParentId(vo.getParentId());
            this.fillSingleStaffPermissions(temp, staffRuleList);
            list.add(temp);
        }
        return list;
    }

    private List<StaffTreeVo> searchStaffTree(Map<String, Object> queryParams) {
        return this.sysStruMapper.searchStaffTree(queryParams);
    }

    @Override
    public Page<OrganizationVo> loadAssistPostByStaffId(PageInfo pageInfo, QueryAssistPostDto queryAssistPostDto) {
        Long postId;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        Long parentStruId = queryAssistPostDto.getParentId();
        AssertUtil.isNotNull((Object)parentStruId, (String)"\u4e0a\u7ea7\u53c2\u6570\u672a\u4f20\u9012");
        boolean isRoot = Objects.equals(Constants.ROOT_NODE_ID, parentStruId);
        if (!isRoot) {
            SysStru pSysStru = (SysStru)Optional.ofNullable(this.sysStruMapper.selectById(parentStruId)).orElse(new SysStru());
            struFid = pSysStru.getStruFid();
        }
        ArrayList<String> organTypesList = new ArrayList<String>();
        organTypesList.add("3");
        queryOrgParams.put("organTypes", organTypesList);
        int level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
        queryOrgParams.put("parentStruId", OrganUtil.convert((Long)parentStruId));
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        int gradePLevel = 0;
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            SysStru gradePSysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            gradePLevel = gradePSysStru.getStruLevel();
            int gradeDepStruLevel = gradePLevel + 1;
            int searchStruLevel = 0;
            if (!isRoot) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
                level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
            }
        }
        queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        if (HussarUtils.isNotEmpty((Object)queryAssistPostDto.getId())) {
            postId = this.sysStruMapper.getPostByStaffId(queryAssistPostDto.getId());
            if (HussarUtils.isNotEmpty((Object)postId)) {
                ArrayList<Long> excludeIds = new ArrayList<Long>();
                excludeIds.add(postId);
                queryOrgParams.put("excludeIds", excludeIds);
            }
        } else {
            SysStru postStru;
            postId = queryAssistPostDto.getPostId();
            if (HussarUtils.isNotEmpty((Object)postId) && HussarUtils.isNotEmpty((Object)(postStru = (SysStru)this.sysStruMapper.selectById(postId))) && postStru.getStruType().equals("3")) {
                ArrayList<Long> excludeIds = new ArrayList<Long>();
                excludeIds.add(postId);
                queryOrgParams.put("excludeIds", excludeIds);
            }
        }
        queryOrgParams.put("struLevel", level);
        queryOrgParams.put("organCode", StringUtils.trimToEmpty((String)queryAssistPostDto.getOrganCode()));
        queryOrgParams.put("organName", StringUtils.trimToEmpty((String)queryAssistPostDto.getOrganName()));
        List<OrganizationVo> data = this.sysStruMapper.queryOrganization((Page<OrganizationVo>)page, queryOrgParams);
        page.setRecords(data);
        return page;
    }

    @Override
    public List<StaffTreeVo> selectStaffTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        ArrayList<StaffTreeVo> result = new ArrayList<StaffTreeVo>();
        boolean flag = this.createUserConfigService.isUserOnOneEmp();
        if (flag) {
            queryParams.put("userOnOneEmp", "true");
        }
        List<StaffTreeVo> data = this.sysStruMapper.selectStaffTree(queryParams);
        StaffTreeVo root = new StaffTreeVo();
        OrganizationTreeVo organizationTreeVo = this.queryOrganizationManager.lazyOrganizationById(parentId);
        root.setStruType(organizationTreeVo.getStruType());
        root.setId(organizationTreeVo.getId());
        root.setHasChildren(organizationTreeVo.getHasChildren());
        root.setLabel(organizationTreeVo.getLabel());
        root.setDisabled(Boolean.valueOf(true));
        root.setIcon(organizationTreeVo.getIcon());
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public List<SysStaff> selectStaffByStruIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        return this.sysStaffMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getStruId, struIds));
    }
}

