/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.jxdinfo.hussar.authorization.enums.DatascopeEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseIndexOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.IndexOrganizationTreeVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseIndexOrganizationServiceImpl")
public class HussarBaseIndexOrganizationServiceImpl
implements IHussarBaseIndexOrganizationService {
    private static final String STRUFID = "struFid";
    private static final String STRULEVEL = "struLevel";
    private static final String PARENTID = "parentId";
    private static final String PARENTIDS = "parentIds";
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysEmployeeService sysEmployeeService;

    public ApiResponse<List<IndexOrganizationTreeVo>> lazyLoadOrganizationTree(Long parentId, DatascopeEnum datascopeEnum) {
        ArrayList<IndexOrganizationTreeVo> result = new ArrayList<IndexOrganizationTreeVo>();
        List<IndexOrganizationTreeVo> data = this.getOrganizationTree(parentId, datascopeEnum);
        result.addAll(data);
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(result));
    }

    private boolean isRoot(Long parentId) {
        return parentId.equals(Constants.ROOT_NODE_ID);
    }

    private int getLevel(SecurityUser shiroUser) {
        int level = 0;
        Long empolyeeId = shiroUser.getEmployeeId();
        level = this.sysEmployeeService.selectStruLevel(empolyeeId);
        return level;
    }

    private List<IndexOrganizationTreeVo> getOrganizationTree(Long parentId, DatascopeEnum datascopeEnum) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (parentId == null) {
            parentId = Constants.ROOT_NODE_ID;
        }
        boolean isRoot = this.isRoot(parentId);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        List<IndexOrganizationTreeVo> list = null;
        Long finalParentId = parentId;
        ConditionUtils.isTureOrFalse((boolean)shiroUser.isGradeadmin()).trueOrFalseHandle(() -> {
            Long deptId = shiroUser.getDeptId();
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            String userParentFid = sysStru.getStruFid();
            int level = this.getLevel(shiroUser);
            AtomicBoolean f = new AtomicBoolean(false);
            ConditionUtils.isTureOrFalse((boolean)isRoot).trueOrFalseHandle(() -> {
                queryParams.put(STRUFID, userParentFid);
                queryParams.put(STRULEVEL, level);
                f.set(true);
            }, () -> {
                SysStru sysStruT = (SysStru)this.sysStruMapper.selectById(finalParentId);
                queryParams.put(STRULEVEL, sysStruT.getStruLevel() + 1);
                if (sysStruT.getStruLevel() >= level) {
                    queryParams.put(STRUFID, sysStruT.getStruFid());
                } else {
                    f.set(true);
                    queryParams.put(STRUFID, OrganUtil.convert((String)OrganUtil.getStruFidByLevel((String)userParentFid, (int)(sysStruT.getStruLevel() + 1))));
                }
            });
        }, () -> {
            if (datascopeEnum.getScope().equals(DatascopeEnum.UNLIMITED.getScope())) {
                queryParams.put(PARENTID, finalParentId);
            } else if (datascopeEnum.getScope().equals(DatascopeEnum.SAMELEVEL.getScope())) {
                Long deptId = shiroUser.getDeptId();
                SysStru sysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            }
        });
        list = this.searchIndexOrganizationTree(queryParams);
        return list;
    }

    private List<IndexOrganizationTreeVo> searchIndexOrganizationTree(Map<String, Object> queryParams) {
        return this.sysStruMapper.searchIndexOrganizationTree(queryParams);
    }
}

