/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.sysappauth.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.sysappauth.dao.VolHussarTicketMapper;
import com.jxdinfo.hussar.authorization.volmanage.model.VolHussarTicket;
import com.jxdinfo.hussar.authorization.volmanage.service.IVolHussarTicketService;
import com.jxdinfo.hussar.authorization.volmanage.vo.VolHussarTicketVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.sysappauth.service.impl.VolHussarTicketImpl")
public class VolHussarTicketImpl
extends ServiceImpl<VolHussarTicketMapper, VolHussarTicket>
implements IVolHussarTicketService {
    @Autowired
    private VolHussarTicketMapper volHussarTicketMapper;

    public IPage<VolHussarTicket> pageList(Page<VolHussarTicket> pages, VolHussarTicketVo volHussarTicketVo) {
        if ("0".equals(volHussarTicketVo.getDisabled().toString())) {
            IPage<VolHussarTicket> page = this.volHussarTicketMapper.pageList(pages, volHussarTicketVo);
            List records = page.getRecords();
            this.isInIpRecord(records);
            return page;
        }
        LambdaQueryWrapper volHussarTicketLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)volHussarTicketVo.getStartMode())) {
            volHussarTicketLambdaQueryWrapper.eq(VolHussarTicket::getStartMode, (Object)volHussarTicketVo.getStartMode());
        }
        if (HussarUtils.isNotEmpty((Object)volHussarTicketVo.getOutIp())) {
            volHussarTicketLambdaQueryWrapper.eq(VolHussarTicket::getOutIp, (Object)volHussarTicketVo.getOutIp());
        }
        if (HussarUtils.isNotEmpty((Object)volHussarTicketVo.getIp())) {
            volHussarTicketLambdaQueryWrapper.eq(VolHussarTicket::getIp, (Object)volHussarTicketVo.getIp());
        }
        if (HussarUtils.isNotEmpty((Object)volHussarTicketVo.getStartUpTime())) {
            volHussarTicketLambdaQueryWrapper.ge(VolHussarTicket::getUpTime, (Object)volHussarTicketVo.getStartUpTime());
        }
        if (HussarUtils.isNotEmpty((Object)volHussarTicketVo.getEndUpTime())) {
            volHussarTicketLambdaQueryWrapper.lt(VolHussarTicket::getUpTime, (Object)volHussarTicketVo.getEndUpTime());
        }
        if (HussarUtils.isNotEmpty((Object)volHussarTicketVo.getDisabled())) {
            volHussarTicketLambdaQueryWrapper.eq(VolHussarTicket::getDisabled, (Object)volHussarTicketVo.getDisabled());
        }
        volHussarTicketLambdaQueryWrapper.orderByDesc(VolHussarTicket::getUpTime);
        return this.volHussarTicketMapper.selectPage((IPage)pages, (Wrapper)volHussarTicketLambdaQueryWrapper);
    }

    private void isInIpRecord(List<VolHussarTicket> records) {
        List<Map> ipRecordList = this.volHussarTicketMapper.getIpRecordList();
        block0: for (VolHussarTicket vol : records) {
            if ("\u6682\u65e0\u6570\u636e".equals(vol.getOutIp())) continue;
            long checkIp = this.ipToLong(vol.getOutIp());
            vol.setIsInipRecord("0");
            for (Map item : ipRecordList) {
                if (!HussarUtils.isNotEmpty((Object)((String)item.get("startOutIp"))) || !HussarUtils.isNotEmpty((Object)((String)item.get("endOutIp")))) continue;
                long startIp = this.ipToLong((String)item.get("startOutIp"));
                long endIp = this.ipToLong((String)item.get("endOutIp"));
                if (checkIp < startIp || checkIp > endIp) continue;
                vol.setIsInipRecord("1");
                continue block0;
            }
        }
    }

    public long ipToLong(String ip) {
        String[] split = ip.split("\\.");
        long resut = 0L;
        for (int i = 0; i < split.length; ++i) {
            resut += Long.parseLong(split[i]) << 24 - 8 * i;
        }
        return resut;
    }

    private void firstTimeAndPeriodTime(List<VolHussarTicket> records) {
        records.stream().forEach(item -> {
            List<VolHussarTicket> list;
            List volHussarTickets;
            String hostname = item.getHostname();
            if (hostname.split("-").length > 3) {
                int lastIndex = hostname.lastIndexOf(45);
                int secondLastIndex = hostname.lastIndexOf(45, lastIndex - 1);
                hostname = hostname.substring(0, secondLastIndex);
            }
            if (HussarUtils.isNotEmpty((Object)(volHussarTickets = this.volHussarTicketMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(VolHussarTicket::getHostname, (Object)hostname)).orderByAsc(VolHussarTicket::getUpTime))))) {
                item.setFirstUpTime(((VolHussarTicket)volHussarTickets.get(0)).getUpTime());
            }
            if (HussarUtils.isNotEmpty(list = this.volHussarTicketMapper.getArchivalInfo(hostname))) {
                item.setEndTime(list.get(0).getEndTime());
                item.setArchivalId(list.get(0).getArchivalId());
                item.setIsPastEndTime(list.get(0).getIsPastEndTime());
                item.setAppId(list.get(0).getAppId());
            }
        });
    }
}

