/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.sysappauth.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.sysappauth.dao.SysAppAuthMapper;
import com.jxdinfo.hussar.authorization.sysappauth.model.SysAppAuth;
import com.jxdinfo.hussar.authorization.sysappauth.service.ISysAppAuthService;
import com.jxdinfo.hussar.authorization.sysappauth.vo.SysAppAuthVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.sysappauth.service.impl.SysAppAuthServiceImpl")
@HussarDs(value="master")
public class SysAppAuthServiceImpl
extends HussarServiceImpl<SysAppAuthMapper, SysAppAuth>
implements ISysAppAuthService {
    private static final Logger logger = LoggerFactory.getLogger(SysAppAuthServiceImpl.class);
    @Resource
    private ISysUsersService sysUsersService;

    public boolean save(SysAppAuth sysAppAuth) {
        logger.info("\u6388\u6743\u7ba1\u7406\u65b0\u589e\uff1asysAppAuth===={}", (Object)sysAppAuth);
        Long userId = BaseSecurityUtil.getUser().getId();
        sysAppAuth.setCheckStatus("0");
        sysAppAuth.setUserId(userId);
        sysAppAuth.setApplyTime(LocalDateTime.now());
        SysUsers sysUsers = this.sysUsersService.getUser(userId);
        Long id = IdWorker.getId((Object)new SysAppAuth());
        sysAppAuth.setId(id);
        sysAppAuth.setProcessKey("bpm_sqshlc");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userAccount", sysUsers.getUserAccount());
        map.put("userName", sysUsers.getUserName());
        map.put("authType", sysAppAuth.getAuthType());
        map.put("createTime", sysAppAuth.getApplyTime());
        map.put("authCode", sysAppAuth.getAuthCode());
        map.put("authCreateTime", sysAppAuth.getAuthCreateTime());
        map.put("authEndTime", sysAppAuth.getAuthEndTime());
        map.put("remark", sysAppAuth.getRemark());
        logger.info("\u6388\u6743\u7ba1\u7406\u65b0\u589e\uff1a\u5f00\u542f\u6d41\u7a0b==========");
        JSONObject res = InstanceEngineService.startProcessInstanceByKey((String)sysAppAuth.getProcessKey(), (String)String.valueOf(userId), (String)String.valueOf(sysAppAuth.getId()), map).getResult().getJSONObject(0);
        sysAppAuth.setProcessInstanceId(res.getString("processInsId"));
        logger.info("\u6388\u6743\u7ba1\u7406\u65b0\u589e\uff1a\u7b2c\u4e00\u8282\u70b9==========");
        TaskEngineService.completeTask((String)res.getString("taskId"), (String)String.valueOf(userId), (String)sysAppAuth.getRemark(), null);
        logger.info("\u6388\u6743\u7ba1\u7406\u65b0\u589e\uff1a\u4fdd\u5b58\u6570\u636e==========");
        return super.save((BaseEntity)sysAppAuth);
    }

    public boolean removeById(Serializable id) {
        SysAppAuth sysAppAuth = (SysAppAuth)super.getById(id);
        sysAppAuth.setDelFlag("1");
        return super.updateById((BaseEntity)sysAppAuth);
    }

    public Page<SysAppAuthVo> pageList(Page page, SysAppAuthVo sysAppAuthVo) {
        if (BaseSecurityUtil.getUser().isSuperAdmin()) {
            sysAppAuthVo.setUserId(null);
        }
        return ((SysAppAuthMapper)this.getBaseMapper()).pageList((Page<SysAppAuthVo>)page, sysAppAuthVo);
    }

    public boolean audit(JSONObject jsonObject) {
        String taskId = jsonObject.getString("taskId");
        String opinion = jsonObject.getString("opinion");
        String checkStatus = jsonObject.getString("checkStatus");
        SecurityUser user = BaseSecurityUtil.getUser();
        if ("1".equals(checkStatus)) {
            return "1".equals(TaskEngineService.completeTask((String)taskId, (String)String.valueOf(user.getId()), (String)opinion, null).getCode());
        }
        return "1".equals(TaskEngineService.rejectToLastTask((String)taskId, (String)String.valueOf(user.getId()), (String)opinion, (boolean)false, null).getCode());
    }
}

