/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.EditStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editStaffManagerImpl")
public class EditStaffManagerImpl
extends CommonStaffManager
implements EditStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditStaffManagerImpl.class);

    @Override
    public String editStaff(EditStaffDto editStaffDto) {
        String validateMsg = this.validateService.validate((Object)editStaffDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysStaff sysStaff = new SysStaff();
        this.initialization(editStaffDto, sysStru, sysOrgan, sysStaff);
        this.parentOrganizationAuditDataExists(sysStru.getParentId());
        if (!this.sysStruAuditService.checkCanOperate(sysStru.getId())) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        String assistIds = editStaffDto.getAssistIds();
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysStaff, assistIds);
        return result;
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        LOGGER.info("\u5224\u65ad\u9700\u4e0d\u9700\u8981\u5ba1\u6838,\u5982\u679c\u9700\u8981\u5ba1\u6838\uff0c\u5219\u5148\u52a0\u5165\u5ba1\u6838\u8868");
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            return this.doEditStaffAuditData(sysStru, sysOrgan, sysStaff, assistIds);
        }
        return this.doEditStaffData(sysStru, sysOrgan, sysStaff, assistIds);
    }

    private String doEditStaffAuditData(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        this.auditAdd(sysOrgan, sysStru, sysStaff, "2");
        this.sysStruAssistOrganAuditService.saveAssistOrganAudit(assistIds, sysStru.getId());
        return "\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
    }

    private String doEditStaffData(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        this.sysOrganMapper.updateById(sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysStruMapper.updateById(sysStru);
        this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).set(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffService.saveOrUpdate((Object)sysStaff);
        }
        Long sysStruId = sysStru.getId();
        this.sysStruAssistOrganService.saveAssistOrgan(assistIds, sysStruId);
        return "\u4fee\u6539\u6210\u529f\uff01";
    }

    private void initialization(EditStaffDto editStaffDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        LOGGER.info("\u6839\u636eEditStaffDto\u521d\u59cb\u5316SysStru,SysOrgan,SysStaff,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)editStaffDto));
        Long id = editStaffDto.getId();
        String staffName = StringUtils.trimToEmpty((String)editStaffDto.getStaffName());
        String staffPosition = editStaffDto.getStaffPosition();
        String sex = editStaffDto.getSex();
        String birthday = editStaffDto.getBirthday();
        String idcard = editStaffDto.getIdcard();
        String address = editStaffDto.getAddress();
        String workId = editStaffDto.getWorkId();
        String workDate = editStaffDto.getWorkDate();
        String graduateDate = editStaffDto.getGraduateDate();
        String graduateSchool = editStaffDto.getGraduateSchool();
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStruT, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f");
        SysOrgan sysOrganT = (SysOrgan)this.sysOrganMapper.selectById(sysStruT.getOrganId());
        String currentFname = sysOrganT.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + staffName;
        SysStaff sysStaffT = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)id));
        BeanUtils.copyProperties((Object)sysOrganT, (Object)sysOrgan);
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysStaffT, (Object)sysStaff);
        sysStru.setOrganAlias(staffName);
        sysStru.setStaffPosition(staffPosition);
        sysOrgan.setOrganName(staffName);
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        sysStaff.setSex(sex);
        sysStaff.setName(staffName);
        sysStaff.setBirthday(birthday);
        sysStaff.setIdcard(idcard);
        sysStaff.setWorkId(workId);
        sysStaff.setAddress(address);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setWorkDate(workDate);
    }
}

