/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruChangeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruSaveDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysStaffDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrgService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.StruSaveVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/orgMainFront"})
public class SysOrgManageFrontController
extends HussarBaseController<SysStru, SysOrgManageService> {
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysOrgService iSysOrgService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"orgMainFront:orgTree"})
    @GetMapping(value={"/orgTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgTree(@ApiParam(value="\u7ec4\u7ec7\u6811dto") OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)this.iSysOrgService.getOrgMergeTreeVue(organTreeDto));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", notes="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d(\u8fc7\u6ee4\u5c97\u4f4d\u8282\u70b9)")
    @CheckPermission(value={"orgMainFront:orgTree"})
    @GetMapping(value={"/orgDepTree"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgDepTree(@ApiParam(value="\u8282\u70b9id") @RequestParam Long parentId) {
        this.orgMaintenanceService.checkOrganInfo((Object)parentId, "orgDepTree");
        return ApiResponse.success((Object)this.iSysOrgService.getOrgDepTreeVue(parentId));
    }

    @Deprecated
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/orgInfoList"})
    @CheckPermission(value={"orgMainFront:orgInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysOrganVo>> orgInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u7ec4\u7ec7dto") SysOrganDto sysOrganDto) {
        sysOrganDto.setOrganName(sysOrganDto.getOrganName().replace("%", "\\%").replace("_", "\\_"));
        sysOrganDto.setOrganCode(sysOrganDto.getOrganCode().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrgInfoListByParentId(page, sysOrganDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811", notes="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811")
    @CheckPermission(value={"orgMainFront:getDeReTree"})
    @GetMapping(value={"/getDelegateRetrieveTree"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getStruParentId(@ApiParam(value="\u7ec4\u7ec7\u6811dto") OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)this.iSysOrgService.getDelegateRetrieveTree(organTreeDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id", notes="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id")
    @CheckPermission(value={"orgMainFront:orgTree"})
    @GetMapping(value={"/orgResourceStruId"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> orgResourceStruId(@ApiParam(value="\u8d44\u6e90id") @RequestParam Long resourceId, @ApiParam(value="\u8d44\u6e90\u7c7b\u578b") @RequestParam String type) {
        return ApiResponse.success((Object)this.iSysOrgService.getResourceStruId(resourceId, type));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u653e\u529f\u80fd\u7684\u7ec4\u7ec7\u673a\u6784id", notes="\u83b7\u53d6\u4e0b\u653e\u529f\u80fd\u7684\u7ec4\u7ec7\u673a\u6784id")
    @GetMapping(value={"/orgFunctionStruId"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u4e0b\u653e\u529f\u80fd\u7684\u7ec4\u7ec7\u673a\u6784id", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> orgFunctionStruId(@ApiParam(value="\u529f\u80fdid") @RequestParam Long functionId) {
        return ApiResponse.success((Object)this.iSysOrgService.getFunctionStruId(functionId));
    }

    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u6839\u636e\u8282\u70b9\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"orgMainFront:orgTreeById"})
    @GetMapping(value={"/orgTreeById"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u8282\u70b9ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgTreeById(@ApiParam(value="\u7ec4\u7ec7\u6811dto") OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrgTreeByIdVue(organTreeDto));
    }

    @Deprecated
    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b")
    @GetMapping(value={"/orgInfo"})
    @CheckPermission(value={"orgMainFront:orgInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysOrganVo> orgInfo(@ApiParam(value="\u7ec4\u7ec7id") @RequestParam Long struId) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrgInfoById(struId));
    }

    @Deprecated
    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e")
    @GetMapping(value={"/orgInfoAdd"})
    @CheckPermission(value={"orgMainFront:orgInfoAdd"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<StruSaveVo> orgInfoAdd(@ApiParam(value="\u4e0a\u7ea7\u7ec4\u7ec7id") @RequestParam Long orgParentId) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getAddOrganInfo(orgParentId));
    }

    @ApiOperation(value="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u89d2\u8272\u4fe1\u606f", notes="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u89d2\u8272\u4fe1\u606f")
    @GetMapping(value={"/struRoleInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruRole>> getStruRoleInfo(@ApiParam(value="\u7ec4\u7ec7id") @RequestParam Long struId) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getStruRole(struId));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @CheckPermission(value={"orgMainFront:getOrgRoleByCode"})
    @GetMapping(value={"/getOrgRoleByCode"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruRule>> getOrgRoleByCode(@ApiParam(value="\u7ec4\u7ec7\u7c7b\u578b") @RequestParam String orgType, @ApiParam(value="\u662f\u5426\u4e3a\u6839\u8282\u70b9") @RequestParam String isRoot) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", notes="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @GetMapping(value={"/getExitOrgRoleByCode"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> getExitOrgRoleByCode(@ApiParam(value="\u7ec4\u7ec7\u7c7b\u578b") @RequestParam String orgType, @ApiParam(value="\u662f\u5426\u4e3a\u6839\u8282\u70b9") @RequestParam String isRoot) {
        return ApiResponse.success((Object)this.orgMaintenanceService.isExistChildOrgTypeByOrgType(orgType, isRoot));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58")
    @PostMapping(value={"/orgInfoSave"})
    @CheckPermission(value={"orgMainFront:orgInfoSave"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784->\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<JSONObject> orgInfoSave(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto") @RequestBody StruSaveDto struSaveDto) {
        this.orgMaintenanceService.checkOrganInfo((Object)struSaveDto, "add");
        return ApiResponse.success((String)this.orgMaintenanceService.saveOrgInfoVue(struSaveDto));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58")
    @PostMapping(value={"/orgInfoEditSave"})
    @CheckPermission(value={"orgMainFront:orgInfoEditSave"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<JSONObject> orgInfoEditSave(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto") @RequestBody StruSaveDto struSaveDto) {
        this.orgMaintenanceService.checkOrganInfo((Object)struSaveDto, "edit");
        return ApiResponse.success((String)this.orgMaintenanceService.updateOrgInfoVue(struSaveDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f", notes="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f")
    @PostMapping(value={"/orgTreeOrder"})
    @CheckPermission(value={"orgMainFront:orgTreeOrder"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Object> orgTreeOrder(@ApiParam(value="\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784id\u96c6\u5408") @RequestBody List<Long> idList) {
        this.orgMaintenanceService.updateOrgTreeOrder(idList);
        return ApiResponse.success((Object)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u7ec4\u7ec7\u673a\u6784", notes="\u6839\u636eID\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @CheckPermission(value={"orgMainFront:delOrgById"})
    @PostMapping(value={"/delOrgById"})
    @CheckSafe
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u5220\u9664\u7ec4\u7ec7\u673a\u6784", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<JSONObject> delOrgById(@ApiParam(value="\u7ec4\u7ec7\u673a\u6784id") @RequestBody Long struId) {
        return ApiResponse.success((String)this.orgMaintenanceService.deleteOrgByIdVue(struId));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868", notes="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868")
    @CheckPermission(value={"orgMainFront:principalSelect"})
    @GetMapping(value={"principalSelect"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage> principalSelect(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u4eba\u5458dto") SysStaffDto sysStaffDto) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getPrincipalSelectList(page, sysStaffDto));
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"orgMainFront:orgChangeById"})
    @GetMapping(value={"/orgChangeById"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgChangeById(@ApiParam(value="\u7ec4\u7ec7\u6811dto") OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)this.iSysOrgService.getOrgChangeTreeById(organTreeDto));
    }

    @ApiOperation(value="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784", notes="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784")
    @PostMapping(value={"/orgTreeChange"})
    @CheckPermission(value={"orgMainFront:orgTreeChange"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse orgTreeChange(@ApiParam(value="\u7ec4\u7ec7\u8f6c\u79fbdto") @RequestBody StruChangeDto struChangeDto) {
        this.orgMaintenanceService.checkOrganInfo((Object)struChangeDto, "orgTreeChange");
        return this.orgMaintenanceService.orgTreeChangeVue(struChangeDto);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u6811\u4e0a\u79fb\u4e0b\u79fb", notes="\u7ec4\u7ec7\u673a\u6784\u6811\u4e0a\u79fb\u4e0b\u79fb")
    @PostMapping(value={"/singleMove"})
    @CheckPermission(value={"orgMain:singleMove"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u6811\u4e0a\u79fb\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @Deprecated
    public ApiResponse updateMoveNode(@ApiParam(value="\u7ec4\u7ec7\u6811\u8f6c\u79fbdto") @RequestBody StruChangeDto struChangeDto) {
        this.orgMaintenanceService.checkOrganInfo((Object)struChangeDto, "updateMoveNode");
        this.orgMaintenanceService.updateMoveNode(struChangeDto.getStruId(), struChangeDto.getUpFlag());
        return ApiResponse.success((String)"\u79fb\u52a8\u6210\u529f");
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa", notes="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/exportData"})
    @CheckPermission(value={"orgMainFront:exportData"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@ApiParam(value="\u5bfc\u51fa\u7684\u7ec4\u7ec7id\u5b57\u7b26\u4e32") @RequestBody String ids, HttpServletResponse response) {
        this.orgMaintenanceService.exportData(ids, response);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u5165", notes="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u5165")
    @PostMapping(path={"/importData"})
    @CheckPermission(value={"orgMainFront:importData"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<Object> importData(@ApiParam(value="\u5bfc\u5165\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u6587\u4ef6") @RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.success((Object)this.orgMaintenanceService.importVueOrg(content));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u662f\u5426\u5ba1\u6838", notes="\u7ec4\u7ec7\u673a\u6784\u662f\u5426\u5ba1\u6838")
    @GetMapping(value={"/isAudit"})
    public ApiResponse<Boolean> isAudit() {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868", notes="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868")
    @GetMapping(value={"/searchOrganization"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchOrganizationVo>> searchOrganization(@RequestParam(value="current", required=false) Long current, @RequestParam(value="size", required=false) Long size, String name) {
        return this.orgMaintenanceService.searchOrganization(current, size, name);
    }

    @ApiOperation(value="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811")
    @GetMapping(value={"/organTreeById"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> organTreeById(@RequestParam(value="organId") Long organId) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrganTreeById(organId));
    }
}

