/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruOrganRelationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.service.impl.SysEmployeeServiceImpl;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysStruAssistOrganImpl
extends HussarServiceImpl<SysStruAssistOrganMapper, SysStruAssistOrgan>
implements ISysStruAssistOrganService {
    @Resource
    SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Lazy
    @Resource
    SysOrgManageService sysOrgManageService;
    @Lazy
    @Resource
    ISysStruRuleService sysStruRuleService;
    @Lazy
    @Resource
    SysEmployeeServiceImpl sysEmployeeService;
    @Resource
    SysStruMapper sysStruMapper;

    @Deprecated
    @HussarTransactional
    public boolean saveAssistOrgan(String organIds, Long struId) {
        StruOrganRelationDto struOrganRelationDto = new StruOrganRelationDto();
        struOrganRelationDto.setOrganIds(organIds);
        struOrganRelationDto.setSysStruId(struId);
        return this.saveAssistOrgan(struOrganRelationDto);
    }

    @HussarTransactional
    public boolean saveAssistOrgan(StruOrganRelationDto struOrganRelationDto) {
        Long struId = struOrganRelationDto.getSysStruId();
        String organIds = struOrganRelationDto.getOrganIds();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruAssistOrgan::getStruId, (Object)struId);
        this.remove((Wrapper)wrapper);
        if (ToolUtil.isNotEmpty((Object)organIds)) {
            String[] ids = organIds.split(",");
            ArrayList<SysStruAssistOrgan> sysStruAssistOrganList = new ArrayList<SysStruAssistOrgan>();
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            for (String organId : ids) {
                if (ToolUtil.isEmpty((Object)organId)) continue;
                SysStruAssistOrgan sysStruAssistOrgan = new SysStruAssistOrgan();
                sysStruAssistOrgan.setAssistParentId(Long.valueOf(organId));
                sysStruAssistOrgan.setStruId(struId);
                sysStruAssistOrgan.setCreator(securityUser.getId());
                sysStruAssistOrgan.setLastEditor(securityUser.getId());
                sysStruAssistOrgan.setLastTime(now);
                sysStruAssistOrgan.setCreateTime(now);
                sysStruAssistOrganList.add(sysStruAssistOrgan);
            }
            if (!this.saveBatch(sysStruAssistOrganList, sysStruAssistOrganList.size())) {
                throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
            }
        }
        return true;
    }

    public List<JSTreeModel> getOrgTree(OrganTreeDto organTreeDto) {
        if (ToolUtil.isEmpty((Object)organTreeDto)) {
            throw new BaseException("\u83b7\u53d6\u517c\u804c\u6811\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.sysEmployeeService.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setState(false, false, true);
        result.add(root);
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List<JSTreeModel> orgTree = this.sysStruAssistOrganMapper.getHNOrganTree(organTreeDto.getIsEmployee());
        List<Object> orgTree1 = new ArrayList();
        List list = this.sysStruRuleService.getAllowStaffOrganType();
        orgTree1 = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(orgTree, level) : orgTree;
        List<Long> parents = this.getParents(level);
        for (JSTreeModel jSTreeModel : orgTree1) {
            if (ToolUtil.equals((Object)organTreeDto.getParentId(), (Object)jSTreeModel.getId())) {
                jSTreeModel.setState(false, false, true);
            }
            if (!list.contains(jSTreeModel.getType())) {
                jSTreeModel.setState(false, false, true);
            }
            if (isGradeAdmin && parents.contains(jSTreeModel.getId())) {
                jSTreeModel.setState(false, false, true);
            }
            if ("3".equals(jSTreeModel.getType())) continue;
            jSTreeModel.setState(false, false, true);
        }
        result.addAll(orgTree1);
        return result;
    }

    public List<JSTreeModel> getOrgMergeTree(OrganTreeDto organTreeDto) {
        return TreeModelUtils.merge(this.getOrgTree(organTreeDto));
    }

    public List<SysStruAssistOrgan> getStruAssistOrganByStruIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        return this.sysStruAssistOrganMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStruAssistOrgan::getStruId, struIds));
    }

    public List<SysStruAssistOrgan> getAssistOrgan(Long struId) {
        if (ToolUtil.isEmpty((Object)struId)) {
            throw new BaseException("\u4eba\u5458\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruAssistOrgan::getStruId, (Object)struId);
        return this.sysStruAssistOrganMapper.selectList((Wrapper)wrapper);
    }

    public List<SysStruAssistOrgan> getAssistOrgan(String struId) {
        return this.getAssistOrgan(Long.parseLong(struId));
    }

    public List<Map<String, Object>> getAllAssistOrgan(Long struId) {
        return this.sysStruAssistOrganMapper.getAllAssistOrgan(struId);
    }

    public List<SysStruAssistOrgan> getAssistOrganByParent(Long struId) {
        List list = this.sysStruAssistOrganMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrgan::getAssistParentId, (Object)struId));
        return list;
    }

    public List<JSTreeModel> getAssistOrganTree(String[] assistOrganIds, OrganTreeDto organTreeDto) {
        List<JSTreeModel> orgTree = this.getOrgTree(organTreeDto);
        List<Object> array = new ArrayList();
        if (assistOrganIds[0].length() != 0) {
            array = Arrays.asList(assistOrganIds);
        }
        HashMap<String, JSTreeModel> map = new HashMap<String, JSTreeModel>();
        if (CollectionUtils.isNotEmpty(array)) {
            for (String string : array) {
                this.findPid(map, string, orgTree);
            }
            ArrayList treeModels = new ArrayList(map.values());
            Collections.sort(treeModels, new Comparator<JSTreeModel>(){

                @Override
                public int compare(JSTreeModel o1, JSTreeModel o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            return TreeModelUtils.merge(treeModels);
        }
        return TreeModelUtils.merge(orgTree.stream().filter(item -> item.getParent() == 0L).collect(Collectors.toList()));
    }

    private void findPid(Map<String, JSTreeModel> map, String id, List<JSTreeModel> orgTree) {
        for (JSTreeModel jsTreeModel : orgTree) {
            if (!(jsTreeModel.getId() + "").equals(id)) continue;
            map.put(id, jsTreeModel);
            if (jsTreeModel.getParent() == 0L) continue;
            this.findPid(map, jsTreeModel.getParent() + "", orgTree);
        }
    }

    private List<Long> getParents(Integer currentLevel) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long currentStruId = shiroUser.getEmployeeId();
        Long currentUserId = shiroUser.getId();
        Long currentDeptId = shiroUser.getDeptId();
        Long deptId = shiroUser.getDeptId();
        List<SysStru> list = this.sysStruMapper.getParentStruTree(currentLevel);
        List<SysStru> childList = this.sysStruMapper.getChildStruTree(currentLevel - 1);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (SysStru sysStru : list) {
            Long id = sysStru.getId();
            Long parentId = sysStru.getParentId();
            idMap.put(id, parentId);
        }
        Long struId = currentStruId;
        Long parentId = currentStruId;
        ArrayList<Long> idList = new ArrayList<Long>();
        do {
            struId = parentId;
            parentId = (Long)idMap.get(struId);
            idList.add(struId);
        } while (idMap.containsKey(parentId));
        idList.remove(currentDeptId);
        return idList;
    }
}

