/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editBatchOutsideUserManagerImpl")
public class EditBatchOutsideUserManagerImpl
extends CommonOutsideUserManager
implements EditBatchOutsideUserManager {
    @Override
    public R<EditOutsideUserDto> editBatchUsers(List<EditOutsideUserDto> users) {
        boolean canEdit = false;
        if (HussarUtils.isNotEmpty(users) && users.size() <= 50) {
            canEdit = true;
        }
        if (!canEdit) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        boolean getLoginUpperOpen = this.hussarLoginConfigService.getLoginUpperOpen();
        for (EditOutsideUserDto userDto : users) {
            SysUsers sysUsers;
            boolean convert;
            String account = userDto.getUserAccount();
            boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(account);
            if (convert) {
                account = account.toUpperCase();
            }
            if ((sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)) != null) continue;
            OrganUtil.addErrorMsg(errors, (Object)userDto, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728"});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashSet<SysStru> sysStruCollection = new LinkedHashSet<SysStru>();
            LinkedHashSet<SysOrgan> sysOrganCollection = new LinkedHashSet<SysOrgan>();
            LinkedHashSet<SysStaff> sysStaffCollection = new LinkedHashSet<SysStaff>();
            LinkedHashSet<SysUsers> sysUsersCollection = new LinkedHashSet<SysUsers>();
            for (EditOutsideUserDto userDto : users) {
                boolean convert;
                String account = userDto.getUserAccount();
                boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(account);
                if (convert) {
                    account = account.toUpperCase();
                }
                SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
                SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)sysUsers.getEmployeeId());
                SysStaff sysStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)sysStru.getId()));
                SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
                this.initializationEdit(userDto, sysStru, sysOrgan, sysStaff, sysUsers);
                this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
                sysStruCollection.add(sysStru);
                sysOrganCollection.add(sysOrgan);
                sysStaffCollection.add(sysStaff);
                sysUsersCollection.add(sysUsers);
                dataMappings.add(new DataMapping(sysUsers.getId(), sysUsers.getUserAccount()));
            }
            result.setSuccessList(dataMappings);
            this.sysStruService.updateBatchById(sysStruCollection);
            this.sysOrganService.updateBatchById(sysOrganCollection);
            this.sysStaffService.updateBatchById(sysStaffCollection);
            this.sysUsersService.updateBatchById(sysUsersCollection);
        }
        return result;
    }
}

