/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncResDelDto;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteDataRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysFunctionResourcesServiceImpl
extends HussarServiceImpl<SysFunctionResourcesMapper, SysFunctionResources>
implements ISysFunctionResourcesService {
    private static Logger logger = LoggerFactory.getLogger(SysFunctionResourcesServiceImpl.class);
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    @Lazy
    private ISysRoleFunctionsService iSysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private DeleteDataRightManager deleteDataRightManager;
    @Resource
    private QueryDataRightManager queryDataRightManager;

    public Map<String, Object> getFunctionResourceList(String functionId, String page, String limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
        List<Map<String, String>> list = this.sysFunctionResourcesMapper.getFunctionResourceList(pages, functionId);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    public int deleteFunRes(FuncResDelDto funcResDelDto) {
        String functionId = ToolUtil.isNotEmpty((Object)funcResDelDto.getFunctionId()) ? funcResDelDto.getFunctionId() : "";
        List resourceIds = ToolUtil.isNotEmpty((Object)funcResDelDto.getResourceIds()) ? funcResDelDto.getResourceIds() : new ArrayList();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleFunctions::getFunctionId, (Object)functionId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list((Wrapper)queryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctionsList)) {
            for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
                roleIds.add(sysRoleFunctions.getRoleId());
            }
        }
        if (ToolUtil.isNotEmpty(roleIds)) {
            LambdaQueryWrapper queryWrapperRr = new LambdaQueryWrapper();
            queryWrapperRr.in(SysRoleResource::getId, roleIds);
            queryWrapperRr.in(SysRoleResource::getResourceId, (Collection)resourceIds);
            this.iSysRoleResourceService.remove((Wrapper)queryWrapperRr);
        }
        return this.sysFunctionResourcesMapper.deleteFunRes(functionId, resourceIds);
    }

    public boolean saveFunctionRes(Long functionId, List<Map<String, String>> resources) {
        QueryWrapper queryWrapperFr = new QueryWrapper();
        queryWrapperFr.eq((Object)"FUNCTION_ID", (Object)functionId);
        List<FuncResVo> sysFunctionResourcesMap = this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
        ArrayList resourceIds = new ArrayList();
        ArrayList<Long> delResourceIds = new ArrayList<Long>();
        sysFunctionResourcesMap.parallelStream().forEach(sysFunctionResources -> {
            Long resourceId = sysFunctionResources.getResourceId();
            resourceIds.add(resourceId);
            delResourceIds.add(resourceId);
        });
        if (ToolUtil.isNotEmpty(resourceIds)) {
            this.remove((Wrapper)queryWrapperFr);
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"FUNCTION_ID", (Object)functionId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list((Wrapper)queryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctionsList)) {
            for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
                roleIds.add(sysRoleFunctions.getRoleId());
            }
        }
        for (Map map : resources) {
            delResourceIds.add(Long.valueOf((String)map.get("id")));
        }
        if (ToolUtil.isNotEmpty(roleIds) && ToolUtil.isNotEmpty(delResourceIds)) {
            LambdaQueryWrapper queryWrapperRr = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getId, roleIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)queryWrapperRr, SysRoleResource::getResourceId, delResourceIds);
            queryWrapperRr.eq(SysRoleResource::getRelationSource, (Object)"1");
            this.iSysRoleResourceService.remove((Wrapper)queryWrapperRr);
        }
        ArrayList<SysFunctionResources> sysFunctionResourcesSaveList = new ArrayList<SysFunctionResources>();
        ArrayList<SysRoleResource> arrayList = new ArrayList<SysRoleResource>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        for (Map<String, String> resource : resources) {
            if (!"res_menu".equals(resource.get("type")) && !"res_btn".equals(resource.get("type")) && !"res_rights".equals(resource.get("type"))) continue;
            SysFunctionResources sysFunctionResources2 = new SysFunctionResources();
            sysFunctionResources2.setResourceId(Long.valueOf(resource.get("id")));
            sysFunctionResources2.setFunctionId(functionId);
            sysFunctionResources2.setCreator(securityUser.getId());
            sysFunctionResources2.setLastEditor(securityUser.getId());
            sysFunctionResources2.setLastTime(now);
            sysFunctionResources2.setCreateTime(now);
            sysFunctionResourcesSaveList.add(sysFunctionResources2);
            if (!ToolUtil.isNotEmpty(roleIds)) continue;
            for (Long roleId : roleIds) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setResourceId(Long.valueOf(resource.get("id")));
                sysRoleResource.setId(roleId);
                sysRoleResource.setRelationSource("1");
                sysRoleResource.setCreator(securityUser.getId());
                sysRoleResource.setLastEditor(securityUser.getId());
                sysRoleResource.setLastTime(now);
                sysRoleResource.setCreateTime(now);
                arrayList.add(sysRoleResource);
            }
        }
        if (ToolUtil.isNotEmpty(arrayList)) {
            this.iSysRoleResourceService.saveBatch(arrayList);
        }
        boolean saveFlag = this.saveBatch(sysFunctionResourcesSaveList);
        this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIds);
        return saveFlag;
    }

    public List<FuncResVo> getFunctionResourceList(Long functionId) {
        return this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
    }

    public void insertOrUpdateFunctionResource(List<SysFunctionResources> functionResourcesList) {
        if (CollectionUtils.isEmpty(functionResourcesList)) {
            logger.info("\u529f\u80fd\u8d44\u6e90\u65b0\u589e{}\u6761", (Object)functionResourcesList.size());
            return;
        }
        List<SysFunctionResources> existList = this.selectExistList(functionResourcesList);
        List<SysFunctionResources> addList = functionResourcesList;
        if (ToolUtil.isNotEmpty(existList)) {
            addList = this.getAddList(functionResourcesList, existList);
        }
        if (ToolUtil.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        logger.info("\u529f\u80fd\u8d44\u6e90\u65b0\u589e{}\u6761", (Object)addList.size());
    }

    public void dataSyncByfuncRes(List<SysFunctionResources> functionResourcesList) {
        List functionIdList = functionResourcesList.stream().map(SysFunctionResources::getFunctionId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryRoleFunc = new LambdaQueryWrapper();
        queryRoleFunc.in(SysRoleFunctions::getFunctionId, functionIdList);
        List sysRoleFuncList = this.sysRoleFunctionsMapper.selectList((Wrapper)queryRoleFunc);
        if (ToolUtil.isNotEmpty((Object)sysRoleFuncList)) {
            ArrayList<Long> repeatIds = new ArrayList<Long>();
            HashMap funcIdAndResIdListMap = new HashMap();
            for (SysFunctionResources funcRes : functionResourcesList) {
                if (repeatIds.contains(funcRes.getFunctionId())) {
                    ((List)funcIdAndResIdListMap.get(funcRes.getFunctionId())).add(funcRes.getResourceId());
                    continue;
                }
                repeatIds.add(funcRes.getFunctionId());
                ArrayList<Long> resIdList = new ArrayList<Long>();
                resIdList.add(funcRes.getResourceId());
                funcIdAndResIdListMap.put(funcRes.getFunctionId(), resIdList);
            }
            ArrayList newroleResourceList = new ArrayList();
            HashMap<String, SysRoleResource> distinctRoleRes = new HashMap<String, SysRoleResource>();
            for (SysRoleFunctions roleFunction : sysRoleFuncList) {
                List resIdList = (List)funcIdAndResIdListMap.get(roleFunction.getFunctionId());
                for (Long resId : resIdList) {
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource.setId(roleFunction.getRoleId());
                    sysRoleResource.setResourceId(resId);
                    sysRoleResource.setRelationSource("1");
                    distinctRoleRes.put(roleFunction.getRoleId().toString() + resId.toString() + "1", sysRoleResource);
                }
            }
            distinctRoleRes.forEach((key, value) -> newroleResourceList.add(value));
            if (ToolUtil.isNotEmpty(newroleResourceList)) {
                this.iSysRoleResourceService.delRoleResByDoubleId(newroleResourceList);
                this.iSysRoleResourceService.saveBatch(newroleResourceList);
            }
        }
    }

    public List<SysFunctionResources> selectListByDoubleIds(List<SysFunctionResources> sysFunctionResources) {
        ArrayList<SysFunctionResources> retunList = new ArrayList<SysFunctionResources>();
        LambdaQueryWrapper funcResQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysFunctionResources.size(); i += 999) {
            List<SysFunctionResources> temp;
            if (i + 999 >= sysFunctionResources.size()) {
                temp = sysFunctionResources.subList(i, sysFunctionResources.size());
                funcResQueryWrapper.clear();
                for (SysFunctionResources funcRes : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
                }
                retunList.addAll(this.sysFunctionResourcesMapper.selectList((Wrapper)funcResQueryWrapper));
                continue;
            }
            temp = sysFunctionResources.subList(i, i + 999);
            funcResQueryWrapper.clear();
            for (SysFunctionResources funcRes : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
            }
            retunList.addAll(this.sysFunctionResourcesMapper.selectList((Wrapper)funcResQueryWrapper));
        }
        return retunList;
    }

    public void deleteListByDoubleIds(List<SysFunctionResources> sysFunctionResourcesList) {
        LambdaQueryWrapper funcResQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysFunctionResourcesList.size(); i += 999) {
            List<SysFunctionResources> temp;
            if (i + 999 >= sysFunctionResourcesList.size()) {
                temp = sysFunctionResourcesList.subList(i, sysFunctionResourcesList.size());
                funcResQueryWrapper.clear();
                for (SysFunctionResources funcRes : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
                }
                this.sysFunctionResourcesMapper.delete((Wrapper)funcResQueryWrapper);
                continue;
            }
            temp = sysFunctionResourcesList.subList(i, i + 999);
            funcResQueryWrapper.clear();
            for (SysFunctionResources funcRes : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
            }
            this.sysFunctionResourcesMapper.delete((Wrapper)funcResQueryWrapper);
        }
    }

    public List<SysFunctionResources> selectFunctionResByFuncIds(List<Long> functionIds) {
        if (HussarUtils.isEmpty(functionIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long funcId : functionIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcId);
        }
        return this.sysFunctionResourcesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public List<SysFunctionResources> getFunctionResource(String resType) {
        return this.sysFunctionResourcesMapper.getFunctionResourceBtn(resType);
    }

    public List<Map<String, Object>> getRoleFunctionRes(String resType) {
        return this.sysFunctionResourcesMapper.getRoleFunctionRes(resType);
    }

    private List<SysFunctionResources> selectExistList(List<SysFunctionResources> sysFunctionResources) {
        List<Object> returnList = new ArrayList<SysFunctionResources>();
        ArrayList functionIds = new ArrayList();
        ArrayList resourceIds = new ArrayList();
        sysFunctionResources.forEach(fr -> {
            functionIds.add(fr.getFunctionId());
            resourceIds.add(fr.getResourceId());
        });
        if (ToolUtil.isNotEmpty(functionIds) && ToolUtil.isNotEmpty(resourceIds)) {
            List distFuncIds = functionIds.stream().distinct().collect(Collectors.toList());
            List distResIds = resourceIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper funcResQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysFunctionResources::getFunctionId, distFuncIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)funcResQueryWrapper, SysFunctionResources::getResourceId, distResIds);
            returnList = this.sysFunctionResourcesMapper.selectList((Wrapper)funcResQueryWrapper);
        }
        return returnList;
    }

    private List<SysFunctionResources> getAddList(List<SysFunctionResources> functionResourcesList, List<SysFunctionResources> existList) {
        ArrayList<SysFunctionResources> addList = new ArrayList<SysFunctionResources>();
        HashMap existMap = new HashMap();
        existList.forEach(fr -> existMap.put(fr.getFunctionId() + "-" + fr.getResourceId(), "1"));
        for (SysFunctionResources functionResources : functionResourcesList) {
            String idStr = functionResources.getFunctionId() + "-" + functionResources.getResourceId();
            if (!ToolUtil.isEmpty(existMap.get(idStr))) continue;
            addList.add(functionResources);
        }
        return addList;
    }
}

