/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.jxdinfo.hussar.authorization.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonUserManager {
    @Autowired
    protected ISysConfRolesService sysConfRolesService;
    @Autowired
    protected IHussarValidateService validateService;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysStruAuditMapper sysStruAuditMapper;
    @Resource
    protected AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Autowired
    protected ICreateUserConfigService createUserConfigService;
    @Autowired
    protected IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    protected AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Autowired
    protected ISysUsersAuditService sysUsersAuditService;
    @Autowired
    protected ISysStruAuditService sysStruAuditService;
    @Autowired
    protected ISysUserIpAuditService sysUserIpAuditService;
    @Autowired
    protected ISysUserIpService sysUserIpService;
    @Autowired
    protected ISysUserRoleService sysUserRoleService;
    @Autowired
    protected ISysUserroleAuditService sysUserroleAuditService;
    @Autowired
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    protected HussarBaseProperties hussarBaseProperties;
    @Autowired
    protected SysLoginUserService sysLoginUserService;
    @Resource
    protected SysOrgManageService sysOrgManageService;
    protected static final String ADD = "1";
    protected static final String DELETE = "2";

    protected void checkIncludeConfRole(Long[] idLs) {
        if (HussarUtils.isNotEmpty((Object[])idLs)) {
            AssertUtil.isFalse((boolean)this.sysConfRolesService.isIncludeConfRole(idLs), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
    }

    protected boolean saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotBlank((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String string : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(string);
                sysUserIps.add(sysUserIp);
            }
        }
        if (sysUserIps.size() > 0) {
            ArrayList<String> newsysUserIps = new ArrayList<String>();
            for (SysUserIp sysUserIp : sysUserIps) {
                AssertUtil.isFalse((boolean)newsysUserIps.contains(sysUserIp.getUserIp()), (String)("\u5b58\u5728\u91cd\u590d\u7684ip\uff1a" + sysUserIp.getUserIp()));
                newsysUserIps.add(sysUserIp.getUserIp());
            }
            flag = this.sysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }

    protected boolean saveUserAuditIP(Long userId, String accessLoginIp, String currentStatus) {
        boolean flag = false;
        ArrayList<SysUserIpAudit> listAudit = new ArrayList<SysUserIpAudit>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
                sysUserIpAudit.setUserId(userId);
                sysUserIpAudit.setUserIp(ip);
                sysUserIpAudit.setIsAudit("0");
                sysUserIpAudit.setCurrentStatus(currentStatus);
                listAudit.add(sysUserIpAudit);
            }
        }
        if (HussarUtils.isNotEmpty(listAudit)) {
            flag = this.sysUserIpAuditService.saveBatch(listAudit);
        }
        return flag;
    }
}

