/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.SysResourcesVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysResourcesServiceImpl
extends HussarServiceImpl<SysResourcesMapper, SysResources>
implements ISysResourcesService {
    @Resource
    SysResourcesMapper resourceMapper;

    public Map<String, Integer> insertOrUpdateList(List<SysResources> resourcesList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (CollectionUtils.isEmpty(resourcesList)) {
            result.put("update", 0);
            result.put("insert", 0);
            return result;
        }
        for (SysResources sysResources : resourcesList) {
            if (sysResources.getPermissions() != null) continue;
            sysResources.setPermissions("");
        }
        List<Long> resIds = resourcesList.stream().map(SysResources::getId).collect(Collectors.toList());
        List<SysResources> existedResources = this.selectResourcesByResIds(resIds);
        if (HussarUtils.isEmpty(existedResources)) {
            this.saveBatch(resourcesList);
            result.put("update", 0);
            result.put("insert", resourcesList.size());
            return result;
        }
        ArrayList<SysResources> updateData = new ArrayList<SysResources>();
        ArrayList<SysResources> insertData = new ArrayList<SysResources>();
        List existedIds = existedResources.stream().map(SysResources::getId).collect(Collectors.toList());
        for (SysResources sysResources : resourcesList) {
            if (existedIds.contains(sysResources.getId())) {
                updateData.add(sysResources);
                continue;
            }
            insertData.add(sysResources);
        }
        if (HussarUtils.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        this.updateBatchById(updateData);
        result.put("update", updateData.size());
        result.put("insert", insertData.size());
        return result;
    }

    public boolean checkResource(String resourceUrl) {
        boolean flag = false;
        List resources = this.resourceMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)resourceUrl)).eq(SysResources::getIsRepeatAuthenticate, (Object)"1"));
        if (resources != null && resources.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public SysResourcesVo getResourceInfoByUrl(String key) {
        return new SysResourcesVo();
    }

    public List<String> queryResUrlsByRoleId(String roleId) {
        return this.resourceMapper.getResUrlsByRoleId(roleId);
    }

    public List<String> queryPermissionsByRoleIds(List<Long> roleIds) {
        if (ToolUtil.isNotEmpty(roleIds)) {
            return this.resourceMapper.getPermissionsByRoleIds(roleIds);
        }
        return new ArrayList<String>();
    }

    public List<SysResources> selectResourcesByResIds(List<Long> resourceIds) {
        if (HussarUtils.isEmpty(resourceIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long resId : resourceIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysResources::getId, (Object)resId);
        }
        return this.resourceMapper.selectList((Wrapper)lambdaQueryWrapper);
    }
}

