/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.grade.staff.manager.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffVo;
import com.jxdinfo.hussar.authorization.properties.HussarSystemIdProperties;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.grade.enums.AuthorGradeTipEnum;
import com.jxdinfo.hussar.grade.organ.manager.QueryGradeOrganManager;
import com.jxdinfo.hussar.grade.staff.manager.QueryGradeStaffManager;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.grade.staff.manager.impl.queryGradeStaffManagerImpl")
public class QueryGradeStaffManagerImpl
implements QueryGradeStaffManager {
    @Resource
    private QueryGradeOrganManager queryGradeOrganManager;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Resource
    private QueryStaffManager queryStaffManager;
    @Resource
    private HussarSystemIdProperties hussarSystemIdProperties;

    @Override
    public Page<StaffVo> list(PageInfo pageInfo, Long organId, String staffName, String staffCode) {
        Long innerOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        Page staffVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        if (HussarUtils.equals((Object)innerOrganNodeId, (Object)organId) || HussarUtils.equals((Object)outOrganNodeId, (Object)organId)) {
            String organProperty = HussarUtils.equals((Object)innerOrganNodeId, (Object)organId) ? "0" : "1";
            if (HussarUtils.isEmpty((Object)(organId = this.queryGradeOrganManager.getGradeOrganType(organId)))) {
                staffVoPage.setRecords(Collections.emptyList());
                return staffVoPage;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(organId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                staffVoPage.setRecords(Collections.emptyList());
                return staffVoPage;
            }
        }
        if (HussarUtils.isNotEmpty((Object)organId)) {
            String struPath;
            if (Objects.equals(innerOrganNodeId, organId)) {
                struPath = "0";
            } else if (Objects.equals(outOrganNodeId, organId)) {
                struPath = "1";
            } else {
                SysStru sysStru = (SysStru)this.sysStruMapper.selectById((Serializable)organId);
                struPath = sysStru.getStruFid();
            }
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("staffName", SqlQueryUtil.transferSpecialChar((String)staffName));
            queryMap.put("staffCode", SqlQueryUtil.transferSpecialChar((String)staffCode));
            queryMap.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            List staffVos = this.sysStaffMapper.listNew(staffVoPage, struPath, queryMap);
            staffVoPage.setRecords(staffVos);
            return staffVoPage;
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)AuthorGradeTipEnum.AUTHOR_GRADE_ORG_ID_EMPTY.getMessage()));
    }

    @Override
    public StaffVo detail(Long staffId) {
        StaffVo staffVo = this.queryStaffManager.detail(staffId);
        Long organId = this.queryGradeOrganManager.getGradeOrganType(null);
        if (HussarUtils.isEmpty((Object)organId)) {
            return staffVo;
        }
        List allSubOrgan = this.hussarBaseOrganizationBoService.getAllSubOrgan(organId);
        List visibleList = allSubOrgan.stream().map(OrganVo::getId).collect(Collectors.toList());
        Iterator iterator = staffVo.getOrganization().iterator();
        while (iterator.hasNext()) {
            OrganizationVo vo;
            vo.setHidden(Boolean.valueOf(!visibleList.contains((vo = (OrganizationVo)iterator.next()).getId())));
        }
        return staffVo;
    }
}

