/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.grade.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.ReadOnlyOrganizationTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCacheVo;
import com.jxdinfo.hussar.authorization.permit.vo.OptionVo;
import com.jxdinfo.hussar.authorization.properties.HussarSystemIdProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.grade.organ.manager.QueryGradeOrganManager;
import com.jxdinfo.hussar.grade.organ.manager.impl.CommonQueryGradeOrganManager;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.grade.organ.manager.impl.queryGradeOrganManagerImpl")
public class QueryGradeOrganManagerImpl
extends CommonQueryGradeOrganManager
implements QueryGradeOrganManager {
    @Resource
    private HussarSystemIdProperties hussarSystemIdProperties;

    @Override
    public List<OrganizationTreeVo> lazyLoadOrganizationTree(Long parentId, String organProperty) {
        List<OrganizationTreeVo> data;
        Long innerOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        Long gradeRootId = null;
        if (HussarUtils.equals((Object)innerOrganNodeId, (Object)parentId) || HussarUtils.equals((Object)outOrganNodeId, (Object)parentId)) {
            if (HussarUtils.isEmpty((Object)(parentId = this.getGradeOrganType(parentId)))) {
                return result;
            }
            if (!HussarUtils.equals((Object)innerOrganNodeId, (Object)parentId) && !HussarUtils.equals((Object)outOrganNodeId, (Object)parentId)) {
                gradeRootId = parentId;
            }
        }
        if (HussarUtils.isNotEmpty(data = this.getGradeOrganizationTree(parentId, organProperty, gradeRootId))) {
            for (OrganizationTreeVo vo : data) {
                vo.setDisabled(Boolean.valueOf(false));
            }
        }
        this.fillOrganizationPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public Long getGradeOrganType(Long rootId) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        assert (currentUser != null);
        List roleIdList = currentUser.getRolesList();
        ArrayList dataRightCacheVoList = new ArrayList();
        ArrayList<String> organTypes = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)roleIdList)) {
            for (Long roleId : roleIdList) {
                List cacheList = (List)HussarCacheUtil.get((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
                if (!HussarUtils.isNotEmpty((Object)cacheList)) continue;
                dataRightCacheVoList.addAll(cacheList);
            }
        }
        if (HussarUtils.isEmpty(dataRightCacheVoList)) {
            return rootId;
        }
        for (DataRightCacheVo vo : dataRightCacheVoList) {
            if (!HussarUtils.equals((Object)"res_rights", (Object)vo.getResTypeCode()) && !HussarUtils.equals((Object)"res_form_rights", (Object)vo.getResTypeCode()) || !HussarUtils.equals((Object)"6", (Object)String.valueOf(vo.getType()))) continue;
            Map dynamicParameterValue = (Map)JSON.parseObject((String)vo.getCustomDataCondition(), (TypeReference)new TypeReference<Map<String, List<OptionVo>>>(){}, (Feature[])new Feature[0]);
            organTypes.add(((OptionVo)((List)dynamicParameterValue.get("gradeOrganType")).get(0)).getValue());
        }
        if (HussarUtils.isEmpty(organTypes)) {
            return rootId;
        }
        SysStru stru = (SysStru)this.sysGradeStruMapper.selectById(currentUser.getDeptId());
        String type = this.getTopTypeByTypeInList(stru.getStruType(), organTypes);
        return this.getParentOrganByType(currentUser.getDeptId(), type);
    }

    @Override
    public Long getParentOrganByType(Long organId, String type) {
        if (HussarUtils.isEmpty((Object)organId) || HussarUtils.equals((Object)this.hussarSystemIdProperties.getInnerOrganNodeId(), (Object)organId)) {
            return organId;
        }
        SysStru stru = (SysStru)this.sysGradeStruMapper.selectById(organId);
        if (HussarUtils.isEmpty((Object)stru) || HussarUtils.equals((Object)type, (Object)stru.getStruType())) {
            return organId;
        }
        OrganizationBo bo = this.hussarBaseOrganizationBoService.findOrganByTypeAndOrganId(type, organId);
        if (HussarUtils.isEmpty((Object)bo)) {
            return null;
        }
        return bo.getId();
    }

    @Override
    public String getTopTypeByTypeInList(String currentType, List<String> organTypes) {
        List organTypeList = this.sysOrganTypeService.list();
        Map<String, SysOrganType> organTypeMap = organTypeList.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
        HashMap<String, Integer> organTypeSeqMap = new HashMap<String, Integer>();
        this.buildOrganTypeSeqMap(currentType, 1, organTypeSeqMap, organTypeMap);
        String type = "";
        Integer seq = 0;
        for (String organType : organTypes) {
            if (!HussarUtils.isNotEmpty(organTypeSeqMap.get(organType)) || (Integer)organTypeSeqMap.get(organType) <= seq) continue;
            type = organType;
            seq = (Integer)organTypeSeqMap.get(organType);
        }
        return type;
    }

    private void buildOrganTypeSeqMap(String organTypeCode, Integer seq, Map<String, Integer> organTypeSeqMap, Map<String, SysOrganType> organTypeMap) {
        SysOrganType organType = organTypeMap.get(organTypeCode);
        if (HussarUtils.isNotEmpty((Object)organType)) {
            organTypeSeqMap.put(organType.getOrganType(), seq);
            this.buildOrganTypeSeqMap(organType.getParentType(), seq + 1, organTypeSeqMap, organTypeMap);
        }
    }

    @Override
    public List<ReadOnlyOrganizationTreeVo> lazyLoadOrganizationTreeNoPermissions(Long parentId, String organProperty) {
        Long innerOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        ArrayList<ReadOnlyOrganizationTreeVo> result = new ArrayList<ReadOnlyOrganizationTreeVo>();
        Long gradeRootId = null;
        if (HussarUtils.equals((Object)innerOrganNodeId, (Object)parentId) || HussarUtils.equals((Object)outOrganNodeId, (Object)parentId)) {
            if (HussarUtils.isEmpty((Object)(parentId = this.getGradeOrganType(parentId)))) {
                return result;
            }
            if (!HussarUtils.equals((Object)innerOrganNodeId, (Object)parentId) && !HussarUtils.equals((Object)outOrganNodeId, (Object)parentId)) {
                gradeRootId = parentId;
            }
        }
        List<OrganizationTreeVo> data = this.getGradeOrganizationTree(parentId, organProperty, gradeRootId);
        ReadOnlyOrganizationTreeVo readOnlyOrganizationTreeVo = null;
        if (HussarUtils.isNotEmpty(data)) {
            for (OrganizationTreeVo vo : data) {
                readOnlyOrganizationTreeVo = new ReadOnlyOrganizationTreeVo();
                readOnlyOrganizationTreeVo.setId(vo.getId());
                readOnlyOrganizationTreeVo.setLabel(vo.getLabel());
                readOnlyOrganizationTreeVo.setHasChildren(vo.getHasChildren());
                readOnlyOrganizationTreeVo.setChildren(vo.getChildren());
                readOnlyOrganizationTreeVo.setIcon(vo.getIcon());
                readOnlyOrganizationTreeVo.setStruType(vo.getStruType());
                readOnlyOrganizationTreeVo.setStruLevel(vo.getStruLevel());
                readOnlyOrganizationTreeVo.setParentId(vo.getParentId());
                readOnlyOrganizationTreeVo.setOrganProperty(vo.getOrganProperty());
                result.add(readOnlyOrganizationTreeVo);
            }
        }
        return HussarTreeParser.getTreeList(result);
    }
}

