/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.extend.dao.HussarBaseStaffExtendWebMapper;
import com.jxdinfo.hussar.authorization.extend.model.StaffExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseStaffExtendWebService;
import com.jxdinfo.hussar.authorization.extend.service.ImportExcelStaffExtendManager;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendStaffInfoVo;
import com.jxdinfo.hussar.authorization.extend.vo.SysStaffExtendVo;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dto.StaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.SortStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.manager.ValidateUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.properties.HussarSystemIdProperties;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.staffmanager.StaffChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorizationextend.staff.impl.hussarBaseStaffExtendServiceImpl")
@HussarTokenDs
public class HussarBaseStaffExtendWebWebServiceImpl
implements IHussarBaseStaffExtendWebService {
    protected static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseStaffExtendWebWebServiceImpl.class);
    @Resource
    private AddStaffManager addStaffManager;
    @Resource
    private DeleteStaffManager deleteStaffManager;
    @Resource
    private EditStaffManager editStaffManager;
    @Resource
    private SortStaffManager sortStaffManager;
    @Autowired
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    protected ICreateUserConfigService createUserConfigService;
    @Autowired
    private ValidateUserManager validateUserManager;
    @Autowired
    protected ISysUsersService sysUsersService;
    @Autowired
    protected IHussarPwdConfigService pwdConfigService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Autowired
    protected ISysStaffAuditService sysStaffAuditService;
    @Resource
    protected SysStaffMapper sysStaffMapper;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    protected ISysStaffService sysStaffService;
    @Autowired
    protected ISysStruStaffService sysStruStaffService;
    @Resource
    protected StaffChangeNotify staffChangeNotify;
    @Autowired
    protected ISysStruStaffAuditService sysStruStaffAuditService;
    @Autowired
    protected UserChangeNotify userChangeNotify;
    @Autowired
    protected ISysStruUserService sysStruUserService;
    @Autowired
    private ISysUserRoleService userRoleService;
    @Autowired
    private IConvertPinyinService convertPinyinService;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Autowired
    protected ISysUsersAuditService sysUsersAuditService;
    @Autowired
    protected HussarBaseStaffExtendWebMapper hussarBaseStaffExtendWebMapper;
    @Autowired
    private ImportExcelStaffExtendManager importExcelStaffExtendManager;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    private HussarSystemIdProperties hussarSystemIdProperties;

    public ApiResponse<String> sortUnifyStaff(List<SysStaffExtendVo> list) {
        List idList = list.stream().map(SysStaffExtendVo::getRECORD_ID).collect(Collectors.toList());
        this.sortStaffManager.sortUnifyStaff(idList);
        return ApiResponse.success();
    }

    public ApiResponse<String> deleteStaff(String ids) {
        List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        for (Long id : idList) {
            this.deleteStaffManager.delete(id);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<String> saveStaffOrgan(StaffDto staffDto) {
        StringBuilder stringBuilder = new StringBuilder("");
        SysStaff oldStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysStaff::getId, (Object)staffDto.getId()));
        if (HussarUtils.isNotEmpty((Object)oldStaff)) {
            this.dealSaveOrUpdate(staffDto);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
            return ApiResponse.success((String)stringBuilder.toString());
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
    }

    public ApiResponse<List<ExtendStaffInfoVo>> getStaffInfo(String struId) {
        Long inOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        ArrayList result = new ArrayList();
        Long parentId = null;
        if (HussarUtils.isNotEmpty((Object)struId)) {
            parentId = Long.parseLong(struId);
        }
        if (HussarUtils.equals((Object)inOrganNodeId, parentId) || HussarUtils.equals((Object)outOrganNodeId, (Object)parentId)) {
            if (HussarUtils.isEmpty((Object)(parentId = this.queryOrganizationManager.getGradeOrganType(parentId, SecurityUser.convert((UserDetails)EngineUtil.getUser()))))) {
                return ApiResponse.success(result);
            }
            if (!HussarUtils.equals((Object)inOrganNodeId, (Object)parentId) && !HussarUtils.equals((Object)outOrganNodeId, (Object)parentId)) {
                struId = parentId.toString();
            }
        }
        if (inOrganNodeId.toString().equals(struId)) {
            List<ExtendStaffInfoVo> staffInfoVoList = this.validateOrganFname(this.hussarBaseStaffExtendWebMapper.getStaffInfo(null, "0"));
            return ApiResponse.success(staffInfoVoList);
        }
        if (outOrganNodeId.toString().equals(struId)) {
            List<ExtendStaffInfoVo> staffInfoVoList = this.validateOrganFname(this.hussarBaseStaffExtendWebMapper.getStaffInfo(null, "1"));
            return ApiResponse.success(staffInfoVoList);
        }
        String struFid = "";
        if (HussarUtils.isNotEmpty((Object)struId)) {
            struFid = "%/" + struId + "/%";
        }
        List<ExtendStaffInfoVo> staffInfoVoList = this.validateOrganFname(this.hussarBaseStaffExtendWebMapper.getStaffInfo(struFid, null));
        return ApiResponse.success(staffInfoVoList);
    }

    private List<ExtendStaffInfoVo> validateOrganFname(List<ExtendStaffInfoVo> extendStaffInfoVoList) {
        if (HussarUtils.isNotEmpty(extendStaffInfoVoList)) {
            ArrayList<ExtendStaffInfoVo> resultVoList = new ArrayList<ExtendStaffInfoVo>();
            Map<String, List<ExtendStaffInfoVo>> staffInfoMap = extendStaffInfoVoList.stream().collect(Collectors.groupingBy(ExtendStaffInfoVo::getStaffId));
            for (String key : staffInfoMap.keySet()) {
                List<ExtendStaffInfoVo> staffInfoVoList = staffInfoMap.get(key);
                StringBuilder organFname = new StringBuilder(staffInfoVoList.get(0).getOrganFname());
                for (int i = 1; i < staffInfoVoList.size(); ++i) {
                    organFname.append(",");
                    organFname.append(staffInfoVoList.get(i).getOrganFname());
                }
                staffInfoVoList.get(0).setOrganFname(organFname.toString());
                ExtendStaffInfoVo extendStaffInfoVo = new ExtendStaffInfoVo();
                BeanUtils.copyProperties((Object)staffInfoVoList.get(0), (Object)extendStaffInfoVo);
                resultVoList.add(extendStaffInfoVo);
            }
            return resultVoList;
        }
        return extendStaffInfoVoList;
    }

    public ApiResponse<SysStaff> add(StaffDto staffDto) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (HussarUtils.isNotEmpty((Object)this.sysStaffService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysStaff::getId, (Object)staffDto.getId())))) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_STAFF_EXIST.getMessage()));
        }
        SysStaff sysStaff = new SysStaff();
        long id = IdWorker.getId((Object)sysStaff);
        staffDto.setId(Long.valueOf(id));
        Integer maxOrder = this.sysStaffMapper.getMaxOrder();
        sysStaff.setStaffOrder(Integer.valueOf(maxOrder != null ? maxOrder + 1 : 1));
        String code = this.getCode(staffDto.getStaffCode());
        staffDto.setStaffCode(code);
        BeanUtil.copy((Object)staffDto, (Object)sysStaff);
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            this.validateUserManager.validateLimit();
            this.sysStaffService.save((Object)sysStaff);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
            this.dealSaveOrUpdate(staffDto);
            this.staffChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStaff});
            this.syncUser(staffDto);
        } else if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
            List audits = this.sysStaffAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStaffCode, (Object)staffDto.getStaffCode())).eq(SysStaffAudit::getAuditStatus, (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)audits)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_CODE_REVIEW.getMessage()));
            }
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            BeanUtil.copy((Object)sysStaff, (Object)sysStaffAudit);
            long sysStaffAuditId = IdWorker.getId((Object)sysStaffAudit);
            sysStaffAudit.setId(Long.valueOf(sysStaffAuditId));
            sysStaffAudit.setRealStaffId(sysStaff.getId());
            sysStaffAudit.setAuditStatus("0");
            sysStaffAudit.setOperateType("1");
            this.sysStaffAuditService.save((Object)sysStaffAudit);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage()));
            this.auditDealSaveOrUpdate(staffDto);
        } else {
            this.sysStaffService.save((Object)sysStaff);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
            this.dealSaveOrUpdate(staffDto);
            this.staffChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStaff});
        }
        return ApiResponse.success((Object)sysStaff);
    }

    public ApiResponse<String> edit(StaffDto staffDto) {
        StringBuilder stringBuilder = new StringBuilder();
        SysStaff oldStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysStaff::getId, (Object)staffDto.getId()));
        if (HussarUtils.isNotEmpty((Object)oldStaff)) {
            SysUsers user;
            SysStaff staff = new SysStaff();
            BeanUtil.copy((Object)staffDto, (Object)staff);
            staff.setStaffOrder(oldStaff.getStaffOrder());
            boolean flag = this.compareStaff(staff, oldStaff);
            if (this.createUserConfigService.isOperateStaffWithUser()) {
                if (!flag) {
                    this.sysStaffService.updateById((Object)staff);
                }
                List<Long> delStruIds = this.dealSaveOrUpdate(staffDto);
                this.staffChangeNotify.notify(DataChangeType.UPDATE, new Object[]{staff});
                this.syncUserEdit(staffDto, delStruIds);
                stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
                return ApiResponse.success((String)stringBuilder.toString());
            }
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
                if (!flag) {
                    SysStaffAudit sysStaffAudit1 = (SysStaffAudit)this.sysStaffAuditService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getRealStaffId, (Object)staff.getId())).eq(SysStaffAudit::getAuditStatus, (Object)"0"));
                    if (HussarUtils.isNotEmpty((Object)sysStaffAudit1)) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
                    }
                    SysStaffAudit sysStaffAudit = new SysStaffAudit();
                    BeanUtil.copy((Object)staff, (Object)sysStaffAudit);
                    long sysStaffAuditId = IdWorker.getId((Object)sysStaffAudit);
                    sysStaffAudit.setId(Long.valueOf(sysStaffAuditId));
                    sysStaffAudit.setRealStaffId(staff.getId());
                    sysStaffAudit.setAuditStatus("0");
                    sysStaffAudit.setOperateType("2");
                    LocalDateTime now = LocalDateTime.now();
                    sysStaffAudit.setCreateTime(now);
                    sysStaffAudit.setLastTime(now);
                    this.sysStaffAuditService.save((Object)sysStaffAudit);
                }
                this.dealSaveOrUpdate(staffDto);
                this.staffChangeNotify.notify(DataChangeType.UPDATE, new Object[]{oldStaff});
                if (flag) {
                    stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
                } else {
                    stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage()));
                }
                return ApiResponse.success((String)stringBuilder.toString());
            }
            if (!flag) {
                user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffDto.getId())).ne(SysUsers::getAccountStatus, (Object)"2"));
                if (HussarUtils.isNotEmpty((Object)user)) {
                    this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getId, (Object)user.getId())).set(SysUsers::getUserName, (Object)staffDto.getName()));
                }
                this.sysStaffService.updateById((Object)staff);
            }
            this.dealSaveOrUpdate(staffDto);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
            this.sysUsersAuditService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsersAudit::getEmployeeId, (Object)staff.getId())).set(SysUsersAudit::getUserName, (Object)staffDto.getName()));
            this.staffChangeNotify.notify(DataChangeType.UPDATE, new Object[]{staff});
            user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffDto.getId())).ne(SysUsers::getAccountStatus, (Object)"2"));
            this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
            return ApiResponse.success((String)stringBuilder.toString());
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
    }

    public ApiResponse<List<String>> getUserByStruId(Long appId, Long formId, String ids) {
        List<String> delIdList = Arrays.asList(ids.split(","));
        List sysUsers = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, delIdList));
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            List<Object> nameList = new ArrayList();
            nameList = sysUsers.stream().map(SysUsers::getUserName).collect(Collectors.toList());
            return ApiResponse.success(nameList);
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<List<SysStaff>> getStaffInfoByName(List<String> nameList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysStaff::getName, nameList);
        return ApiResponse.success((Object)this.sysStaffService.list((Wrapper)queryWrapper));
    }

    public ApiResponse<ExcelCheckResult> saveStaffBatch(List<StaffExtendExcel> userExtendList) {
        ExcelCheckResult result = this.importExcelStaffExtendManager.check(userExtendList, new ArrayList<Object>());
        List errDataList = result.getErrDatas();
        List newDataList = result.getNewDatas();
        List updateDataList = result.getUpdateDatas();
        Object customExcelCheckResult = result.getCheckMsg();
        if (HussarUtils.isNotEmpty((Object)errDataList)) {
            throw new BaseException();
        }
        this.saveOrUpdateImport(newDataList, updateDataList);
        return ApiResponse.success((Object)result);
    }

    public void saveOrUpdateImport(List<StaffExtendExcel> newDataList, List<StaffExtendExcel> updateDataList) {
        if (HussarUtils.isNotEmpty(newDataList)) {
            this.importExcelStaffExtendManager.saveData(newDataList, new ArrayList<Object>());
        }
        if (HussarUtils.isNotEmpty(updateDataList)) {
            this.importExcelStaffExtendManager.updateData(updateDataList, new ArrayList<Object>());
        }
    }

    private String getCode(String code) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF");
                lambdaQueryWrapper.eq(SysStaff::getStaffCode, (Object)code);
                currentCount = this.sysStaffMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysStaff::getStaffCode, (Object)code);
            currentCount = this.sysStaffMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_CODE.getMessage()));
            }
        }
        return code;
    }

    private void syncUser(StaffDto staffDto) {
        boolean isUpper = false;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && StringUtils.isNotBlank((CharSequence)staffDto.getName()) && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)staffDto.getName())) {
            isUpper = true;
        }
        if (this.sysUsersService.isExistAccount(isUpper ? staffDto.getName().toUpperCase() : staffDto.getName())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
        }
        SysUsers user = this.initUser(staffDto, isUpper);
        this.sysUsersService.save((Object)user);
        this.handleRelation(user, staffDto);
        this.userChangeNotify.notify(DataChangeType.INSERT, new Object[]{user});
    }

    private void handleRelation(SysUsers user, StaffDto staffDto) {
        Long userId = user.getId();
        String struIds = StringUtils.trimToEmpty((String)staffDto.getOrganId());
        ArrayList<Long> organIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            organIdList.addAll(Arrays.asList(temp));
        }
        ArrayList<SysStruUser> struUsers = new ArrayList<SysStruUser>();
        for (Long struId : organIdList) {
            SysStruUser struUser = new SysStruUser();
            struUser.setStruId(struId);
            struUser.setUserId(userId);
            struUsers.add(struUser);
        }
        this.sysStruUserService.saveBatch(struUsers, struUsers.size());
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(user.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.userRoleService.save((Object)userRole);
    }

    private SysUsers initUser(StaffDto staffDto, Boolean isUpper) {
        SysUsers user = new SysUsers();
        long id = IdWorker.getId((Object)user);
        user.setId(Long.valueOf(id));
        user.setUserAccount(isUpper != false ? staffDto.getName().toUpperCase() : staffDto.getName());
        user.setUserName(StringUtils.trimToEmpty((String)staffDto.getName()));
        user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(StringUtils.trimToEmpty((String)staffDto.getName())));
        user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(StringUtils.trimToEmpty((String)staffDto.getName())));
        user.setAccountStatus(UserStatus.OK.getCode());
        user.setMaxSessions(Integer.valueOf(1));
        user.setSecurityLevel(Integer.valueOf(this.protectionStatusConfigBoService.isFenBaoEnable() != false ? 60 : 1));
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        user.setTypeProperty("1");
        user.setEmployeeId(staffDto.getId());
        Integer userOrder = this.sysUsersMapper.getUserMaxOrder();
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        user.setCorporationId(user.getDepartmentId());
        user.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
        String secure = this.pwdConfigService.getDefaultPassword();
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue()) {
            AssertUtil.isNotEmpty((String)user.geteMail(), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CREATE_USER_MAST_SEND_EMAIL.getMessage()));
            if (!this.createUserConfigService.getCreateUserUseDefaultPass().booleanValue()) {
                secure = GeneratePassword.generate((String)this.pwdConfigService.getPwdRule());
            }
        }
        String encodeSecure = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
        user.setPassword(encodeSecure);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && HussarUtils.isNotBlank((CharSequence)user.geteMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)user, (String)secure);
        }
        return user;
    }

    protected List<Long> dealSaveOrUpdate(StaffDto staffDto) {
        List<Long> organIdList;
        if (HussarUtils.isEmpty((Object)staffDto.getOrganId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        String regex = "[,\uff0c]";
        String[] organIds = staffDto.getOrganId().split(regex);
        List<Long> organId = organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
        List<Long> delIdList = new ArrayList<Long>();
        List sysOrganStaffs = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffDto.getId()));
        if (HussarUtils.isNotEmpty((Object)sysOrganStaffs)) {
            List<Long> dataBankOrganIds = sysOrganStaffs.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
            organId = this.contrastAddOrDel(organIdList, dataBankOrganIds);
            delIdList = this.contrastAddOrDel(dataBankOrganIds, organIdList);
            if (HussarUtils.isNotEmpty(delIdList)) {
                this.sysStruStaffService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffDto.getId())).in(SysStruStaff::getStruId, delIdList));
            }
        }
        ArrayList<SysStruStaff> struStaffs = new ArrayList<SysStruStaff>();
        for (Long id : organId) {
            SysStruStaff sysOrganStaff = new SysStruStaff();
            sysOrganStaff.setStruId(id);
            sysOrganStaff.setStaffId(staffDto.getId());
            struStaffs.add(sysOrganStaff);
        }
        this.sysStruStaffService.saveBatch(struStaffs);
        return delIdList;
    }

    protected List<Long> contrastAddOrDel(List<Long> list, List<Long> secondList) {
        return list.stream().filter(item -> !secondList.contains(item)).collect(Collectors.toList());
    }

    protected void auditDealSaveOrUpdate(StaffDto staffDto) {
        if (HussarUtils.isEmpty((Object)staffDto.getOrganId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        String regex = "[,\uff0c]";
        String[] organIds = staffDto.getOrganId().split(regex);
        List organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
        this.sysStruStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaffAudit::getStaffId, (Object)staffDto.getId()));
        for (Long id : organIdList) {
            SysStruStaffAudit sysStruStaffAudit = new SysStruStaffAudit();
            sysStruStaffAudit.setStruId(id);
            sysStruStaffAudit.setStaffId(staffDto.getId());
            sysStruStaffAudit.setAuditStatus("0");
            sysStruStaffAudit.setOperateType("1");
            this.sysStruStaffAuditService.save((Object)sysStruStaffAudit);
        }
    }

    private boolean compareStaff(SysStaff newStaff, SysStaff oldStaff) {
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getName()), (Object)StringUtils.trimToEmpty((String)oldStaff.getName()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getSex()), (Object)StringUtils.trimToEmpty((String)oldStaff.getSex()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getStaffCode()), (Object)StringUtils.trimToEmpty((String)oldStaff.getStaffCode()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getStaffPosition()), (Object)StringUtils.trimToEmpty((String)oldStaff.getStaffPosition()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getAddress()), (Object)StringUtils.trimToEmpty((String)oldStaff.getAddress()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getBirthday()), (Object)StringUtils.trimToEmpty((String)oldStaff.getBirthday()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getGraduateDate()), (Object)StringUtils.trimToEmpty((String)oldStaff.getGraduateDate()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getGraduateSchool()), (Object)StringUtils.trimToEmpty((String)oldStaff.getGraduateSchool()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getIdcard()), (Object)StringUtils.trimToEmpty((String)oldStaff.getIdcard()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getWorkDate()), (Object)StringUtils.trimToEmpty((String)oldStaff.getWorkDate()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getWorkId()), (Object)StringUtils.trimToEmpty((String)oldStaff.getWorkId()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getRemark()), (Object)StringUtils.trimToEmpty((String)oldStaff.getRemark()))) {
            return false;
        }
        return HussarUtils.equals((Object)newStaff.getStaffOrder(), (Object)oldStaff.getStaffOrder());
    }

    private void syncUserEdit(StaffDto staffDto, List<Long> delStruIds) {
        List addOrganIds;
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffDto.getId())).ne(SysUsers::getAccountStatus, (Object)"2"));
        if (HussarUtils.isEmpty((Object)user)) {
            return;
        }
        String struIds = StringUtils.trimToEmpty((String)staffDto.getOrganId());
        AssertUtil.isNotEmpty((String)struIds, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_STAFF_NO_CONNECT_ORGAN.getMessage()));
        List<String> struIdList = Arrays.asList(struIds.split(","));
        Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
        ArrayList<Long> currentStaffOrganIds = new ArrayList<Long>(Arrays.asList(temp));
        this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getId, (Object)user.getId())).set(SysUsers::getUserName, (Object)staffDto.getName())).set(SysUsers::getUserNamePinyinFull, (Object)this.convertPinyinService.getNameFullPinyin(staffDto.getName()))).set(SysUsers::getUserNamePinyinInitial, (Object)this.convertPinyinService.getNameInitialsPinyin(staffDto.getName())));
        List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List oldUserOrganIds = struUsers.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(delStruIds)) {
            List newDelOrganIds = delStruIds.stream().filter(oldUserOrganIds::contains).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(newDelOrganIds)) {
                this.sysStruUserService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId())).in(SysStruUser::getStruId, newDelOrganIds));
                this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SysUsers::getDepartmentId, (Object)struIdList.get(0))).eq(SysUsers::getId, (Object)user.getId()));
            }
        }
        if (HussarUtils.isNotEmpty(addOrganIds = currentStaffOrganIds.stream().filter(item -> !oldUserOrganIds.contains(item)).collect(Collectors.toList()))) {
            ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
            for (Long struId : addOrganIds) {
                SysStruUser struUser = new SysStruUser();
                struUser.setStruId(struId);
                struUser.setUserId(user.getId());
                struUserList.add(struUser);
            }
            this.sysStruUserService.saveBatch(struUserList, struUserList.size());
        }
    }
}

