/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.extend.model.OrganExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.ImportExcelOrganExtendManager;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.enums.ExcelOrganEnum;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganInfoVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import org.springframework.util.LinkedMultiValueMap;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.importExcelOrganExtendManagerImpl")
public class ImportExcelOrganExtendManagerImpl
extends CommonOrganizationManager
implements ImportExcelOrganExtendManager {
    @Resource
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    @Override
    public void saveData(List<OrganExtendExcel> datas, List<Object> otherParams) {
        Object organProperty;
        ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
        ArrayList<SysStru> struList = new ArrayList<SysStru>();
        ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
        ArrayList<SysStru> updateStruList = new ArrayList<SysStru>();
        HashMap<String, SysOrganType> organNameAndOrganMap = new HashMap<String, SysOrganType>();
        HashMap<String, String> organTypeAndNameMap = new HashMap<String, String>();
        this.getAllOrganType(organNameAndOrganMap, organTypeAndNameMap);
        ArrayList<OrganExtendExcel> inData = new ArrayList<OrganExtendExcel>();
        ArrayList<OrganExtendExcel> outData = new ArrayList<OrganExtendExcel>();
        HashMap<String, Integer> firstLevelOrderMap = new HashMap<String, Integer>();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getStruLevel, (Object)1)).orderByAsc(SysStru::getStruSeq);
        List firstStrus = this.sysStruMapper.selectList((Wrapper)queryWrapper);
        List list = firstStrus.stream().map(SysStru::getStruOrder).collect(Collectors.toList());
        HashSet<Integer> changeStru = new HashSet<Integer>();
        List users = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()));
        Map userMap = users.stream().collect(Collectors.toMap(SysUsers::getUserAccount, Function.identity()));
        ArrayList<Integer> orderExcelList = new ArrayList<Integer>();
        LinkedHashSet<String> firstLevelNoOrder = new LinkedHashSet<String>();
        for (OrganExtendExcel organExtendExcel : datas) {
            String userAccount = organExtendExcel.getUserAccount();
            if (HussarUtils.isNotBlank((CharSequence)userAccount) && HussarUtils.isNotEmpty(userMap.get(userAccount))) {
                SysUsers user = (SysUsers)userMap.get(userAccount);
                organExtendExcel.setPrincipalId(user.getId());
            }
            if (HussarUtils.equals((Object)(organProperty = organExtendExcel.getOrganProperty()), (Object)ExcelOrganEnum.ORGAN_IN.getValue()) || HussarUtils.isBlank((CharSequence)organProperty)) {
                inData.add(organExtendExcel);
                organProperty = ExcelOrganEnum.ORGAN_IN.getValue();
            }
            if (HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_OUT.getValue())) {
                outData.add(organExtendExcel);
            }
            if (!HussarUtils.isEmpty((Object)organExtendExcel.getParentOrganNames())) continue;
            String organName = organExtendExcel.getOrganName();
            String organFname = "/" + organName;
            if (HussarUtils.isNotEmpty((Object)organExtendExcel.getStruOrder())) {
                int index;
                Integer struOrder = Integer.parseInt(organExtendExcel.getStruOrder());
                struOrder = this.initFirstLevelOrder(struOrder, orderExcelList);
                organExtendExcel.setStruOrder(String.valueOf(struOrder));
                firstLevelOrderMap.put(organFname + "_" + (String)organProperty, struOrder);
                if (!list.contains(struOrder)) continue;
                for (int n = index = list.indexOf(struOrder); n < list.size(); ++n) {
                    Integer order = (Integer)list.get(n);
                    list.set(n, order + 1);
                    changeStru.add(n);
                }
                continue;
            }
            firstLevelNoOrder.add(organFname + "_" + (String)organProperty);
        }
        if (HussarUtils.isNotEmpty(firstLevelNoOrder)) {
            Integer order = 0;
            if (HussarUtils.isNotEmpty(list)) {
                order = (Integer)list.get(list.size() - 1);
            }
            for (String fName : firstLevelNoOrder) {
                organProperty = order;
                Integer n = order = Integer.valueOf(order + 1);
                firstLevelOrderMap.put(fName, order);
            }
        }
        if (HussarUtils.isNotEmpty(changeStru)) {
            for (Integer n : changeStru) {
                Integer order = (Integer)list.get(n);
                SysStru sysStru = (SysStru)firstStrus.get(n);
                sysStru.setStruOrder(order);
                sysStru.setStruSeq("/" + String.format("%04d", order));
                updateStruList.add(sysStru);
            }
        }
        if (HussarUtils.isNotEmpty(inData)) {
            this.initOrganData(inData, organNameAndOrganMap, updateStruList, organList, struList, officeList, firstLevelOrderMap, ExcelOrganEnum.ORGAN_IN.getValue());
        }
        if (HussarUtils.isNotEmpty(outData)) {
            this.initOrganData(outData, organNameAndOrganMap, updateStruList, organList, struList, officeList, firstLevelOrderMap, ExcelOrganEnum.ORGAN_OUT.getValue());
        }
        this.sysOrganService.saveBatch(organList);
        this.sysStruService.saveOrUpdateBatch(struList);
        this.sysOfficeService.saveBatch(officeList);
        this.sysStruService.updateBatchById(updateStruList);
        this.refreshStruSeq();
    }

    private void refreshStruSeq() {
        List strus = this.sysStruMapper.selectList(null);
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)organsEntity.getParentId()) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)organsEntity.getParentId())).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
        this.sysStruService.updateBatchById((Collection)strus);
    }

    private void setInfo(SysStru root, List<SysStru> all) {
        AtomicInteger index = new AtomicInteger(1);
        all.stream().filter(stru -> HussarUtils.equals((Object)stru.getParentId(), (Object)root.getId())).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, all);
            return stru;
        }).collect(Collectors.toList());
    }

    private Integer initFirstLevelOrder(Integer struOrder, List<Integer> orderExcelList) {
        if (!orderExcelList.contains(struOrder)) {
            orderExcelList.add(struOrder);
            return struOrder;
        }
        Integer n = struOrder;
        Integer n2 = struOrder = Integer.valueOf(struOrder + 1);
        return this.initFirstLevelOrder(struOrder, orderExcelList);
    }

    @Override
    public void updateData(List<OrganExtendExcel> datas, List<Object> otherParams) {
        ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
        ArrayList<SysStru> struList = new ArrayList<SysStru>();
        ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
        ArrayList<SysStru> updateStruList = new ArrayList<SysStru>();
        ArrayList<OrganExtendExcel> inData = new ArrayList<OrganExtendExcel>();
        ArrayList<OrganExtendExcel> outData = new ArrayList<OrganExtendExcel>();
        for (OrganExtendExcel organExcel : datas) {
            String organProperty = organExcel.getOrganProperty();
            if (HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_IN.getValue()) || HussarUtils.isBlank((CharSequence)organProperty)) {
                inData.add(organExcel);
            }
            if (!HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_OUT.getValue())) continue;
            outData.add(organExcel);
        }
        List users = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()));
        Map<String, SysUsers> userMap = users.stream().collect(Collectors.toMap(SysUsers::getUserAccount, Function.identity()));
        if (HussarUtils.isNotEmpty(inData)) {
            this.initUpdateOrganData(inData, organList, struList, officeList, ExcelOrganEnum.ORGAN_IN.getValue(), userMap, updateStruList);
        }
        if (HussarUtils.isNotEmpty(outData)) {
            this.initUpdateOrganData(outData, organList, struList, officeList, ExcelOrganEnum.ORGAN_OUT.getValue(), userMap, updateStruList);
        }
        this.sysStruService.updateBatchById(updateStruList);
        this.sysOrganService.updateBatchById(organList);
        this.sysStruService.updateBatchById(struList);
        this.sysOfficeService.updateBatchById(officeList);
        this.refreshStruSeq();
    }

    private void getAllOrganType(Map<String, SysOrganType> typeNameAndOrganMap, Map<String, String> organTypeAndNameMap) {
        List organTypeList = this.sysOrganTypeService.getOrgTypeExcludeStaff();
        for (SysOrganType sysOrganType : organTypeList) {
            String organTypeName = sysOrganType.getTypeName();
            String organType = sysOrganType.getOrganType();
            typeNameAndOrganMap.put(organTypeName, sysOrganType);
            organTypeAndNameMap.put(organType, organTypeName);
        }
    }

    private void initOrganData(List<OrganExtendExcel> datas, Map<String, SysOrganType> organNameAndOrganMap, List<SysStru> updateStruList, List<SysOrgan> organList, List<SysStru> struList, List<SysOffice> officeList, Map<String, Integer> firstLevelOrderMap, String organProperty) {
        HashMap<String, SearchOrganInfoVo> organMap = new HashMap<String, SearchOrganInfoVo>();
        HashMap<Long, SearchOrganInfoVo> organIdMap = new HashMap<Long, SearchOrganInfoVo>();
        LinkedMultiValueMap fNameStruMap = new LinkedMultiValueMap();
        this.initDbOrgan(organMap, organIdMap, (LinkedMultiValueMap<String, SearchOrganInfoVo>)fNameStruMap, organProperty);
        LinkedMultiValueMap multiValueLevelMap = new LinkedMultiValueMap();
        LinkedMultiValueMap multiValueParentMap = new LinkedMultiValueMap();
        HashMap<String, OrganExtendExcel> organExcelMap = new HashMap<String, OrganExtendExcel>();
        this.initExcelOrgan(datas, (LinkedMultiValueMap<Integer, OrganExtendExcel>)multiValueLevelMap, (LinkedMultiValueMap<String, OrganExtendExcel>)multiValueParentMap, organExcelMap);
        HashMap<String, SysStru> struExcelMap = new HashMap<String, SysStru>();
        ArrayList levels = new ArrayList(multiValueLevelMap.keySet());
        Collections.sort(levels);
        for (Integer level : levels) {
            List excels = multiValueLevelMap.get((Object)level);
            for (int i = 0; i < excels.size(); ++i) {
                OrganExtendExcel organExcel = (OrganExtendExcel)excels.get(i);
                SysOrgan organ = new SysOrgan();
                SysStru stru = new SysStru();
                SysOffice office = new SysOffice();
                long organId = organExcel.getOrganId();
                long struId = HussarUtils.isEmpty((Object)((OrganExtendExcel)excels.get(i)).getStruId()) ? IdWorker.getId((Object)stru) : Long.parseLong(((OrganExtendExcel)excels.get(i)).getStruId());
                organ.setOrganProperty(organProperty);
                this.initOrgan(organExcel, organNameAndOrganMap, organExcelMap, organMap, level, organ, organId);
                this.initStru(organExcel, updateStruList, (LinkedMultiValueMap<String, OrganExtendExcel>)multiValueParentMap, organExcelMap, organMap, (LinkedMultiValueMap<String, SearchOrganInfoVo>)fNameStruMap, struExcelMap, stru, organId, struId, level, organ.getOrganType(), firstLevelOrderMap, organProperty);
                office.setStruId(Long.valueOf(struId));
                office.setOfficeAlias(organExcel.getOfficeAlias());
                office.setOfficeAddress(organExcel.getOfficeAddress());
                organList.add(organ);
                struList.add(stru);
                officeList.add(office);
            }
        }
    }

    private void initDbOrgan(Map<String, SearchOrganInfoVo> organMap, Map<Long, SearchOrganInfoVo> organIdMap, LinkedMultiValueMap<String, SearchOrganInfoVo> fNameStruMap, String organProperty) {
        List organs = this.sysStruMapper.getAllOrganInfo(null, organProperty);
        for (SearchOrganInfoVo organ : organs) {
            Long parentId = organ.getParentId();
            if (!HussarUtils.equals((Object)parentId, (Object)11L) && !HussarUtils.equals((Object)parentId, (Object)12L)) {
                SearchOrganInfoVo pOrgan = organIdMap.get(parentId);
                String pOrganFname = pOrgan.getOrganFname();
                fNameStruMap.add((Object)pOrganFname, (Object)organ);
            } else {
                fNameStruMap.add((Object)"", (Object)organ);
            }
            organMap.put(organ.getOrganFname(), organ);
            organIdMap.put(organ.getStruId(), organ);
        }
    }

    private void initExcelOrgan(List<OrganExtendExcel> datas, LinkedMultiValueMap<Integer, OrganExtendExcel> multiValueLevelMap, LinkedMultiValueMap<String, OrganExtendExcel> multiValueParentMap, Map<String, OrganExtendExcel> organExcelMap) {
        for (OrganExtendExcel organExcel : datas) {
            String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
            String organName = organExcel.getOrganName();
            String organFname = parentOrganNames + "/" + organName;
            String organCode = organExcel.getOrganCode();
            int level = 1;
            if (HussarUtils.isNotBlank((CharSequence)parentOrganNames)) {
                long count = parentOrganNames.chars().filter(item -> HussarUtils.equals((Object)item, (Object)47)).count();
                level = Integer.parseInt(Long.toString(count)) + 1;
            }
            if (HussarUtils.isBlank((CharSequence)organCode)) {
                SysOrgan organ = new SysOrgan();
                organCode = this.getOrganCode(organ);
                organExcel.setOrganCode(organCode);
            }
            multiValueLevelMap.add((Object)level, (Object)organExcel);
            multiValueParentMap.add((Object)parentOrganNames, (Object)organExcel);
            organExcelMap.put(organFname, organExcel);
        }
        if (this.sysBaseConfigService.isNotRedis()) {
            this.updateOrganCodeCacheToDb();
        }
    }

    private void initOrgan(OrganExtendExcel organExcel, Map<String, SysOrganType> organNameAndOrganMap, Map<String, OrganExtendExcel> organExcelMap, Map<String, SearchOrganInfoVo> organMap, Integer level, SysOrgan organ, long organId) {
        String organName = organExcel.getOrganName();
        String parentOrganNames = HussarUtils.isEmpty((Object)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
        String organFname = parentOrganNames + "/" + organName;
        organ.setId(Long.valueOf(organId));
        organ.setOrganName(organName);
        organ.setOrganFname(organFname);
        String organType = organNameAndOrganMap.get(organExcel.getOrganTypeName()).getOrganType();
        organ.setOrganType(organType);
        if (HussarUtils.isBlank((CharSequence)organExcel.getShortName())) {
            organ.setShortName(organName);
        } else {
            organ.setShortName(organExcel.getShortName());
        }
        organ.setOrganCode(organExcel.getOrganCode());
        String organFcode = "/";
        String fullCode = this.getFullCode(organExcel, organMap, organExcelMap, organFcode, level);
        organ.setOrganFcode(fullCode);
        organ.setValidTimeLimitType(organExcel.getValidTimeLimitType());
        organ.setOrganNamePinyinFull(this.convertPinyinService.getFullPinyin(organName));
        organ.setOrganNamePinyinInitial(this.convertPinyinService.getInitialsPinyin(organName));
    }

    private String getFullCode(OrganExtendExcel organExcel, Map<String, SearchOrganInfoVo> organMap, Map<String, OrganExtendExcel> organExcelMap, String organFcode, Integer level) {
        String organCode = organExcel.getOrganCode();
        String parentOrganNames = organExcel.getParentOrganNames();
        if (OrganConstants.ORGAN_LEVEL.equals(level)) {
            organFcode = "/" + organCode + organFcode;
        } else if (organMap.containsKey(parentOrganNames)) {
            organFcode = organMap.get(parentOrganNames).getOrganFcode() + organCode + organFcode;
        } else {
            organFcode = "/" + organCode + organFcode;
            OrganExtendExcel excel = organExcelMap.get(parentOrganNames);
            organFcode = this.getFullCode(excel, organMap, organExcelMap, organFcode, level - 1);
        }
        return organFcode;
    }

    private void initStru(OrganExtendExcel organExcel, List<SysStru> updateStruList, LinkedMultiValueMap<String, OrganExtendExcel> multiValueParentMap, Map<String, OrganExtendExcel> organExcelMap, Map<String, SearchOrganInfoVo> organMap, LinkedMultiValueMap<String, SearchOrganInfoVo> fNameStruMap, Map<String, SysStru> struExcelMap, SysStru stru, long organId, long struId, int level, String organType, Map<String, Integer> firstLevelOrderMap, String organProperty) {
        String organName = organExcel.getOrganName();
        String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
        String organFname = parentOrganNames + "/" + organName;
        stru.setId(Long.valueOf(struId));
        stru.setOrganId(Long.valueOf(organId));
        stru.setStruType(organType);
        if (HussarUtils.isBlank((CharSequence)organExcel.getOrganAlias())) {
            stru.setOrganAlias(organName);
        } else {
            stru.setOrganAlias(organExcel.getOrganAlias());
        }
        if (OrganConstants.ORGAN_LEVEL.equals(level)) {
            Long parentId = HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_IN.getValue()) ? 11L : 12L;
            stru.setParentId(parentId);
        } else if (organExcelMap.containsKey(parentOrganNames)) {
            SysStru sysStru = struExcelMap.get(parentOrganNames);
            stru.setParentId(sysStru.getId());
        } else {
            SearchOrganInfoVo organInfoVo = organMap.get(parentOrganNames);
            stru.setParentId(organInfoVo.getStruId());
            String isLeaf = organInfoVo.getIsLeaf();
            if (!HussarUtils.equals((Object)isLeaf, (Object)"N")) {
                SysStru updateStru = new SysStru();
                updateStru.setIsLeaf("N");
                updateStru.setId(organInfoVo.getStruId());
                updateStruList.add(updateStru);
            }
        }
        stru.setStruLevel(Integer.valueOf(level));
        String struFid = "/";
        struFid = this.getFullStruId(organExcel, organExcelMap, organMap, struExcelMap, struId, struFid, level);
        stru.setStruFid(struFid);
        int order = 0;
        order = OrganConstants.ORGAN_LEVEL.equals(level) ? firstLevelOrderMap.get(organFname + "_" + organProperty).intValue() : this.getStruOrder(organExcel, updateStruList, multiValueParentMap, fNameStruMap, parentOrganNames, organFname);
        stru.setStruOrder(Integer.valueOf(order));
        stru.setIsLeaf("Y");
        if (multiValueParentMap.containsKey((Object)organFname)) {
            stru.setIsLeaf("N");
        }
        stru.setPrincipalId(organExcel.getPrincipalId());
        struExcelMap.put(organFname, stru);
    }

    private int getStruOrder(OrganExtendExcel organExcel, List<SysStru> updateStruList, LinkedMultiValueMap<String, OrganExtendExcel> multiValueParentMap, LinkedMultiValueMap<String, SearchOrganInfoVo> fNameStruMap, String parentOrganNames, String organFname) {
        int order = 0;
        List list = multiValueParentMap.get((Object)parentOrganNames);
        ArrayList<Integer> orderExcelList = new ArrayList<Integer>();
        ArrayList<String> excelNoOrderFnames = new ArrayList<String>();
        List childList = new ArrayList();
        List<Object> dbOrderList = new ArrayList();
        HashSet<Integer> changeStru = new HashSet<Integer>();
        if (fNameStruMap.containsKey((Object)parentOrganNames)) {
            childList = fNameStruMap.get((Object)parentOrganNames);
            dbOrderList = childList.stream().map(SearchOrganInfoVo::getStruOrder).collect(Collectors.toList());
        }
        for (int n = 0; n < list.size(); ++n) {
            OrganExtendExcel excel = (OrganExtendExcel)list.get(n);
            String name = excel.getOrganName();
            String excelParentOrganNames = excel.getParentOrganNames();
            String fullName = HussarUtils.isBlank((CharSequence)excelParentOrganNames) ? "/" + name : excelParentOrganNames + "/" + name;
            String struOrder = excel.getStruOrder();
            if (HussarUtils.isNotBlank((CharSequence)struOrder)) {
                Integer excelOrder = Integer.parseInt(struOrder);
                if (dbOrderList.contains(excelOrder = this.initFirstLevelOrder(excelOrder, orderExcelList))) {
                    int index;
                    for (int i = index = dbOrderList.indexOf(excelOrder); i < dbOrderList.size(); ++i) {
                        Integer num = (Integer)dbOrderList.get(i);
                        dbOrderList.set(i, num + 1);
                        changeStru.add(i);
                    }
                }
                if (!HussarUtils.equals((Object)fullName, (Object)organFname)) continue;
                order = excelOrder;
                continue;
            }
            excelNoOrderFnames.add(fullName);
        }
        if (HussarUtils.isBlank((CharSequence)organExcel.getStruOrder())) {
            int index = excelNoOrderFnames.indexOf(organFname);
            if (HussarUtils.isNotEmpty(dbOrderList)) {
                order = (Integer)dbOrderList.get(dbOrderList.size() - 1) + index + 1;
            } else if (HussarUtils.isNotEmpty(orderExcelList)) {
                Integer max = (Integer)Collections.max(orderExcelList);
                order = max + index + 1;
            } else {
                order = index + 1;
            }
        }
        if (HussarUtils.isNotEmpty(changeStru)) {
            for (Integer index : changeStru) {
                Integer struOrder = (Integer)dbOrderList.get(index);
                SearchOrganInfoVo searchOrganInfoVo = (SearchOrganInfoVo)childList.get(index);
                SysStru sysStru = new SysStru();
                sysStru.setId(searchOrganInfoVo.getStruId());
                sysStru.setStruOrder(struOrder);
                String seq = searchOrganInfoVo.getStruSeq();
                sysStru.setStruSeq(seq.substring(0, seq.lastIndexOf("/")) + "/" + String.format("%04d", struOrder));
                updateStruList.add(sysStru);
            }
        }
        return order;
    }

    private String getFullStruId(OrganExtendExcel organExcel, Map<String, OrganExtendExcel> organExcelMap, Map<String, SearchOrganInfoVo> organMap, Map<String, SysStru> struExcelMap, Long struId, String struFid, Integer level) {
        String parentOrganNames = organExcel.getParentOrganNames();
        if (OrganConstants.ORGAN_LEVEL.equals(level)) {
            struFid = "/" + struId + struFid;
        } else if (organMap.containsKey(parentOrganNames)) {
            SearchOrganInfoVo organInfoVo = organMap.get(parentOrganNames);
            struFid = organInfoVo.getStruFid() + struId + struFid;
        } else {
            struFid = "/" + struId + struFid;
            SysStru stru = struExcelMap.get(parentOrganNames);
            OrganExtendExcel excel = organExcelMap.get(parentOrganNames);
            struFid = this.getFullStruId(excel, organExcelMap, organMap, struExcelMap, stru.getId(), struFid, level - 1);
        }
        return struFid;
    }

    private void initUpdateOrganData(List<OrganExtendExcel> datas, List<SysOrgan> organList, List<SysStru> struList, List<SysOffice> officeList, String organProperty, Map<String, SysUsers> userMap, List<SysStru> updateStruList) {
        ArrayList<String> fullOrganNames = new ArrayList<String>();
        LinkedMultiValueMap excelOrganMap = new LinkedMultiValueMap();
        LinkedMultiValueMap excelIndexMap = new LinkedMultiValueMap();
        for (OrganExtendExcel organExcel : datas) {
            String organName = organExcel.getOrganName();
            String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
            String fullOrganName = parentOrganNames + "/" + organName;
            fullOrganNames.add(fullOrganName);
            if (HussarUtils.isNotBlank((CharSequence)organExcel.getStruOrder())) {
                excelOrganMap.add((Object)parentOrganNames, (Object)Integer.parseInt(organExcel.getStruOrder()));
                continue;
            }
            excelIndexMap.add((Object)parentOrganNames, (Object)fullOrganName);
        }
        List organs = this.sysStruMapper.getAllOrganInfo(LambdaQueryUtil.getSplitList(fullOrganNames), organProperty);
        Map map = organs.stream().collect(Collectors.toMap(SearchOrganInfoVo::getOrganFname, Function.identity()));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.isNotNull(SysStru::getParentId)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0'));
        List strus = this.sysStruMapper.selectList((Wrapper)queryWrapper);
        Map<Long, List<SysStru>> pMap = strus.stream().collect(Collectors.groupingBy(SysStru::getParentId));
        LinkedMultiValueMap excelOrderMap = new LinkedMultiValueMap();
        HashMap<String, SysOrganType> organNameAndOrganMap = new HashMap<String, SysOrganType>();
        HashMap<String, String> organTypeAndNameMap = new HashMap<String, String>();
        this.getAllOrganType(organNameAndOrganMap, organTypeAndNameMap);
        for (OrganExtendExcel organExcel : datas) {
            SysOrgan organ = new SysOrgan();
            SysStru stru = new SysStru();
            SysOffice office = new SysOffice();
            String organName = organExcel.getOrganName();
            String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
            String fullOrganName = parentOrganNames + "/" + organName;
            SearchOrganInfoVo infoVo = (SearchOrganInfoVo)map.get(fullOrganName);
            BeanUtil.copy((Object)infoVo, (Object)organ);
            organ.setId(infoVo.getOrganId());
            organ.setShortName(organExcel.getShortName());
            SysOrganType sysOrganType = (SysOrganType)organNameAndOrganMap.get(organExcel.getOrganTypeName());
            organ.setOrganType(sysOrganType.getOrganType());
            organ.setValidTimeLimitType(organExcel.getValidTimeLimitType());
            organ.setOrganNamePinyinFull(this.convertPinyinService.getFullPinyin(organName));
            organ.setOrganNamePinyinInitial(this.convertPinyinService.getInitialsPinyin(organName));
            BeanUtil.copy((Object)infoVo, (Object)stru);
            stru.setId(infoVo.getStruId());
            stru.setOrganAlias(organExcel.getOrganAlias());
            stru.setStruType(sysOrganType.getOrganType());
            String userAccount = organExcel.getUserAccount();
            if (HussarUtils.isNotBlank((CharSequence)userAccount) && HussarUtils.isNotEmpty((Object)userMap.get(userAccount))) {
                stru.setPrincipalId(userMap.get(userAccount).getId());
            } else {
                stru.setPrincipalId(null);
            }
            if (!HussarUtils.equals((Object)String.valueOf(infoVo.getStruOrder()), (Object)organExcel.getStruOrder())) {
                Long parentId = infoVo.getParentId();
                List<SysStru> list = pMap.get(parentId);
                List dbOrderList = list.stream().map(SysStru::getStruOrder).collect(Collectors.toList());
                HashSet<Integer> changeStru = new HashSet<Integer>();
                String struOrder = organExcel.getStruOrder();
                if (HussarUtils.isNotBlank((CharSequence)struOrder)) {
                    Integer excelOrder = Integer.parseInt(struOrder);
                    List excelMap = excelOrderMap.get((Object)parentId);
                    if (HussarUtils.isNotEmpty((Object)excelMap)) {
                        excelOrder = this.initFirstLevelOrder(excelOrder, excelMap);
                        excelOrderMap.put((Object)parentId, excelMap);
                    } else {
                        excelOrderMap.add((Object)parentId, (Object)excelOrder);
                    }
                    if (dbOrderList.contains(excelOrder)) {
                        int index;
                        for (int i = index = dbOrderList.indexOf(excelOrder); i < dbOrderList.size(); ++i) {
                            Integer num = (Integer)dbOrderList.get(i);
                            dbOrderList.set(i, num + 1);
                            changeStru.add(i);
                        }
                    }
                    String seq = infoVo.getStruSeq();
                    stru.setStruOrder(excelOrder);
                    stru.setStruSeq(seq.substring(0, seq.lastIndexOf("/")) + "/" + String.format("%04d", excelOrder));
                } else {
                    Integer max;
                    int order = (Integer)dbOrderList.get(dbOrderList.size() - 1);
                    List excelOrder = excelOrganMap.get((Object)parentOrganNames);
                    List indexList = excelIndexMap.get((Object)parentOrganNames);
                    order = HussarUtils.isNotEmpty((Object)excelOrder) ? ((max = (Integer)Collections.max(excelOrder)) > order ? max + excelOrder.size() + indexList.indexOf(infoVo.getOrganFname()) + 1 : order + excelOrder.size() + indexList.indexOf(infoVo.getOrganFname()) + 1) : order + indexList.indexOf(infoVo.getOrganFname()) + 1;
                    stru.setStruOrder(Integer.valueOf(order));
                    String seq = infoVo.getStruSeq();
                    stru.setStruSeq(seq.substring(0, seq.lastIndexOf("/")) + "/" + String.format("%04d", order));
                }
                if (HussarUtils.isNotEmpty(changeStru)) {
                    for (Integer index : changeStru) {
                        Integer order = (Integer)dbOrderList.get(index);
                        SysStru sysStru = list.get(index);
                        if (HussarUtils.equals((Object)stru.getId(), (Object)sysStru.getId())) continue;
                        sysStru.setStruOrder(order);
                        String seq = sysStru.getStruSeq();
                        sysStru.setStruSeq(seq.substring(0, seq.lastIndexOf("/")) + "/" + String.format("%04d", order));
                        updateStruList.add(sysStru);
                    }
                }
            }
            BeanUtil.copy((Object)infoVo, (Object)office);
            office.setId(infoVo.getOfficeId());
            office.setOfficeAlias(organExcel.getOfficeAlias());
            office.setOfficeAddress(organExcel.getOfficeAddress());
            organList.add(organ);
            struList.add(stru);
            officeList.add(office);
        }
    }
}

