/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.extend.dao.HussarBaseOrganExtendWebMapper;
import com.jxdinfo.hussar.authorization.extend.dto.OrganExtendFullDto;
import com.jxdinfo.hussar.authorization.extend.model.OrganExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseOrganExtendWebService;
import com.jxdinfo.hussar.authorization.extend.service.impl.ImportExcelOrganExtendManagerImpl;
import com.jxdinfo.hussar.authorization.extend.utils.AuthorizationExtendUtils;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendOrganInfoVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganExtendSortVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganExtendTransferVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganExtendTypeVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganWithStruIdVo;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.SortOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.EditOrganizationAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStruRuleVo;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.organmanager.OrganChangeNotify;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorizationextend.organization.impl.hussarBaseOrganExtendServiceImpl")
@HussarTokenDs
public class HussarBaseOrganExtendWebWebServiceImpl
implements IHussarBaseOrganExtendWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseOrganExtendWebWebServiceImpl.class);
    @Resource
    private AddOrganizationManager addOrganManager;
    @Resource
    private SortOrganizationManager sortOrganizationManager;
    @Resource
    private DeleteOrganizationManager deleteOrganManager;
    @Resource
    private EditOrganizationManager editOrganManager;
    @Autowired
    private AuthorizationExtendUtils authorizationExtendUtils;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;
    @Autowired
    protected IHussarValidateService validateService;
    @Resource
    protected ISysStruService sysStruService;
    @Resource
    private AddOrganizationManager addOrganizationManager;
    @Resource
    protected ISysOrganService sysOrganService;
    @Autowired
    protected ISysOfficeService sysOfficeService;
    @Resource
    protected OrganChangeNotify organChangeNotify;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Resource
    protected IConvertPinyinService convertPinyinService;
    @Resource
    protected ISysStruRuleService sysStruRuleService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Resource
    protected IHussarBasePostService hussarBasePostService;
    @Resource
    protected EditOrganizationAuthorizationChangeReporter editOrganizationAuthorizationChangeReporter;
    @Autowired
    protected ISysStruPostService sysStruPostService;
    @Autowired
    protected ISysStruRoleService sysStruRoleService;
    @Autowired
    protected ISysOrganAuditService sysOrganAuditService;
    @Autowired
    protected ISysStruAuditService sysStruAuditService;
    @Autowired
    protected ISysOfficeAuditService sysOfficeAuditService;
    @Autowired
    protected ISysStruPostAuditService sysStruPostAuditService;
    @Autowired
    protected ISysStruRoleAuditService sysStruRoleAuditService;
    @Autowired
    protected ISysStaffAuditService sysStaffAuditService;
    @Autowired
    protected ISysOrgEventService sysOrgEventService;
    @Resource
    protected ISysStruAssistOrganService sysStruAssistOrganService;
    @Autowired
    protected HussarBaseOrganExtendWebMapper hussarBaseOrganExtendWebMapper;
    @Autowired
    private ImportExcelOrganExtendManagerImpl importExcelOrganExtendManager;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;

    public ApiResponse<List<OrganExtendSortVo>> sortOrganization(List<Long> idList) {
        List<Long> struIdList = this.hussarBaseOrganExtendWebMapper.selectStruIdList(idList);
        this.sortOrganizationManager.sortOrganization(struIdList);
        ArrayList<Long> ids = new ArrayList<Long>();
        List<OrganExtendSortVo> list = this.hussarBaseOrganExtendWebMapper.list(idList);
        AssertUtil.isTrue((idList.size() == list.size() ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CONTAINS_NON_PERSONNEL.getMessage()));
        for (int i = 0; i < idList.size(); ++i) {
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_COMPARE_ID_ORDER.getMessage()));
            if (Objects.equals(list.get(i).getRECORD_ID(), idList.get(i))) continue;
            ids.add(idList.get(i));
        }
        ArrayList<OrganExtendSortVo> update = new ArrayList<OrganExtendSortVo>();
        if (HussarUtils.isNotEmpty(ids)) {
            List<OrganExtendSortVo> listTemp = this.hussarBaseOrganExtendWebMapper.list(idList);
            Map map = listTemp.stream().collect(Collectors.toMap(OrganExtendSortVo::getRECORD_ID, Function.identity()));
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_SORT_CHANGED.getMessage()));
            OrganExtendSortVo temp = null;
            for (int i = 0; i < ids.size(); ++i) {
                temp = new OrganExtendSortVo();
                OrganExtendSortVo sysOrganT = (OrganExtendSortVo)map.get(ids.get(i));
                BeanUtils.copyProperties((Object)sysOrganT, (Object)temp);
                temp.setORGAN_ORDER(listTemp.get(i).getORGAN_ORDER());
                update.add(temp);
            }
        }
        return ApiResponse.success(update, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
    }

    public ApiResponse<OrganWithStruIdVo> addOrgan(AddOrganizationDto addOrganizationDto) {
        if (!this.queryOrganizationManager.checkSameOrganName(addOrganizationDto.getOrganName(), Long.valueOf(HussarUtils.isEmpty((Object)addOrganizationDto.getParentId()) ? 1L : addOrganizationDto.getParentId()), null).booleanValue()) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        Map addResult = (Map)this.addOrganization(addOrganizationDto).getData();
        SysOrgan sysOrgan = (SysOrgan)addResult.get("sysOrgan");
        SysStru sysStru = (SysStru)addResult.get("sysStru");
        HashMap resultMap = new HashMap();
        OrganWithStruIdVo organWithStruIdVo = new OrganWithStruIdVo();
        organWithStruIdVo.setOrganId(sysOrgan.getId());
        organWithStruIdVo.setStruId(sysStru.getId());
        organWithStruIdVo.setSysOrgan(sysOrgan);
        return ApiResponse.success((Object)organWithStruIdVo);
    }

    public ApiResponse<String> deleteOrgan(List<Long> idList) {
        for (Long id : idList) {
            this.deleteOrganManager.deleteOrganization(id);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<String> editOrgan(EditOrganizationDto editOrganizationDto) {
        return ApiResponse.success((String)this.editOrganManager.editOrganization(editOrganizationDto));
    }

    public ApiResponse<List<SysStruRuleVo>> getOrganizationTypeByParentId(String parentId, String typeId, List<OrganExtendTypeVo> organExtendTypeVoList) {
        ArrayList<SysStruRuleVo> list = new ArrayList<SysStruRuleVo>();
        SysStruRuleVo rule = null;
        if (HussarUtils.isEmpty((Object)parentId) || HussarUtils.isEmpty((Object)typeId)) {
            List types = organExtendTypeVoList.stream().filter(organExtendTypeVo -> HussarUtils.isEmpty((Object)organExtendTypeVo.getParentType())).collect(Collectors.toList());
            for (OrganExtendTypeVo type : types) {
                rule = new SysStruRuleVo();
                rule.setOrganType(type.getOrganType());
                rule.setOrganTypeName(type.getOrganTypeName());
                rule.setSysOrganType(type.getParentType());
                rule.setSysOrganTypeName(type.getParentTypeName());
                list.add(rule);
            }
        } else {
            List types = organExtendTypeVoList.stream().filter(organExtendTypeVo -> organExtendTypeVo.getParentType().equals(typeId) || organExtendTypeVo.getOrganType().equals(typeId)).collect(Collectors.toList());
            for (OrganExtendTypeVo type : types) {
                rule = new SysStruRuleVo();
                rule.setOrganType(type.getOrganType());
                rule.setOrganTypeName(type.getOrganTypeName());
                rule.setSysOrganType(type.getParentType());
                rule.setSysOrganTypeName(type.getParentTypeName());
                list.add(rule);
            }
        }
        return ApiResponse.success(list);
    }

    public ApiResponse<OrganExtendTransferVo> transferOrganization(TransferOrganizationDto transferOrganizationDto, String organName) {
        if (!this.queryOrganizationManager.checkSameOrganName(organName, transferOrganizationDto.getNewId(), null).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        OrganExtendTransferVo organExtendTransferVo = this.transferOrganization(transferOrganizationDto);
        return ApiResponse.success((Object)organExtendTransferVo);
    }

    public ApiResponse<String> saveOrganInfo(String appId, String formId, OrganExtendFullDto organExtendFullDto) {
        if (!this.queryOrganizationManager.checkSameOrganName(organExtendFullDto.getOrganName(), organExtendFullDto.getParentId(), null).booleanValue()) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff01\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (HussarUtils.isEmpty((Object)organExtendFullDto.getId())) {
            AddOrganizationDto addOrganizationDto = new AddOrganizationDto();
            BeanUtil.copy((Object)organExtendFullDto, (Object)addOrganizationDto);
            return this.addOrganBaseInfo(addOrganizationDto);
        }
        EditOrganizationDto editOrganizationDto = new EditOrganizationDto();
        BeanUtil.copy((Object)organExtendFullDto, (Object)editOrganizationDto);
        return this.editOrganBaseInfo(editOrganizationDto);
    }

    public ApiResponse<String> saveOrganPost(String appId, String formId, EditOrganizationDto editOrganizationDto) {
        if (HussarUtils.isEmpty((Object)editOrganizationDto.getId())) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        Long struId = editOrganizationDto.getId();
        List postIds = editOrganizationDto.getPostIds();
        ArrayList<SysStruPost> sysStruPosts = new ArrayList<SysStruPost>();
        List userPostByOrgan = this.sysStruPostService.getUserPostByOrgan(struId, postIds);
        AssertUtil.isEmpty((Collection)userPostByOrgan, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.EDIT_FAIL_EXIST_RELATE_POST_USER.getMessage()));
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            for (Long postId : postIds) {
                SysStruPost sysStruPost = new SysStruPost();
                sysStruPost.setStruId(struId);
                sysStruPost.setPostId(postId);
                sysStruPosts.add(sysStruPost);
            }
        }
        this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)struId));
        if (HussarUtils.isNotEmpty(sysStruPosts)) {
            this.sysStruPostService.saveBatch(sysStruPosts, sysStruPosts.size());
        }
        String msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS.getMessage());
        this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{struId, sysStruPosts});
        this.editOrganizationAuthorizationChangeReporter.report(new Object[]{struId});
        return ApiResponse.success((String)msg);
    }

    public ApiResponse<String> saveOrganRole(String appId, String formId, EditOrganizationDto editOrganizationDto) {
        if (HussarUtils.isEmpty((Object)editOrganizationDto.getId())) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        Long struId = editOrganizationDto.getId();
        List roleIds = editOrganizationDto.getRoleIds();
        ArrayList<SysStruRole> sysStruRoles = new ArrayList<SysStruRole>();
        if (HussarUtils.isNotEmpty((Object)roleIds)) {
            for (Long roleId : roleIds) {
                SysStruRole sysStruRole = new SysStruRole();
                sysStruRole.setStruId(struId);
                sysStruRole.setGrantedRole(roleId);
                sysStruRoles.add(sysStruRole);
            }
        }
        this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)struId));
        if (HussarUtils.isNotEmpty(sysStruRoles)) {
            this.sysStruRoleService.saveBatch(sysStruRoles, sysStruRoles.size());
        }
        String msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS.getMessage());
        this.editOrganizationAuthorizationChangeReporter.report(new Object[]{struId});
        return ApiResponse.success((String)msg);
    }

    public ApiResponse<List<ExtendOrganInfoVo>> getOrganInfo(String struId) {
        ArrayList result = new ArrayList();
        Long parentId = null;
        if (HussarUtils.isNotEmpty((Object)struId)) {
            parentId = Long.parseLong(struId);
        }
        if (HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, parentId) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
            if (HussarUtils.isEmpty((Object)(parentId = this.queryOrganizationManager.getGradeOrganType(parentId, BaseSecurityUtil.getUser())))) {
                return ApiResponse.success(result);
            }
            if (!HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, (Object)parentId) && !HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
                struId = parentId.toString();
            }
        }
        if (Constants.ROOT_NODE_ID.toString().equals(struId)) {
            return ApiResponse.success(this.hussarBaseOrganExtendWebMapper.getOrganInfo(null, null, "0"));
        }
        if (Constants.OUT_STRU_NODE_ID.toString().equals(struId)) {
            return ApiResponse.success(this.hussarBaseOrganExtendWebMapper.getOrganInfo(null, null, "1"));
        }
        String struFid = "";
        String notLikefid = "";
        if (HussarUtils.isNotEmpty((Object)struId)) {
            struFid = "%/" + struId + "/%";
            notLikefid = "%/" + struId + "/";
        }
        return ApiResponse.success(this.hussarBaseOrganExtendWebMapper.getOrganInfo(struFid, notLikefid, null));
    }

    private ApiResponse<String> addOrganBaseInfo(AddOrganizationDto addOrganizationDto) {
        boolean flag;
        String validateMsg = this.validateService.validate((Object)addOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String organCode = addOrganizationDto.getOrganCode();
        String organName = addOrganizationDto.getOrganName();
        if (HussarUtils.isNotBlank((CharSequence)organCode)) {
            boolean bl = flag = !organCode.contains("/") && organCode.length() < 33;
            if (!flag) {
                LOGGER.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CONSTANT_1.getMessage()), (Object)organCode);
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_CODE_OUTSIDE_CHECK.getMessage()));
            }
        }
        if (HussarUtils.isNotBlank((CharSequence)organName)) {
            boolean bl = flag = !organName.contains("/");
            if (!flag) {
                LOGGER.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CONSTANT_2.getMessage()), (Object)organName);
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_OUTSIDE_CHECK.getMessage()));
            }
        }
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(addOrganizationDto, sysStru, sysOrgan, sysOffice);
        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
        this.doSave(sysStru, sysOrgan, sysOffice);
        String msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage());
        this.organChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStru.getId(), sysOrgan});
        return ApiResponse.success((Object)String.valueOf(sysStru.getId()), (String)msg);
    }

    private ApiResponse<String> editOrganBaseInfo(EditOrganizationDto editOrganizationDto) {
        String validateMsg = this.validateService.validate((Object)editOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String organName = editOrganizationDto.getOrganName();
        if (HussarUtils.isNotBlank((CharSequence)organName)) {
            boolean flag;
            boolean bl = flag = !organName.contains("/");
            if (!flag) {
                LOGGER.error(TipConstantsEnum.AUTHOR_ORGAN_NAME_OUTSIDE_CHECK.getMessage() + ":" + organName);
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_OUTSIDE_CHECK.getMessage()));
            }
        }
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(editOrganizationDto, sysStru, sysOrgan, sysOffice);
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VERIFY_AUDIT_ADD_AUDIT_LIST.getMessage()));
        boolean flag = this.compareBaseInfo(sysStru, sysOrgan, sysOffice);
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_AUDIT_UNNECESSARY_BEFORE_EDIT_ORGAN.getMessage()));
        if (!flag) {
            this.sysStruService.updateById((Object)sysStru);
            this.sysOrganService.updateById((Object)sysOrgan);
            if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                this.sysOfficeService.saveOrUpdate((Object)sysOffice);
            }
        }
        String msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS.getMessage());
        this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysStru.getId(), sysOrgan});
        this.editOrganizationAuthorizationChangeReporter.report(new Object[]{sysStru.getId()});
        return ApiResponse.success((Object)String.valueOf(sysStru.getId()), (String)msg);
    }

    private void initialization(AddOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACCORDING_PARAM_INITIALIZE_ADD.getMessage()), (Object)JSON.toJSONString((Object)addOrganizationDto));
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(addOrganizationDto.getParentId());
        sysStru.setPrincipalId(addOrganizationDto.getPrincipalId());
        sysStru.setStruType(addOrganizationDto.getStruType());
        sysStru.setPrincipalId(addOrganizationDto.getPrincipalId());
        int level = 0;
        SysStru temp = (SysStru)this.sysStruService.getById((Serializable)sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAddress(StringUtils.trimToEmpty((String)addOrganizationDto.getOfficeAddress()));
        sysOffice.setOfficeAlias(StringUtils.trimToEmpty((String)addOrganizationDto.getOfficeAlias()));
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode()));
        sysOrgan.setOrganName(StringUtils.trimToEmpty((String)addOrganizationDto.getOrganName()));
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)addOrganizationDto.getShortName()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getShortName()));
        sysOrgan.setOrganType(addOrganizationDto.getStruType());
        String organProperty = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganProperty());
        sysOrgan.setOrganProperty(HussarUtils.isEmpty((Object)organProperty) ? "0" : organProperty);
        String validTimeLimitType = StringUtils.trimToEmpty((String)addOrganizationDto.getValidTimeLimitType());
        sysOrgan.setValidTimeLimitType(HussarUtils.isEmpty((Object)validTimeLimitType) ? "0" : validTimeLimitType);
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getOrganAlias()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias()));
        String newCode = (String)this.getCode(sysOrgan).getData();
        sysOrgan.setOrganCode(newCode);
        sysOrgan.setOrganNamePinyinFull(this.convertPinyinService.getFullPinyin(sysOrgan.getOrganName()));
        sysOrgan.setOrganNamePinyinInitial(this.convertPinyinService.getInitialsPinyin(sysOrgan.getOrganName()));
        sysStru.setIsLeaf("Y");
    }

    private void initialization(EditOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        boolean needAudit;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACCORDING_PARAM_INITIALIZE.getMessage()), (Object)JSON.toJSONString((Object)editOrganizationDto));
        Long struId = editOrganizationDto.getId();
        SysStru sysStruT = (SysStru)this.sysStruService.getById((Serializable)struId);
        SysOrgan sysOrganT = (SysOrgan)this.sysOrganService.getById((Serializable)sysStruT.getOrganId());
        SysStru sysStruP = (SysStru)this.sysStruService.getById((Serializable)sysStruT.getParentId());
        if (HussarUtils.isNotEmpty((Object)sysStruP)) {
            AssertUtil.isTrue((boolean)this.sysStruRuleService.judgeRelationshipOfTypeCascade(sysStruT.getStruType(), sysStruP.getStruType()), (String)"\u4fee\u6539\u5931\u8d25\uff01\u4e0a\u4e0b\u7ea7\u7c7b\u578b\u5173\u7cfb\u4e0d\u5408\u89c4\uff01");
        }
        this.checkDownStruType(editOrganizationDto);
        if (!HussarUtils.equals((Object)sysStruT.getStruType(), (Object)editOrganizationDto.getStruType())) {
            this.checkExistRelatePost(sysStruT, editOrganizationDto);
        }
        String currentFname = sysOrganT.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrganT.getOrganName()) && !needAudit) {
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_AUDIT_CONSTANT_1.getMessage()));
            HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
            queryOrgParams.put("ORGAN_FCODE", SqlQueryUtil.transferSpecialChar((String)sysOrganT.getOrganFcode()));
            queryOrgParams.put("organId", sysOrganT.getId());
            queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            List sysOrgans = this.sysOrganService.getSubOrganByFcode(queryOrgParams);
            for (SysOrgan temp : sysOrgans) {
                String tempFname = temp.getOrganFname();
                tempFname = newFname + tempFname.substring(tempFname.lastIndexOf("/"));
                temp.setOrganFname(tempFname);
            }
            this.sysOrganService.updateBatchById((Collection)sysOrgans);
        }
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        BeanUtils.copyProperties((Object)sysOrganT, (Object)sysOrgan);
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        sysStru.setOrganAlias(StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias()));
        sysStru.setPrincipalId(editOrganizationDto.getPrincipalId());
        sysStru.setStruType(editOrganizationDto.getStruType());
        sysOrgan.setOrganName(StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName()));
        sysOrgan.setOrganFname(newFname);
        sysOrgan.setShortName(StringUtils.trimToEmpty((String)editOrganizationDto.getShortName()));
        sysOrgan.setOrganType(editOrganizationDto.getStruType());
        sysOffice.setOfficeAddress(StringUtils.trimToEmpty((String)editOrganizationDto.getOfficeAddress()));
        sysOffice.setOfficeAlias(StringUtils.trimToEmpty((String)editOrganizationDto.getOfficeAlias()));
        sysOrgan.setOrganProperty(editOrganizationDto.getOrganProperty());
        sysOrgan.setOrganNamePinyinFull(this.convertPinyinService.getFullPinyin(sysOrgan.getOrganName()));
        sysOrgan.setOrganNamePinyinInitial(this.convertPinyinService.getInitialsPinyin(sysOrgan.getOrganName()));
        sysOrgan.setValidTimeLimitType(editOrganizationDto.getValidTimeLimitType());
    }

    private void doSave(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        this.sysOrganService.save((Object)sysOrgan);
        this.sysStruService.save((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)sysOffice)) {
            this.sysOfficeService.saveOrUpdate((Object)sysOffice);
        }
    }

    public ApiResponse<String> getCode(SysOrgan sysOrgan) {
        String fieldName = "ORGAN_CODE_4";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        String code = StringUtils.trimToEmpty((String)sysOrgan.getOrganCode());
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode(fieldName, "SYS_ORGAN");
                lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)code);
                currentCount = this.sysOrganService.count((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)code);
            currentCount = this.sysOrganService.count((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_ORGAN_CODE.getMessage()));
            }
        }
        return ApiResponse.success((Object)code, (String)"");
    }

    private AddOrganizationDto processAddParam(Map<String, Object> params) {
        if (HussarUtils.isEmpty((Object)params.get("ORGAN_CODE"))) {
            SysOrgan sysOrgan = new SysOrgan();
            String code = (String)this.getCode(sysOrgan).getData();
            params.put("ORGAN_CODE", code);
        }
        String s = JSON.toJSONString(params);
        return (AddOrganizationDto)JSON.parseObject((String)s, AddOrganizationDto.class);
    }

    private EditOrganizationDto processEditParam(Map<String, Object> params) {
        String s = JSON.toJSONString(params);
        return (EditOrganizationDto)JSON.parseObject((String)s, EditOrganizationDto.class);
    }

    private void checkDownStruType(EditOrganizationDto editOrganizationDto) {
        Long id = editOrganizationDto.getId();
        String parentType = editOrganizationDto.getStruType();
        List strus = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)strus)) {
            Set struTypes = strus.stream().map(SysStru::getStruType).collect(Collectors.toSet());
            List struRules = this.sysStruRuleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruRule::getOrganType, struTypes)).eq(SysStruRule::getSysOrganType, (Object)parentType));
            if (!HussarUtils.equals((Object)struTypes.size(), (Object)struRules.size())) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\u4e0a\u4e0b\u7ea7\u7c7b\u578b\u5173\u7cfb\u4e0d\u5408\u89c4\uff01");
            }
        }
    }

    private void checkExistRelatePost(SysStru sysStru, EditOrganizationDto editOrganizationDto) {
        List postIds = editOrganizationDto.getPostIds();
        if (HussarUtils.isEmpty((Object)postIds)) {
            return;
        }
        String struType = sysStru.getStruType();
        List posts = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPost::getId, (Collection)postIds)).eq(SysPost::getOrganTypeCode, (Object)struType));
        if (HussarUtils.isNotEmpty((Object)posts)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EDIT_FAIL_EXIST_RELATE_POST.getMessage()));
        }
    }

    private boolean compareBaseInfo(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        SysStru oldStru = (SysStru)this.sysStruService.getById((Serializable)sysStru.getId());
        SysOrgan oldOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysOrgan.getId());
        SysOffice oldOffice = (SysOffice)this.sysOfficeService.getById((Serializable)sysOffice.getId());
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOrgan.getOrganName()), (Object)StringUtils.trimToEmpty((String)oldOrgan.getOrganName()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOrgan.getShortName()), (Object)StringUtils.trimToEmpty((String)oldOrgan.getShortName()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysStru.getOrganAlias()), (Object)StringUtils.trimToEmpty((String)oldStru.getOrganAlias()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOffice.getOfficeAlias()), (Object)StringUtils.trimToEmpty((String)oldOffice.getOfficeAlias()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)sysOffice.getOfficeAddress()), (Object)StringUtils.trimToEmpty((String)oldOffice.getOfficeAddress()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)sysStru.getPrincipalId(), (Object)oldStru.getPrincipalId())) {
            return false;
        }
        if (!HussarUtils.equals((Object)sysOrgan.getValidTimeLimitType(), (Object)oldOrgan.getValidTimeLimitType())) {
            return false;
        }
        return HussarUtils.equals((Object)sysStru.getStruType(), (Object)oldStru.getStruType());
    }

    private ApiResponse<Map<String, Object>> addOrganization(AddOrganizationDto addOrganizationDto) {
        boolean flag;
        String validateMsg = this.validateService.validate((Object)addOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String organCode = addOrganizationDto.getOrganCode();
        String organName = addOrganizationDto.getOrganName();
        if (HussarUtils.isNotBlank((CharSequence)organCode)) {
            boolean bl = flag = !organCode.contains("/") && organCode.length() < 33;
            if (!flag) {
                LOGGER.error("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801:{}\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/,\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732", (Object)organCode);
                return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/,\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
            }
        }
        if (HussarUtils.isNotBlank((CharSequence)organName)) {
            boolean bl = flag = !organName.contains("/");
            if (!flag) {
                LOGGER.error("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0:{}\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/", (Object)organName);
                return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/");
            }
        }
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(addOrganizationDto, sysStru, sysOrgan, sysOffice);
        ArrayList<SysStruPost> sysStruPosts = new ArrayList<SysStruPost>();
        ArrayList<SysStruRole> sysStruRoles = new ArrayList<SysStruRole>();
        this.initializationRelations(sysStru.getId(), addOrganizationDto, sysStruPosts, sysStruRoles);
        this.parentOrganizationAuditDataExists(addOrganizationDto.getParentId());
        this.wrapAddOrgan(sysStru, sysOrgan);
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysOffice, sysStruPosts, sysStruRoles);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("sysStru", sysStru);
        resultMap.put("sysOrgan", sysOrgan);
        return ApiResponse.success(resultMap, (String)result);
    }

    private void initializationRelations(Long struId, AddOrganizationDto addOrganizationDto, List<SysStruPost> sysStruPosts, List<SysStruRole> sysStruRoles) {
        List postIds = addOrganizationDto.getPostIds();
        List roleIds = addOrganizationDto.getRoleIds();
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            for (Long postId : postIds) {
                SysStruPost sysStruPost = new SysStruPost();
                sysStruPost.setStruId(struId);
                sysStruPost.setPostId(postId);
                sysStruPosts.add(sysStruPost);
            }
        }
        if (HussarUtils.isNotEmpty((Object)roleIds)) {
            for (Long roleId : roleIds) {
                SysStruRole sysStruRole = new SysStruRole();
                sysStruRole.setStruId(struId);
                sysStruRole.setGrantedRole(roleId);
                sysStruRoles.add(sysStruRole);
            }
        }
    }

    private void parentOrganizationAuditDataExists(Long parentId) {
        LOGGER.info("\u5224\u65ad\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u6240\u5728\u7684\u7236\u7ec4\u7ec7\u673a\u6784{}\u662f\u5426\u5b58\u5728\u5ba1\u6838\u6570\u636e", (Object)parentId);
        if (!this.sysStruAuditService.checkCanOperate(parentId)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01");
        }
    }

    private void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan) {
        LOGGER.debug("\u586b\u5145\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u7801\u76f8\u5173\u5b57\u6bb5");
        this.wrapAddOrgan(sysStru, sysOrgan, true);
    }

    private void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan, boolean updateStruSeq) {
        String organFcode = "/" + sysOrgan.getOrganCode();
        String organFname = "/" + sysOrgan.getOrganName();
        long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
        String struFid = "/" + struIdTemp;
        String pSeq = "";
        String pFid = "/";
        int level = sysStru.getStruLevel();
        if (level > 1) {
            boolean needAudit;
            SysStru pSysStru = (SysStru)this.sysStruService.getById((Serializable)sysStru.getParentId());
            SysOrgan pSysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)pSysStru.getOrganId());
            pSeq = pSysStru.getStruSeq();
            pFid = pSysStru.getStruFid();
            sysOrgan.setParentTypeCode(pSysOrgan.getOrganType());
            organFcode = pSysOrgan.getOrganFcode() + organFcode;
            struFid = pFid + struFid;
            organFname = pSysOrgan.getOrganFname() + organFname;
            boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
            if (!sysOrgan.getOrganType().equals("9") && !needAudit) {
                pSysStru.setIsLeaf("N");
                this.sysStruService.updateById((Object)pSysStru);
            }
        }
        if (updateStruSeq) {
            if (!sysOrgan.getOrganType().equals("9")) {
                sysStru.setStruSeq(this.getStruSeq(pFid, pSeq, level));
            } else {
                sysStru.setStruSeq(pSeq);
            }
        }
        sysOrgan.setOrganFcode(OrganUtil.convert((String)organFcode));
        sysOrgan.setOrganFname(organFname);
        sysStru.setId(Long.valueOf(struIdTemp));
        sysStru.setStruFid(OrganUtil.convert((String)struFid));
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice, List<SysStruPost> sysStruPosts, List<SysStruRole> sysStruRoles) {
        boolean needAudit;
        StringBuilder stringBuilder = new StringBuilder("");
        LOGGER.info("\u5224\u65ad\u9700\u4e0d\u9700\u8981\u5ba1\u6838,\u5982\u679c\u9700\u8981\u5ba1\u6838\uff0c\u5219\u5148\u52a0\u5165\u5ba1\u6838\u8868");
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (needAudit) {
            Set organIds;
            List sysStruAuditList;
            LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u9700\u8981\u5ba1\u6838");
            List sysOrganAuditList = this.sysOrganAuditService.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getOrganCode, (Object)sysOrgan.getOrganCode()));
            if (HussarUtils.isNotEmpty((Object)sysOrganAuditList) && HussarUtils.isNotEmpty((Object)(sysStruAuditList = this.sysStruAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruAudit::getOrganId, organIds = sysOrganAuditList.stream().map(SysOrganAudit::getId).collect(Collectors.toSet()))).eq(SysStruAudit::getState, (Object)"0"))))) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5f85\u5ba1\u6838\u6570\u636e\u4e2d\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
            this.auditAdd(sysOrgan, sysStru, null, sysOffice, "1");
            this.auditStruPost(sysStruPosts);
            this.auditStruRole(sysStruRoles);
            stringBuilder.append("\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        } else {
            this.doSave(sysStru, sysOrgan, sysOffice);
            if (HussarUtils.isNotEmpty(sysStruPosts)) {
                this.sysStruPostService.saveBatch(sysStruPosts, sysStruPosts.size());
            }
            if (HussarUtils.isNotEmpty(sysStruRoles)) {
                this.sysStruRoleService.saveBatch(sysStruRoles, sysStruRoles.size());
            }
            stringBuilder.append("\u65b0\u589e\u6210\u529f");
            this.organChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysStru.getId(), sysOrgan, sysStruPosts});
        }
        return stringBuilder.toString();
    }

    private String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.sysStruService.getMaxStruSeq(pFid, level);
        String struSeq = "";
        if (HussarUtils.isBlank((CharSequence)maxStruSeq)) {
            struSeq = pSeq + "/0001";
        } else {
            String[] arr = maxStruSeq.split("/");
            if (StringUtils.isNotBlank((CharSequence)pSeq)) {
                int len = arr.length - 1;
                if (len < level) {
                    StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                    for (int i = 0; i < level - len; ++i) {
                        stringBuilder.append("/0001");
                    }
                    struSeq = stringBuilder.toString();
                } else {
                    struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf("/")) + "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
                }
            } else {
                struSeq = "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        }
        return struSeq;
    }

    private void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, SysOffice sysOffice, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if ("2".equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setId(null);
        }
        this.sysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getId());
        if ("2".equals(flag)) {
            sysStruAudit.setOrganId(sysOrganAudit.getId());
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.sysStruAuditService.save((Object)sysStruAudit);
        if (HussarUtils.isNotEmpty((Object)sysStaff)) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag)) {
                sysStaffAudit.setStruId(sysStruAudit.getId());
                sysStaffAudit.setRealStaffId(sysStaff.getId());
                sysStaffAudit.setId(null);
            }
            this.sysStaffAuditService.save((Object)sysStaffAudit);
        }
        if (HussarUtils.isNotEmpty((Object)sysOffice)) {
            SysOfficeAudit sysOfficeAudit = new SysOfficeAudit();
            CopyPropertieUtils.copyProperties((Object)sysOfficeAudit, (Object)sysOffice);
            sysOfficeAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag)) {
                sysOfficeAudit.setStruId(sysStruAudit.getId());
                sysOfficeAudit.setRealOfficeId(sysOffice.getId());
                sysOfficeAudit.setId(null);
            }
            this.sysOfficeAuditService.save((Object)sysOfficeAudit);
        }
    }

    private void auditStruPost(List<SysStruPost> struPosts) {
        if (HussarUtils.isNotEmpty(struPosts)) {
            ArrayList<SysStruPostAudit> struPostAudits = new ArrayList<SysStruPostAudit>();
            for (SysStruPost struPost : struPosts) {
                SysStruPostAudit struPostAudit = new SysStruPostAudit();
                struPostAudit.setStruId(struPost.getStruId());
                struPostAudit.setPostId(struPost.getPostId());
                struPostAudit.setAuditStatus("0");
                struPostAudit.setOperateType("1");
                struPostAudits.add(struPostAudit);
            }
            this.sysStruPostAuditService.saveBatch(struPostAudits, struPostAudits.size());
        }
    }

    private void auditStruRole(List<SysStruRole> struRoles) {
        if (HussarUtils.isNotEmpty(struRoles)) {
            ArrayList<SysStruRoleAudit> struRoleAudits = new ArrayList<SysStruRoleAudit>();
            for (SysStruRole struRole : struRoles) {
                SysStruRoleAudit struRoleAudit = new SysStruRoleAudit();
                struRoleAudit.setStruId(struRole.getStruId());
                struRoleAudit.setRoleId(struRole.getGrantedRole());
                struRoleAudit.setStatus(StruRoleStatus.LOCKED.getCode());
                struRoleAudit.setOperationType("1");
                struRoleAudits.add(struRoleAudit);
            }
            this.sysStruRoleAuditService.saveBatch(struRoleAudits, struRoleAudits.size());
        }
    }

    private OrganExtendTransferVo transferOrganization(TransferOrganizationDto transferOrganizationDto) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TRANSFER_PARAM.getMessage()), (Object)JSON.toJSONString((Object)transferOrganizationDto));
        String validateMsg = this.validateService.validate((Object)transferOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long oldId = transferOrganizationDto.getOldId();
        Long newId = transferOrganizationDto.getNewId();
        SysStru oldSysStru = (SysStru)this.sysStruService.getById((Serializable)oldId);
        SysStru newSysStru = (SysStru)this.sysStruService.getById((Serializable)newId);
        AssertUtil.isNotNull((Object)oldSysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_FIND_TRANS_ORG.getMessage()));
        AssertUtil.isNotNull((Object)newSysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_FIND_NEED_TRANS_ORG.getMessage()));
        this.validateTransferOrganization(oldSysStru, newSysStru);
        this.sysOrgEventService.beforeOrgChange(oldId, newId);
        Map<String, Object> transferInfo = this.doTransfer(oldSysStru, newSysStru);
        List updateOrganList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)transferInfo.get("organList"))) {
            updateOrganList = (List)transferInfo.get("organList");
        }
        String msg = transferInfo.get("msg").toString();
        this.sysOrgEventService.afterOrgChange(oldId, newId);
        OrganExtendTransferVo organExtendTransferVo = new OrganExtendTransferVo();
        organExtendTransferVo.setMessage(msg);
        organExtendTransferVo.setOldOrganId(oldSysStru.getOrganId());
        organExtendTransferVo.setNewOrganId(newSysStru.getOrganId());
        OrganizationBo organ = this.sysOrganService.findOrganById(newSysStru.getId());
        organExtendTransferVo.setNewParentName(organ.getOrganName());
        if (HussarUtils.isNotEmpty(updateOrganList)) {
            organExtendTransferVo.setUpdateOrganList(updateOrganList);
        }
        return organExtendTransferVo;
    }

    private void validateTransferOrganization(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_VALIDATE_TRANSFER.getMessage()));
        if (newSysStru.getStruFid().contains(oldSysStru.getStruFid())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MOVE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
        this.whetherComplianceWithOrganizationRule(oldSysStru, newSysStru);
        this.existsAuditData(oldSysStru.getId(), newSysStru.getId());
    }

    private Map<String, Object> doTransfer(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_REAL_TRANSFER.getMessage()));
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = "";
        String sourceOrgType = oldSysStru.getStruType();
        Long sourceStruId = oldSysStru.getId();
        Long targetStruId = newSysStru.getId();
        Integer changeLevel = newSysStru.getStruLevel();
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer maxOrder = this.sysStruService.getMaxOrderById(targetStruId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
        Integer struOrder = orderTree.get();
        Integer level = changeLevel + 1;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)sourceStruId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setOrganId(Long.valueOf(IdWorker.getId((Object)sysStruAudit)));
            sysStruAudit.setInUse("4");
            sysStruAudit.setStruOrder(struOrder);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setStruLevel(level);
            sysStruAudit.setParentId(targetStruId);
            this.sysStruAuditService.save((Object)sysStruAudit);
            SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
            SysOrganAudit sysOrganAudit = new SysOrganAudit();
            CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
            sysOrganAudit.setId(sysStruAudit.getOrganId());
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setInUse("4");
            this.sysOrganAuditService.save((Object)sysOrganAudit);
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS_WAIT_REVIEW.getMessage());
        } else {
            List<SysOrgan> updateOrgan = this.organizationChange(sourceStruId, targetStruId, sourceOrgType, struOrder);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(SysStruAssistOrgan::getStruId, (Object)sourceStruId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)targetStruId);
            this.sysStruAssistOrganService.remove((Wrapper)wrapper);
            SysOrgan sysOrgan = this.sysStruService.getOrganInfoByDeparmentId(sourceStruId);
            this.organChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sourceStruId, sysOrgan, null});
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage());
            result.put("organList", updateOrgan);
        }
        result.put("msg", msg);
        return result;
    }

    private void whetherComplianceWithOrganizationRule(SysStru oldSysStru, SysStru newSysStru) {
        String oldOrganType = oldSysStru.getStruType();
        String newOrganType = newSysStru.getStruType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getSysOrganType, (Object)newOrganType);
        wrapper.eq(SysStruRule::getOrganType, (Object)oldOrganType);
        long count = this.sysStruRuleService.count((Wrapper)wrapper);
        if (count == 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MOVE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
    }

    private void existsAuditData(Long oldId, Long newId) {
        if (!this.sysStruAuditService.checkCanOperate(oldId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_FAIL_EXIST_REVIEW.getMessage()));
        }
        if (!this.sysStruAuditService.checkCanOperate(newId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORG_HAS_UNAPPROVED.getMessage()));
        }
    }

    private List<SysOrgan> organizationChange(Long sourceStruId, Long targetStruId, String sourceOrgType, Integer order) {
        String struSeq;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_UPDATE_CODE_AND_CHILDREN_CODE.getMessage()));
        SysOrgan parentOrg = this.sysStruService.getOrganInfoByDeparmentId(targetStruId);
        SysOrgan sysOrgan = this.sysStruService.getOrganInfoByDeparmentId(sourceStruId);
        SysStru newSysStru = (SysStru)this.sysStruService.getById((Serializable)targetStruId);
        SysStru oldSysStru = (SysStru)this.sysStruService.getById((Serializable)sourceStruId);
        LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)oldSysStru.getStruFid());
        wrapper2.orderByAsc(SysStru::getStruSeq);
        List strus = this.sysStruService.list((Wrapper)wrapper2);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("ORGAN_FCODE", SqlQueryUtil.transferSpecialChar((String)sysOrgan.getOrganFcode()));
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List organs = this.sysOrganService.getSubOrganByFcode(queryOrgParams);
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFcode(parentOrg.getOrganFcode() + sysOrgan.getOrganCode() + "/");
        ((SysOrgan)organsMap.get(sysOrgan.getId())).setOrganFname(parentOrg.getOrganFname() + "/" + sysOrgan.getOrganName());
        String struFid = newSysStru.getStruFid() + oldSysStru.getId() + "/";
        String struSeqT = struSeq = this.getStruSeq(newSysStru.getStruFid(), newSysStru.getStruSeq(), OrganUtil.getLevel((SysStru)newSysStru) + 1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(sourceStruId)).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(((SysOrgan)organsMap.get(sysOrgan.getId())).getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            sysOrganT.setOrganProperty(parentOrg.getOrganProperty());
            stru.setStruFid(OrganUtil.convert((String)(struFid + stru.getId() + "/")));
            stru.setStruSeq(struSeqT + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            this.changeInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        for (SysStru temp : strus) {
            if (!Objects.equals(temp.getId(), sourceStruId)) continue;
            temp.setStruFid(OrganUtil.convert((String)struFid));
            temp.setStruLevel(Integer.valueOf(temp.getStruFid().split("/").length - 1));
            temp.setStruSeq(struSeq);
            temp.setStruOrder(order);
            temp.setParentId(targetStruId);
        }
        this.sysStruService.updateBatchById((Collection)strus);
        this.sysOrganService.updateBatchById(organsMap.values());
        this.updateLeaf(oldSysStru, newSysStru);
        return new ArrayList<SysOrgan>(organsMap.values());
    }

    private void changeInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getStruSeq)).map(stru -> {
            SysOrgan sysOrganT = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrganT.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrganT.getOrganName());
            sysOrganT.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrganT.getOrganCode() + "/")));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId() + "/")));
            stru.setStruSeq(root.getStruSeq() + stru.getStruSeq().substring(stru.getStruSeq().lastIndexOf("/")));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (Objects.equals(stru.getStruType(), "9")) {
                stru.setStruSeq(OrganUtil.getStruFidByLevel((String)stru.getStruSeq(), (int)(stru.getStruLevel() - 1)));
            }
            this.changeInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }

    private void updateLeaf(SysStru oldSysStru, SysStru newSysStru) {
        if (!oldSysStru.getStruType().equals("9")) {
            newSysStru.setIsLeaf("N");
        }
        this.sysStruService.updateById((Object)newSysStru);
        Long sourceStruId = oldSysStru.getParentId();
        int struLevel = oldSysStru.getStruLevel();
        if (!oldSysStru.getStruType().equals("9") && struLevel > 1) {
            SysStru pSysStru = (SysStru)this.sysStruService.getById((Serializable)sourceStruId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStru::getParentId, (Object)sourceStruId);
            wrapper.ne(SysStru::getId, (Object)oldSysStru.getId());
            wrapper.ne(SysStru::getStruType, (Object)"9");
            Long count = this.sysStruService.count((Wrapper)wrapper);
            pSysStru.setIsLeaf(count > 0L ? "N" : "Y");
            this.sysStruService.updateById((Object)pSysStru);
        }
    }

    public ApiResponse<List<Long>> getStruByOrganId(List<Long> organIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysStru::getOrganId, organIdList);
        List struList = this.sysStruService.list((Wrapper)queryWrapper);
        List struIdList = struList.stream().map(SysStru::getId).collect(Collectors.toList());
        return ApiResponse.success(struIdList);
    }

    public ApiResponse<String> saveOrganBatch(List<OrganExtendExcel> list) {
        int i;
        ArrayList<Long> recordIdList = new ArrayList<Long>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            recordIdList.add(list.get(i2).getOrganId());
        }
        List<Object> existRecordIdList = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysOrgan::getId, recordIdList);
        List existSysOrganList = this.sysOrganService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)existSysOrganList)) {
            existRecordIdList = existSysOrganList.stream().map(SysOrgan::getId).collect(Collectors.toList());
        }
        ArrayList<OrganExtendExcel> editOrganList = new ArrayList<OrganExtendExcel>();
        ArrayList<OrganExtendExcel> addOrganList = new ArrayList<OrganExtendExcel>();
        for (i = 0; i < list.size(); ++i) {
            if (existRecordIdList.contains((long)list.get(i).getOrganId())) {
                editOrganList.add(list.get(i));
                continue;
            }
            addOrganList.add(list.get(i));
        }
        if (HussarUtils.isNotEmpty(addOrganList)) {
            this.importExcelOrganExtendManager.saveData(addOrganList, new ArrayList<Object>());
        }
        if (HussarUtils.isNotEmpty(editOrganList)) {
            for (i = 0; i < editOrganList.size(); ++i) {
                String organId = ((OrganExtendExcel)editOrganList.get(i)).getOrganId().toString();
                LambdaQueryWrapper queryWrapperStruId = new LambdaQueryWrapper();
                queryWrapperStruId.eq(SysStru::getOrganId, (Object)organId);
                SysStru sysStru = (SysStru)this.sysStruService.getOne((Wrapper)queryWrapperStruId);
                Long struId = sysStru.getId();
                ((OrganExtendExcel)editOrganList.get(i)).setStruId(struId.toString());
            }
            this.importExcelOrganExtendManager.updateData(editOrganList, new ArrayList<Object>());
        }
        return ApiResponse.success();
    }

    public ApiResponse<List<SysOrganType>> getOrganType() {
        return ApiResponse.success((Object)this.sysOrganTypeService.list());
    }
}

