/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.job.task;

import com.jxdinfo.hussar.authorization.extend.job.outService.IOrganTestJobProcessorsOutService;
import com.jxdinfo.hussar.authorization.extend.job.outService.IStaffTestJobProcessorsOutService;
import com.jxdinfo.hussar.authorization.extend.job.outService.IUserTestJobProcessorsOutService;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffBaseService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.authorization.extend.job.task.SyncStruInfo")
public class SyncStruInfo
implements BasicProcessor {
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired(required=false)
    private ISysOrganService sysOrganService;
    @Autowired(required=false)
    private ISysStaffBaseService sysStaffService;
    @Autowired(required=false)
    private ISysUsersService sysUsersService;
    @Autowired(required=false)
    private IOrganTestJobProcessorsOutService organTestJobProcessorsOutService;
    @Autowired(required=false)
    private IStaffTestJobProcessorsOutService staffTestJobProcessorsOutService;
    @Autowired(required=false)
    private IUserTestJobProcessorsOutService userTestJobProcessorsOutService;
    private static final String ORGAN_NEW_INFO = "\u7ec4\u7ec7\u65b0\u589e\u6570\u636e\uff1a";
    private static final String STAFF_NEW_INFO = "\u4eba\u5458\u65b0\u589e\u6570\u636e\uff1a";
    private static final String USER_NEW_INFO = "\u7528\u6237\u65b0\u589e\u6570\u636e\uff1a";
    private static final String EDIT_INFO = "\u6761\uff0c\u4fee\u6539\u6570\u636e\uff1a";
    private static final String NUM = "\u6761";
    private static final String NO_NAME = "\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a";
    private static final String TENANT = "\u7684\u79df\u6237";

    public ProcessResult process(TaskContext taskContext) throws Exception {
        boolean tenantOpen = TenantCacheUtil.openTenant();
        HashSet<String> connNameList = new HashSet<String>();
        Map normalTenants = new HashMap<String, DefaultTenant>();
        if (tenantOpen) {
            Set tenantConnNameList = this.sysTenantService.getConnNameList();
            if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                connNameList.addAll(tenantConnNameList);
            }
            normalTenants = this.sysTenantService.getNormalTenants();
        } else {
            connNameList.add("master");
            normalTenants.put("master", new DefaultTenant());
        }
        ArrayList<String> resultStr = new ArrayList<String>();
        for (String connName : connNameList) {
            HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
            if (hussarTenantDefinition == null) {
                throw new BaseException(NO_NAME + connName + TENANT);
            }
            HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
            if (!HussarUtils.isNotEmpty(this.organTestJobProcessorsOutService.getAppId(connName, "918541819388895233"))) continue;
            resultStr.add(this.syncStart(connName));
        }
        CharSequence[] allInfo = resultStr.toArray(new String[0]);
        return new ProcessResult(true, String.join((CharSequence)"\u3002", allInfo));
    }

    private String syncStart(String connName) {
        ArrayList<String> syncInfo = new ArrayList<String>();
        syncInfo.add(this.syncOrganInfo(connName));
        syncInfo.add(this.syncStaffInfo(connName));
        syncInfo.add(this.syncUserInfo(connName));
        CharSequence[] syncInfoArray = syncInfo.toArray(new String[0]);
        return String.join((CharSequence)";", syncInfoArray);
    }

    private String syncOrganInfo(String connName) {
        List list = this.sysOrganService.list(connName);
        List<Long> extendIds = this.organTestJobProcessorsOutService.selectAllOrganExtendIds(connName);
        ArrayList<SysOrgan> containsList = new ArrayList<SysOrgan>();
        if (HussarUtils.isNotEmpty(extendIds)) {
            for (SysOrgan sysOrgan : list) {
                if (!extendIds.contains(sysOrgan.getId())) continue;
                containsList.add(sysOrgan);
            }
        }
        list.removeAll(containsList);
        Integer addNum = 0;
        Integer editNum = 0;
        if (HussarUtils.isNotEmpty((Object)list)) {
            addNum = this.organTestJobProcessorsOutService.insertOrganBatch(connName, list);
        }
        if (HussarUtils.isNotEmpty(containsList)) {
            editNum = this.organTestJobProcessorsOutService.updateOrganBatch(connName, containsList);
        }
        StringBuilder resultBulider = new StringBuilder(ORGAN_NEW_INFO);
        resultBulider.append(addNum).append(EDIT_INFO).append(editNum).append(NUM);
        return resultBulider.toString();
    }

    private String syncStaffInfo(String connName) {
        List list = this.sysStaffService.list(connName);
        List<Long> extendIds = this.staffTestJobProcessorsOutService.selectAllStaffExtendIds(connName);
        ArrayList<SysStaff> containsList = new ArrayList<SysStaff>();
        if (HussarUtils.isNotEmpty(extendIds)) {
            for (SysStaff sysStaff : list) {
                if (!extendIds.contains(sysStaff.getId())) continue;
                containsList.add(sysStaff);
            }
        }
        this.setStaffDateNull(list);
        this.setStaffDateNull(containsList);
        list.removeAll(containsList);
        Integer addNum = 0;
        Integer editNum = 0;
        if (HussarUtils.isNotEmpty((Object)list)) {
            addNum = this.staffTestJobProcessorsOutService.insertStaffBatch(connName, list);
        }
        if (HussarUtils.isNotEmpty(containsList)) {
            editNum = this.staffTestJobProcessorsOutService.updateStaffBatch(connName, containsList);
        }
        StringBuilder resultBulider = new StringBuilder(STAFF_NEW_INFO);
        resultBulider.append(addNum).append(EDIT_INFO).append(editNum).append(NUM);
        return resultBulider.toString();
    }

    private void setStaffDateNull(List<SysStaff> list) {
        for (SysStaff staff : list) {
            if (HussarUtils.isEmpty((Object)staff.getBirthday())) {
                staff.setBirthday(null);
            }
            if (HussarUtils.isEmpty((Object)staff.getWorkDate())) {
                staff.setWorkDate(null);
            }
            if (HussarUtils.isEmpty((Object)staff.getGraduateDate())) {
                staff.setGraduateDate(null);
            }
            if (HussarUtils.isEmpty((Object)staff.getCreateTime())) {
                staff.setCreateTime(null);
            }
            if (!HussarUtils.isEmpty((Object)staff.getLastTime())) continue;
            staff.setLastTime(null);
        }
    }

    private String syncUserInfo(String connName) {
        List list = this.sysUsersService.list(connName);
        List<Long> extendIds = this.userTestJobProcessorsOutService.selectAllUserExtendIds(connName);
        ArrayList<SysUsers> containsList = new ArrayList<SysUsers>();
        if (HussarUtils.isNotEmpty(extendIds)) {
            for (SysUsers sysUsers : list) {
                if (!extendIds.contains(sysUsers.getId())) continue;
                containsList.add(sysUsers);
            }
        }
        this.setUserDateNull(list);
        this.setUserDateNull(containsList);
        list.removeAll(containsList);
        Integer addNum = 0;
        Integer editNum = 0;
        if (HussarUtils.isNotEmpty((Object)list)) {
            addNum = this.userTestJobProcessorsOutService.insertUserBatch(connName, list);
        }
        if (HussarUtils.isNotEmpty((Object)editNum)) {
            editNum = this.userTestJobProcessorsOutService.updateUserBatch(connName, containsList);
        }
        StringBuilder resultBulider = new StringBuilder(USER_NEW_INFO);
        resultBulider.append(addNum).append(EDIT_INFO).append(editNum).append(NUM);
        return resultBulider.toString();
    }

    private void setUserDateNull(List<SysUsers> list) {
        for (SysUsers users : list) {
            if (HussarUtils.isEmpty((Object)users.getCreateTime())) {
                users.setCreateTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getLastTime())) {
                users.setLastTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getLockTime())) {
                users.setLockTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getExpiredTime())) {
                users.setExpiredTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getPswdUptTime())) {
                users.setPswdUptTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getPswdTime())) {
                users.setPswdTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getStartTime())) {
                users.setStartTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getLastLoginTime())) {
                users.setLastLoginTime(null);
            }
            if (HussarUtils.isEmpty((Object)users.getAccessLoginStartTime())) {
                users.setAccessLoginStartTime(null);
            }
            if (!HussarUtils.isEmpty((Object)users.getAccessLoginEndTime())) continue;
            users.setAccessLoginEndTime(null);
        }
    }
}

