/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.enums;

import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.stream.Stream;

public enum UserStatus {
    LOCKED("0", "USER_STATUS_LOCKED"),
    OK("1", "USER_STATUS_OK"),
    DORMANCY("3", "USER_STATUS_DORMANCY"),
    DELETE("2", "USER_STATUS_DELETE"),
    CANCEL("4", "USER_STATUS_CANCEL"),
    TEMPORARY("0", "USER_STATUS_TEMPORARY");

    String code;
    String message;

    private UserStatus(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return TranslateUtil.getTranslateName((String)this.message);
    }

    public static String toString(String value) {
        if (value == null) {
            return "";
        }
        for (UserStatus ms : UserStatus.values()) {
            if (!value.equals(ms.getCode())) continue;
            return TranslateUtil.getTranslateName((String)ms.getMessage());
        }
        return "";
    }

    public static UserStatus convert(String value) {
        return Stream.of(UserStatus.values()).filter(bean -> bean.code.equals(value)).findAny().orElse(OK);
    }

    public static UserStatus convertByMessage(String message) {
        return Stream.of(UserStatus.values()).filter(bean -> bean.message.equals(message)).findAny().orElse(OK);
    }
}

