/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.constants;

import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="global")
public class GlobalProperties {
    private ISysBaseConfigService iSysBaseConfigService = null;
    private static final String OPEN = "0";
    private static final String CLOSE = "1";
    public static final String Global_PREFIX = "global";
    private String title = "HussarV8";
    private String defaultPassword = "123456";
    private String pwdComplexityRegular = "/^[\\S]{6,12}$/ ";
    private String unmatchedHint = "\u5bc6\u7801\u5fc5\u987b6\u523012\u4f4d\uff0c\u4e14\u4e0d\u80fd\u51fa\u73b0\u7a7a\u683c";
    private String unmatchedHintMark = "defaultRule";
    private boolean forceChangePwd = true;
    private long passwordHist = 90L;
    private int pwdRepeatTime = 2;
    private int tryLoginTime = 3;
    private int lockTime = 1;
    private boolean sessionLimit = true;
    private boolean kickoutAfter = true;
    private String defaultTheme = "default";
    private boolean changeTheme = true;
    private boolean criticalOperationsAudit;
    private boolean organAudit;
    private boolean userAudit;
    private boolean roleAudit;
    private boolean struAudit;
    private boolean roleResourceCheck;
    private boolean treeLazyLoad = true;
    private boolean userOnOneEmp;
    private boolean operateStaffWithUser;
    private boolean tabSwitchover = true;
    private boolean skipWelcome;
    private String pwdRule = "8,16,1";
    private String pwdRuleMessage = "\u5bc6\u7801\u6700\u5c0f\u4e0d\u80fd\u5c0f\u4e8e%s\u4f4d\uff0c\u6700\u5927\u4e0d\u80fd\u5927\u4e8e%s\u4f4d\uff0c\u5f3a\u5ea6\u9700\u9ad8\u4e8e\u7ea7\u522b%s\u8981\u6c42!";
    private boolean pwdRuleCustom;
    private boolean first = true;
    private Boolean loginTimeLimit = false;
    private Boolean loginIpLimit = false;
    private Boolean createUserSendEmail = false;
    private String domain = "HUSSAR_V8";
    private Boolean createUserUseDefaultPass = true;
    private Long systemMaxSession = 1000000L;
    private Long antiReplayTimeout = -1L;
    private boolean encryptSignOpen;
    private boolean exceptionAlert;
    private String exceptionAlertEmail;
    private int securitylogCountAlert = -1;
    private String antiReplayScanPackage;
    private boolean showLoginPage = true;
    private boolean tenantOpen;
    private String tenantUserModel = "2";
    private boolean tenantChangeInputPwd;
    private String tenantLevel = "2";
    private List<String> tenantPatterns = new ArrayList<String>(){
        private static final long serialVersionUID = 8722768095776932260L;
        {
            this.add("com.jxdinfo.hussar.*.*Controller.*");
        }
    };
    private List<String> tenantExcludePatterns = new ArrayList<String>(){
        private static final long serialVersionUID = -3001361909393991022L;
        {
            this.add("com.jxdinfo.hussar.*.JobFrontController.*");
        }
    };
    private String xFrameOptions = "SAMEORIGIN";
    private String contentSecurityPolicy = "object-src 'none';";

    public Long getAntiReplayTimeout() {
        return this.antiReplayTimeout;
    }

    public void setAntiReplayTimeout(Long antiReplayTimeout) {
        this.antiReplayTimeout = antiReplayTimeout;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public int getLockTime() {
        String lockTimeStr = this.getStringBaseConfig("fail_lock_time", String.valueOf(this.lockTime));
        this.lockTime = Integer.valueOf(lockTimeStr);
        return this.lockTime;
    }

    public void setLockTime(int lockTime) {
        this.lockTime = lockTime;
    }

    public boolean isSessionLimit() {
        this.sessionLimit = this.getBooleanBaseConfig("session_limit", this.sessionLimit);
        return this.sessionLimit;
    }

    public boolean isSessionLimit(SecurityUser shiroUser) {
        SysBaseConfig baseConfig = this.getBaseConfigByKey("session_limit", shiroUser);
        if (ToolUtil.isNotEmpty((Object)baseConfig) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            this.sessionLimit = OPEN.equals(baseConfig.getConfigValue());
        }
        return this.sessionLimit;
    }

    public void setSessionLimit(boolean sessionLimit) {
        this.sessionLimit = sessionLimit;
    }

    public int getTryLoginTime() {
        String tryLoginTimeStr = this.getStringBaseConfig("fail_number", String.valueOf(this.tryLoginTime));
        this.tryLoginTime = Integer.valueOf(tryLoginTimeStr);
        return this.tryLoginTime;
    }

    public void setTryLoginTime(int tryLoginTime) {
        this.tryLoginTime = tryLoginTime;
    }

    public boolean isKickoutAfter() {
        this.kickoutAfter = this.getBooleanBaseConfig("kickout_after", this.kickoutAfter);
        return this.kickoutAfter;
    }

    public void setKickoutAfter(boolean kickoutAfter) {
        this.kickoutAfter = kickoutAfter;
    }

    public int getPwdRepeatTime() {
        String pwdRepeatTimeStr = this.getStringBaseConfig("pwd_repeat_time", String.valueOf(this.pwdRepeatTime));
        this.pwdRepeatTime = Integer.valueOf(pwdRepeatTimeStr);
        return this.pwdRepeatTime;
    }

    public void setPwdRepeatTime(int pwdRepeatTime) {
        this.pwdRepeatTime = pwdRepeatTime;
    }

    public long getPasswordHist() {
        String passwordHistStr = this.getStringBaseConfig("password_hist", String.valueOf(this.passwordHist));
        this.passwordHist = Long.valueOf(passwordHistStr);
        return this.passwordHist;
    }

    public void setPasswordHist(long passwordHist) {
        this.passwordHist = passwordHist;
    }

    public String getDefaultPassword() {
        this.defaultPassword = this.getStringBaseConfig("default_password", this.defaultPassword);
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setDefaultTheme(String defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public boolean isChangeTheme() {
        return this.changeTheme;
    }

    public void setChangeTheme(boolean changeTheme) {
        this.changeTheme = changeTheme;
    }

    public boolean isForceChangePwd() {
        this.forceChangePwd = this.getBooleanBaseConfig("force_change_pwd", this.forceChangePwd);
        return this.forceChangePwd;
    }

    public void setForceChangePwd(boolean forceChangePwd) {
        this.forceChangePwd = forceChangePwd;
    }

    public boolean isCriticalOperationsAudit() {
        this.criticalOperationsAudit = this.getBooleanBaseConfig("critical_operations_audit", this.criticalOperationsAudit);
        return this.criticalOperationsAudit;
    }

    public void setCriticalOperationsAudit(boolean criticalOperationsAudit) {
        this.criticalOperationsAudit = criticalOperationsAudit;
    }

    public boolean isOrganAudit() {
        this.organAudit = this.getBooleanBaseConfig("organ_audit", this.organAudit);
        return this.organAudit;
    }

    public void setOrganAudit(boolean organAudit) {
        this.organAudit = organAudit;
    }

    public boolean isUserAudit() {
        this.userAudit = this.getBooleanBaseConfig("user_audit", this.userAudit);
        return this.userAudit;
    }

    public void setUserAudit(boolean userAudit) {
        this.userAudit = userAudit;
    }

    public boolean isRoleAudit() {
        this.roleAudit = this.getBooleanBaseConfig("role_audit", this.roleAudit);
        return this.roleAudit;
    }

    public void setRoleAudit(boolean roleAudit) {
        this.roleAudit = roleAudit;
    }

    public boolean isTreeLazyLoad() {
        return this.treeLazyLoad;
    }

    public void setTreeLazyLoad(boolean treeLazyLoad) {
        this.treeLazyLoad = treeLazyLoad;
    }

    public String getPwdComplexityRegular() {
        if (this.isPwdRuleCustom()) {
            this.pwdComplexityRegular = this.getStringBaseConfig("pwd_complexity_regular", this.pwdComplexityRegular);
        } else {
            this.setRule();
        }
        return this.pwdComplexityRegular;
    }

    public void setPwdComplexityRegular(String pwdComplexityRegular) {
        this.pwdComplexityRegular = pwdComplexityRegular;
    }

    public void setPwdComplexityRegularCache(String pwdComplexityRegular) {
        this.setBaseConfigCache("pwd_complexity_regular", pwdComplexityRegular);
        this.pwdComplexityRegular = pwdComplexityRegular;
    }

    public Boolean getLoginTimeLimit() {
        this.loginTimeLimit = this.getBooleanBaseConfig("login_time_limit", this.loginTimeLimit);
        return this.loginTimeLimit;
    }

    public void setLoginTimeLimit(Boolean loginTimeLimit) {
        this.loginTimeLimit = loginTimeLimit;
    }

    public Boolean getLoginIpLimit() {
        this.loginIpLimit = this.getBooleanBaseConfig("login_ip_limit", this.loginIpLimit);
        return this.loginIpLimit;
    }

    public void setLoginIpLimit(Boolean loginIpLimit) {
        this.loginIpLimit = loginIpLimit;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Boolean getCreateUserSendEmail() {
        this.createUserSendEmail = this.getBooleanBaseConfig("create_user_send_email", this.createUserSendEmail);
        return this.createUserSendEmail;
    }

    public void setCreateUserSendEmail(Boolean createUserSendEmail) {
        this.createUserSendEmail = createUserSendEmail;
    }

    public Boolean getCreateUserUseDefaultPass() {
        this.createUserUseDefaultPass = this.getBooleanBaseConfig("create_user_use_default_pass", this.createUserUseDefaultPass);
        return this.createUserUseDefaultPass;
    }

    public void setCreateUserUseDefaultPass(Boolean createUserUseDefaultPass) {
        this.createUserUseDefaultPass = createUserUseDefaultPass;
    }

    public String getUnmatchedHint() {
        this.setRule();
        return this.unmatchedHint;
    }

    public void setUnmatchedHint(String unmatchedHint) {
        this.unmatchedHint = unmatchedHint;
    }

    public void setUnmatchedHintCache(String unmatchedHint) {
        this.setBaseConfigCache("unmatched_hint", unmatchedHint);
        this.unmatchedHint = unmatchedHint;
    }

    public String getUnmatchedHintMark() {
        this.unmatchedHintMark = this.isPwdRuleCustom() ? "defaultRule" : "customRule";
        return this.unmatchedHintMark;
    }

    public void setUnmatchedHintMark(String unmatchedHintMark) {
        this.unmatchedHintMark = unmatchedHintMark;
    }

    public boolean isUserOnOneEmp() {
        this.userOnOneEmp = this.getBooleanBaseConfig("user_on_one_emp", this.userOnOneEmp);
        return this.userOnOneEmp;
    }

    public void setUserOnOneEmp(boolean userOnOneEmp) {
        this.userOnOneEmp = userOnOneEmp;
    }

    public boolean isOperateStaffWithUser() {
        this.operateStaffWithUser = this.getBooleanBaseConfig("operate_staff_with_user", this.operateStaffWithUser);
        return this.operateStaffWithUser;
    }

    public void setOperateStaffWithUser(boolean operateStaffWithUser) {
        this.operateStaffWithUser = operateStaffWithUser;
    }

    public boolean isTabSwitchover() {
        this.tabSwitchover = this.getBooleanBaseConfig("tab_switchover", this.tabSwitchover);
        return this.tabSwitchover;
    }

    public void setTabSwitchover(boolean tabSwitchover) {
        this.tabSwitchover = tabSwitchover;
    }

    public String getPwdRule() {
        String[] regArray;
        this.pwdRule = this.getStringBaseConfig("pwd_rule", this.pwdRule);
        if (!this.isPwdRuleCustom() && (regArray = this.pwdRule.split(",")).length != 3) {
            this.pwdRule = "8,16,1";
        }
        return this.pwdRule;
    }

    public void setPwdRule(String pwdRule) {
        this.pwdRule = pwdRule;
    }

    private synchronized void setRule() {
        if (!this.isPwdRuleCustom()) {
            this.pwdRule = this.getPwdRule();
            Object[] regArray = this.pwdRule.split(",");
            String minLength = regArray[0];
            String maxLength = regArray[1];
            String level = regArray[2];
            int minInt = 4;
            int maxInt = 16;
            int levelInt = 1;
            if (StringUtils.isNumeric((CharSequence)minLength) && StringUtils.isNumeric((CharSequence)maxLength) && StringUtils.isNumeric((CharSequence)level)) {
                minInt = Integer.parseInt(minLength);
                maxInt = Integer.parseInt(maxLength);
                levelInt = Integer.parseInt(level);
            }
            String regex = "^[A-Z]{%d,%d}$|^[a-z]{%d,%d}$|^[0-9]{%d,%d}$|^[\\W_]{%d,%d}$";
            this.pwdRuleMessage = this.getPwdRuleMessage(levelInt);
            switch (levelInt) {
                case 1: {
                    regex = new StringBuffer("^[A-Z]{%d,%d}$|^[a-z]{%d,%d}$|^[0-9]{%d,%d}$|^[\\W_]{%d,%d}$").append("|").append("^(?!\\d+$)(?![\\W_]+$)[\\d\\W_]{%d,%d}$|^(?!\\d+$)(?![a-z]+$)[\\da-z]{%d,%d}$|^(?!\\d+$)(?![A-Z]+$)[\\dA-Z]{%d,%d}$|^(?![a-z]+$)(?![A-Z]+$)[a-zA-Z]{%d,%d}$|^(?![a-z]+$)(?![\\W_]+$)[a-z\\W]{%d,%d}$|^(?![A-Z]+$)(?![\\W_]+$)[A-Z\\W]{%d,%d}$").append("|").append("^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$").toString();
                    break;
                }
                case 2: {
                    regex = new StringBuffer("^(?!\\d+$)(?![\\W_]+$)[\\d\\W_]{%d,%d}$|^(?!\\d+$)(?![a-z]+$)[\\da-z]{%d,%d}$|^(?!\\d+$)(?![A-Z]+$)[\\dA-Z]{%d,%d}$|^(?![a-z]+$)(?![A-Z]+$)[a-zA-Z]{%d,%d}$|^(?![a-z]+$)(?![\\W_]+$)[a-z\\W]{%d,%d}$|^(?![A-Z]+$)(?![\\W_]+$)[A-Z\\W]{%d,%d}$").append("|").append("^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$").toString();
                    break;
                }
                case 3: {
                    regex = "^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$";
                    break;
                }
                default: {
                    regex = "^[A-Z]{%d,%d}$|^[a-z]{%d,%d}$|^[0-9]{%d,%d}$|^[\\W_]{%d,%d}$";
                }
            }
            Object[] args = new Object[28];
            for (int i = 0; i < args.length; ++i) {
                args[i] = i % 2 == 0 ? Integer.valueOf(minInt) : Integer.valueOf(maxInt);
            }
            regex = String.format(regex, args);
            regex = new StringBuffer("/").append(regex).append("/").toString();
            String message = String.format(this.pwdRuleMessage, regArray);
            this.setPwdComplexityRegularCache(regex);
            this.setUnmatchedHintCache(message);
        }
    }

    public String getPwdRuleMessage() {
        this.pwdRuleMessage = this.getStringBaseConfig("pwd_rule_message", this.pwdRuleMessage);
        if (!this.isPwdRuleCustom()) {
            this.setRule();
        }
        return this.pwdRuleMessage;
    }

    public String getPwdRuleMessage(int levelInt) {
        this.pwdRuleMessage = this.getStringBaseConfig("pwd_rule_message", this.pwdRuleMessage);
        if (!this.isPwdRuleCustom()) {
            switch (levelInt) {
                case 1: {
                    this.pwdRuleMessage = new StringBuffer(this.pwdRuleMessage).append(" <br>\u7ea7\u522b1\uff1a\u5bc6\u7801\u53ea\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e00\u79cd\u7ec4\u6210\u3002").toString();
                    break;
                }
                case 2: {
                    this.pwdRuleMessage = new StringBuffer(this.pwdRuleMessage).append(" <br>\u7ea7\u522b2\uff1a\u5bc6\u7801\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e24\u79cd\u7ec4\u6210\u3002").toString();
                    break;
                }
                case 3: {
                    this.pwdRuleMessage = new StringBuffer(this.pwdRuleMessage).append(" <br>\u7ea7\u522b3\uff1a\u5bc6\u7801\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e09\u79cd\u4ee5\u4e0a\u7ec4\u6210\u3002").toString();
                }
            }
        }
        return this.pwdRuleMessage;
    }

    public void setPwdRuleMessage(String pwdRuleMessage) {
        this.pwdRuleMessage = pwdRuleMessage;
    }

    public boolean isPwdRuleCustom() {
        this.pwdRuleCustom = this.getBooleanBaseConfig("pwd_rule_custom", this.pwdRuleCustom);
        return this.pwdRuleCustom;
    }

    public void setPwdRuleCustom(boolean pwdRuleCustom) {
        this.pwdRuleCustom = pwdRuleCustom;
    }

    public Long getSystemMaxSession() {
        return this.systemMaxSession;
    }

    public void setSystemMaxSession(Long systemMaxSession) {
        if (systemMaxSession <= 0L) {
            throw new RuntimeException("\u7cfb\u7edf\u6700\u5927\u4f1a\u8bdd\u6570\u9700\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
        }
        this.systemMaxSession = systemMaxSession;
    }

    public boolean isEncryptSignOpen() {
        return this.encryptSignOpen;
    }

    public void setEncryptSignOpen(boolean encryptSignOpen) {
        this.encryptSignOpen = encryptSignOpen;
    }

    public boolean isExceptionAlert() {
        this.exceptionAlert = this.getBooleanBaseConfig("exception_alert", this.exceptionAlert);
        return this.exceptionAlert;
    }

    public void setExceptionAlert(boolean exceptionAlert) {
        this.exceptionAlert = exceptionAlert;
    }

    public String getExceptionAlertEmail() {
        this.exceptionAlertEmail = this.getStringBaseConfig("exception_alert_email", this.exceptionAlertEmail);
        return this.exceptionAlertEmail;
    }

    public String getExceptionAlertEmail(SecurityUser shiroUser) {
        SysBaseConfig baseConfig = this.getBaseConfigByKey("exception_alert_email", shiroUser);
        if (ToolUtil.isNotEmpty((Object)baseConfig) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            this.exceptionAlertEmail = baseConfig.getConfigValue();
        }
        return this.exceptionAlertEmail;
    }

    public void setExceptionAlertEmail(String exceptionAlertEmail) {
        this.exceptionAlertEmail = exceptionAlertEmail;
    }

    public int getSecuritylogCountAlert() {
        String countAlertStr = this.getStringBaseConfig("securitylog_count_alert", String.valueOf(this.securitylogCountAlert));
        this.securitylogCountAlert = Integer.valueOf(countAlertStr);
        return this.securitylogCountAlert;
    }

    public int getSecuritylogCountAlert(SecurityUser shiroUser) {
        SysBaseConfig baseConfig = this.getBaseConfigByKey("securitylog_count_alert", shiroUser);
        if (ToolUtil.isNotEmpty((Object)baseConfig) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            this.securitylogCountAlert = Integer.valueOf(baseConfig.getConfigValue());
        }
        return this.securitylogCountAlert;
    }

    public void setSecuritylogCountAlert(int securitylogCountAlert) {
        this.securitylogCountAlert = securitylogCountAlert;
    }

    public String getAntiReplayScanPackage() {
        return this.antiReplayScanPackage;
    }

    public void setAntiReplayScanPackage(String antiReplayScanPackage) {
        this.antiReplayScanPackage = antiReplayScanPackage;
    }

    public String getxFrameOptions() {
        return this.xFrameOptions;
    }

    public void setxFrameOptions(String xFrameOptions) {
        this.xFrameOptions = xFrameOptions;
    }

    public String getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    public void setContentSecurityPolicy(String contentSecurityPolicy) {
        this.contentSecurityPolicy = contentSecurityPolicy;
    }

    public boolean isShowLoginPage() {
        return this.showLoginPage;
    }

    public void setShowLoginPage(boolean showLoginPage) {
        this.showLoginPage = showLoginPage;
    }

    public boolean isTenantOpen() {
        return this.tenantOpen;
    }

    public void setTenantOpen(boolean tenantOpen) {
        this.tenantOpen = tenantOpen;
    }

    public String getTenantUserModel() {
        return this.tenantUserModel;
    }

    public void setTenantUserModel(String tenantUserModel) {
        this.tenantUserModel = tenantUserModel;
    }

    public boolean isTenantChangeInputPwd() {
        return this.tenantChangeInputPwd;
    }

    public void setTenantChangeInputPwd(boolean tenantChangeInputPwd) {
        this.tenantChangeInputPwd = tenantChangeInputPwd;
    }

    public String getTenantLevel() {
        return this.tenantLevel;
    }

    public void setTenantLevel(String tenantLevel) {
        this.tenantLevel = tenantLevel;
    }

    public boolean isRoleResourceCheck() {
        this.roleResourceCheck = this.getBooleanBaseConfig("role_resource_check", this.roleResourceCheck);
        return this.roleResourceCheck;
    }

    public void setRoleResourceCheck(boolean roleResourceCheck) {
        this.roleResourceCheck = roleResourceCheck;
    }

    public List<String> getTenantPatterns() {
        return this.tenantPatterns;
    }

    public void setTenantPatterns(List<String> tenantPatterns) {
        this.tenantPatterns = tenantPatterns;
    }

    public List<String> getTenantExcludePatterns() {
        return this.tenantExcludePatterns;
    }

    public void setTenantExcludePatterns(List<String> tenantExcludePatterns) {
        this.tenantExcludePatterns = tenantExcludePatterns;
    }

    public boolean isStruAudit() {
        this.struAudit = this.getBooleanBaseConfig("stru_audit", this.struAudit);
        return this.struAudit;
    }

    public void setStruAudit(boolean struAudit) {
        this.struAudit = struAudit;
    }

    public boolean isSkipWelcome() {
        this.skipWelcome = this.getBooleanBaseConfig("skip_welcome", this.skipWelcome);
        return this.skipWelcome;
    }

    public void setSkipWelcome(boolean skipWelcome) {
        this.skipWelcome = skipWelcome;
    }

    private SysBaseConfig getBaseConfigByKey(String key, SecurityUser shiroUser) {
        if (ToolUtil.isEmpty((Object)this.iSysBaseConfigService)) {
            this.iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            return this.iSysBaseConfigService.getSysBaseConfigWithUser(key, shiroUser);
        }
        return this.iSysBaseConfigService.getSysBaseConfig(key);
    }

    private void setBaseConfigCache(String key, Object value) {
        SysBaseConfig baseConfig;
        if (ToolUtil.isEmpty((Object)this.iSysBaseConfigService)) {
            this.iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        }
        if (ToolUtil.isNotEmpty((Object)(baseConfig = this.getBaseConfigByKey(key, null))) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            if (!baseConfig.getConfigValue().equals(String.valueOf(value))) {
                baseConfig.setConfigValue(String.valueOf(value));
                this.iSysBaseConfigService.setSysBaseConfigCache(key, baseConfig);
            }
        } else {
            baseConfig = new SysBaseConfig();
            baseConfig.setConfigValue(String.valueOf(value));
            this.iSysBaseConfigService.setSysBaseConfigCache(key, baseConfig);
        }
    }

    private Boolean getBooleanBaseConfig(String key, Boolean prop) {
        SysBaseConfig baseConfig = this.getBaseConfigByKey(key, null);
        if (ToolUtil.isNotEmpty((Object)baseConfig) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            prop = OPEN.equals(baseConfig.getConfigValue());
        }
        return prop;
    }

    private String getStringBaseConfig(String key, String prop) {
        SysBaseConfig baseConfig = this.getBaseConfigByKey(key, null);
        if (ToolUtil.isNotEmpty((Object)baseConfig) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            prop = baseConfig.getConfigValue();
        }
        return prop;
    }
}

