/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.stream.Stream;

public class AccountStatusConverter
implements Converter<String> {
    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public String convertToJavaData(ReadConverterContext<?> context) {
        String excelValue = context.getReadCellData().getStringValue();
        if (HussarUtils.isBlank((CharSequence)excelValue)) {
            return UserStatus.OK.getCode();
        }
        if (Stream.of(UserStatus.values()).map(UserStatus::getMessage).noneMatch(m -> HussarUtils.equals((Object)m, (Object)excelValue))) {
            if (HussarUtils.equals((Object)"\u8d26\u6237\u72b6\u6001*", (Object)excelValue) || HussarUtils.equals((Object)"\u8d26\u6237\u72b6\u6001", (Object)excelValue)) {
                return excelValue;
            }
            return UserStatus.OK.getCode();
        }
        return UserStatus.convertByMessage(excelValue).getCode();
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<String> context) {
        return new WriteCellData(UserStatus.convert((String)context.getValue()).getMessage());
    }
}

