/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.staff.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.service.SysStruStaffService;
import com.jxdinfo.hussar.authorization.staff.dto.StaffDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DealSaveOrUpdateUtil {
    private static SysStruStaffService sysStruStaffService = (SysStruStaffService)SpringContextHolder.getBean(SysStruStaffService.class);
    private static ISysUserRoleService sysUserRoleService = (ISysUserRoleService)SpringContextHolder.getBean(ISysUserRoleService.class);

    public static void dealSaveOrUpdate(StaffDto staffDto) {
        DealSaveOrUpdateUtil.dealOrganStaffAndUserRole(staffDto);
    }

    public static void dealOrganStaffAndUserRole(StaffDto staffDto) {
        List<Long> organIdList;
        if (HussarUtils.isEmpty((Object)staffDto.getOrganId())) {
            throw new BaseException("\u672a\u5173\u8054\u7ec4\u7ec7");
        }
        String regex = "[,\uff0c]";
        String[] organIds = staffDto.getOrganId().split(regex);
        List<Long> organId = organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
        List sysOrganStaffs = sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffDto.getId()));
        if (HussarUtils.isNotEmpty((Object)sysOrganStaffs)) {
            List<Long> dataBankOrganIds = sysOrganStaffs.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
            organId = DealSaveOrUpdateUtil.contrastAddOrDel(organIdList, dataBankOrganIds);
            List<Long> delIdList = DealSaveOrUpdateUtil.contrastAddOrDel(dataBankOrganIds, organIdList);
            if (HussarUtils.isNotEmpty(delIdList)) {
                sysStruStaffService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffDto.getId())).in(SysStruStaff::getStruId, delIdList));
            }
        }
        for (Long id : organId) {
            SysStruStaff sysOrganStaff = new SysStruStaff();
            sysOrganStaff.setStruId(id);
            sysOrganStaff.setStaffId(staffDto.getId());
            sysStruStaffService.save((Object)sysOrganStaff);
        }
    }

    public static void deleteUserRole(String relationSource, SysUsers lastUsers) {
        if (HussarUtils.isNotEmpty((Object)((Object)lastUsers))) {
            sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)lastUsers.getId())).eq(SysUserRole::getRelationSource, (Object)relationSource));
        }
    }

    public static List<Long> contrastAddOrDel(List<Long> list, List<Long> secondList) {
        return list.stream().filter(item -> !secondList.contains(item)).collect(Collectors.toList());
    }
}

