/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.staff.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysOrganRole;
import com.jxdinfo.hussar.authorization.relational.model.SysOrganStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysStaffPost;
import com.jxdinfo.hussar.authorization.relational.service.IHussarBaseOrganRoleService;
import com.jxdinfo.hussar.authorization.relational.service.SysOrganStaffService;
import com.jxdinfo.hussar.authorization.relational.service.SysPostRoleService;
import com.jxdinfo.hussar.authorization.relational.service.SysStaffPostService;
import com.jxdinfo.hussar.authorization.staff.dto.StaffDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DealSaveOrUpdateUtil {
    private static ISysUsersService sysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
    private static SysOrganStaffService sysOrganStaffService = (SysOrganStaffService)SpringContextHolder.getBean(SysOrganStaffService.class);
    private static SysStaffPostService sysStaffPostService = (SysStaffPostService)SpringContextHolder.getBean(SysStaffPostService.class);
    private static ISysUserRoleService sysUserRoleService = (ISysUserRoleService)SpringContextHolder.getBean(ISysUserRoleService.class);
    private static IHussarBaseOrganRoleService organRoleService = (IHussarBaseOrganRoleService)SpringContextHolder.getBean(IHussarBaseOrganRoleService.class);
    private static SysPostRoleService sysPostRoleService = (SysPostRoleService)SpringContextHolder.getBean(SysPostRoleService.class);

    public static void dealSaveOrUpdate(StaffDto staffDto) {
        Long userId = staffDto.getUserId();
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BaseException("\u7528\u6237\u53c2\u6570\u672a\u4f20\u9012");
        }
        SysUsers lastUsers = (SysUsers)((Object)sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getStaffId, (Object)staffDto.getId())));
        DealSaveOrUpdateUtil.dealOrganStaffAndUserRole(staffDto, lastUsers);
        DealSaveOrUpdateUtil.dealStaffPostAndUserRole(staffDto, lastUsers);
        if (HussarUtils.isNotEmpty((Object)((Object)lastUsers))) {
            lastUsers.setStaffId(-1L);
            sysUsersService.updateById((Object)lastUsers);
        }
        if (HussarUtils.isNotEmpty((Object)userId) && !Objects.equals(-1L, userId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysUsers::getId, (Object)staffDto.getUserId());
            SysUsers users = (SysUsers)((Object)sysUsersService.getOne((Wrapper)queryWrapper));
            if (HussarUtils.isEmpty((Object)((Object)users)) || users.getStaffId() != -1L) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5173\u8054\u4eba\u5458\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
            users.setStaffId(staffDto.getId());
            sysUsersService.updateById((Object)users);
        }
    }

    public static void dealOrganStaffAndUserRole(StaffDto staffDto, SysUsers lastUsers) {
        if (HussarUtils.isNotEmpty((Object)staffDto.getOrganId())) {
            List<Long> organIdList;
            String regex = "[,\uff0c]";
            String[] organIds = staffDto.getOrganId().split(regex);
            List<Long> organId = organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
            List<Object> delIdList = new ArrayList();
            List sysOrganStaffs = sysOrganStaffService.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganStaff::getStaffId, (Object)staffDto.getId()));
            if (HussarUtils.isNotEmpty((Object)sysOrganStaffs)) {
                List dataBankOrganIds = sysOrganStaffs.stream().map(SysOrganStaff::getStruId).collect(Collectors.toList());
                organId = DealSaveOrUpdateUtil.contrastAddOrDel(organIdList, dataBankOrganIds);
                delIdList = DealSaveOrUpdateUtil.contrastAddOrDel(dataBankOrganIds, organIdList);
                if (HussarUtils.isNotEmpty(delIdList)) {
                    sysOrganStaffService.remove((Wrapper)new LambdaQueryWrapper().in(SysOrganStaff::getStruId, delIdList));
                }
            }
            for (Long id : organId) {
                SysOrganStaff sysOrganStaff = new SysOrganStaff();
                sysOrganStaff.setStruId(id);
                sysOrganStaff.setStaffId(staffDto.getId());
                sysOrganStaffService.save((Object)sysOrganStaff);
            }
            if (HussarUtils.isNotEmpty((Object)staffDto.getUserId()) && !Objects.equals(-1L, staffDto.getUserId())) {
                Long lastUsersId = -1L;
                if (HussarUtils.isNotEmpty((Object)((Object)lastUsers))) {
                    lastUsersId = lastUsers.getId();
                }
                if (!staffDto.getUserId().equals(lastUsersId)) {
                    DealSaveOrUpdateUtil.deleteUserRole("2", lastUsers);
                    List sysOrganRoles = organRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysOrganRole::getStruId, organIdList));
                    if (HussarUtils.isNotEmpty((Object)sysOrganRoles)) {
                        for (SysOrganRole sysOrganRole : sysOrganRoles) {
                            if (!HussarUtils.isNotEmpty((Object)sysOrganRole.getRoleId())) continue;
                            SysUserRole sysUserRole = new SysUserRole();
                            LocalDateTime now = LocalDateTime.now();
                            sysUserRole.setCreator(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setLastEditor(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setCreateTime(now);
                            sysUserRole.setLastTime(now);
                            sysUserRole.setUserId(staffDto.getUserId());
                            sysUserRole.setGrantedRole(sysOrganRole.getRoleId());
                            sysUserRole.setAdminOption("1");
                            sysUserRole.setRelationSource("2");
                            sysUserRole.setSourceId(sysOrganRole.getStruId());
                            sysUserRoleService.save(sysUserRole);
                        }
                    }
                } else {
                    List addSysOrganRoles;
                    List delSysOrganRoles;
                    if (HussarUtils.isNotEmpty(delIdList) && HussarUtils.isNotEmpty((Object)(delSysOrganRoles = organRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysOrganRole::getStruId, delIdList))))) {
                        for (SysOrganRole sysOrganRole : delSysOrganRoles) {
                            sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)staffDto.getUserId())).eq(SysUserRole::getGrantedRole, (Object)sysOrganRole.getRoleId())).eq(SysUserRole::getRelationSource, (Object)"2")).eq(SysUserRole::getSourceId, (Object)sysOrganRole.getStruId()));
                        }
                    }
                    if (HussarUtils.isNotEmpty(organId) && HussarUtils.isNotEmpty((Object)(addSysOrganRoles = organRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysOrganRole::getStruId, organId))))) {
                        for (SysOrganRole sysOrganRole : addSysOrganRoles) {
                            SysUserRole sysUserRole = new SysUserRole();
                            LocalDateTime now = LocalDateTime.now();
                            sysUserRole.setCreator(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setLastEditor(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setCreateTime(now);
                            sysUserRole.setLastTime(now);
                            sysUserRole.setUserId(staffDto.getUserId());
                            sysUserRole.setGrantedRole(sysOrganRole.getRoleId());
                            sysUserRole.setAdminOption("1");
                            sysUserRole.setRelationSource("2");
                            sysUserRole.setSourceId(sysOrganRole.getStruId());
                            sysUserRoleService.save(sysUserRole);
                        }
                    }
                }
            } else {
                DealSaveOrUpdateUtil.deleteUserRole("2", lastUsers);
            }
        } else {
            sysOrganStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysOrganStaff::getStaffId, (Object)staffDto.getId()));
            DealSaveOrUpdateUtil.deleteUserRole("2", lastUsers);
        }
    }

    public static void dealStaffPostAndUserRole(StaffDto staffDto, SysUsers lastUsers) {
        Long addMainPostId = staffDto.getPostId();
        Long delMainPostId = null;
        if (HussarUtils.isNotEmpty((Object)staffDto.getPostId())) {
            SysStaffPost sysStaffPost = (SysStaffPost)((Object)sysStaffPostService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffPost::getStaffId, (Object)staffDto.getId())).eq(SysStaffPost::getRelateType, (Object)"0")));
            if (HussarUtils.isNotEmpty((Object)((Object)sysStaffPost))) {
                if (!staffDto.getPostId().equals(sysStaffPost.getPostId())) {
                    delMainPostId = sysStaffPost.getPostId();
                    sysStaffPost.setPostId(staffDto.getPostId());
                    sysStaffPostService.updateById((Object)sysStaffPost);
                } else {
                    addMainPostId = null;
                }
            } else {
                SysStaffPost sysStaffMainPost = new SysStaffPost();
                sysStaffMainPost.setPostId(staffDto.getPostId());
                sysStaffMainPost.setRelateType("0");
                sysStaffMainPost.setStaffId(staffDto.getId());
                sysStaffPostService.save((Object)sysStaffMainPost);
            }
        } else {
            sysStaffPostService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffPost::getStaffId, (Object)staffDto.getId())).eq(SysStaffPost::getRelateType, (Object)"0"));
        }
        List<Object> partPostId = new ArrayList();
        List<Long> delIdList = new ArrayList<Long>();
        List<Object> postIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)staffDto.getPartPostId())) {
            String regex = "[,\uff0c]";
            String[] partPostIds = staffDto.getPartPostId().split(regex);
            List<Long> partPostIdList = Arrays.stream(partPostIds).map(Long::valueOf).collect(Collectors.toList());
            postIdList = partPostIdList;
            partPostId = partPostIdList;
            List partStaffPost = sysStaffPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffPost::getStaffId, (Object)staffDto.getId())).eq(SysStaffPost::getRelateType, (Object)"1"));
            if (HussarUtils.isNotEmpty((Object)partStaffPost)) {
                List dataBankPartPostId = partStaffPost.stream().map(SysStaffPost::getPostId).collect(Collectors.toList());
                partPostId = DealSaveOrUpdateUtil.contrastAddOrDel(partPostIdList, dataBankPartPostId);
                delIdList = DealSaveOrUpdateUtil.contrastAddOrDel(dataBankPartPostId, partPostIdList);
                if (HussarUtils.isNotEmpty(delIdList)) {
                    sysStaffPostService.remove((Wrapper)new LambdaQueryWrapper().in(SysStaffPost::getPostId, delIdList));
                }
            }
            for (Long l : partPostId) {
                SysStaffPost sysStaffPartPost = new SysStaffPost();
                sysStaffPartPost.setPostId(l);
                sysStaffPartPost.setRelateType("1");
                sysStaffPartPost.setStaffId(staffDto.getId());
                sysStaffPostService.save((Object)sysStaffPartPost);
            }
        } else {
            sysStaffPostService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffPost::getStaffId, (Object)staffDto.getId())).eq(SysStaffPost::getRelateType, (Object)"1"));
        }
        if (HussarUtils.isNotEmpty((Object)staffDto.getPostId()) || HussarUtils.isNotEmpty((Object)staffDto.getPartPostId())) {
            if (HussarUtils.isNotEmpty((Object)staffDto.getUserId()) && !Objects.equals(-1L, staffDto.getUserId())) {
                SysUserRole sysUserRole;
                if (HussarUtils.isNotEmpty((Object)addMainPostId)) {
                    postIdList.add(addMainPostId);
                    partPostId.add(addMainPostId);
                }
                if (HussarUtils.isNotEmpty((Object)delMainPostId)) {
                    delIdList.add(delMainPostId);
                }
                Long lastUsersId = -1L;
                if (HussarUtils.isNotEmpty((Object)((Object)lastUsers))) {
                    lastUsersId = lastUsers.getId();
                }
                if (!staffDto.getUserId().equals(lastUsersId)) {
                    List sysPostRoles;
                    DealSaveOrUpdateUtil.deleteUserRole("1", lastUsers);
                    if (HussarUtils.isNotEmpty(postIdList) && HussarUtils.isNotEmpty((Object)(sysPostRoles = sysPostRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, postIdList))))) {
                        for (SysPostRole sysPostRole : sysPostRoles) {
                            if (!HussarUtils.isNotEmpty((Object)sysPostRole.getRoleId())) continue;
                            sysUserRole = new SysUserRole();
                            LocalDateTime localDateTime = LocalDateTime.now();
                            sysUserRole.setCreator(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setLastEditor(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setCreateTime(localDateTime);
                            sysUserRole.setLastTime(localDateTime);
                            sysUserRole.setUserId(staffDto.getUserId());
                            sysUserRole.setGrantedRole(sysPostRole.getRoleId());
                            sysUserRole.setAdminOption("1");
                            sysUserRole.setRelationSource("1");
                            sysUserRole.setSourceId(sysPostRole.getPostId());
                            sysUserRoleService.save(sysUserRole);
                        }
                    }
                } else {
                    List addSysPostRoles;
                    List delSysPostRoles;
                    if (HussarUtils.isNotEmpty(delIdList) && HussarUtils.isNotEmpty((Object)(delSysPostRoles = sysPostRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, delIdList))))) {
                        for (SysPostRole sysPostRole : delSysPostRoles) {
                            sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)staffDto.getUserId())).eq(SysUserRole::getGrantedRole, (Object)sysPostRole.getRoleId())).eq(SysUserRole::getRelationSource, (Object)"1")).eq(SysUserRole::getSourceId, (Object)sysPostRole.getPostId()));
                        }
                    }
                    if (HussarUtils.isNotEmpty(partPostId) && HussarUtils.isNotEmpty((Object)(addSysPostRoles = sysPostRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, partPostId))))) {
                        for (SysPostRole sysPostRole : addSysPostRoles) {
                            sysUserRole = new SysUserRole();
                            LocalDateTime localDateTime = LocalDateTime.now();
                            sysUserRole.setCreator(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setLastEditor(BaseSecurityUtil.getUser().getId());
                            sysUserRole.setCreateTime(localDateTime);
                            sysUserRole.setLastTime(localDateTime);
                            sysUserRole.setUserId(staffDto.getUserId());
                            sysUserRole.setGrantedRole(sysPostRole.getRoleId());
                            sysUserRole.setAdminOption("1");
                            sysUserRole.setRelationSource("1");
                            sysUserRole.setSourceId(sysPostRole.getPostId());
                            sysUserRoleService.save(sysUserRole);
                        }
                    }
                }
            } else {
                DealSaveOrUpdateUtil.deleteUserRole("1", lastUsers);
            }
        } else {
            DealSaveOrUpdateUtil.deleteUserRole("1", lastUsers);
        }
    }

    public static void deleteUserRole(String relationSource, SysUsers lastUsers) {
        if (HussarUtils.isNotEmpty((Object)((Object)lastUsers))) {
            sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)lastUsers.getId())).eq(SysUserRole::getRelationSource, (Object)relationSource));
        }
    }

    public static List<Long> contrastAddOrDel(List<Long> list, List<Long> secondList) {
        return list.stream().filter(item -> !secondList.contains(item)).collect(Collectors.toList());
    }
}

