/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.util;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganUtil {
    private static final Logger logger = LoggerFactory.getLogger(OrganUtil.class);
    private static Validator validator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).addProperty("hibernate.validator.fail_fast", "false")).buildValidatorFactory().getValidator();

    private OrganUtil() {
    }

    public static String getStruFidByLevel(String struFid, int level) {
        String[] arr = struFid.split("/");
        StringBuilder str = new StringBuilder("");
        int len = arr.length > level ? level : arr.length - 1;
        for (int i = 1; i <= len; ++i) {
            str.append("/").append(arr[i]);
        }
        return str.toString();
    }

    public static String getParentName(String fname) {
        List split;
        int len;
        String result = "";
        if (HussarUtils.isNotBlank((CharSequence)fname) && (len = (split = Arrays.stream(fname.split("/")).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList())).size()) > 1) {
            return fname.substring(0, fname.lastIndexOf("/"));
        }
        return result;
    }

    public static String getShortParentName(String fname) {
        String result = "";
        if (HussarUtils.isNotBlank((CharSequence)fname)) {
            List split = Arrays.stream(fname.split("/")).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
            int len = split.size();
            if (len > 1) {
                return (String)split.get(len - 2);
            }
            return "";
        }
        return result;
    }

    public static String convert(Long fcode) {
        return "/" + fcode + "/";
    }

    public static String convert(String fcode) {
        if (HussarUtils.isNotBlank((CharSequence)fcode)) {
            if (fcode.trim().length() == 1) {
                return "/";
            }
            StringBuilder stringBuilder = new StringBuilder(fcode.replace("//", "/"));
            if (!fcode.startsWith("/")) {
                stringBuilder.insert(0, "/");
            }
            if (!fcode.endsWith("/")) {
                stringBuilder.append("/");
            }
            return stringBuilder.toString();
        }
        return "/";
    }

    public static int getSubordinateLevel(String fid) {
        if (HussarUtils.isNotBlank((CharSequence)fid)) {
            if (fid.trim().length() == 1) {
                return 1;
            }
            return fid.split("/").length;
        }
        return 1;
    }

    public static String getPostName(String fullname) {
        if (HussarUtils.isNotBlank((CharSequence)fullname)) {
            String[] split = fullname.split("/");
            int len = split.length;
            if (len > 3) {
                return split[len - 2] + "/" + split[len - 1];
            }
            return fullname.replaceFirst("/", "");
        }
        return null;
    }

    public static int getLevel(SysStru sysStru) {
        String fid = sysStru.getStruFid();
        int level1 = 1;
        int level2 = 1;
        if (HussarUtils.isNotBlank((CharSequence)fid)) {
            level1 = sysStru.getStruFid().split("/").length - 1;
        }
        if (level1 != (level2 = sysStru.getStruLevel().intValue())) {
            logger.error("SYS_STRU\u8868\u4e3b\u952e\u4e3a" + sysStru.getId() + "\u7684\u6570\u636eSTRU_LEVEL\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return level1;
    }

    public static <T> List<Error<T>> validateOne(T object) {
        ArrayList<Error<T>> list = new ArrayList<Error<T>>();
        Set violations = validator.validate(object, new Class[0]);
        if (HussarUtils.isNotEmpty((Object)violations)) {
            Error error = new Error();
            error.setData(object);
            LinkedHashMap errMsg = new LinkedHashMap();
            for (ConstraintViolation violation : violations) {
                String property = violation.getPropertyPath().toString();
                if (errMsg.get(property) == null) {
                    errMsg.put(property, new ArrayList());
                }
                ((List)errMsg.get(property)).add(violation.getMessage());
            }
            error.setErrMsg(errMsg);
            list.add(error);
        }
        return list;
    }

    public static <T> List<Error<T>> addErrorMsg(List<Error<T>> errors, T data, String property, String ... errorMsg) {
        if (HussarUtils.isNotEmpty(errors)) {
            Optional<Error> first = errors.stream().filter(item -> item.getData() == data).findFirst();
            if (first.isPresent()) {
                Error error = first.get();
                Map errMsg = error.getErrMsg();
                if (errMsg.keySet().contains(property)) {
                    for (String str : errorMsg) {
                        ((List)errMsg.get(property)).add(str);
                    }
                } else {
                    ArrayList strList = Lists.newArrayList((Object[])errorMsg);
                    errMsg.put(property, strList);
                }
            } else {
                Error errorTemp = new Error();
                LinkedHashMap<String, ArrayList> errMsg = new LinkedHashMap<String, ArrayList>();
                ArrayList strList = Lists.newArrayList((Object[])errorMsg);
                errMsg.put(property, strList);
                errorTemp.setErrMsg(errMsg);
                errorTemp.setData(data);
                errors.add(errorTemp);
            }
        } else {
            Error errorTemp = new Error();
            LinkedHashMap<String, ArrayList> errMsg = new LinkedHashMap<String, ArrayList>();
            ArrayList strList = Lists.newArrayList((Object[])errorMsg);
            errMsg.put(property, strList);
            errorTemp.setErrMsg(errMsg);
            errorTemp.setData(data);
            errors.add(errorTemp);
        }
        return errors;
    }

    public static <T> List<Error<T>> validateMany(List<T> objects) {
        ArrayList<Error<T>> result = new ArrayList<Error<T>>();
        for (T obj : objects) {
            List<Error<T>> list = OrganUtil.validateOne(obj);
            if (!HussarUtils.isNotEmpty(list)) continue;
            result.addAll(list);
        }
        return result;
    }

    public static void main(String[] args) {
        String shortParentName = OrganUtil.getStruFidByLevel("/1/2/3", 2);
        logger.info(shortParentName);
    }
}

